/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators;

import junit.framework.TestCase;
import weka.core.CheckGOE;
import weka.core.SerializationHelper;
import weka.datagenerators.ClusterDefinition;

public abstract class AbstractClusterDefinitionTest
extends TestCase {
    protected ClusterDefinition m_Definition;
    protected CheckGOE m_GOETester;

    public AbstractClusterDefinitionTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.m_Definition = this.getDefinition();
        this.m_GOETester = this.getGOETester();
    }

    protected void tearDown() {
        this.m_Definition = null;
        this.m_GOETester = null;
    }

    public abstract ClusterDefinition getDefinition();

    protected CheckGOE getGOETester() {
        CheckGOE result = new CheckGOE();
        result.setObject((Object)this.getDefinition());
        result.setSilent(true);
        return result;
    }

    public void testOptions() {
        try {
            this.m_Definition.setOptions(this.m_Definition.getOptions());
        }
        catch (Exception e) {
            AbstractClusterDefinitionTest.fail((String)("setOptions(getOptions()) does not work: " + e.getMessage()));
        }
    }

    public void testSerialVersionUID() {
        if (SerializationHelper.needsUID(this.m_Definition.getClass())) {
            AbstractClusterDefinitionTest.fail((String)"Doesn't declare serialVersionUID!");
        }
    }

    public void testGlobalInfo() {
        if (!this.m_GOETester.checkGlobalInfo()) {
            AbstractClusterDefinitionTest.fail((String)"No globalInfo method");
        }
    }

    public void testToolTips() {
        if (!this.m_GOETester.checkToolTips()) {
            AbstractClusterDefinitionTest.fail((String)"Tool tips inconsistent");
        }
    }
}

