/*
 * Decompiled with CFR 0.152.
 */
package weka.filters;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.TimeSeriesTranslate;
import weka.filters.unsupervised.attribute.TimeSeriesTranslateTest;

public abstract class AbstractTimeSeriesFilterTest
extends AbstractFilterTest {
    protected static final double TOLERANCE = 0.001;

    public AbstractTimeSeriesFilterTest(String name) {
        super(name);
    }

    @Override
    public abstract Filter getFilter();

    public void testDefault() {
        this.testInstanceRange_X(((TimeSeriesTranslate)this.m_Filter).getInstanceRange());
    }

    public void testInstanceRange() {
        this.testInstanceRange_X(-5);
        this.testInstanceRange_X(-2);
        this.testInstanceRange_X(2);
        this.testInstanceRange_X(5);
    }

    public void testFillWithMissing() {
        ((TimeSeriesTranslate)this.m_Filter).setFillWithMissing(true);
        Instances result = this.useFilter();
        AbstractTimeSeriesFilterTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        AbstractTimeSeriesFilterTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        for (int i = 0; i < result.numInstances(); ++i) {
            Instance in = this.m_Instances.instance(i);
            Instance out = result.instance(i);
            for (int j = 0; j < result.numAttributes(); ++j) {
                if (j == 1 || j == 2) continue;
                if (in.isMissing(j)) {
                    AbstractTimeSeriesFilterTest.assertTrue((String)"Nonselected missing values should pass through", (boolean)out.isMissing(j));
                    continue;
                }
                if (result.attribute(j).isString()) {
                    AbstractTimeSeriesFilterTest.assertEquals((String)("Nonselected attributes shouldn't change. " + in + " --> " + out), (String)this.m_Instances.attribute(j).value((int)in.value(j)), (String)result.attribute(j).value((int)out.value(j)));
                    continue;
                }
                AbstractTimeSeriesFilterTest.assertEquals((String)("Nonselected attributes shouldn't change. " + in + " --> " + out), (double)in.value(j), (double)out.value(j), (double)0.001);
            }
        }
    }

    private void testInstanceRange_X(int range) {
        ((TimeSeriesTranslate)this.m_Filter).setInstanceRange(range);
        Instances result = this.useFilter();
        AbstractTimeSeriesFilterTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        AbstractTimeSeriesFilterTest.assertEquals((int)(this.m_Instances.numInstances() - Math.abs(range)), (int)result.numInstances());
        for (int i = 0; i < result.numInstances(); ++i) {
            Instance in = this.m_Instances.instance(i - (range > 0 ? 0 : range));
            Instance out = result.instance(i);
            for (int j = 0; j < result.numAttributes(); ++j) {
                if (j == 1 || j == 2) continue;
                if (in.isMissing(j)) {
                    AbstractTimeSeriesFilterTest.assertTrue((String)"Nonselected missing values should pass through", (boolean)out.isMissing(j));
                    continue;
                }
                if (result.attribute(j).isString()) {
                    AbstractTimeSeriesFilterTest.assertEquals((String)("Nonselected attributes shouldn't change. " + in + " --> " + out), (String)this.m_Instances.attribute(j).value((int)in.value(j)), (String)result.attribute(j).value((int)out.value(j)));
                    continue;
                }
                AbstractTimeSeriesFilterTest.assertEquals((String)("Nonselected attributes shouldn't change. " + in + " --> " + out), (double)in.value(j), (double)out.value(j), (double)0.001);
            }
        }
    }

    @Override
    public void testFilteredClassifier() {
        try {
            Instances data = this.getFilteredClassifierData();
            for (int i = 0; i < data.numAttributes(); ++i) {
                if (data.classIndex() == i || !data.attribute(i).isNumeric()) continue;
                ((TimeSeriesTranslate)this.m_FilteredClassifier.getFilter()).setAttributeIndices("" + (i + 1));
                ((TimeSeriesTranslate)this.m_FilteredClassifier.getFilter()).setFillWithMissing(true);
                break;
            }
        }
        catch (Exception e) {
            AbstractTimeSeriesFilterTest.fail((String)("Problem setting up test for FilteredClassifier: " + e.toString()));
        }
        super.testFilteredClassifier();
    }

    public static Test suite() {
        return new TestSuite(TimeSeriesTranslateTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)AbstractTimeSeriesFilterTest.suite());
    }
}

