/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import weka.core.Copyright;
import weka.core.Environment;
import weka.core.WekaException;
import weka.gui.beans.LogPanel;
import weka.gui.knowledgeflow.LayoutPanel;
import weka.gui.knowledgeflow.MainKFPerspective;
import weka.gui.knowledgeflow.MainKFPerspectiveToolBar;
import weka.gui.knowledgeflow.StepVisual;
import weka.knowledgeflow.ExecutionFinishedCallback;
import weka.knowledgeflow.Flow;
import weka.knowledgeflow.FlowExecutor;
import weka.knowledgeflow.FlowRunner;
import weka.knowledgeflow.JSONFlowUtils;
import weka.knowledgeflow.KFDefaults;
import weka.knowledgeflow.LogManager;
import weka.knowledgeflow.StepManager;
import weka.knowledgeflow.StepManagerImpl;

public class VisibleLayout
extends JPanel {
    protected static final int LAYOUT_WIDTH = 2560;
    protected static final int LAYOUT_HEIGHT = 1440;
    protected static final int SCROLLBAR_INCREMENT = 50;
    private static final long serialVersionUID = -3644458365810712479L;
    protected Flow m_flow;
    protected KFLogPanel m_logPanel = new KFLogPanel();
    protected int m_zoomSetting = 100;
    protected File m_filePath;
    protected List<StepVisual> m_selectedSteps = new ArrayList<StepVisual>();
    protected Stack<File> m_undoBuffer = new Stack();
    protected boolean m_hasBeenEdited;
    protected FlowExecutor m_flowExecutor;
    protected Environment m_env = Environment.getSystemWide();
    protected boolean m_isExecuting;
    protected MainKFPerspective m_mainPerspective;
    protected List<StepVisual> m_renderGraph = new ArrayList<StepVisual>();
    protected LayoutOperation m_userOpp = LayoutOperation.NONE;
    protected LayoutPanel m_layout;
    protected StepVisual m_editStep;
    protected String m_editConnection;

    public VisibleLayout(MainKFPerspective mainPerspective) {
        this.setLayout(new BorderLayout());
        this.m_flow = new Flow();
        this.m_mainPerspective = mainPerspective;
        this.m_layout = new LayoutPanel(this);
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        JScrollPane js = new JScrollPane(this.m_layout);
        p1.add((Component)js, "Center");
        js.getVerticalScrollBar().setUnitIncrement(20);
        js.getHorizontalScrollBar().setUnitIncrement(20);
        this.m_layout.setSize(this.m_mainPerspective.getSetting(KFDefaults.LAYOUT_WIDTH_KEY, 2560), this.m_mainPerspective.getSetting(KFDefaults.LAYOUT_HEIGHT_KEY, 1440));
        Dimension d = this.m_layout.getPreferredSize();
        this.m_layout.setMinimumSize(d);
        this.m_layout.setPreferredSize(d);
        this.m_logPanel = new KFLogPanel();
        this.setUpLogPanel(this.m_logPanel);
        Dimension d2 = new Dimension(100, 170);
        this.m_logPanel.setPreferredSize(d2);
        this.m_logPanel.setMinimumSize(d2);
        this.m_filePath = new File("-NONE-");
        JSplitPane p2 = new JSplitPane(0, p1, this.m_logPanel);
        p2.setOneTouchExpandable(true);
        p2.setDividerLocation(0.7);
        p2.setResizeWeight(1.0);
        this.add((Component)p2, "Center");
    }

    protected List<StepVisual> getRenderGraph() {
        return this.m_renderGraph;
    }

    protected MainKFPerspective getMainPerspective() {
        return this.m_mainPerspective;
    }

    protected StepVisual getEditStep() {
        return this.m_editStep;
    }

    protected void setEditStep(StepVisual step) {
        this.m_editStep = step;
    }

    protected String getEditConnection() {
        return this.m_editConnection;
    }

    protected void setEditConnection(String connName) {
        this.m_editConnection = connName;
    }

    protected List<StepVisual> getSelectedSteps() {
        return this.m_selectedSteps;
    }

    protected void setSelectedSteps(List<StepVisual> selected) {
        for (StepVisual s : this.m_selectedSteps) {
            s.setDisplayConnectors(false);
        }
        this.m_selectedSteps = selected;
        for (StepVisual s : this.m_selectedSteps) {
            s.setDisplayConnectors(true);
        }
        if (this.m_selectedSteps.size() > 0) {
            this.m_mainPerspective.getMainToolBar().enableWidgets(MainKFPerspectiveToolBar.Widgets.CUT_BUTTON.toString(), MainKFPerspectiveToolBar.Widgets.COPY_BUTTON.toString(), MainKFPerspectiveToolBar.Widgets.DELETE_BUTTON.toString());
        } else {
            this.m_mainPerspective.getMainToolBar().disableWidgets(MainKFPerspectiveToolBar.Widgets.CUT_BUTTON.toString(), MainKFPerspectiveToolBar.Widgets.COPY_BUTTON.toString(), MainKFPerspectiveToolBar.Widgets.DELETE_BUTTON.toString());
        }
    }

    protected void removeSelectedSteps() throws WekaException {
        this.addUndoPoint();
        for (StepVisual v : this.m_selectedSteps) {
            this.m_flow.removeStep(v.getStepManager());
            this.m_renderGraph.remove(v);
            this.m_layout.remove(v);
            String key = v.getStepName() + "$" + v.getStepManager().getManagedStep().hashCode();
            this.m_logPanel.statusMessage(key + "|remove");
        }
        this.setSelectedSteps(new ArrayList<StepVisual>());
        this.m_mainPerspective.getMainToolBar().disableWidgets(MainKFPerspectiveToolBar.Widgets.DELETE_BUTTON.toString());
        this.m_mainPerspective.getMainToolBar().enableWidget(MainKFPerspectiveToolBar.Widgets.SELECT_ALL_BUTTON.toString(), this.m_flow.size() > 0);
        this.m_layout.repaint();
    }

    protected void copySelectedStepsToClipboard() throws WekaException {
        this.copyStepsToClipboard(this.getSelectedSteps());
    }

    protected void copyStepsToClipboard(List<StepVisual> steps) throws WekaException {
        this.m_mainPerspective.copyStepsToClipboard(steps);
    }

    protected void pasteFromClipboard(int x, int y) throws WekaException {
        this.addUndoPoint();
        Flow fromPaste = Flow.JSONToFlow(this.m_mainPerspective.getPasteBuffer(), true);
        List<StepVisual> added = this.addAll(fromPaste.getSteps(), false);
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        for (StepVisual v : added) {
            if (v.getX() < minX) {
                minX = v.getX();
            }
            if (v.getY() >= minY) continue;
            minY = v.getY();
        }
        int deltaX = x - minX;
        int deltaY = y - minY;
        for (StepVisual v : added) {
            v.setX(v.getX() + deltaX);
            v.setY(v.getY() + deltaY);
        }
        this.m_layout.revalidate();
        this.m_layout.repaint();
        this.setSelectedSteps(added);
    }

    protected void addUndoPoint() {
        try {
            File tempFile = File.createTempFile("knowledgeflow", ".kf");
            tempFile.deleteOnExit();
            JSONFlowUtils.writeFlow(this.m_flow, tempFile);
            this.m_undoBuffer.push(tempFile);
            if (this.m_undoBuffer.size() > this.m_mainPerspective.getSetting(KFDefaults.MAX_UNDO_POINTS_KEY, 20)) {
                this.m_undoBuffer.remove(0);
            }
            this.m_mainPerspective.getMainToolBar().enableWidgets(MainKFPerspectiveToolBar.Widgets.UNDO_BUTTON.toString());
        }
        catch (Exception ex) {
            this.m_logPanel.logMessage("[KnowledgeFlow] a problem occurred while trying to create an undo point : " + ex.getMessage());
        }
    }

    protected int getUndoBufferSize() {
        return this.m_undoBuffer.size();
    }

    protected void snapSelectedToGrid() {
        if (this.m_selectedSteps.size() > 0) {
            this.m_layout.snapSelectedToGrid();
        }
    }

    protected void initiateAddNote() {
        this.m_layout.initiateAddNote();
    }

    public Flow getFlow() {
        return this.m_flow;
    }

    public void setFlow(Flow flow) {
        this.m_flow = flow;
        this.m_renderGraph.clear();
        Iterator<StepManagerImpl> iter = this.m_flow.iterator();
        this.m_layout.removeAll();
        while (iter.hasNext()) {
            StepManagerImpl manager = iter.next();
            StepVisual visual = StepVisual.createVisual(manager);
            manager.setStepVisual(visual);
            this.m_renderGraph.add(visual);
            this.m_layout.add(visual);
        }
        this.m_mainPerspective.getMainToolBar().enableWidget(MainKFPerspectiveToolBar.Widgets.SELECT_ALL_BUTTON.toString(), this.m_flow.size() > 0);
        this.m_layout.revalidate();
        this.m_layout.repaint();
    }

    protected List<StepVisual> addAll(List<StepManagerImpl> steps) {
        return this.addAll(steps, true);
    }

    protected List<StepVisual> addAll(List<StepManagerImpl> steps, boolean revalidate) {
        ArrayList<StepVisual> added = new ArrayList<StepVisual>();
        this.m_flow.addAll(steps);
        for (StepManagerImpl s : steps) {
            StepVisual visual = StepVisual.createVisual(s);
            s.setStepVisual(visual);
            added.add(visual);
            this.m_renderGraph.add(visual);
            this.m_layout.add(visual);
        }
        if (revalidate) {
            this.m_layout.repaint();
        }
        return added;
    }

    protected void addStep(StepManagerImpl manager, int x, int y) {
        this.m_flow.addStep(manager);
        StepVisual visual = StepVisual.createVisual(manager);
        Dimension d = visual.getPreferredSize();
        int dx = (int)(d.getWidth() / 2.0);
        int dy = (int)(d.getHeight() / 2.0);
        if ((x -= dx) >= 0 && (y -= dy) >= 0) {
            visual.setX(x);
            visual.setY(y);
        }
        manager.setStepVisual(visual);
        this.m_renderGraph.add(visual);
        this.m_layout.add(visual);
        visual.setLocation(x, y);
        this.m_mainPerspective.setCursor(Cursor.getPredefinedCursor(0));
        this.m_mainPerspective.getMainToolBar().enableWidget(MainKFPerspectiveToolBar.Widgets.SELECT_ALL_BUTTON.toString(), this.m_flow.size() > 0);
    }

    public void connectSteps(StepManagerImpl source, StepManagerImpl target, String connectionType) {
        if (this.m_mainPerspective.getDebug()) {
            System.err.println("[KF] connecting steps: " + source.getName() + " to " + target.getName());
        }
        boolean success = this.m_flow.connectSteps(source, target, connectionType);
        if (this.m_mainPerspective.getDebug()) {
            if (success) {
                System.err.println("[KF] connection successful");
            } else {
                System.err.println("[KF] connection failed");
            }
        }
        this.m_layout.repaint();
    }

    protected void renameStep(String oldName, String newName) {
        try {
            this.m_flow.renameStep(oldName, newName);
        }
        catch (WekaException ex) {
            this.m_mainPerspective.showErrorDialog(ex);
        }
    }

    protected void removeStep(StepVisual step) throws WekaException {
        this.m_flow.removeStep(step.getStepManager());
        this.m_renderGraph.remove(step);
        this.m_layout.remove(step);
        this.m_layout.repaint();
    }

    protected int numSteps() {
        return this.m_renderGraph.size();
    }

    public Environment getEnvironment() {
        return this.m_env;
    }

    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    public String environmentSubstitute(String source) {
        Environment env = this.m_env != null ? this.m_env : Environment.getSystemWide();
        try {
            source = env.substitute(source);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return source;
    }

    public FlowExecutor getFlowExecutor() {
        return this.m_flowExecutor;
    }

    public void setFlowExecutor(FlowExecutor executor) {
        this.m_flowExecutor = executor;
    }

    public File getFilePath() {
        return this.m_filePath;
    }

    public void setFilePath(File path) {
        File file = this.m_filePath = path != null ? path : new File("-NONE-");
        if (path != null) {
            File absolute = new File(path.getAbsolutePath());
            this.getEnvironment().addVariable("Internal.knowledgeflow.directory", absolute.getParent());
        }
    }

    public KFLogPanel getLogPanel() {
        return this.m_logPanel;
    }

    public int getZoomSetting() {
        return this.m_zoomSetting;
    }

    public void setZoomSetting(int zoom) {
        this.m_zoomSetting = zoom;
    }

    public boolean getEdited() {
        return this.m_hasBeenEdited;
    }

    public void setEdited(boolean edited) {
        this.m_hasBeenEdited = edited;
        this.m_mainPerspective.setCurrentTabTitleEditedStatus(edited);
    }

    public boolean isExecuting() {
        return this.m_isExecuting;
    }

    protected LayoutOperation getFlowLayoutOperation() {
        return this.m_userOpp;
    }

    protected void setFlowLayoutOperation(LayoutOperation mode) {
        this.m_userOpp = mode;
    }

    public synchronized void executeFlow(boolean sequential) throws WekaException {
        if (this.isExecuting()) {
            throw new WekaException("The flow is already executing!");
        }
        if (this.m_flowExecutor == null) {
            this.m_flowExecutor = new FlowRunner(this.m_mainPerspective.getMainApplication().getApplicationSettings());
            this.m_flowExecutor.setLogger(this.m_logPanel);
        }
        this.m_flowExecutor.setSettings(this.m_mainPerspective.getMainApplication().getApplicationSettings());
        this.m_mainPerspective.getMainToolBar().disableWidgets(MainKFPerspectiveToolBar.Widgets.PLAY_PARALLEL_BUTTON.toString(), MainKFPerspectiveToolBar.Widgets.PLAY_SEQUENTIAL_BUTTON.toString());
        this.m_mainPerspective.getMainToolBar().enableWidgets(MainKFPerspectiveToolBar.Widgets.STOP_BUTTON.toString());
        this.m_flowExecutor.getExecutionEnvironment().setEnvironmentVariables(this.m_env);
        this.m_isExecuting = true;
        this.m_flowExecutor.addExecutionFinishedCallback(new ExecutionFinishedCallback(){

            @Override
            public void executionFinished() {
                VisibleLayout.this.m_isExecuting = false;
                VisibleLayout.this.m_logPanel.statusMessage("@!@[KnowledgeFlow]|OK.");
                if (VisibleLayout.this.m_flowExecutor.wasStopped()) {
                    VisibleLayout.this.m_logPanel.setMessageOnAll(false, "Stopped.");
                }
                VisibleLayout.this.m_mainPerspective.getMainToolBar().enableWidgets(MainKFPerspectiveToolBar.Widgets.PLAY_PARALLEL_BUTTON.toString(), MainKFPerspectiveToolBar.Widgets.PLAY_SEQUENTIAL_BUTTON.toString());
                VisibleLayout.this.m_mainPerspective.getMainToolBar().disableWidgets(MainKFPerspectiveToolBar.Widgets.STOP_BUTTON.toString());
            }
        });
        this.m_flowExecutor.setFlow(this.m_flow);
        this.m_logPanel.clearStatus();
        this.m_logPanel.statusMessage("@!@[KnowledgeFlow]|Executing...");
        if (sequential) {
            this.m_flowExecutor.runSequentially();
        } else {
            this.m_flowExecutor.runParallel();
        }
    }

    public void stopFlow() {
        if (this.isExecuting()) {
            this.m_flowExecutor.stopProcessing();
        }
    }

    protected StepVisual findStep(Point p) {
        Rectangle tempBounds = new Rectangle();
        for (StepVisual v : this.m_renderGraph) {
            tempBounds = v.getBounds();
            if (!tempBounds.contains(p)) continue;
            return v;
        }
        return null;
    }

    protected List<StepVisual> findSteps(Rectangle boundingBox) {
        ArrayList<StepVisual> steps = new ArrayList<StepVisual>();
        for (StepVisual v : this.m_renderGraph) {
            int centerY;
            int centerX = v.getX() + v.getWidth() / 2;
            if (!boundingBox.contains(centerX, centerY = v.getY() + v.getHeight() / 2)) continue;
            steps.add(v);
        }
        return steps;
    }

    protected List<StepManagerImpl> findStepsThatCanAcceptConnection(String connectionName) {
        ArrayList<StepManagerImpl> result = new ArrayList<StepManagerImpl>();
        for (StepManagerImpl step : this.m_flow.getSteps()) {
            List<String> incomingConnNames = step.getManagedStep().getIncomingConnectionTypes();
            if (incomingConnNames == null || !incomingConnNames.contains(connectionName)) continue;
            result.add(step);
        }
        return result;
    }

    protected Map<String, List<StepManagerImpl[]>> findClosestConnections(Point point, int delta) {
        HashMap<String, List<StepManagerImpl[]>> closestConnections = new HashMap<String, List<StepManagerImpl[]>>();
        for (StepManagerImpl sourceManager : this.m_flow.getSteps()) {
            for (Map.Entry<String, List<StepManager>> outCons : sourceManager.getOutgoingConnections().entrySet()) {
                List<StepManager> targetsOfConnType = outCons.getValue();
                for (StepManager target : targetsOfConnType) {
                    StepManagerImpl targetManager = (StepManagerImpl)target;
                    String connName = outCons.getKey();
                    StepVisual sourceVisual = sourceManager.getStepVisual();
                    StepVisual targetVisual = targetManager.getStepVisual();
                    Point bestSourcePt = sourceVisual.getClosestConnectorPoint(new Point(targetVisual.getX() + targetVisual.getWidth() / 2, targetVisual.getY() + targetVisual.getHeight() / 2));
                    Point bestTargetPt = targetVisual.getClosestConnectorPoint(new Point(sourceVisual.getX() + sourceVisual.getWidth() / 2, sourceVisual.getY() + sourceVisual.getHeight() / 2));
                    int minx = (int)Math.min(bestSourcePt.getX(), bestTargetPt.getX());
                    int maxx = (int)Math.max(bestSourcePt.getX(), bestTargetPt.getX());
                    int miny = (int)Math.min(bestSourcePt.getY(), bestTargetPt.getY());
                    int maxy = (int)Math.max(bestSourcePt.getY(), bestTargetPt.getY());
                    if (!(point.getX() >= (double)(minx - delta)) || !(point.getX() <= (double)(maxx + delta)) || !(point.getY() >= (double)(miny - delta)) || !(point.getY() <= (double)(maxy + delta))) continue;
                    double a = bestSourcePt.getY() - bestTargetPt.getY();
                    double b = bestTargetPt.getX() - bestSourcePt.getX();
                    double c = bestSourcePt.getX() * bestTargetPt.getY() - bestTargetPt.getX() * bestSourcePt.getY();
                    double distance = Math.abs(a * point.getX() + b * point.getY() + c);
                    if (!((distance /= Math.abs(Math.sqrt(a * a + b * b))) <= (double)delta)) continue;
                    ArrayList<StepManagerImpl[]> conList = (ArrayList<StepManagerImpl[]>)closestConnections.get(connName);
                    if (conList == null) {
                        conList = new ArrayList<StepManagerImpl[]>();
                        closestConnections.put(connName, conList);
                    }
                    StepManagerImpl[] conn = new StepManagerImpl[]{sourceManager, targetManager};
                    conList.add(conn);
                }
            }
        }
        return closestConnections;
    }

    protected boolean previousConn(Map<String, List<StepManager>> outConns, StepManagerImpl target, int index) {
        boolean result = false;
        int count = 0;
        for (Map.Entry<String, List<StepManager>> e : outConns.entrySet()) {
            List<StepManager> connectedSteps = e.getValue();
            for (StepManager c : connectedSteps) {
                StepManagerImpl cI = (StepManagerImpl)c;
                if (target.getManagedStep() != cI.getManagedStep() || count >= index) continue;
                result = true;
                break;
            }
            if (result) break;
            ++count;
        }
        return result;
    }

    private void setUpLogPanel(final LogPanel logPanel) {
        String date = new SimpleDateFormat("EEEE, d MMMM yyyy").format(new Date());
        logPanel.logMessage("Weka Knowledge Flow was written by Mark Hall");
        logPanel.logMessage("Weka Knowledge Flow");
        logPanel.logMessage("(c) 2002-" + Copyright.getToYear() + " " + Copyright.getOwner() + ", " + Copyright.getAddress());
        logPanel.logMessage("web: " + Copyright.getURL());
        logPanel.logMessage(date);
        logPanel.statusMessage("@!@[KnowledgeFlow]|Welcome to the Weka Knowledge Flow");
        logPanel.getStatusTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (logPanel.getStatusTable().rowAtPoint(e.getPoint()) == 0 && ((e.getModifiers() & 0x10) != 16 || e.isAltDown())) {
                    System.gc();
                    Runtime currR = Runtime.getRuntime();
                    long freeM = currR.freeMemory();
                    long totalM = currR.totalMemory();
                    long maxM = currR.maxMemory();
                    logPanel.logMessage("[KnowledgeFlow] Memory (free/total/max.) in bytes: " + String.format("%,d", freeM) + " / " + String.format("%,d", totalM) + " / " + String.format("%,d", maxM));
                    logPanel.statusMessage("@!@[KnowledgeFlow]|Memory (free/total/max.) in bytes: " + String.format("%,d", freeM) + " / " + String.format("%,d", totalM) + " / " + String.format("%,d", maxM));
                }
            }
        });
    }

    protected void saveLayout(boolean showDialog) {
        boolean shownDialog = false;
        int returnVal = 0;
        File sFile = this.getFilePath();
        if (showDialog || sFile.getName().equals("-NONE-")) {
            returnVal = this.m_mainPerspective.m_FileChooser.showSaveDialog(this);
            shownDialog = true;
        }
        if (returnVal == 0) {
            if (shownDialog) {
                sFile = this.m_mainPerspective.m_FileChooser.getSelectedFile();
            }
            if (!sFile.getName().toLowerCase().endsWith(".kf")) {
                sFile = new File(sFile.getParent(), sFile.getName() + ".kf");
            }
            try {
                String fName = sFile.getName();
                if (fName.indexOf(".") > 0) {
                    fName = fName.substring(0, fName.lastIndexOf(46));
                }
                this.m_flow.setFlowName(fName.replace(".kf", ""));
                this.m_flow.saveFlow(sFile);
                this.setFilePath(sFile);
                this.setEdited(false);
                this.m_mainPerspective.setCurrentTabTitle(fName);
            }
            catch (WekaException e) {
                this.m_mainPerspective.showErrorDialog(e);
            }
        }
    }

    protected void popAndLoadUndo() {
        if (this.m_undoBuffer.size() > 0) {
            File undo = this.m_undoBuffer.pop();
            if (this.m_undoBuffer.size() == 0) {
                this.m_mainPerspective.getMainToolBar().disableWidgets(MainKFPerspectiveToolBar.Widgets.UNDO_BUTTON.toString());
            }
            this.loadLayout(undo, true);
        }
    }

    protected void loadLayout(File fFile, boolean isUndo) {
        this.stopFlow();
        this.m_mainPerspective.getMainToolBar().disableWidgets(MainKFPerspectiveToolBar.Widgets.PLAY_PARALLEL_BUTTON.toString(), MainKFPerspectiveToolBar.Widgets.PLAY_SEQUENTIAL_BUTTON.toString(), MainKFPerspectiveToolBar.Widgets.SAVE_FLOW_BUTTON.toString(), MainKFPerspectiveToolBar.Widgets.SAVE_FLOW_AS_BUTTON.toString());
        if (!isUndo) {
            File absolute = new File(fFile.getAbsolutePath());
            this.getEnvironment().addVariable("Internal.knowledgeflow.directory", absolute.getParent());
        }
        try {
            Flow flow = Flow.loadFlow(fFile, this.m_logPanel);
            this.setFlow(flow);
            if (!isUndo) {
                this.setFilePath(fFile);
            }
            if (!this.getFlow().getFlowName().equals("Untitled")) {
                this.m_mainPerspective.setCurrentTabTitle(this.getFlow().getFlowName());
            }
        }
        catch (WekaException e) {
            this.m_logPanel.statusMessage("@!@[KnowledgeFlow]|Unable to load flow (see log).");
            this.m_logPanel.logMessage("[KnowledgeFlow] Unable to load flow\n" + LogManager.stackTraceToString(e));
            this.m_mainPerspective.showErrorDialog(e);
        }
        this.m_mainPerspective.getMainToolBar().enableWidgets(MainKFPerspectiveToolBar.Widgets.PLAY_PARALLEL_BUTTON.toString(), MainKFPerspectiveToolBar.Widgets.PLAY_SEQUENTIAL_BUTTON.toString(), MainKFPerspectiveToolBar.Widgets.SAVE_FLOW_BUTTON.toString(), MainKFPerspectiveToolBar.Widgets.SAVE_FLOW_AS_BUTTON.toString());
        this.m_mainPerspective.getMainToolBar().enableWidget(MainKFPerspectiveToolBar.Widgets.SELECT_ALL_BUTTON.toString(), this.m_flow.size() > 0);
    }

    public static String serializeStepsToJSON(List<StepVisual> steps, String name) throws WekaException {
        if (steps.size() > 0) {
            ArrayList<StepManagerImpl> toCopy = new ArrayList<StepManagerImpl>();
            for (StepVisual s : steps) {
                toCopy.add(s.getStepManager());
            }
            Flow temp = new Flow();
            temp.setFlowName("Clipboard copy");
            temp.addAll(toCopy);
            return JSONFlowUtils.flowToJSON(temp);
        }
        throw new WekaException("No steps to serialize!");
    }

    protected class KFLogPanel
    extends LogPanel {
        private static final long serialVersionUID = -2224509243343105276L;

        protected KFLogPanel() {
        }

        public synchronized void setMessageOnAll(boolean mainKFLine, String message) {
            for (String key : this.m_tableIndexes.keySet()) {
                if (!mainKFLine && key.equals("[KnowledgeFlow]")) continue;
                String tm = key + "|" + message;
                this.statusMessage(tm);
            }
        }
    }

    protected static enum LayoutOperation {
        NONE,
        MOVING,
        CONNECTING,
        ADDING,
        SELECTING,
        PASTING;

    }
}

