/*
 * Decompiled with CFR 0.152.
 */
package weka.filters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import junit.framework.TestCase;
import weka.classifiers.Classifier;
import weka.classifiers.meta.FilteredClassifier;
import weka.classifiers.trees.J48;
import weka.classifiers.trees.M5P;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CheckGOE;
import weka.core.CheckOptionHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.SerializationHelper;
import weka.core.TestInstances;
import weka.filters.Filter;
import weka.test.Regression;

public abstract class AbstractFilterTest
extends TestCase {
    protected static boolean VERBOSE = false;
    protected Filter m_Filter;
    protected Instances m_Instances;
    protected CheckOptionHandler m_OptionTester;
    protected FilteredClassifier m_FilteredClassifier;
    protected CheckGOE m_GOETester;

    public AbstractFilterTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.m_Filter = this.getFilter();
        this.m_Instances = new Instances((Reader)new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream("weka/filters/data/FilterTest.arff"))));
        this.m_OptionTester = this.getOptionTester();
        this.m_GOETester = this.getGOETester();
        this.m_FilteredClassifier = this.getFilteredClassifier();
    }

    protected void tearDown() {
        this.m_Filter = null;
        this.m_Instances = null;
        this.m_OptionTester = null;
        this.m_GOETester = null;
        this.m_FilteredClassifier = null;
    }

    protected CheckOptionHandler getOptionTester() {
        CheckOptionHandler result = new CheckOptionHandler();
        if (this.getFilter() instanceof OptionHandler) {
            result.setOptionHandler((OptionHandler)this.getFilter());
        } else {
            result.setOptionHandler(null);
        }
        result.setUserOptions(new String[0]);
        result.setSilent(true);
        return result;
    }

    protected CheckGOE getGOETester() {
        CheckGOE result = new CheckGOE();
        result.setObject((Object)this.getFilter());
        result.setSilent(true);
        return result;
    }

    protected FilteredClassifier getFilteredClassifier() {
        J48 cls;
        FilteredClassifier result = new FilteredClassifier();
        Filter filter = this.getFilter();
        result.setFilter(filter);
        if (filter.getCapabilities().handles(Capabilities.Capability.NOMINAL_CLASS)) {
            cls = new J48();
        } else if (filter.getCapabilities().handles(Capabilities.Capability.BINARY_CLASS)) {
            cls = new J48();
        } else if (filter.getCapabilities().handles(Capabilities.Capability.UNARY_CLASS)) {
            cls = new J48();
        } else if (filter.getCapabilities().handles(Capabilities.Capability.NUMERIC_CLASS)) {
            cls = new M5P();
        } else if (filter.getCapabilities().handles(Capabilities.Capability.DATE_CLASS)) {
            cls = new M5P();
        } else {
            throw new IllegalStateException("Cannot determine base classifier for FilteredClassifier!");
        }
        result.setClassifier((Classifier)cls);
        return result;
    }

    protected Instances getFilteredClassifierData() throws Exception {
        TestInstances test = TestInstances.forCapabilities((Capabilities)this.m_FilteredClassifier.getClassifier().getCapabilities());
        test.setClassIndex(-1);
        Instances result = test.generate();
        return result;
    }

    public abstract Filter getFilter();

    protected Instances useFilter() {
        Instances result = null;
        Instances icopy = new Instances(this.m_Instances);
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            result = Filter.useFilter((Instances)icopy, (Filter)this.m_Filter);
            AbstractFilterTest.assertNotNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        return result;
    }

    public void testSerialVersionUID() {
        if (SerializationHelper.needsUID(this.m_Filter.getClass())) {
            AbstractFilterTest.fail((String)"Doesn't declare serialVersionUID!");
        }
    }

    public void testBuffered() {
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            result = Filter.useFilter((Instances)icopy, (Filter)this.m_Filter);
            AbstractFilterTest.assertNotNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        StringWriter sw = new StringWriter(2000);
        sw.write(result.toString());
        AbstractFilterTest.assertTrue((boolean)icopy.equalHeaders(this.m_Instances));
        AbstractFilterTest.assertEquals((int)icopy.numInstances(), (int)this.m_Instances.numInstances());
        Instances result2 = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            result2 = Filter.useFilter((Instances)icopy, (Filter)this.m_Filter);
            AbstractFilterTest.assertNotNull((Object)result2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        AbstractFilterTest.assertTrue((boolean)icopy.equalHeaders(this.m_Instances));
        AbstractFilterTest.assertEquals((int)icopy.numInstances(), (int)this.m_Instances.numInstances());
        AbstractFilterTest.assertTrue((boolean)result.equalHeaders(result2));
        AbstractFilterTest.assertEquals((int)result.numInstances(), (int)result2.numInstances());
    }

    public void testIncremental() {
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        boolean headerImmediate = false;
        try {
            headerImmediate = this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        if (headerImmediate) {
            if (VERBOSE) {
                System.err.println("Filter makes header immediately available.");
            }
            result = this.m_Filter.getOutputFormat();
        }
        for (int i = 0; i < icopy.numInstances(); ++i) {
            if (VERBOSE) {
                System.err.println("Input instance to filter");
            }
            boolean collectNow = false;
            try {
                collectNow = this.m_Filter.input(icopy.instance(i));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                AbstractFilterTest.fail((String)("Exception thrown on input(): \n" + ex.getMessage()));
            }
            if (!collectNow) continue;
            if (VERBOSE) {
                System.err.println("Filter said collect immediately");
            }
            if (!headerImmediate) {
                AbstractFilterTest.fail((String)"Filter didn't return true from setInputFormat() earlier!");
            }
            if (VERBOSE) {
                System.err.println("Getting output instance");
            }
            result.add(this.m_Filter.output());
        }
        if (VERBOSE) {
            System.err.println("Setting end of batch");
        }
        boolean toCollect = false;
        try {
            toCollect = this.m_Filter.batchFinished();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail((String)("Exception thrown on batchFinished(): \n" + ex.getMessage()));
        }
        if (toCollect) {
            if (VERBOSE) {
                System.err.println("Filter said collect output");
            }
            if (!headerImmediate) {
                if (VERBOSE) {
                    System.err.println("Getting output format");
                }
                result = this.m_Filter.getOutputFormat();
            }
            if (VERBOSE) {
                System.err.println("Getting output instance");
            }
            while (this.m_Filter.numPendingOutput() > 0) {
                result.add(this.m_Filter.output());
                if (!VERBOSE) continue;
                System.err.println("Getting output instance");
            }
        }
        AbstractFilterTest.assertNotNull((Object)result);
        StringWriter sw = new StringWriter(2000);
        sw.write(result.toString());
    }

    public void testRegression() {
        Regression reg = new Regression(((Object)((Object)this)).getClass());
        Instances result = this.useFilter();
        reg.println(result.toString());
        try {
            String diff = reg.diff();
            if (diff == null) {
                System.err.println("Warning: No reference available, creating.");
            } else if (!diff.equals("")) {
                AbstractFilterTest.fail((String)("Regression test failed. Difference:\n" + diff));
            }
        }
        catch (IOException ex) {
            AbstractFilterTest.fail((String)("Problem during regression testing.\n" + ex));
        }
        reg = new Regression(((Object)((Object)this)).getClass());
        Instances icopy = new Instances(this.m_Instances);
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            Instance processed;
            for (int i = 0; i < icopy.numInstances(); ++i) {
                this.m_Filter.input(icopy.instance(i));
            }
            this.m_Filter.batchFinished();
            result = this.m_Filter.getOutputFormat();
            while ((processed = this.m_Filter.output()) != null) {
                result.add(processed);
            }
            AbstractFilterTest.assertNotNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        reg.println(result.toString());
        try {
            String diff = reg.diff();
            if (diff == null) {
                System.err.println("Warning: No reference available, creating.");
            } else if (!diff.equals("")) {
                AbstractFilterTest.fail((String)("Regression test failed when using deprecated methods. Difference:\n" + diff));
            }
        }
        catch (IOException ex) {
            AbstractFilterTest.fail((String)("Problem during regression testing.\n" + ex));
        }
    }

    public void testThroughput() {
        if (VERBOSE) {
            Instances icopy = new Instances(this.m_Instances);
            Instances result = null;
            for (int i = 0; i < 20000; ++i) {
                icopy.add(this.m_Instances.instance(i % this.m_Instances.numInstances()));
            }
            long starttime = System.currentTimeMillis();
            boolean headerImmediate = false;
            try {
                headerImmediate = this.m_Filter.setInputFormat(icopy);
                if (headerImmediate) {
                    result = this.m_Filter.getOutputFormat();
                }
                for (int i = 0; i < icopy.numInstances(); ++i) {
                    boolean collectNow = false;
                    collectNow = this.m_Filter.input(icopy.instance(i));
                    if (!collectNow) continue;
                    if (!headerImmediate) {
                        AbstractFilterTest.fail((String)"Filter didn't return true from setInputFormat() earlier!");
                    }
                    result.add(this.m_Filter.output());
                }
                boolean toCollect = false;
                toCollect = this.m_Filter.batchFinished();
                if (toCollect) {
                    if (!headerImmediate) {
                        result = this.m_Filter.getOutputFormat();
                    }
                    while (this.m_Filter.numPendingOutput() > 0) {
                        result.add(this.m_Filter.output());
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                AbstractFilterTest.fail((String)("Exception thrown during incremental filtering: \n" + ex.getMessage()));
            }
            long endtime = System.currentTimeMillis();
            double secs = (double)(endtime - starttime) / 1000.0;
            double rate = (double)icopy.numInstances() / secs;
            System.err.println("\n" + this.m_Filter.getClass().getName() + " incrementally processed " + rate + " instances per sec");
            starttime = System.currentTimeMillis();
            try {
                this.m_Filter.setInputFormat(icopy);
                result = Filter.useFilter((Instances)icopy, (Filter)this.m_Filter);
                AbstractFilterTest.assertNotNull((Object)result);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                AbstractFilterTest.fail((String)("Exception thrown during batch filtering: \n" + ex.getMessage()));
            }
            endtime = System.currentTimeMillis();
            secs = (double)(endtime - starttime) / 1000.0;
            rate = (double)icopy.numInstances() / secs;
            System.err.println("\n" + this.m_Filter.getClass().getName() + " batch processed " + rate + " instances per sec");
        }
    }

    public void testListOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkListOptions()) {
            AbstractFilterTest.fail((String)"Options cannot be listed via listOptions.");
        }
    }

    public void testSetOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkSetOptions()) {
            AbstractFilterTest.fail((String)"setOptions method failed.");
        }
    }

    public void testDefaultOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkDefaultOptions()) {
            AbstractFilterTest.fail((String)"Default options were not processed correctly.");
        }
    }

    public void testRemainingOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkRemainingOptions()) {
            AbstractFilterTest.fail((String)"There were 'left-over' options.");
        }
    }

    public void testCanonicalUserOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkCanonicalUserOptions()) {
            AbstractFilterTest.fail((String)"setOptions method failed");
        }
    }

    public void testResettingOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkSetOptions()) {
            AbstractFilterTest.fail((String)"Resetting of options failed");
        }
    }

    public void testFilteredClassifier() {
        if (this.m_FilteredClassifier == null) {
            return;
        }
        try {
            Instances data = this.getFilteredClassifierData();
            this.m_FilteredClassifier.buildClassifier(data);
            for (int i = 0; i < data.numInstances(); ++i) {
                this.m_FilteredClassifier.classifyInstance(data.instance(i));
            }
        }
        catch (Exception e) {
            AbstractFilterTest.fail((String)("Problem with FilteredClassifier: " + e.toString()));
        }
    }

    public void testBatchFiltering() {
        Instance out;
        Instances result = null;
        Instances icopy = new Instances(this.m_Instances);
        try {
            if (this.m_Filter.setInputFormat(icopy)) {
                result = this.m_Filter.getOutputFormat();
                AbstractFilterTest.assertNotNull((String)"Output format defined (setup)", (Object)result);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex));
        }
        try {
            for (int i = 0; i < icopy.numInstances(); ++i) {
                if (!this.m_Filter.input(icopy.instance(i))) continue;
                out = this.m_Filter.output();
                AbstractFilterTest.assertNotNull((String)"Instance not made available immediately (1. batch)", (Object)out);
                result.add(out);
            }
            this.m_Filter.batchFinished();
            if (result == null) {
                result = this.m_Filter.getOutputFormat();
                AbstractFilterTest.assertNotNull((String)"Output format defined (1. batch)", (Object)result);
                AbstractFilterTest.assertTrue((String)"Pending output instances (1. batch)", (this.m_Filter.numPendingOutput() > 0 ? 1 : 0) != 0);
            }
            while (this.m_Filter.numPendingOutput() > 0) {
                result.add(this.m_Filter.output());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail((String)("Exception thrown during 1. batch: \n" + ex));
        }
        try {
            result = null;
            if (this.m_Filter.isOutputFormatDefined()) {
                result = this.m_Filter.getOutputFormat();
            }
            for (int i = 0; i < icopy.numInstances(); ++i) {
                if (!this.m_Filter.input(icopy.instance(i))) continue;
                if (result == null) {
                    AbstractFilterTest.fail((String)"Filter didn't return true from isOutputFormatDefined() (2. batch)");
                    continue;
                }
                out = this.m_Filter.output();
                AbstractFilterTest.assertNotNull((String)"Instance not made available immediately (2. batch)", (Object)out);
                result.add(out);
            }
            this.m_Filter.batchFinished();
            if (result == null) {
                result = this.m_Filter.getOutputFormat();
                AbstractFilterTest.assertNotNull((String)"Output format defined (2. batch)", (Object)result);
                AbstractFilterTest.assertTrue((String)"Pending output instances (2. batch)", (this.m_Filter.numPendingOutput() > 0 ? 1 : 0) != 0);
            }
            while (this.m_Filter.numPendingOutput() > 0) {
                result.add(this.m_Filter.output());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail((String)("Exception thrown during 2. batch: \n" + ex));
        }
    }

    public void testBatchFilteringSmaller() {
        Instances result = null;
        Instances icopy = new Instances(this.m_Instances);
        try {
            if (this.m_Filter.setInputFormat(icopy)) {
                result = this.m_Filter.getOutputFormat();
                AbstractFilterTest.assertNotNull((String)"Output format defined (setup)", (Object)result);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex));
        }
        try {
            for (int i = 0; i < icopy.numInstances(); ++i) {
                if (!this.m_Filter.input(icopy.instance(i))) continue;
                Instance out = this.m_Filter.output();
                AbstractFilterTest.assertNotNull((String)"Instance not made available immediately (1. batch)", (Object)out);
                result.add(out);
            }
            this.m_Filter.batchFinished();
            if (result == null) {
                result = this.m_Filter.getOutputFormat();
                AbstractFilterTest.assertNotNull((String)"Output format defined (1. batch)", (Object)result);
                AbstractFilterTest.assertTrue((String)"Pending output instances (1. batch)", (this.m_Filter.numPendingOutput() > 0 ? 1 : 0) != 0);
            }
            while (this.m_Filter.numPendingOutput() > 0) {
                result.add(this.m_Filter.output());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail((String)("Exception thrown during 1. batch: \n" + ex));
        }
        try {
            int i;
            result = null;
            if (this.m_Filter.isOutputFormatDefined()) {
                result = this.m_Filter.getOutputFormat();
            }
            int num = (int)((double)icopy.numInstances() * 0.3);
            for (i = 0; i < num; ++i) {
                icopy.delete(0);
            }
            for (i = 0; i < icopy.numInstances(); ++i) {
                if (!this.m_Filter.input(icopy.instance(i))) continue;
                if (result == null) {
                    AbstractFilterTest.fail((String)"Filter didn't return true from isOutputFormatDefined() (2. batch)");
                    continue;
                }
                Instance out = this.m_Filter.output();
                AbstractFilterTest.assertNotNull((String)"Instance not made available immediately (2. batch)", (Object)out);
                result.add(out);
            }
            this.m_Filter.batchFinished();
            if (result == null) {
                result = this.m_Filter.getOutputFormat();
                AbstractFilterTest.assertNotNull((String)"Output format defined (2. batch)", (Object)result);
                AbstractFilterTest.assertTrue((String)"Pending output instances (2. batch)", (this.m_Filter.numPendingOutput() > 0 ? 1 : 0) != 0);
            }
            while (this.m_Filter.numPendingOutput() > 0) {
                result.add(this.m_Filter.output());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail((String)("Exception thrown during 2. batch: \n" + ex));
        }
    }

    public void testBatchFilteringLarger() {
        Instances result = null;
        Instances icopy = new Instances(this.m_Instances);
        try {
            if (this.m_Filter.setInputFormat(icopy)) {
                result = this.m_Filter.getOutputFormat();
                AbstractFilterTest.assertNotNull((String)"Output format defined (setup)", (Object)result);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex));
        }
        try {
            for (int i = 0; i < icopy.numInstances(); ++i) {
                if (!this.m_Filter.input(icopy.instance(i))) continue;
                Instance out = this.m_Filter.output();
                AbstractFilterTest.assertNotNull((String)"Instance not made available immediately (1. batch)", (Object)out);
                result.add(out);
            }
            this.m_Filter.batchFinished();
            if (result == null) {
                result = this.m_Filter.getOutputFormat();
                AbstractFilterTest.assertNotNull((String)"Output format defined (1. batch)", (Object)result);
                AbstractFilterTest.assertTrue((String)"Pending output instances (1. batch)", (this.m_Filter.numPendingOutput() > 0 ? 1 : 0) != 0);
            }
            while (this.m_Filter.numPendingOutput() > 0) {
                result.add(this.m_Filter.output());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail((String)("Exception thrown during 1. batch: \n" + ex));
        }
        try {
            int i;
            result = null;
            if (this.m_Filter.isOutputFormatDefined()) {
                result = this.m_Filter.getOutputFormat();
            }
            int num = (int)((double)icopy.numInstances() * 0.3);
            for (i = 0; i < num; ++i) {
                icopy.add(icopy.instance(i));
            }
            for (i = 0; i < icopy.numInstances(); ++i) {
                if (!this.m_Filter.input(icopy.instance(i))) continue;
                if (result == null) {
                    AbstractFilterTest.fail((String)"Filter didn't return true from isOutputFormatDefined() (2. batch)");
                    continue;
                }
                Instance out = this.m_Filter.output();
                AbstractFilterTest.assertNotNull((String)"Instance not made available immediately (2. batch)", (Object)out);
                result.add(out);
            }
            this.m_Filter.batchFinished();
            if (result == null) {
                result = this.m_Filter.getOutputFormat();
                AbstractFilterTest.assertNotNull((String)"Output format defined (2. batch)", (Object)result);
                AbstractFilterTest.assertTrue((String)"Pending output instances (2. batch)", (this.m_Filter.numPendingOutput() > 0 ? 1 : 0) != 0);
            }
            while (this.m_Filter.numPendingOutput() > 0) {
                result.add(this.m_Filter.output());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractFilterTest.fail((String)("Exception thrown during 2. batch: \n" + ex));
        }
    }

    public void testGlobalInfo() {
        if (!this.m_GOETester.checkGlobalInfo()) {
            AbstractFilterTest.fail((String)"No globalInfo method");
        }
    }

    public void testToolTips() {
        if (!this.m_GOETester.checkToolTips()) {
            AbstractFilterTest.fail((String)"Tool tips inconsistent");
        }
    }

    protected String compareDatasets(Instances data1, Instances data2) {
        int x;
        if (data1.numInstances() != data2.numInstances()) {
            System.err.println(this.getName() + " [compareDatasets] datasets differ in number of instances: " + data1.numInstances() + " != " + data2.numInstances());
        }
        if (data1.numAttributes() != data2.numAttributes()) {
            System.err.println(this.getName() + " [compareDatasets] datasets differ in number of attributes: " + data1.numAttributes() + " != " + data2.numAttributes());
        }
        for (x = 0; x < data1.numAttributes() && x < data2.numAttributes(); ++x) {
            if (data1.attribute(x).type() == data2.attribute(x).type()) continue;
            System.err.println(this.getName() + " [compareDatasets] datasets differ in attribute type at " + (x + 1) + ": " + Attribute.typeToString((int)data1.attribute(x).type()) + " != " + Attribute.typeToString((int)data2.attribute(x).type()));
        }
        for (int y = 0; y < data1.numInstances() && y < data2.numInstances(); ++y) {
            for (x = 0; x < data1.numAttributes() && x < data2.numAttributes(); ++x) {
                Object c2;
                Object c1;
                if (data1.attribute(x).type() != data2.attribute(x).type()) continue;
                switch (data1.attribute(x).type()) {
                    case 2: {
                        c1 = data1.instance(y).stringValue(x);
                        c2 = data2.instance(y).stringValue(x);
                        break;
                    }
                    case 4: {
                        c1 = data1.instance(y).relationalValue(x).toString();
                        c2 = data2.instance(y).relationalValue(x).toString();
                        break;
                    }
                    default: {
                        c1 = data1.instance(y).value(x);
                        c2 = data2.instance(y).value(x);
                    }
                }
                if (c1.compareTo(c2) == 0) continue;
                return "Values differ in instance " + (y + 1) + " at attribute " + (x + 1) + ":\n" + c1 + "\n" + "!=\n" + c2;
            }
        }
        return null;
    }

    public void testChangesInputData() {
        String msg;
        Instances result;
        Instances icopy = new Instances(this.m_Instances);
        try {
            this.m_Filter.setInputFormat(this.m_Instances);
        }
        catch (Exception e) {
            AbstractFilterTest.fail((String)("Failed to use setInputFormat: " + e));
        }
        try {
            result = Filter.useFilter((Instances)this.m_Instances, (Filter)this.m_Filter);
            msg = this.compareDatasets(this.m_Instances, icopy);
            AbstractFilterTest.assertNotNull((String)"Filtered data is null", (Object)result);
            AbstractFilterTest.assertNull((String)("1st filtering changed input data: " + msg), (Object)msg);
        }
        catch (Exception e) {
            AbstractFilterTest.fail((String)("Failed to apply filter for 1st time: " + e));
        }
        try {
            result = Filter.useFilter((Instances)this.m_Instances, (Filter)this.m_Filter);
            msg = this.compareDatasets(this.m_Instances, icopy);
            AbstractFilterTest.assertNotNull((String)"Filtered data is null", (Object)result);
            AbstractFilterTest.assertNull((String)("2nd filtering changed input data: " + msg), (Object)msg);
        }
        catch (Exception e) {
            AbstractFilterTest.fail((String)("Failed to apply filter for 2nd time: " + e));
        }
    }
}

