/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.instance;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.AttributeStats;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.supervised.instance.Resample;

public class ResampleTest
extends AbstractFilterTest {
    public ResampleTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances.setClassIndex(1);
    }

    @Override
    public Filter getFilter() {
        Resample f = new Resample();
        f.setSampleSizePercent(50.0);
        return f;
    }

    public void testSampleSizePercent() {
        Instances result = this.useFilter();
        ResampleTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        ResampleTest.assertEquals((String)"Expecting output to be 50% of input", (int)(this.m_Instances.numInstances() / 2), (int)result.numInstances());
        ((Resample)this.m_Filter).setSampleSizePercent(200.0);
        result = this.useFilter();
        ResampleTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        ResampleTest.assertEquals((String)"Expecting output to be 200% of input", (int)(this.m_Instances.numInstances() * 2), (int)result.numInstances());
    }

    public void testSampleSizePercentNoReplacement() {
        ((Resample)this.m_Filter).setSampleSizePercent(20.0);
        ((Resample)this.m_Filter).setNoReplacement(true);
        Instances result = this.useFilter();
        ResampleTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        ResampleTest.assertEquals((String)"Expecting output to be 3", (int)3, (int)result.numInstances());
    }

    public void testSampleSizePercentNoReplacementInverted() {
        ((Resample)this.m_Filter).setSampleSizePercent(20.0);
        ((Resample)this.m_Filter).setNoReplacement(true);
        ((Resample)this.m_Filter).setInvertSelection(true);
        Instances result = this.useFilter();
        ResampleTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        ResampleTest.assertEquals((String)"Expecting output to be 18", (int)18, (int)result.numInstances());
    }

    public void testNoBias() throws Exception {
        this.m_Instances.setClassIndex(1);
        AttributeStats origs = this.m_Instances.attributeStats(1);
        ResampleTest.assertNotNull((Object)origs.nominalCounts);
        Instances result = this.useFilter();
        ResampleTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        AttributeStats outs = result.attributeStats(1);
        ResampleTest.assertNotNull((Object)outs.nominalCounts);
        ResampleTest.assertEquals((int)origs.nominalCounts.length, (int)outs.nominalCounts.length);
        for (int i = 0; i < origs.nominalCounts.length; ++i) {
            int est = origs.nominalCounts[i] / 2 - 1;
            ResampleTest.assertTrue((String)("Counts for value:" + i + " orig:" + origs.nominalCounts[i] + " out50%:" + outs.nominalCounts[i]), (est <= outs.nominalCounts[i] && outs.nominalCounts[i] <= est + 3 ? 1 : 0) != 0);
        }
    }

    public void testBiasToUniform() throws Exception {
        this.m_Instances.setClassIndex(1);
        AttributeStats origs = this.m_Instances.attributeStats(1);
        ResampleTest.assertNotNull((Object)origs.nominalCounts);
        ((Resample)this.m_Filter).setBiasToUniformClass(1.0);
        Instances result = this.useFilter();
        ResampleTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        AttributeStats outs = result.attributeStats(1);
        ResampleTest.assertNotNull((Object)outs.nominalCounts);
        ResampleTest.assertEquals((int)origs.nominalCounts.length, (int)outs.nominalCounts.length);
        int est = (origs.totalCount - origs.missingCount) / origs.distinctCount;
        est = est / 2 - 1;
        for (int i = 0; i < origs.nominalCounts.length; ++i) {
            ResampleTest.assertTrue((String)("Counts for value:" + i + " orig:" + origs.nominalCounts[i] + " out50%:" + outs.nominalCounts[i] + " ~wanted:" + est), (est <= outs.nominalCounts[i] && outs.nominalCounts[i] <= est + 3 ? 1 : 0) != 0);
        }
    }

    public static Test suite() {
        return new TestSuite(ResampleTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ResampleTest.suite());
    }
}

