/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.RenameNominalValues;

public class RenameNominalValuesTest
extends AbstractFilterTest {
    public RenameNominalValuesTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        return this.getFilter("2,5", "b:bob");
    }

    public Filter getFilter(String rangelist, String renameSpec) {
        RenameNominalValues af = new RenameNominalValues();
        if (rangelist.length() > 0) {
            af.setSelectedAttributes(rangelist);
        }
        if (renameSpec.length() > 0) {
            af.setValueReplacements(renameSpec);
        }
        return af;
    }

    public void testNoSelectedAttsNoReplaceSpec() {
        this.m_Filter = this.getFilter();
        ((RenameNominalValues)this.m_Filter).setSelectedAttributes("");
        ((RenameNominalValues)this.m_Filter).setValueReplacements("");
        Instances result = this.useFilter();
        RenameNominalValuesTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        RenameNominalValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        for (int i = 0; i < result.numInstances(); ++i) {
            Instance orig = this.m_Instances.instance(i);
            Instance filtered = result.instance(i);
            for (int j = 0; j < orig.numAttributes(); ++j) {
                RenameNominalValuesTest.assertEquals((Object)orig.value(j), (Object)filtered.value(j));
            }
        }
    }

    public void testTypical() {
        this.m_Filter = this.getFilter();
        Instances result = this.useFilter();
        RenameNominalValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        RenameNominalValuesTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        Attribute first = result.attribute(1);
        Attribute second = result.attribute(4);
        RenameNominalValuesTest.assertEquals((String)first.value(2), (String)"bob");
        RenameNominalValuesTest.assertEquals((String)second.value(1), (String)"bob");
        Instance inst = result.instance(1);
        RenameNominalValuesTest.assertEquals((String)inst.stringValue(1), (String)"bob");
        RenameNominalValuesTest.assertEquals((String)inst.stringValue(4), (String)"bob");
    }

    public void testTypical2() {
        this.m_Filter = this.getFilter("2", "b:bob");
        Instances result = this.useFilter();
        RenameNominalValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        RenameNominalValuesTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        Attribute first = result.attribute(1);
        Attribute second = result.attribute(4);
        RenameNominalValuesTest.assertEquals((String)first.value(2), (String)"bob");
        RenameNominalValuesTest.assertEquals((String)second.value(1), (String)"b");
        Instance inst = result.instance(1);
        RenameNominalValuesTest.assertEquals((String)inst.stringValue(1), (String)"bob");
        RenameNominalValuesTest.assertEquals((String)inst.stringValue(4), (String)"b");
    }

    public void testInverted1() {
        this.m_Filter = this.getFilter("", "b:bob");
        ((RenameNominalValues)this.m_Filter).setInvertSelection(true);
        Instances result = this.useFilter();
        RenameNominalValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        RenameNominalValuesTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        Attribute first = result.attribute(1);
        Attribute second = result.attribute(4);
        RenameNominalValuesTest.assertEquals((String)first.value(2), (String)"bob");
        RenameNominalValuesTest.assertEquals((String)second.value(1), (String)"bob");
        Instance inst = result.instance(1);
        RenameNominalValuesTest.assertEquals((String)inst.stringValue(1), (String)"bob");
        RenameNominalValuesTest.assertEquals((String)inst.stringValue(4), (String)"bob");
    }

    @Override
    public void testFilteredClassifier() {
        try {
            Instances data = this.getFilteredClassifierData();
            for (int i = 0; i < data.numAttributes(); ++i) {
                if (data.classIndex() == i || !data.attribute(i).isNominal()) continue;
                ((RenameNominalValues)this.m_FilteredClassifier.getFilter()).setSelectedAttributes("" + (i + 1));
                break;
            }
        }
        catch (Exception e) {
            RenameNominalValuesTest.fail((String)("Problem setting up test for FilteredClassifier: " + e.toString()));
        }
        super.testFilteredClassifier();
    }

    public static Test suite() {
        return new TestSuite(RenameNominalValuesTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RenameNominalValuesTest.suite());
    }
}

