/*
 * Decompiled with CFR 0.152.
 */
package weka.filters;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.RenameRelation;

public class RenameRelationTest
extends AbstractFilterTest {
    public RenameRelationTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        return new RenameRelation();
    }

    public void testTypical() {
        String originalRelationName = this.m_Instances.relationName();
        ((RenameRelation)this.m_Filter).setModificationText("GoofyGoober");
        Instances result = this.useFilter();
        RenameRelationTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        RenameRelationTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        RenameRelationTest.assertEquals((String)this.m_Instances.relationName(), (String)originalRelationName);
        RenameRelationTest.assertEquals((String)result.relationName(), (String)"GoofyGoober");
    }

    public void testPrepend() {
        String originalRelationName = this.m_Instances.relationName();
        this.m_Filter = this.getFilter();
        ((RenameRelation)this.m_Filter).setModificationText("GoofyGoober");
        ((RenameRelation)this.m_Filter).setModType(RenameRelation.ModType.PREPEND);
        Instances result = this.useFilter();
        RenameRelationTest.assertEquals((String)result.relationName(), (String)("GoofyGoober" + originalRelationName));
    }

    public void testAppend() {
        String originalRelationName = this.m_Instances.relationName();
        this.m_Filter = this.getFilter();
        ((RenameRelation)this.m_Filter).setModificationText("GoofyGoober");
        ((RenameRelation)this.m_Filter).setModType(RenameRelation.ModType.APPEND);
        Instances result = this.useFilter();
        RenameRelationTest.assertEquals((String)result.relationName(), (String)(originalRelationName + "GoofyGoober"));
    }

    public void testRegex() {
        this.m_Filter = this.getFilter();
        ((RenameRelation)this.m_Filter).setModificationText("GoofyGoober");
        ((RenameRelation)this.m_Filter).setModType(RenameRelation.ModType.REGEX);
        ((RenameRelation)this.m_Filter).setRegexMatch("Test");
        Instances result = this.useFilter();
        RenameRelationTest.assertEquals((String)result.relationName(), (String)"FilterGoofyGoober");
    }

    public static Test suite() {
        return new TestSuite(RenameRelationTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RenameRelationTest.suite());
    }
}

