/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.EventSetDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.PluginManager;
import weka.core.Utils;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.HeadlessEventCollector;
import weka.gui.beans.ImageEvent;
import weka.gui.beans.ImageListener;
import weka.gui.beans.OffscreenChartRenderer;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;
import weka.gui.beans.WekaOffscreenChartRenderer;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizePanel;

public class DataVisualizer
extends JPanel
implements DataSourceListener,
TrainingSetListener,
TestSetListener,
Visible,
UserRequestAcceptor,
Serializable,
BeanContextChild,
HeadlessEventCollector,
EnvironmentHandler,
BeanCommon,
EventConstraints {
    private static final long serialVersionUID = 1949062132560159028L;
    protected BeanVisual m_visual = new BeanVisual("DataVisualizer", "weka/gui/beans/icons/DefaultDataVisualizer.gif", "weka/gui/beans/icons/DefaultDataVisualizer_animated.gif");
    protected transient Instances m_visualizeDataSet;
    protected transient JFrame m_popupFrame;
    protected boolean m_framePoppedUp = false;
    protected boolean m_design;
    protected transient BeanContext m_beanContext = null;
    private VisualizePanel m_visPanel;
    protected List<EventObject> m_headlessEvents;
    protected transient boolean m_processingHeadlessEvents = false;
    protected ArrayList<ImageListener> m_imageListeners = new ArrayList();
    protected List<Object> m_listenees = new ArrayList<Object>();
    private final Vector<DataSourceListener> m_dataSetListeners = new Vector();
    protected transient List<Instances> m_offscreenPlotData;
    protected transient OffscreenChartRenderer m_offscreenRenderer;
    protected String m_offscreenRendererName = "Weka Chart Renderer";
    protected String m_xAxis = "";
    protected String m_yAxis = "";
    protected String m_additionalOptions = "";
    protected String m_width = "500";
    protected String m_height = "400";
    protected transient Environment m_env;
    protected BeanContextChildSupport m_bcSupport = new BeanContextChildSupport(this);

    public DataVisualizer() {
        GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (!GraphicsEnvironment.isHeadless()) {
            this.appearanceFinal();
        } else {
            this.m_headlessEvents = new ArrayList<EventObject>();
        }
    }

    public String globalInfo() {
        return "Visualize incoming data/training/test sets in a 2D scatter plot.";
    }

    protected void appearanceDesign() {
        this.m_visPanel = null;
        this.removeAll();
        this.useDefaultVisual();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    protected void appearanceFinal() {
        GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.removeAll();
        if (!GraphicsEnvironment.isHeadless()) {
            this.setLayout(new BorderLayout());
            this.setUpFinal();
        }
    }

    protected void setUpFinal() {
        if (this.m_visPanel == null) {
            this.m_visPanel = new VisualizePanel();
        }
        this.add((Component)this.m_visPanel, "Center");
    }

    @Override
    public void acceptTrainingSet(TrainingSetEvent e) {
        Instances trainingSet = e.getTrainingSet();
        DataSetEvent dse = new DataSetEvent(this, trainingSet);
        this.acceptDataSet(dse);
    }

    @Override
    public void acceptTestSet(TestSetEvent e) {
        Instances testSet = e.getTestSet();
        DataSetEvent dse = new DataSetEvent(this, testSet);
        this.acceptDataSet(dse);
    }

    @Override
    public synchronized void acceptDataSet(DataSetEvent e) {
        if (e.isStructureOnly()) {
            return;
        }
        this.m_visualizeDataSet = new Instances(e.getDataSet());
        if (this.m_visualizeDataSet.classIndex() < 0) {
            this.m_visualizeDataSet.setClassIndex(this.m_visualizeDataSet.numAttributes() - 1);
        }
        if (!this.m_design) {
            try {
                this.setInstances(this.m_visualizeDataSet);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (this.m_headlessEvents != null) {
            this.m_headlessEvents = new ArrayList<EventObject>();
            this.m_headlessEvents.add(e);
        }
        this.notifyDataSetListeners(e);
        this.renderOffscreenImage(e);
    }

    protected void renderOffscreenImage(DataSetEvent e) {
        if (this.m_env == null) {
            this.m_env = Environment.getSystemWide();
        }
        if (this.m_imageListeners.size() > 0 && !this.m_processingHeadlessEvents) {
            String[] optionsParts;
            this.setupOffscreenRenderer();
            this.m_offscreenPlotData = new ArrayList<Instances>();
            Instances predictedI = e.getDataSet();
            if (predictedI.classIndex() >= 0 && predictedI.classAttribute().isNominal()) {
                int i;
                Instances[] classes = new Instances[predictedI.numClasses()];
                for (i = 0; i < predictedI.numClasses(); ++i) {
                    classes[i] = new Instances(predictedI, 0);
                    classes[i].setRelationName(predictedI.classAttribute().value(i));
                }
                for (i = 0; i < predictedI.numInstances(); ++i) {
                    Instance current = predictedI.instance(i);
                    classes[(int)current.classValue()].add((Instance)current.copy());
                }
                for (Instances classe : classes) {
                    this.m_offscreenPlotData.add(classe);
                }
            } else {
                this.m_offscreenPlotData.add(new Instances(predictedI));
            }
            ArrayList<String> options = new ArrayList<String>();
            String additional = this.m_additionalOptions;
            if (this.m_additionalOptions != null && this.m_additionalOptions.length() > 0) {
                try {
                    additional = this.m_env.substitute(additional);
                }
                catch (Exception current) {
                    // empty catch block
                }
            }
            if (additional != null && additional.indexOf("-color") < 0) {
                if (additional.length() > 0) {
                    additional = additional + ",";
                }
                additional = predictedI.classIndex() >= 0 ? additional + "-color=" + predictedI.classAttribute().name() : additional + "-color=/last";
            }
            for (String p : optionsParts = additional.split(",")) {
                options.add(p.trim());
            }
            String xAxis = this.m_xAxis;
            try {
                xAxis = this.m_env.substitute(xAxis);
            }
            catch (Exception classe) {
                // empty catch block
            }
            String yAxis = this.m_yAxis;
            try {
                yAxis = this.m_env.substitute(yAxis);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String width = this.m_width;
            String height = this.m_height;
            int defWidth = 500;
            int defHeight = 400;
            try {
                width = this.m_env.substitute(width);
                height = this.m_env.substitute(height);
                defWidth = Integer.parseInt(width);
                defHeight = Integer.parseInt(height);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                BufferedImage osi = this.m_offscreenRenderer.renderXYScatterPlot(defWidth, defHeight, this.m_offscreenPlotData, xAxis, yAxis, options);
                ImageEvent ie = new ImageEvent(this, osi);
                this.notifyImageListeners(ie);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyImageListeners(ImageEvent te) {
        ArrayList l;
        DataVisualizer dataVisualizer = this;
        synchronized (dataVisualizer) {
            l = (ArrayList)this.m_imageListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((ImageListener)l.get(i)).acceptImage(te);
            }
        }
    }

    @Override
    public List<EventObject> retrieveHeadlessEvents() {
        return this.m_headlessEvents;
    }

    @Override
    public void processHeadlessEvents(List<EventObject> headless) {
        if (!GraphicsEnvironment.isHeadless()) {
            this.m_processingHeadlessEvents = true;
            for (EventObject e : headless) {
                if (!(e instanceof DataSetEvent)) continue;
                this.acceptDataSet((DataSetEvent)e);
            }
        }
        this.m_processingHeadlessEvents = false;
    }

    @Override
    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    @Override
    public BeanVisual getVisual() {
        return this.m_visual;
    }

    @Override
    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DefaultDataVisualizer.gif", "weka/gui/beans/icons/DefaultDataVisualizer_animated.gif");
    }

    @Override
    public Enumeration<String> enumerateRequests() {
        Vector<String> newVector = new Vector<String>(0);
        if (this.m_visualizeDataSet != null) {
            newVector.addElement("Show plot");
        }
        return newVector.elements();
    }

    @Override
    public void addPropertyChangeListener(String name, PropertyChangeListener pcl) {
        this.m_bcSupport.addPropertyChangeListener(name, pcl);
    }

    @Override
    public void removePropertyChangeListener(String name, PropertyChangeListener pcl) {
        this.m_bcSupport.removePropertyChangeListener(name, pcl);
    }

    @Override
    public void addVetoableChangeListener(String name, VetoableChangeListener vcl) {
        this.m_bcSupport.addVetoableChangeListener(name, vcl);
    }

    @Override
    public void removeVetoableChangeListener(String name, VetoableChangeListener vcl) {
        this.m_bcSupport.removeVetoableChangeListener(name, vcl);
    }

    @Override
    public void setBeanContext(BeanContext bc) {
        this.m_beanContext = bc;
        this.m_design = this.m_beanContext.isDesignTime();
        if (this.m_design) {
            this.appearanceDesign();
        } else {
            GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (!GraphicsEnvironment.isHeadless()) {
                this.appearanceFinal();
            }
        }
    }

    @Override
    public BeanContext getBeanContext() {
        return this.m_beanContext;
    }

    public void setInstances(Instances inst) throws Exception {
        if (this.m_design) {
            throw new Exception("This method is not to be used during design time. It is meant to be used if this bean is being used programatically as as stand alone component.");
        }
        this.m_visualizeDataSet = inst;
        PlotData2D pd1 = new PlotData2D(this.m_visualizeDataSet);
        String relationName = this.m_visualizeDataSet.relationName();
        pd1.setPlotName(relationName);
        try {
            this.m_visPanel.setMasterPlot(pd1);
        }
        catch (Exception ex) {
            System.err.println("Problem setting up visualization (DataVisualizer)");
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDataSetListeners(DataSetEvent ge) {
        Vector l;
        DataVisualizer dataVisualizer = this;
        synchronized (dataVisualizer) {
            l = (Vector)this.m_dataSetListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((DataSourceListener)l.elementAt(i)).acceptDataSet(ge);
            }
        }
    }

    @Override
    public void performRequest(String request) {
        block9: {
            if (request.compareTo("Show plot") == 0) {
                try {
                    if (!this.m_framePoppedUp) {
                        this.m_framePoppedUp = true;
                        VisualizePanel vis = new VisualizePanel();
                        PlotData2D pd1 = new PlotData2D(this.m_visualizeDataSet);
                        String relationName = this.m_visualizeDataSet.relationName();
                        if (relationName.startsWith("__")) {
                            boolean[] connect = new boolean[this.m_visualizeDataSet.numInstances()];
                            for (int i = 1; i < connect.length; ++i) {
                                connect[i] = true;
                            }
                            pd1.setConnectPoints(connect);
                            relationName = relationName.substring(2);
                        }
                        pd1.setPlotName(relationName);
                        try {
                            vis.setMasterPlot(pd1);
                        }
                        catch (Exception ex) {
                            System.err.println("Problem setting up visualization (DataVisualizer)");
                            ex.printStackTrace();
                        }
                        final JFrame jf = Utils.getWekaJFrame("Visualize", this.m_visual);
                        jf.getContentPane().setLayout(new BorderLayout());
                        jf.getContentPane().add((Component)vis, "Center");
                        jf.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                jf.dispose();
                                DataVisualizer.this.m_framePoppedUp = false;
                            }
                        });
                        jf.pack();
                        jf.setSize(800, 600);
                        jf.setLocationRelativeTo(SwingUtilities.getWindowAncestor(this.m_visual));
                        jf.setVisible(true);
                        this.m_popupFrame = jf;
                        break block9;
                    }
                    this.m_popupFrame.toFront();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.m_framePoppedUp = false;
                }
            } else {
                throw new IllegalArgumentException(request + " not supported (DataVisualizer)");
            }
        }
    }

    protected void setupOffscreenRenderer() {
        if (this.m_offscreenRenderer == null) {
            if (this.m_offscreenRendererName == null || this.m_offscreenRendererName.length() == 0) {
                this.m_offscreenRenderer = new WekaOffscreenChartRenderer();
                return;
            }
            if (this.m_offscreenRendererName.equalsIgnoreCase("weka chart renderer")) {
                this.m_offscreenRenderer = new WekaOffscreenChartRenderer();
            } else {
                try {
                    Object r = PluginManager.getPluginInstance("weka.gui.beans.OffscreenChartRenderer", this.m_offscreenRendererName);
                    this.m_offscreenRenderer = r != null && r instanceof OffscreenChartRenderer ? (OffscreenChartRenderer)r : new WekaOffscreenChartRenderer();
                }
                catch (Exception ex) {
                    this.m_offscreenRenderer = new WekaOffscreenChartRenderer();
                }
            }
        }
    }

    public synchronized void addDataSourceListener(DataSourceListener dsl) {
        this.m_dataSetListeners.addElement(dsl);
    }

    public synchronized void removeDataSourceListener(DataSourceListener dsl) {
        this.m_dataSetListeners.remove(dsl);
    }

    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.err.println("Usage: DataVisualizer <dataset>");
                System.exit(1);
            }
            BufferedReader r = new BufferedReader(new FileReader(args[0]));
            Instances inst = new Instances(r);
            final JFrame jf = new JFrame();
            jf.getContentPane().setLayout(new BorderLayout());
            DataVisualizer as = new DataVisualizer();
            as.setInstances(inst);
            jf.getContentPane().add((Component)as, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.setSize(800, 600);
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    public void setOffscreenXAxis(String xAxis) {
        this.m_xAxis = xAxis;
    }

    public String getOffscreenXAxis() {
        return this.m_xAxis;
    }

    public void setOffscreenYAxis(String yAxis) {
        this.m_yAxis = yAxis;
    }

    public String getOffscreenYAxis() {
        return this.m_yAxis;
    }

    public void setOffscreenWidth(String width) {
        this.m_width = width;
    }

    public String getOffscreenWidth() {
        return this.m_width;
    }

    public void setOffscreenHeight(String height) {
        this.m_height = height;
    }

    public String getOffscreenHeight() {
        return this.m_height;
    }

    public void setOffscreenRendererName(String rendererName) {
        this.m_offscreenRendererName = rendererName;
        this.m_offscreenRenderer = null;
    }

    public String getOffscreenRendererName() {
        return this.m_offscreenRendererName;
    }

    public void setOffscreenAdditionalOpts(String additional) {
        this.m_additionalOptions = additional;
    }

    public String getOffscreenAdditionalOpts() {
        return this.m_additionalOptions;
    }

    public synchronized void addImageListener(ImageListener cl) {
        this.m_imageListeners.add(cl);
    }

    public synchronized void removeImageListener(ImageListener cl) {
        this.m_imageListeners.remove(cl);
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    @Override
    public void setLog(Logger logger) {
    }

    @Override
    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    @Override
    public boolean connectionAllowed(String eventName) {
        return eventName.equals("dataSet") || eventName.equals("trainingSet") || eventName.equals("testSet");
    }

    @Override
    public void connectionNotification(String eventName, Object source) {
        if (this.connectionAllowed(eventName)) {
            this.m_listenees.add(source);
        }
    }

    @Override
    public void disconnectionNotification(String eventName, Object source) {
        this.m_listenees.remove(source);
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        if (this.m_listenees.size() == 0) {
            return false;
        }
        boolean ok = false;
        for (Object o : this.m_listenees) {
            if (!(o instanceof EventConstraints) || !((EventConstraints)o).eventGeneratable("dataSet") && !((EventConstraints)o).eventGeneratable("trainingSet") && !((EventConstraints)o).eventGeneratable("testSet")) continue;
            ok = true;
            break;
        }
        return ok;
    }
}

