/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.simplecli;

import java.util.ArrayList;
import weka.core.CapabilitiesHandler;
import weka.core.OptionHandler;
import weka.gui.simplecli.AbstractCommand;

public class Capabilities
extends AbstractCommand {
    @Override
    public String getName() {
        return "capabilities";
    }

    @Override
    public String getHelp() {
        return "Lists the capabilities of the specified class.\nIf the class is a " + OptionHandler.class.getName() + " then\ntrailing options after the classname will be\nset as well.\n";
    }

    @Override
    public String getParameterHelp() {
        return "<classname> <args>";
    }

    @Override
    protected void doExecute(String[] params) throws Exception {
        try {
            Object obj = Class.forName(params[0]).newInstance();
            if (obj instanceof CapabilitiesHandler) {
                if (obj instanceof OptionHandler) {
                    ArrayList<String> args = new ArrayList<String>();
                    for (int i = 1; i < params.length; ++i) {
                        args.add(params[i]);
                    }
                    ((OptionHandler)obj).setOptions(args.toArray(new String[args.size()]));
                }
                weka.core.Capabilities caps = ((CapabilitiesHandler)obj).getCapabilities();
                System.out.println(caps.toString().replace("[", "\n").replace("]", "\n"));
            } else {
                System.out.println("'" + params[0] + "' is not a " + CapabilitiesHandler.class.getName() + "!");
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

