/* The following code was generated by JFlex 1.7.0 */

/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Scanner.java
 * Copyright (C) 2015 University of Waikato, Hamilton, New Zealand
 */

 package weka.core.expressionlanguage.parser;
 
 import java_cup.runtime.*;
 
 import weka.core.expressionlanguage.core.SyntaxException;
 
/**
 * A lexical scanner for an expression language.
 * 
 * It emerged as a superset of the weka.core.mathematicalexpression package,
 * the weka.filers.unsupervised.instance.subsetbyexpression package and the
 * weka.core.AttributeExpression class.
 *
 * Warning: This file (Scanner.java) has been auto generated by jflex.
 *
 * @author Benjamin Weber ( benweber at student dot ethz dot ch )
 * @version $Revision: 1000 $
 */

public class Scanner implements java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int STRING1 = 2;
  public static final int STRING2 = 4;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2, 2
  };

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = {
     0,  0,  0,  0,  0,  0,  0,  0,  0, 35, 38, 35, 35, 35,  0,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
    35, 26, 11,  0,  0,  0, 21, 12, 13, 14, 18, 16, 15, 17,  2, 19, 
     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  0,  0, 28, 27, 29,  0, 
     0, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 
    34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34,  0, 36,  0, 20, 34, 
     0,  8, 37, 34, 23,  6,  7, 31, 34, 30, 34, 34,  9, 34, 22, 25, 
    33, 34,  4, 10,  3,  5, 34, 34, 32, 34, 34,  0, 24,  0,  0,  0
  };

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\3\0\1\1\1\2\5\3\1\4\1\5\1\6\1\7"+
    "\1\10\1\11\1\12\1\13\1\14\1\15\1\16\1\3"+
    "\1\17\1\3\1\20\1\21\1\22\1\23\1\3\1\24"+
    "\1\25\1\26\1\25\1\2\5\3\1\17\1\27\1\30"+
    "\1\31\1\32\1\33\1\34\1\35\1\36\1\37\1\40"+
    "\1\41\1\42\3\3\1\16\1\20\1\43\3\3\1\44"+
    "\1\45";

  private static int [] zzUnpackAction() {
    int [] result = new int[63];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\47\0\116\0\165\0\234\0\303\0\352\0\u0111"+
    "\0\u0138\0\u015f\0\165\0\165\0\165\0\165\0\165\0\165"+
    "\0\165\0\165\0\165\0\165\0\165\0\u0186\0\165\0\u01ad"+
    "\0\165\0\165\0\u01d4\0\u01fb\0\u0222\0\165\0\165\0\165"+
    "\0\u0249\0\u0270\0\u0297\0\u02be\0\u02e5\0\u030c\0\u0333\0\u0111"+
    "\0\165\0\165\0\u0111\0\165\0\165\0\165\0\165\0\165"+
    "\0\165\0\165\0\165\0\165\0\u035a\0\u0381\0\u03a8\0\u0111"+
    "\0\u0111\0\u0111\0\u03cf\0\u03f6\0\u041d\0\u0111\0\u0111";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[63];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\4\1\5\1\4\1\6\1\7\2\10\1\11\1\12"+
    "\2\10\1\13\1\14\1\15\1\16\1\17\1\20\1\21"+
    "\1\22\1\23\1\24\1\25\1\26\1\10\1\27\1\30"+
    "\1\31\1\32\1\33\1\34\1\35\4\10\1\36\1\4"+
    "\1\10\1\36\13\37\1\40\30\37\1\41\1\37\1\4"+
    "\14\37\1\40\27\37\1\41\1\37\1\4\50\0\1\5"+
    "\1\42\45\0\1\10\1\0\1\10\1\43\6\10\13\0"+
    "\2\10\1\0\1\10\4\0\5\10\2\0\1\10\2\0"+
    "\1\10\1\0\3\10\1\44\4\10\13\0\2\10\1\0"+
    "\1\10\4\0\5\10\2\0\1\10\2\0\1\10\1\0"+
    "\10\10\13\0\2\10\1\0\1\10\4\0\5\10\2\0"+
    "\1\10\2\0\1\10\1\0\5\10\1\45\2\10\13\0"+
    "\2\10\1\0\1\10\4\0\5\10\2\0\1\10\2\0"+
    "\1\10\1\0\10\10\13\0\1\46\1\10\1\0\1\10"+
    "\4\0\5\10\2\0\1\10\2\0\1\10\1\0\10\10"+
    "\13\0\2\10\1\0\1\47\4\0\5\10\2\0\1\10"+
    "\2\0\1\10\1\0\1\10\1\50\6\10\13\0\2\10"+
    "\1\0\1\10\4\0\5\10\2\0\1\10\34\0\1\51"+
    "\46\0\1\52\14\0\1\10\1\0\7\10\1\53\13\0"+
    "\2\10\1\0\1\10\4\0\5\10\2\0\1\10\1\0"+
    "\3\54\1\55\1\56\2\54\1\57\3\54\1\60\1\61"+
    "\11\54\1\62\15\54\1\63\1\64\2\0\1\42\46\0"+
    "\1\10\1\0\2\10\1\65\5\10\13\0\2\10\1\0"+
    "\1\10\4\0\5\10\2\0\1\10\2\0\1\10\1\0"+
    "\10\10\13\0\2\10\1\0\1\10\4\0\1\10\1\66"+
    "\3\10\2\0\1\10\2\0\1\10\1\0\6\10\1\67"+
    "\1\10\13\0\2\10\1\0\1\10\4\0\5\10\2\0"+
    "\1\10\2\0\1\10\1\0\10\10\13\0\1\10\1\70"+
    "\1\0\1\10\4\0\5\10\2\0\1\10\2\0\1\10"+
    "\1\0\1\71\7\10\13\0\2\10\1\0\1\10\4\0"+
    "\5\10\2\0\1\10\2\0\1\10\1\0\3\10\1\72"+
    "\4\10\13\0\2\10\1\0\1\10\4\0\5\10\2\0"+
    "\1\10\2\0\1\10\1\0\3\10\1\73\4\10\13\0"+
    "\2\10\1\0\1\10\4\0\5\10\2\0\1\10\2\0"+
    "\1\10\1\0\7\10\1\74\13\0\2\10\1\0\1\10"+
    "\4\0\5\10\2\0\1\10\2\0\1\10\1\0\10\10"+
    "\13\0\2\10\1\0\1\10\4\0\2\10\1\75\2\10"+
    "\2\0\1\10\2\0\1\10\1\0\3\10\1\76\4\10"+
    "\13\0\2\10\1\0\1\10\4\0\5\10\2\0\1\10"+
    "\2\0\1\10\1\0\10\10\13\0\2\10\1\0\1\10"+
    "\4\0\3\10\1\77\1\10\2\0\1\10\1\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[1092];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\3\0\1\11\6\1\13\11\1\1\1\11\1\1\2\11"+
    "\3\1\3\11\10\1\2\11\1\1\11\11\13\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[63];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true iff the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true iff the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;
  
  /** 
   * The number of occupied positions in zzBuffer beyond zzEndRead.
   * When a lead/high surrogate has been read from the input stream
   * into the final zzBuffer position, this will have a value of 1;
   * otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /* user code: */
  private StringBuilder string = new StringBuilder();
  
  private Symbol symbol(int type) {
    return new Symbol(type);
  }
  
  private Symbol symbol(int type, Object obj) {
    return new Symbol(type, obj);
  }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public Scanner(java.io.Reader in) {
    this.zzReader = in;
  }



  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException("Reader returned 0 characters. See JFlex examples for workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      /* If numRead == requested, we might have requested to few chars to
         encode a full Unicode character. We assume that a Reader would
         otherwise never return half characters. */
      if (numRead == requested) {
        if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    zzFinalHighSurrogate = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) throws SyntaxException {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new SyntaxException(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  throws SyntaxException {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException, SyntaxException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
          { return new java_cup.runtime.Symbol(sym.EOF); }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { throw new SyntaxException("Illegal character " + yytext() + "!");
            } 
            // fall through
          case 38: break;
          case 2: 
            { return symbol(sym.FLOAT, Double.valueOf(yytext()));
            } 
            // fall through
          case 39: break;
          case 3: 
            { return symbol(sym.IDENTIFIER, yytext());
            } 
            // fall through
          case 40: break;
          case 4: 
            { yybegin(STRING1); string.setLength(0);
            } 
            // fall through
          case 41: break;
          case 5: 
            { yybegin(STRING2); string.setLength(0);
            } 
            // fall through
          case 42: break;
          case 6: 
            { return symbol(sym.LPAREN);
            } 
            // fall through
          case 43: break;
          case 7: 
            { return symbol(sym.RPAREN);
            } 
            // fall through
          case 44: break;
          case 8: 
            { return symbol(sym.COMMA);
            } 
            // fall through
          case 45: break;
          case 9: 
            { return symbol(sym.PLUS);
            } 
            // fall through
          case 46: break;
          case 10: 
            { return symbol(sym.MINUS);
            } 
            // fall through
          case 47: break;
          case 11: 
            { return symbol(sym.TIMES);
            } 
            // fall through
          case 48: break;
          case 12: 
            { return symbol(sym.DIVISION);
            } 
            // fall through
          case 49: break;
          case 13: 
            { return symbol(sym.POW);
            } 
            // fall through
          case 50: break;
          case 14: 
            { return symbol(sym.AND);
            } 
            // fall through
          case 51: break;
          case 15: 
            { return symbol(sym.OR);
            } 
            // fall through
          case 52: break;
          case 16: 
            { return symbol(sym.NOT);
            } 
            // fall through
          case 53: break;
          case 17: 
            { return symbol(sym.EQUAL);
            } 
            // fall through
          case 54: break;
          case 18: 
            { return symbol(sym.LT);
            } 
            // fall through
          case 55: break;
          case 19: 
            { return symbol(sym.GT);
            } 
            // fall through
          case 56: break;
          case 20: 
            { /* ignore */
            } 
            // fall through
          case 57: break;
          case 21: 
            { string.append(yytext());
            } 
            // fall through
          case 58: break;
          case 22: 
            { yybegin(YYINITIAL); return symbol(sym.STRING, string.toString());
            } 
            // fall through
          case 59: break;
          case 23: 
            { return symbol(sym.LE);
            } 
            // fall through
          case 60: break;
          case 24: 
            { return symbol(sym.GE);
            } 
            // fall through
          case 61: break;
          case 25: 
            { return symbol(sym.IS);
            } 
            // fall through
          case 62: break;
          case 26: 
            { throw new SyntaxException("Invalid escape sequence '" + yytext() + "'!");
            } 
            // fall through
          case 63: break;
          case 27: 
            { string.append('\t');
            } 
            // fall through
          case 64: break;
          case 28: 
            { string.append('\r');
            } 
            // fall through
          case 65: break;
          case 29: 
            { string.append('\f');
            } 
            // fall through
          case 66: break;
          case 30: 
            { string.append('\"');
            } 
            // fall through
          case 67: break;
          case 31: 
            { string.append('\'');
            } 
            // fall through
          case 68: break;
          case 32: 
            { string.append('\n');
            } 
            // fall through
          case 69: break;
          case 33: 
            { string.append('\\');
            } 
            // fall through
          case 70: break;
          case 34: 
            { string.append('\b');
            } 
            // fall through
          case 71: break;
          case 35: 
            { return symbol(sym.BOOLEAN, true);
            } 
            // fall through
          case 72: break;
          case 36: 
            { return symbol(sym.BOOLEAN, false);
            } 
            // fall through
          case 73: break;
          case 37: 
            { return symbol(sym.REGEXP);
            } 
            // fall through
          case 74: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
