/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.RoundingMode;
import java.text.BreakIterator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import weka.core.Attribute;
import weka.core.CapabilitiesHandler;
import weka.core.CapabilitiesUtils;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.ResourceUtils;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public final class Utils
implements RevisionHandler {
    public static double log2 = Math.log(2.0);
    public static double SMALL = 1.0E-6;
    private static final ThreadLocal<DecimalFormat> DF = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            DecimalFormat df = new DecimalFormat();
            DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
            dfs.setDecimalSeparator('.');
            dfs.setNaN("NaN");
            dfs.setInfinity("Infinity");
            df.setGroupingUsed(false);
            df.setRoundingMode(RoundingMode.HALF_UP);
            df.setDecimalFormatSymbols(dfs);
            return df;
        }
    };
    public static String[] ORDINAL_SUFFIXES = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};

    public static double dateToMillis(String dateString, String dateFormat) throws ParseException {
        return new SimpleDateFormat(dateFormat).parse(dateString).getTime();
    }

    public static String millisToDate(double millis, String dateFormat) {
        return new SimpleDateFormat(dateFormat).format(new Date((long)millis));
    }

    public static String indexToOrdinal(int i) {
        if (i < 0) {
            return "The 0-based index " + i + " is negative!";
        }
        return ++i % 100 == 11 || i % 100 == 12 || i % 100 == 13 ? i + "th" : i + ORDINAL_SUFFIXES[i % 10];
    }

    public static boolean isMissingValue(double val) {
        return Double.isNaN(val);
    }

    public static double missingValue() {
        return Double.NaN;
    }

    public static <T> T cast(Object x) {
        return (T)x;
    }

    public static Properties readProperties(String resourceName) throws Exception {
        return ResourceUtils.readProperties(resourceName);
    }

    public static Properties readProperties(String resourceName, ClassLoader loader) throws Exception {
        return ResourceUtils.readProperties(resourceName, loader);
    }

    public static final double correlation(double[] y1, double[] y2, int n) {
        int i;
        double av1 = 0.0;
        double av2 = 0.0;
        double y11 = 0.0;
        double y22 = 0.0;
        double y12 = 0.0;
        if (n <= 1) {
            return 1.0;
        }
        for (i = 0; i < n; ++i) {
            av1 += y1[i];
            av2 += y2[i];
        }
        av1 /= (double)n;
        av2 /= (double)n;
        for (i = 0; i < n; ++i) {
            y11 += (y1[i] - av1) * (y1[i] - av1);
            y22 += (y2[i] - av2) * (y2[i] - av2);
            y12 += (y1[i] - av1) * (y2[i] - av2);
        }
        double c = y11 * y22 == 0.0 ? 1.0 : y12 / Math.sqrt(Math.abs(y11 * y22));
        return c;
    }

    public static String removeSubstring(String inString, String substring) {
        StringBuffer result = new StringBuffer();
        int oldLoc = 0;
        int loc = 0;
        while ((loc = inString.indexOf(substring, oldLoc)) != -1) {
            result.append(inString.substring(oldLoc, loc));
            oldLoc = loc + substring.length();
        }
        result.append(inString.substring(oldLoc));
        return result.toString();
    }

    public static String replaceSubstring(String inString, String subString, String replaceString) {
        StringBuffer result = new StringBuffer();
        int oldLoc = 0;
        int loc = 0;
        while ((loc = inString.indexOf(subString, oldLoc)) != -1) {
            result.append(inString.substring(oldLoc, loc));
            result.append(replaceString);
            oldLoc = loc + subString.length();
        }
        result.append(inString.substring(oldLoc));
        return result.toString();
    }

    public static String padLeftAndAllowOverflow(String inString, int length) {
        return String.format("%1$" + length + "s", inString);
    }

    public static String padRightAndAllowOverflow(String inString, int length) {
        return String.format("%1$-" + length + "s", inString);
    }

    public static String padLeft(String inString, int length) {
        return String.format("%1$" + length + "." + length + "s", inString);
    }

    public static String padRight(String inString, int length) {
        return String.format("%1$-" + length + "." + length + "s", inString);
    }

    public static String doubleToString(double value, int afterDecimalPoint) {
        DF.get().setMaximumFractionDigits(afterDecimalPoint);
        return DF.get().format(value);
    }

    public static String doubleToString(double value, int width, int afterDecimalPoint) {
        int i;
        int dotPosition;
        String tempString = Utils.doubleToString(value, afterDecimalPoint);
        if (afterDecimalPoint >= width) {
            return tempString;
        }
        char[] result = new char[width];
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = 32;
        }
        if (afterDecimalPoint > 0) {
            dotPosition = tempString.indexOf(46);
            if (dotPosition == -1) {
                dotPosition = tempString.length();
            } else {
                result[width - afterDecimalPoint - 1] = 46;
            }
        } else {
            dotPosition = tempString.length();
        }
        int offset = width - afterDecimalPoint - dotPosition;
        if (afterDecimalPoint > 0) {
            --offset;
        }
        if (offset < 0) {
            return tempString;
        }
        for (i = 0; i < dotPosition; ++i) {
            result[offset + i] = tempString.charAt(i);
        }
        for (i = dotPosition + 1; i < tempString.length(); ++i) {
            result[offset + i] = tempString.charAt(i);
        }
        return new String(result);
    }

    public static Class<?> getArrayClass(Class<?> c) {
        if (c.getComponentType().isArray()) {
            return Utils.getArrayClass(c.getComponentType());
        }
        return c.getComponentType();
    }

    public static int getArrayDimensions(Class<?> array) {
        if (array.getComponentType().isArray()) {
            return 1 + Utils.getArrayDimensions(array.getComponentType());
        }
        return 1;
    }

    public static int getArrayDimensions(Object array) {
        return Utils.getArrayDimensions(array.getClass());
    }

    public static String arrayToString(Object array) {
        String result = "";
        int dimensions = Utils.getArrayDimensions(array);
        if (dimensions == 0) {
            result = "null";
        } else if (dimensions == 1) {
            for (int i = 0; i < Array.getLength(array); ++i) {
                if (i > 0) {
                    result = result + ",";
                }
                result = Array.get(array, i) == null ? result + "null" : result + Array.get(array, i).toString();
            }
        } else {
            for (int i = 0; i < Array.getLength(array); ++i) {
                if (i > 0) {
                    result = result + ",";
                }
                result = result + "[" + Utils.arrayToString(Array.get(array, i)) + "]";
            }
        }
        return result;
    }

    public static boolean eq(double a, double b) {
        return a == b || a - b < SMALL && b - a < SMALL;
    }

    public static void checkForRemainingOptions(String[] options) throws Exception {
        int illegalOptionsFound = 0;
        StringBuffer text = new StringBuffer();
        if (options == null) {
            return;
        }
        for (String option : options) {
            if (option.length() <= 0) continue;
            ++illegalOptionsFound;
            text.append(option + ' ');
        }
        if (illegalOptionsFound > 0) {
            throw new Exception("Illegal options: " + text);
        }
    }

    public static boolean getFlag(char flag, String[] options) throws Exception {
        return Utils.getFlag("" + flag, options);
    }

    public static boolean getFlag(String flag, String[] options) throws Exception {
        int pos = Utils.getOptionPos(flag, options);
        if (pos > -1) {
            options[pos] = "";
        }
        return pos > -1;
    }

    public static String getOption(char flag, String[] options) throws Exception {
        return Utils.getOption("" + flag, options);
    }

    public static String getOption(String flag, String[] options) throws Exception {
        int i = Utils.getOptionPos(flag, options);
        if (i > -1) {
            if (options[i].equals("-" + flag)) {
                if (i + 1 == options.length) {
                    throw new Exception("No value given for -" + flag + " option.");
                }
                options[i] = "";
                String newString = new String(options[i + 1]);
                options[i + 1] = "";
                return newString;
            }
            if (options[i].charAt(1) == '-') {
                return "";
            }
        }
        return "";
    }

    public static int getOptionPos(char flag, String[] options) {
        return Utils.getOptionPos("" + flag, options);
    }

    public static int getOptionPos(String flag, String[] options) {
        if (options == null) {
            return -1;
        }
        for (int i = 0; i < options.length; ++i) {
            if (options[i].length() <= 0 || options[i].charAt(0) != '-') continue;
            try {
                Double.valueOf(options[i]);
                continue;
            }
            catch (NumberFormatException e) {
                if (options[i].equals("-" + flag)) {
                    return i;
                }
                if (options[i].charAt(1) != '-') continue;
                return -1;
            }
        }
        return -1;
    }

    public static String quote(String string) {
        boolean quote = false;
        if (string.indexOf(10) != -1 || string.indexOf(13) != -1 || string.indexOf(39) != -1 || string.indexOf(34) != -1 || string.indexOf(92) != -1 || string.indexOf(9) != -1 || string.indexOf(37) != -1 || string.indexOf(30) != -1) {
            string = Utils.backQuoteChars(string);
            quote = true;
        }
        if (quote || string.indexOf(123) != -1 || string.indexOf(125) != -1 || string.indexOf(44) != -1 || string.equals("?") || string.indexOf(32) != -1 || string.equals("")) {
            string = "'".concat(string).concat("'");
        }
        return string;
    }

    public static String unquote(String string) {
        if (string.startsWith("'") && string.endsWith("'") && ((string = string.substring(1, string.length() - 1)).indexOf("\\n") != -1 || string.indexOf("\\r") != -1 || string.indexOf("\\'") != -1 || string.indexOf("\\\"") != -1 || string.indexOf("\\\\") != -1 || string.indexOf("\\t") != -1 || string.indexOf("\\%") != -1 || string.indexOf("\\u001E") != -1)) {
            string = Utils.unbackQuoteChars(string);
        }
        return string;
    }

    public static String backQuoteChars(String string) {
        char[] charsFind = new char[]{'\\', '\'', '\t', '\n', '\r', '\"', '%', '\u001e'};
        String[] charsReplace = new String[]{"\\\\", "\\'", "\\t", "\\n", "\\r", "\\\"", "\\%", "\\u001E"};
        for (int i = 0; i < charsFind.length; ++i) {
            int index;
            if (string.indexOf(charsFind[i]) == -1) continue;
            StringBuffer newStringBuffer = new StringBuffer();
            while ((index = string.indexOf(charsFind[i])) != -1) {
                if (index > 0) {
                    newStringBuffer.append(string.substring(0, index));
                }
                newStringBuffer.append(charsReplace[i]);
                if (index + 1 < string.length()) {
                    string = string.substring(index + 1);
                    continue;
                }
                string = "";
            }
            newStringBuffer.append(string);
            string = newStringBuffer.toString();
        }
        return string;
    }

    public static String convertNewLines(String string) {
        int index;
        StringBuffer newStringBuffer = new StringBuffer();
        while ((index = string.indexOf(10)) != -1) {
            if (index > 0) {
                newStringBuffer.append(string.substring(0, index));
            }
            newStringBuffer.append('\\');
            newStringBuffer.append('n');
            if (index + 1 < string.length()) {
                string = string.substring(index + 1);
                continue;
            }
            string = "";
        }
        newStringBuffer.append(string);
        string = newStringBuffer.toString();
        newStringBuffer = new StringBuffer();
        while ((index = string.indexOf(13)) != -1) {
            if (index > 0) {
                newStringBuffer.append(string.substring(0, index));
            }
            newStringBuffer.append('\\');
            newStringBuffer.append('r');
            if (index + 1 < string.length()) {
                string = string.substring(index + 1);
                continue;
            }
            string = "";
        }
        newStringBuffer.append(string);
        return newStringBuffer.toString();
    }

    public static String revertNewLines(String string) {
        int index;
        StringBuffer newStringBuffer = new StringBuffer();
        while ((index = string.indexOf("\\n")) != -1) {
            if (index > 0) {
                newStringBuffer.append(string.substring(0, index));
            }
            newStringBuffer.append('\n');
            if (index + 2 < string.length()) {
                string = string.substring(index + 2);
                continue;
            }
            string = "";
        }
        newStringBuffer.append(string);
        string = newStringBuffer.toString();
        newStringBuffer = new StringBuffer();
        while ((index = string.indexOf("\\r")) != -1) {
            if (index > 0) {
                newStringBuffer.append(string.substring(0, index));
            }
            newStringBuffer.append('\r');
            if (index + 2 < string.length()) {
                string = string.substring(index + 2);
                continue;
            }
            string = "";
        }
        newStringBuffer.append(string);
        return newStringBuffer.toString();
    }

    public static String[] partitionOptions(String[] options) {
        for (int i = 0; i < options.length; ++i) {
            if (!options[i].equals("--")) continue;
            options[i++] = "";
            String[] result = new String[options.length - i];
            for (int j = i; j < options.length; ++j) {
                result[j - i] = options[j];
                options[j] = "";
            }
            return result;
        }
        return new String[0];
    }

    public static String unbackQuoteChars(String string) {
        String[] charsFind = new String[]{"\\\\", "\\'", "\\t", "\\n", "\\r", "\\\"", "\\%", "\\u001E"};
        char[] charsReplace = new char[]{'\\', '\'', '\t', '\n', '\r', '\"', '%', '\u001e'};
        return Utils.replaceStrings(string, charsFind, charsReplace);
    }

    public static String replaceStrings(String string, String[] charsFind, char[] charsReplace) {
        int[] pos = new int[charsFind.length];
        String str = new String(string);
        StringBuffer newStringBuffer = new StringBuffer();
        while (str.length() > 0) {
            int curPos = str.length();
            int index = -1;
            for (int i = 0; i < pos.length; ++i) {
                pos[i] = str.indexOf(charsFind[i]);
                if (pos[i] <= -1 || pos[i] >= curPos) continue;
                index = i;
                curPos = pos[i];
            }
            if (index == -1) {
                newStringBuffer.append(str);
                str = "";
                continue;
            }
            newStringBuffer.append(str.substring(0, pos[index]));
            newStringBuffer.append(charsReplace[index]);
            str = str.substring(pos[index] + charsFind[index].length());
        }
        return newStringBuffer.toString();
    }

    public static String[] splitOptions(String quotedOptionString) throws Exception {
        return Utils.splitOptions(quotedOptionString, null, null);
    }

    /*
     * Unable to fully structure code
     */
    public static String[] splitOptions(String quotedOptionString, String[] toReplace, char[] replacements) throws Exception {
        optionsVec = new Vector<String>();
        str = new String(quotedOptionString);
        while (true) lbl-1000:
        // 4 sources

        {
            for (i = 0; i < str.length() && Character.isWhitespace(str.charAt(i)); ++i) {
            }
            if ((str = str.substring(i)).length() == 0) break;
            if (str.charAt(0) == '\"') {
                for (i = 1; i < str.length() && str.charAt(i) != str.charAt(0); ++i) {
                    if (str.charAt(i) != '\\' || ++i < str.length()) continue;
                    throw new Exception("String should not finish with \\");
                }
                if (i >= str.length()) {
                    throw new Exception("Quote parse error.");
                }
                optStr = str.substring(1, i);
                optStr = toReplace != null && replacements != null ? Utils.replaceStrings(optStr, toReplace, replacements) : Utils.unbackQuoteChars(optStr);
                optionsVec.addElement(optStr);
                str = str.substring(i + 1);
                ** continue;
            }
            for (i = 0; i < str.length() && !Character.isWhitespace(str.charAt(i)); ++i) {
            }
            optStr = str.substring(0, i);
            optionsVec.addElement(optStr);
            str = str.substring(i);
        }
        options = new String[optionsVec.size()];
        for (i = 0; i < optionsVec.size(); ++i) {
            options[i] = (String)optionsVec.elementAt(i);
        }
        return options;
    }

    public static String joinOptions(String[] optionArray) {
        String optionString = "";
        for (String element : optionArray) {
            if (element.equals("")) continue;
            boolean escape = false;
            for (int n = 0; n < element.length(); ++n) {
                if (!Character.isWhitespace(element.charAt(n)) && element.charAt(n) != '\"' && element.charAt(n) != '\'') continue;
                escape = true;
                break;
            }
            optionString = escape ? optionString + '\"' + Utils.backQuoteChars(element) + '\"' : optionString + element;
            optionString = optionString + " ";
        }
        return optionString.trim();
    }

    public static Object forName(Class<?> classType, String className, String[] options) throws Exception {
        return ResourceUtils.forName(classType, className, options);
    }

    public static JFrame getWekaJFrame(String title, Component component) {
        JFrame jf = new JFrame(title);
        jf.setDefaultCloseOperation(0);
        Window windowAncestor = null;
        if (component != null && (windowAncestor = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component)) instanceof Frame) {
            jf.setIconImage(((Frame)windowAncestor).getIconImage());
        }
        return jf;
    }

    public static String toCommandLine(Object obj) {
        StringBuffer result = new StringBuffer();
        if (obj != null) {
            result.append(obj.getClass().getName());
            if (obj instanceof OptionHandler) {
                result.append(" " + Utils.joinOptions(((OptionHandler)obj).getOptions()));
            }
        }
        return result.toString().trim();
    }

    public static double info(int[] counts) {
        int total = 0;
        double x = 0.0;
        for (int count : counts) {
            x -= Utils.xlogx(count);
            total += count;
        }
        return x + Utils.xlogx(total);
    }

    public static boolean smOrEq(double a, double b) {
        return a - b < SMALL || a <= b;
    }

    public static boolean grOrEq(double a, double b) {
        return b - a < SMALL || a >= b;
    }

    public static boolean sm(double a, double b) {
        return b - a > SMALL;
    }

    public static boolean gr(double a, double b) {
        return a - b > SMALL;
    }

    public static int kthSmallestValue(int[] array, int k) {
        int[] index = Utils.initialIndex(array.length);
        return array[index[Utils.select(array, index, 0, array.length - 1, k)]];
    }

    public static double kthSmallestValue(double[] array, int k) {
        int[] index = Utils.initialIndex(array.length);
        return array[index[Utils.select(array, index, 0, array.length - 1, k)]];
    }

    public static double log2(double a) {
        return Math.log(a) / log2;
    }

    public static int maxIndex(double[] doubles) {
        double maximum = 0.0;
        int maxIndex = 0;
        for (int i = 0; i < doubles.length; ++i) {
            if (i != 0 && !(doubles[i] > maximum)) continue;
            maxIndex = i;
            maximum = doubles[i];
        }
        return maxIndex;
    }

    public static int maxIndex(int[] ints) {
        int maximum = 0;
        int maxIndex = 0;
        for (int i = 0; i < ints.length; ++i) {
            if (i != 0 && ints[i] <= maximum) continue;
            maxIndex = i;
            maximum = ints[i];
        }
        return maxIndex;
    }

    public static double mean(double[] vector) {
        double sum = 0.0;
        if (vector.length == 0) {
            return 0.0;
        }
        for (double element : vector) {
            sum += element;
        }
        return sum / (double)vector.length;
    }

    public static int minIndex(int[] ints) {
        int minimum = 0;
        int minIndex = 0;
        for (int i = 0; i < ints.length; ++i) {
            if (i != 0 && ints[i] >= minimum) continue;
            minIndex = i;
            minimum = ints[i];
        }
        return minIndex;
    }

    public static int minIndex(double[] doubles) {
        double minimum = 0.0;
        int minIndex = 0;
        for (int i = 0; i < doubles.length; ++i) {
            if (i != 0 && !(doubles[i] < minimum)) continue;
            minIndex = i;
            minimum = doubles[i];
        }
        return minIndex;
    }

    public static void normalize(double[] doubles) {
        double sum = 0.0;
        for (double d : doubles) {
            sum += d;
        }
        Utils.normalize(doubles, sum);
    }

    public static void normalize(double[] doubles, double sum) {
        if (Double.isNaN(sum)) {
            throw new IllegalArgumentException("Can't normalize array. Sum is NaN.");
        }
        if (sum == 0.0) {
            throw new IllegalArgumentException("Can't normalize array. Sum is zero.");
        }
        int i = 0;
        while (i < doubles.length) {
            int n = i++;
            doubles[n] = doubles[n] / sum;
        }
    }

    public static double[] logs2probs(double[] a) {
        double max = a[Utils.maxIndex(a)];
        double sum = 0.0;
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = Math.exp(a[i] - max);
            sum += result[i];
        }
        Utils.normalize(result, sum);
        return result;
    }

    public static double probToLogOdds(double prob) {
        if (Utils.gr(prob, 1.0) || Utils.sm(prob, 0.0)) {
            throw new IllegalArgumentException("probToLogOdds: probability must be in [0,1] " + prob);
        }
        double p = SMALL + (1.0 - 2.0 * SMALL) * prob;
        return Math.log(p / (1.0 - p));
    }

    public static int round(double value) {
        int roundedValue = value > 0.0 ? (int)(value + 0.5) : -((int)(Math.abs(value) + 0.5));
        return roundedValue;
    }

    public static int probRound(double value, Random rand) {
        if (value >= 0.0) {
            double lower = Math.floor(value);
            double prob = value - lower;
            if (rand.nextDouble() < prob) {
                return (int)lower + 1;
            }
            return (int)lower;
        }
        double lower = Math.floor(Math.abs(value));
        double prob = Math.abs(value) - lower;
        if (rand.nextDouble() < prob) {
            return -((int)lower + 1);
        }
        return -((int)lower);
    }

    public static void replaceMissingWithMAX_VALUE(double[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!Utils.isMissingValue(array[i])) continue;
            array[i] = Double.MAX_VALUE;
        }
    }

    public static double roundDouble(double value, int afterDecimalPoint) {
        double mask = Math.pow(10.0, afterDecimalPoint);
        return (double)Math.round(value * mask) / mask;
    }

    public static int[] sort(int[] array) {
        int[] index = Utils.initialIndex(array.length);
        int[] newIndex = new int[array.length];
        Utils.quickSort(array, index, 0, array.length - 1);
        int i = 0;
        while (i < index.length) {
            int j;
            int numEqual = 1;
            for (j = i + 1; j < index.length && array[index[i]] == array[index[j]]; ++j) {
                ++numEqual;
            }
            if (numEqual > 1) {
                int[] helpIndex = new int[numEqual];
                for (j = 0; j < numEqual; ++j) {
                    helpIndex[j] = i + j;
                }
                Utils.quickSort(index, helpIndex, 0, numEqual - 1);
                for (j = 0; j < numEqual; ++j) {
                    newIndex[i + j] = index[helpIndex[j]];
                }
                i += numEqual;
                continue;
            }
            newIndex[i] = index[i];
            ++i;
        }
        return newIndex;
    }

    public static int[] sort(double[] array) {
        int[] index = Utils.initialIndex(array.length);
        if (array.length > 1) {
            array = (double[])array.clone();
            Utils.replaceMissingWithMAX_VALUE(array);
            Utils.quickSort(array, index, 0, array.length - 1);
        }
        return index;
    }

    public static int[] sortWithNoMissingValues(double[] array) {
        int[] index = Utils.initialIndex(array.length);
        if (array.length > 1) {
            Utils.quickSort(array, index, 0, array.length - 1);
        }
        return index;
    }

    public static int[] stableSort(double[] array) {
        int[] index = Utils.initialIndex(array.length);
        if (array.length > 1) {
            int[] newIndex = new int[array.length];
            array = (double[])array.clone();
            Utils.replaceMissingWithMAX_VALUE(array);
            Utils.quickSort(array, index, 0, array.length - 1);
            int i = 0;
            while (i < index.length) {
                int j;
                int numEqual = 1;
                for (j = i + 1; j < index.length && array[index[i]] == array[index[j]]; ++j) {
                    ++numEqual;
                }
                if (numEqual > 1) {
                    int[] helpIndex = new int[numEqual];
                    for (j = 0; j < numEqual; ++j) {
                        helpIndex[j] = i + j;
                    }
                    Utils.quickSort(index, helpIndex, 0, numEqual - 1);
                    for (j = 0; j < numEqual; ++j) {
                        newIndex[i + j] = index[helpIndex[j]];
                    }
                    i += numEqual;
                    continue;
                }
                newIndex[i] = index[i];
                ++i;
            }
            return newIndex;
        }
        return index;
    }

    public static double variance(double[] vector) {
        if (vector.length <= 1) {
            return Double.NaN;
        }
        double mean = 0.0;
        double var = 0.0;
        for (int i = 0; i < vector.length; ++i) {
            double delta = vector[i] - mean;
            var += (vector[i] - (mean += delta / (double)(i + 1))) * delta;
        }
        if ((var /= (double)(vector.length - 1)) < 0.0) {
            return 0.0;
        }
        return var;
    }

    public static double sum(double[] doubles) {
        double sum = 0.0;
        for (double d : doubles) {
            sum += d;
        }
        return sum;
    }

    public static int sum(int[] ints) {
        int sum = 0;
        for (int j : ints) {
            sum += j;
        }
        return sum;
    }

    public static double xlogx(int c) {
        if (c == 0) {
            return 0.0;
        }
        return (double)c * Utils.log2(c);
    }

    private static int[] initialIndex(int size) {
        int[] index = new int[size];
        for (int i = 0; i < size; ++i) {
            index[i] = i;
        }
        return index;
    }

    private static int sortLeftRightAndCenter(double[] array, int[] index, int l, int r) {
        int c = (l + r) / 2;
        Utils.conditionalSwap(array, index, l, c);
        Utils.conditionalSwap(array, index, l, r);
        Utils.conditionalSwap(array, index, c, r);
        return c;
    }

    private static void swap(int[] index, int l, int r) {
        int help = index[l];
        index[l] = index[r];
        index[r] = help;
    }

    private static void conditionalSwap(double[] array, int[] index, int left, int right) {
        if (array[index[left]] > array[index[right]]) {
            int help = index[left];
            index[left] = index[right];
            index[right] = help;
        }
    }

    private static int partition(double[] array, int[] index, int l, int r, double pivot) {
        --r;
        while (true) {
            if (array[index[++l]] < pivot) {
                continue;
            }
            while (array[index[--r]] > pivot) {
            }
            if (l >= r) {
                return l;
            }
            Utils.swap(index, l, r);
        }
    }

    private static int partition(int[] array, int[] index, int l, int r) {
        double pivot = array[index[(l + r) / 2]];
        while (l < r) {
            while ((double)array[index[l]] < pivot && l < r) {
                ++l;
            }
            while ((double)array[index[r]] > pivot && l < r) {
                --r;
            }
            if (l >= r) continue;
            int help = index[l];
            index[l] = index[r];
            index[r] = help;
            ++l;
            --r;
        }
        if (l == r && (double)array[index[r]] > pivot) {
            --r;
        }
        return r;
    }

    private static void quickSort(double[] array, int[] index, int left, int right) {
        int diff = right - left;
        switch (diff) {
            case 0: {
                return;
            }
            case 1: {
                Utils.conditionalSwap(array, index, left, right);
                return;
            }
            case 2: {
                Utils.conditionalSwap(array, index, left, left + 1);
                Utils.conditionalSwap(array, index, left, right);
                Utils.conditionalSwap(array, index, left + 1, right);
                return;
            }
        }
        int pivotLocation = Utils.sortLeftRightAndCenter(array, index, left, right);
        Utils.swap(index, pivotLocation, right - 1);
        int center = Utils.partition(array, index, left, right, array[index[right - 1]]);
        Utils.swap(index, center, right - 1);
        Utils.quickSort(array, index, left, center - 1);
        Utils.quickSort(array, index, center + 1, right);
    }

    private static void quickSort(int[] array, int[] index, int left, int right) {
        if (left < right) {
            int middle = Utils.partition(array, index, left, right);
            Utils.quickSort(array, index, left, middle);
            Utils.quickSort(array, index, middle + 1, right);
        }
    }

    private static int select(double[] array, int[] index, int left, int right, int k) {
        int diff = right - left;
        switch (diff) {
            case 0: {
                return left;
            }
            case 1: {
                Utils.conditionalSwap(array, index, left, right);
                return left + k - 1;
            }
            case 2: {
                Utils.conditionalSwap(array, index, left, left + 1);
                Utils.conditionalSwap(array, index, left, right);
                Utils.conditionalSwap(array, index, left + 1, right);
                return left + k - 1;
            }
        }
        int pivotLocation = Utils.sortLeftRightAndCenter(array, index, left, right);
        Utils.swap(index, pivotLocation, right - 1);
        int center = Utils.partition(array, index, left, right, array[index[right - 1]]);
        Utils.swap(index, center, right - 1);
        if (center - left + 1 >= k) {
            return Utils.select(array, index, left, center, k);
        }
        return Utils.select(array, index, center + 1, right, k - (center - left + 1));
    }

    public static File convertToRelativePath(File absolute) throws Exception {
        File result = null;
        if (File.separator.equals("\\")) {
            try {
                String fileStr = absolute.getPath();
                fileStr = fileStr.substring(0, 1).toLowerCase() + fileStr.substring(1);
                result = Utils.createRelativePath(new File(fileStr));
            }
            catch (Exception e) {
                result = Utils.createRelativePath(absolute);
            }
        } else {
            result = Utils.createRelativePath(absolute);
        }
        return result;
    }

    protected static File createRelativePath(File absolute) throws Exception {
        File userDir = new File(System.getProperty("user.dir"));
        String userPath = userDir.getAbsolutePath() + File.separator;
        String targetPath = new File(absolute.getParent()).getPath() + File.separator;
        String fileName = absolute.getName();
        StringBuffer relativePath = new StringBuffer();
        int subdir = targetPath.indexOf(userPath);
        if (subdir == 0) {
            if (userPath.length() == targetPath.length()) {
                relativePath.append(fileName);
            } else {
                int ll = userPath.length();
                relativePath.append(targetPath.substring(ll));
                relativePath.append(fileName);
            }
        } else {
            int sepCount = 0;
            String temp = new String(userPath);
            while (temp.indexOf(File.separator) != -1) {
                int ind = temp.indexOf(File.separator);
                ++sepCount;
                temp = temp.substring(ind + 1, temp.length());
            }
            String targetTemp = new String(targetPath);
            String userTemp = new String(userPath);
            int tcount = 0;
            while (targetTemp.indexOf(File.separator) != -1) {
                String upart;
                int ind = targetTemp.indexOf(File.separator);
                int ind2 = userTemp.indexOf(File.separator);
                String tpart = targetTemp.substring(0, ind + 1);
                if (tpart.compareTo(upart = userTemp.substring(0, ind2 + 1)) != 0) {
                    if (tcount != 0) break;
                    tcount = -1;
                    break;
                }
                ++tcount;
                targetTemp = targetTemp.substring(ind + 1, targetTemp.length());
                userTemp = userTemp.substring(ind2 + 1, userTemp.length());
            }
            if (tcount == -1) {
                throw new Exception("Can't construct a path to file relative to user dir.");
            }
            if (targetTemp.indexOf(File.separator) == -1) {
                targetTemp = "";
            }
            for (int i = 0; i < sepCount - tcount; ++i) {
                relativePath.append(".." + File.separator);
            }
            relativePath.append(targetTemp + fileName);
        }
        return new File(relativePath.toString());
    }

    private static int select(int[] array, int[] index, int left, int right, int k) {
        if (left == right) {
            return left;
        }
        int middle = Utils.partition(array, index, left, right);
        if (middle - left + 1 >= k) {
            return Utils.select(array, index, left, middle, k);
        }
        return Utils.select(array, index, middle + 1, right, k - (middle - left + 1));
    }

    public static boolean getDontShowDialog(String dialogName) {
        File wekaHome = ResourceUtils.getWekaHome();
        if (!wekaHome.exists()) {
            return false;
        }
        File dialogSubDir = new File(wekaHome.toString() + File.separator + "systemDialogs");
        if (!dialogSubDir.exists()) {
            return false;
        }
        File dialogFile = new File(dialogSubDir.toString() + File.separator + dialogName);
        return dialogFile.exists();
    }

    public static void setDontShowDialog(String dialogName) throws Exception {
        File wekaHome = ResourceUtils.getWekaHome();
        if (!wekaHome.exists()) {
            return;
        }
        File dialogSubDir = new File(wekaHome.toString() + File.separator + "systemDialogs");
        if (!dialogSubDir.exists() && !dialogSubDir.mkdir()) {
            return;
        }
        File dialogFile = new File(dialogSubDir.toString() + File.separator + dialogName);
        dialogFile.createNewFile();
    }

    public static String getDontShowDialogResponse(String dialogName) throws Exception {
        if (!Utils.getDontShowDialog(dialogName)) {
            return null;
        }
        File wekaHome = ResourceUtils.getWekaHome();
        File dialogSubDir = new File(wekaHome.toString() + File.separator + "systemDialogs" + File.separator + dialogName);
        BufferedReader br = new BufferedReader(new FileReader(dialogSubDir));
        String response = br.readLine();
        br.close();
        return response;
    }

    public static void setDontShowDialogResponse(String dialogName, String response) throws Exception {
        File wekaHome = ResourceUtils.getWekaHome();
        if (!wekaHome.exists()) {
            return;
        }
        File dialogSubDir = new File(wekaHome.toString() + File.separator + "systemDialogs");
        if (!dialogSubDir.exists() && !dialogSubDir.mkdir()) {
            return;
        }
        File dialogFile = new File(dialogSubDir.toString() + File.separator + dialogName);
        BufferedWriter br = new BufferedWriter(new FileWriter(dialogFile));
        br.write(response + "\n");
        br.flush();
        br.close();
    }

    public static String[] breakUp(String s, int columns) {
        Vector<String> result = new Vector<String>();
        String punctuation = " .,;:!?'\"";
        String[] lines = s.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            BreakIterator boundary = BreakIterator.getWordInstance();
            boundary.setText(lines[i]);
            int boundaryStart = boundary.first();
            int boundaryEnd = boundary.next();
            String line = "";
            while (boundaryEnd != -1) {
                String word = lines[i].substring(boundaryStart, boundaryEnd);
                if (line.length() >= columns) {
                    if (word.length() == 1 && punctuation.indexOf(word.charAt(0)) > -1) {
                        line = line + word;
                        word = "";
                    }
                    result.add(line);
                    line = "";
                }
                line = line + word;
                boundaryStart = boundaryEnd;
                boundaryEnd = boundary.next();
            }
            if (line.length() <= 0) continue;
            result.add(line);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String getGlobalInfo(Object object, boolean addCapabilities) {
        String gi = null;
        StringBuilder result = new StringBuilder();
        try {
            MethodDescriptor[] methods;
            BeanInfo bi = Introspector.getBeanInfo(object.getClass());
            for (MethodDescriptor method : methods = bi.getMethodDescriptors()) {
                String globalInfo;
                String name = method.getDisplayName();
                Method meth = method.getMethod();
                if (!name.equals("globalInfo") || !meth.getReturnType().equals(String.class)) continue;
                Object[] args = new Object[]{};
                gi = globalInfo = (String)meth.invoke(object, args);
                break;
            }
        }
        catch (Exception bi) {
            // empty catch block
        }
        int lineWidth = 180;
        result.append("<html>");
        if (gi != null && gi.length() > 0) {
            StringBuilder firstLine = new StringBuilder();
            firstLine.append("<font color=blue>");
            boolean addFirstBreaks = true;
            int indexOfDot = gi.indexOf(".");
            if (indexOfDot > 0) {
                firstLine.append(gi.substring(0, gi.indexOf(".")));
                if (gi.length() - indexOfDot < 3) {
                    addFirstBreaks = false;
                }
                gi = gi.substring(indexOfDot + 1, gi.length());
            } else {
                firstLine.append(gi);
                gi = "";
            }
            firstLine.append("</font>");
            if (addFirstBreaks && !gi.startsWith("\n\n")) {
                if (!gi.startsWith("\n")) {
                    firstLine.append("<br>");
                }
                firstLine.append("<br>");
            }
            result.append(Utils.lineWrap(firstLine.toString(), lineWidth));
            result.append(Utils.lineWrap(gi, lineWidth).replace("\n", "<br>"));
            result.append("<br>");
        }
        if (addCapabilities) {
            String caps;
            if (object instanceof CapabilitiesHandler) {
                if (!result.toString().endsWith("<br><br>")) {
                    result.append("<br>");
                }
                caps = CapabilitiesUtils.addCapabilities("<font color=red>CAPABILITIES</font>", ((CapabilitiesHandler)object).getCapabilities());
                caps = Utils.lineWrap(caps, lineWidth).replace("\n", "<br>");
                result.append(caps);
            }
            if (object instanceof MultiInstanceCapabilitiesHandler) {
                result.append("<br>");
                caps = CapabilitiesUtils.addCapabilities("<font color=red>MI CAPABILITIES</font>", ((MultiInstanceCapabilitiesHandler)object).getMultiInstanceCapabilities());
                caps = Utils.lineWrap(caps, lineWidth).replace("\n", "<br>");
                result.append(caps);
            }
        }
        result.append("</html>");
        if (result.toString().equals("<html></html>")) {
            return null;
        }
        return result.toString();
    }

    public static String lineWrap(String input, int maxLineWidth) {
        String toAdd;
        StringBuffer sb = new StringBuffer();
        BreakIterator biterator = BreakIterator.getLineInstance();
        biterator.setText(input);
        int linestart = 0;
        int previous = 0;
        while (true) {
            int next = biterator.next();
            toAdd = input.substring(linestart, previous);
            if (next == -1) break;
            if (next - linestart > maxLineWidth) {
                sb.append(toAdd + '\n');
                linestart = previous;
            } else {
                int newLineIndex = toAdd.lastIndexOf(10);
                if (newLineIndex != -1) {
                    sb.append(toAdd.substring(0, newLineIndex + 1));
                    linestart += newLineIndex + 1;
                }
            }
            previous = next;
        }
        sb.append(toAdd);
        return sb.toString();
    }

    public static Range configureRangeFromRangeStringOrAttributeNameList(Instances instanceInfo, String rangeString) throws Exception {
        Range result = new Range(rangeString);
        try {
            result.setUpper(instanceInfo.numAttributes() - 1);
        }
        catch (IllegalArgumentException e) {
            String[] parts = rangeString.split(",");
            if (parts.length == 0) {
                throw new Exception("Must specify a list of attributes to configure the range object with!");
            }
            StringBuilder indexList = new StringBuilder();
            for (String att : parts) {
                Attribute a = instanceInfo.attribute(att = att.trim());
                if (a == null) {
                    throw new Exception("I can't find the requested attribute '" + att + "' in the supplied instances information.");
                }
                indexList.append(a.index() + 1).append(",");
            }
            if (indexList.length() > 0) {
                indexList.setLength(indexList.length() - 1);
            }
            result = new Range(indexList.toString());
            result.setUpper(instanceInfo.numAttributes() - 1);
        }
        return result;
    }

    public static int[] takeSample(double[] weights, Random random) {
        int I;
        double[] P = new double[weights.length];
        System.arraycopy(weights, 0, P, 0, weights.length);
        Utils.normalize(P);
        double[] Q = new double[weights.length];
        int[] A = new int[weights.length];
        int[] W = new int[weights.length];
        int M = weights.length;
        int NN = -1;
        int NP = M;
        for (I = 0; I < M; ++I) {
            if (P[I] < 0.0) {
                throw new IllegalArgumentException("Weights have to be positive.");
            }
            Q[I] = (double)M * P[I];
            if (Q[I] < 1.0) {
                W[++NN] = I;
                continue;
            }
            W[--NP] = I;
        }
        if (NN > -1 && NP < M) {
            for (int S = 0; S < M - 1; ++S) {
                int J;
                int I2 = W[S];
                A[I2] = J = W[NP];
                int n = J;
                Q[n] = Q[n] + (Q[I2] - 1.0);
                if (Q[J] < 1.0) {
                    ++NP;
                }
                if (NP >= M) break;
            }
        }
        for (I = 0; I < M; ++I) {
            int n = I;
            Q[n] = Q[n] + (double)I;
        }
        int[] result = new int[weights.length];
        for (int i = 0; i < weights.length; ++i) {
            int I3;
            double U = (double)M * random.nextDouble();
            int ALRV = U < Q[I3 = (int)U] ? I3 : A[I3];
            int n = ALRV;
            result[n] = result[n] + 1;
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 15700 $");
    }

    public static void main(String[] ops) {
        double[] doublesWithNaN = new double[]{4.5, 6.7, Double.NaN, 3.4, 4.8, 1.2, 3.4};
        double[] doubles = new double[]{4.5, 6.7, 6.7, 3.4, 4.8, 1.2, 3.4, 6.7, 6.7, 3.4};
        int[] ints = new int[]{12, 6, 2, 18, 16, 6, 7, 5, 18, 18, 17};
        try {
            int i;
            String[] partitionedOptions;
            System.out.println("First option split up:");
            if (ops.length > 0) {
                String[] firstOptionSplitUp;
                for (String element : firstOptionSplitUp = Utils.splitOptions(ops[0])) {
                    System.out.println(element);
                }
            }
            System.out.println("Partitioned options: ");
            for (String partitionedOption : partitionedOptions = Utils.partitionOptions(ops)) {
                System.out.println(partitionedOption);
            }
            System.out.println("Get position of flag -f: " + Utils.getOptionPos('f', ops));
            System.out.println("Get flag -f: " + Utils.getFlag('f', ops));
            System.out.println("Get position of option -o: " + Utils.getOptionPos('o', ops));
            System.out.println("Get option -o: " + Utils.getOption('o', ops));
            System.out.println("Checking for remaining options... ");
            Utils.checkForRemainingOptions(ops);
            System.out.println("Original array with NaN (doubles): ");
            for (double element : doublesWithNaN) {
                System.out.print(element + " ");
            }
            System.out.println();
            System.out.println("Original array (doubles): ");
            for (double d : doubles) {
                System.out.print(d + " ");
            }
            System.out.println();
            System.out.println("Original array (ints): ");
            for (int j : ints) {
                System.out.print(j + " ");
            }
            System.out.println();
            System.out.println("Correlation: " + Utils.correlation(doubles, doubles, doubles.length));
            System.out.println("Mean: " + Utils.mean(doubles));
            System.out.println("Variance: " + Utils.variance(doubles));
            System.out.println("Sum (doubles): " + Utils.sum(doubles));
            System.out.println("Sum (ints): " + Utils.sum(ints));
            System.out.println("Max index (doubles): " + Utils.maxIndex(doubles));
            System.out.println("Max index (ints): " + Utils.maxIndex(ints));
            System.out.println("Min index (doubles): " + Utils.minIndex(doubles));
            System.out.println("Min index (ints): " + Utils.minIndex(ints));
            System.out.println("Median (doubles): " + Utils.kthSmallestValue(doubles, doubles.length / 2));
            System.out.println("Median (ints): " + Utils.kthSmallestValue(ints, ints.length / 2));
            System.out.println("Sorted array with NaN (doubles): ");
            int[] nArray = Utils.sort(doublesWithNaN);
            for (i = 0; i < doublesWithNaN.length; ++i) {
                System.out.print(doublesWithNaN[nArray[i]] + " ");
            }
            System.out.println();
            System.out.println("Sorted array (doubles): ");
            int[] nArray2 = Utils.sort(doubles);
            for (i = 0; i < doubles.length; ++i) {
                System.out.print(doubles[nArray2[i]] + " ");
            }
            System.out.println();
            System.out.println("Sorted array (ints): ");
            int[] nArray3 = Utils.sort(ints);
            for (i = 0; i < ints.length; ++i) {
                System.out.print(ints[nArray3[i]] + " ");
            }
            System.out.println();
            System.out.println("Indices from stable sort (doubles): ");
            int[] nArray4 = Utils.stableSort(doubles);
            for (i = 0; i < doubles.length; ++i) {
                System.out.print(nArray4[i] + " ");
            }
            System.out.println();
            System.out.println("Indices from sort (ints): ");
            int[] nArray5 = Utils.sort(ints);
            for (i = 0; i < ints.length; ++i) {
                System.out.print(nArray5[i] + " ");
            }
            System.out.println();
            System.out.println("Normalized array (doubles): ");
            Utils.normalize(doubles);
            for (double d : doubles) {
                System.out.print(d + " ");
            }
            System.out.println();
            System.out.println("Normalized again (doubles): ");
            Utils.normalize(doubles, Utils.sum(doubles));
            for (double d : doubles) {
                System.out.print(d + " ");
            }
            System.out.println();
            System.out.println("-4.58: " + Utils.doubleToString(-4.57826535, 2));
            System.out.println("-6.78: " + Utils.doubleToString(-6.78214234, 6, 2));
            System.out.println("5.70001 == 5.7 ? " + Utils.eq(5.70001, 5.7));
            System.out.println("5.70001 > 5.7 ? " + Utils.gr(5.70001, 5.7));
            System.out.println("5.70001 >= 5.7 ? " + Utils.grOrEq(5.70001, 5.7));
            System.out.println("5.7 < 5.70001 ? " + Utils.sm(5.7, 5.70001));
            System.out.println("5.7 <= 5.70001 ? " + Utils.smOrEq(5.7, 5.70001));
            System.out.println("Info (ints): " + Utils.info(ints));
            System.out.println("log2(4.6): " + Utils.log2(4.6));
            System.out.println("5 * log(5): " + Utils.xlogx(5));
            System.out.println("5.5 rounded: " + Utils.round(5.5));
            System.out.println("5.55555 rounded to 2 decimal places: " + Utils.roundDouble(5.55555, 2));
            System.out.println("Array-Dimensions of 'new int[][]': " + Utils.getArrayDimensions(new int[0][]));
            System.out.println("Array-Dimensions of 'new int[][]{{1,2,3},{4,5,6}}': " + Utils.getArrayDimensions(new int[][]{{1, 2, 3}, {4, 5, 6}}));
            String[][][] s = new String[3][4][];
            System.out.println("Array-Dimensions of 'new String[3][4][]': " + Utils.getArrayDimensions(s));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

