/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.lmt;

import weka.core.Instance;
import weka.core.Instances;

public class SimpleLinearRegression {
    static final long serialVersionUID = 1779336022895414137L;
    private int m_attributeIndex = -1;
    private double m_slope = Double.NaN;
    private double m_intercept = Double.NaN;

    public SimpleLinearRegression() {
    }

    public SimpleLinearRegression(int attIndex, double slope, double intercept) {
        this.m_attributeIndex = attIndex;
        this.m_slope = slope;
        this.m_intercept = intercept;
    }

    public void addModel(SimpleLinearRegression slr) throws Exception {
        this.m_attributeIndex = slr.m_attributeIndex;
        if (this.m_attributeIndex != -1) {
            this.m_slope += slr.m_slope;
            this.m_intercept += slr.m_intercept;
        } else {
            this.m_slope = slr.m_slope;
            this.m_intercept = slr.m_intercept;
        }
    }

    public double classifyInstance(Instance inst) {
        return this.m_intercept + this.m_slope * inst.value(this.m_attributeIndex);
    }

    protected double[] computeMeans(Instances insts) {
        double[] means = new double[insts.numAttributes()];
        double[] counts = new double[insts.numAttributes()];
        for (int j = 0; j < insts.numInstances(); ++j) {
            Instance inst = insts.instance(j);
            int i = 0;
            while (i < insts.numAttributes()) {
                int n = i;
                means[n] = means[n] + inst.weight() * inst.value(i);
                int n2 = i++;
                counts[n2] = counts[n2] + inst.weight();
            }
        }
        for (int i = 0; i < insts.numAttributes(); ++i) {
            if (counts[i] > 0.0) {
                int n = i;
                means[n] = means[n] / counts[i];
                continue;
            }
            means[i] = 0.0;
        }
        return means;
    }

    public void buildClassifier(Instances insts) {
        double[] means = this.computeMeans(insts);
        double[] slopes = new double[insts.numAttributes()];
        double[] sumWeightedDiffsSquared = new double[insts.numAttributes()];
        int classIndex = insts.classIndex();
        for (int j = 0; j < insts.numInstances(); ++j) {
            Instance inst = insts.instance(j);
            double yDiff = inst.value(classIndex) - means[classIndex];
            double weightedYDiff = inst.weight() * yDiff;
            int i = 0;
            while (i < insts.numAttributes()) {
                double diff = inst.value(i) - means[i];
                double weightedDiff = inst.weight() * diff;
                int n = i;
                slopes[n] = slopes[n] + weightedYDiff * diff;
                int n2 = i++;
                sumWeightedDiffsSquared[n2] = sumWeightedDiffsSquared[n2] + weightedDiff * diff;
            }
        }
        double minSSE = Double.MAX_VALUE;
        this.m_attributeIndex = -1;
        for (int i = 0; i < insts.numAttributes(); ++i) {
            if (i == classIndex || sumWeightedDiffsSquared[i] == 0.0) continue;
            double numerator = slopes[i];
            int n = i;
            slopes[n] = slopes[n] / sumWeightedDiffsSquared[i];
            double intercept = means[classIndex] - slopes[i] * means[i];
            double sse = sumWeightedDiffsSquared[classIndex] - slopes[i] * numerator;
            if (!(sse < minSSE)) continue;
            minSSE = sse;
            this.m_attributeIndex = i;
            this.m_slope = slopes[i];
            this.m_intercept = intercept;
        }
    }

    public boolean foundUsefulAttribute() {
        return this.m_attributeIndex != -1;
    }

    public int getAttributeIndex() {
        return this.m_attributeIndex;
    }

    public double getSlope() {
        return this.m_slope;
    }

    public double getIntercept() {
        return this.m_intercept;
    }
}

