/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import java.util.Random;
import weka.classifiers.bayes.NaiveBayesUpdateable;
import weka.classifiers.trees.j48.C45Split;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.NBTreeNoSplit;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;

public class NBTreeSplit
extends ClassifierSplitModel {
    private static final long serialVersionUID = 8922627123884975070L;
    private int m_complexityIndex;
    private final int m_attIndex;
    private final double m_sumOfWeights;
    private double m_errors;
    private C45Split m_c45S;
    NBTreeNoSplit m_globalNB;

    public NBTreeSplit(int attIndex, int minNoObj, double sumOfWeights) {
        this.m_attIndex = attIndex;
        this.m_sumOfWeights = sumOfWeights;
    }

    @Override
    public void buildClassifier(Instances trainInstances) throws Exception {
        this.m_numSubsets = 0;
        this.m_errors = 0.0;
        if (this.m_globalNB != null) {
            this.m_errors = this.m_globalNB.getErrors();
        }
        if (trainInstances.attribute(this.m_attIndex).isNominal()) {
            this.m_complexityIndex = trainInstances.attribute(this.m_attIndex).numValues();
            this.handleEnumeratedAttribute(trainInstances);
        } else {
            this.m_complexityIndex = 2;
            trainInstances.sort(trainInstances.attribute(this.m_attIndex));
            this.handleNumericAttribute(trainInstances);
        }
    }

    public final int attIndex() {
        return this.m_attIndex;
    }

    private void handleEnumeratedAttribute(Instances trainInstances) throws Exception {
        this.m_c45S = new C45Split(this.m_attIndex, 2, this.m_sumOfWeights, true);
        this.m_c45S.buildClassifier(trainInstances);
        if (this.m_c45S.numSubsets() == 0) {
            return;
        }
        this.m_errors = 0.0;
        Instances[] trainingSets = new Instances[this.m_complexityIndex];
        for (int i = 0; i < this.m_complexityIndex; ++i) {
            trainingSets[i] = new Instances(trainInstances, 0);
        }
        for (int i = 0; i < trainInstances.numInstances(); ++i) {
            Instance instance = trainInstances.instance(i);
            int subset = this.m_c45S.whichSubset(instance);
            if (subset > -1) {
                trainingSets[subset].add((Instance)instance.copy());
                continue;
            }
            double[] weights = this.m_c45S.weights(instance);
            for (int j = 0; j < this.m_complexityIndex; ++j) {
                try {
                    Instance temp = (Instance)instance.copy();
                    if (weights.length == this.m_complexityIndex) {
                        temp.setWeight(temp.weight() * weights[j]);
                    } else {
                        temp.setWeight(temp.weight() / (double)this.m_complexityIndex);
                    }
                    trainingSets[j].add(temp);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    System.err.println("*** " + this.m_complexityIndex);
                    System.err.println(weights.length);
                    System.exit(1);
                }
            }
        }
        Random r = new Random(1L);
        int minNumCount = 0;
        for (int i = 0; i < this.m_complexityIndex; ++i) {
            if (trainingSets[i].numInstances() >= 5) {
                ++minNumCount;
                Discretize disc = new Discretize();
                disc.setInputFormat(trainingSets[i]);
                trainingSets[i] = Filter.useFilter(trainingSets[i], disc);
                trainingSets[i].randomize(r);
                trainingSets[i].stratify(5);
                NaiveBayesUpdateable fullModel = new NaiveBayesUpdateable();
                fullModel.buildClassifier(trainingSets[i]);
                this.m_errors += NBTreeNoSplit.crossValidate(fullModel, trainingSets[i], r);
                continue;
            }
            for (int j = 0; j < trainingSets[i].numInstances(); ++j) {
                this.m_errors += trainingSets[i].instance(j).weight();
            }
        }
        if (minNumCount > 1) {
            this.m_numSubsets = this.m_complexityIndex;
        }
    }

    private void handleNumericAttribute(Instances trainInstances) throws Exception {
        this.m_c45S = new C45Split(this.m_attIndex, 2, this.m_sumOfWeights, true);
        this.m_c45S.buildClassifier(trainInstances);
        if (this.m_c45S.numSubsets() == 0) {
            return;
        }
        this.m_errors = 0.0;
        Instances[] trainingSets = new Instances[this.m_complexityIndex];
        trainingSets[0] = new Instances(trainInstances, 0);
        trainingSets[1] = new Instances(trainInstances, 0);
        int subset = -1;
        for (int i = 0; i < trainInstances.numInstances(); ++i) {
            Instance instance = trainInstances.instance(i);
            subset = this.m_c45S.whichSubset(instance);
            if (subset != -1) {
                trainingSets[subset].add((Instance)instance.copy());
                continue;
            }
            double[] weights = this.m_c45S.weights(instance);
            for (int j = 0; j < this.m_complexityIndex; ++j) {
                Instance temp = (Instance)instance.copy();
                if (weights.length == this.m_complexityIndex) {
                    temp.setWeight(temp.weight() * weights[j]);
                } else {
                    temp.setWeight(temp.weight() / (double)this.m_complexityIndex);
                }
                trainingSets[j].add(temp);
            }
        }
        Random r = new Random(1L);
        int minNumCount = 0;
        for (int i = 0; i < this.m_complexityIndex; ++i) {
            if (trainingSets[i].numInstances() > 5) {
                ++minNumCount;
                Discretize disc = new Discretize();
                disc.setInputFormat(trainingSets[i]);
                trainingSets[i] = Filter.useFilter(trainingSets[i], disc);
                trainingSets[i].randomize(r);
                trainingSets[i].stratify(5);
                NaiveBayesUpdateable fullModel = new NaiveBayesUpdateable();
                fullModel.buildClassifier(trainingSets[i]);
                this.m_errors += NBTreeNoSplit.crossValidate(fullModel, trainingSets[i], r);
                continue;
            }
            for (int j = 0; j < trainingSets[i].numInstances(); ++j) {
                this.m_errors += trainingSets[i].instance(j).weight();
            }
        }
        if (minNumCount > 1) {
            this.m_numSubsets = this.m_complexityIndex;
        }
    }

    @Override
    public final int whichSubset(Instance instance) throws Exception {
        return this.m_c45S.whichSubset(instance);
    }

    @Override
    public final double[] weights(Instance instance) {
        return this.m_c45S.weights(instance);
    }

    @Override
    public final String sourceExpression(int index, Instances data) {
        return this.m_c45S.sourceExpression(index, data);
    }

    @Override
    public final String rightSide(int index, Instances data) {
        return this.m_c45S.rightSide(index, data);
    }

    @Override
    public final String leftSide(Instances data) {
        return this.m_c45S.leftSide(data);
    }

    @Override
    public double classProb(int classIndex, Instance instance, int theSubset) throws Exception {
        if (theSubset > -1) {
            return this.m_globalNB.classProb(classIndex, instance, theSubset);
        }
        throw new Exception("This shouldn't happen!!!");
    }

    public NBTreeNoSplit getGlobalModel() {
        return this.m_globalNB;
    }

    public void setGlobalModel(NBTreeNoSplit global) {
        this.m_globalNB = global;
    }

    public double getErrors() {
        return this.m_errors;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10169 $");
    }
}

