/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.core.SelectedTag;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Add;

public class AddTest
extends AbstractFilterTest {
    public AddTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        return new Add();
    }

    public Filter getFilter(int pos) {
        Add af = new Add();
        af.setAttributeIndex("" + (pos + 1));
        return af;
    }

    public void testAddFirst() {
        this.m_Filter = this.getFilter(0);
        this.testBuffered();
    }

    public void testAddLast() {
        this.m_Filter = this.getFilter(this.m_Instances.numAttributes() - 1);
        this.testBuffered();
    }

    protected void testType(int attType) {
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AddTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            result = Filter.useFilter((Instances)icopy, (Filter)this.m_Filter);
            AddTest.assertNotNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AddTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        AddTest.assertEquals((int)attType, (int)result.attribute(result.numAttributes() - 1).type());
    }

    public void testAddNominal() {
        this.m_Filter = this.getFilter();
        ((Add)this.m_Filter).setNominalLabels("hello,there,bob");
        this.testBuffered();
        this.testType(1);
    }

    public void testAddString() {
        this.m_Filter = this.getFilter();
        ((Add)this.m_Filter).setAttributeType(new SelectedTag(2, Add.TAGS_TYPE));
        this.testBuffered();
        this.testType(2);
    }

    public void testAddDate() {
        this.m_Filter = this.getFilter();
        ((Add)this.m_Filter).setAttributeType(new SelectedTag(3, Add.TAGS_TYPE));
        this.testBuffered();
        this.testType(3);
    }

    public static Test suite() {
        return new TestSuite(AddTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)AddTest.suite());
    }
}

