/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MergeInfrequentNominalValues;

public class MergeInfrequentNominalValuesTest
extends AbstractFilterTest {
    public MergeInfrequentNominalValuesTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        MergeInfrequentNominalValues f = new MergeInfrequentNominalValues();
        return f;
    }

    public void testTypical() {
        Instances result = this.useFilter();
        MergeInfrequentNominalValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MergeInfrequentNominalValuesTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
    }

    public void testDifferentRange() {
        ((MergeInfrequentNominalValues)this.m_Filter).setMinimumFrequency(5);
        ((MergeInfrequentNominalValues)this.m_Filter).setInvertSelection(true);
        Instances result = this.useFilter();
        MergeInfrequentNominalValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MergeInfrequentNominalValuesTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        int mergedIndex = -1;
        for (int i = 0; i < result.numInstances(); ++i) {
            if (this.m_Instances.instance(i).value(4) != 1.0 && this.m_Instances.instance(i).value(4) != 2.0) continue;
            if (mergedIndex == -1) {
                mergedIndex = (int)result.instance(i).value(4);
                continue;
            }
            MergeInfrequentNominalValuesTest.assertEquals((String)("Checking merged value for instance: " + (i + 1)), (int)mergedIndex, (int)((int)result.instance(i).value(4)));
        }
    }

    public void testMergeAll() {
        ((MergeInfrequentNominalValues)this.m_Filter).setMinimumFrequency(100);
        ((MergeInfrequentNominalValues)this.m_Filter).setInvertSelection(true);
        Instances result = this.useFilter();
        MergeInfrequentNominalValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MergeInfrequentNominalValuesTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        MergeInfrequentNominalValuesTest.assertEquals((int)1, (int)result.attribute(1).numValues());
        MergeInfrequentNominalValuesTest.assertEquals((int)1, (int)result.attribute(4).numValues());
    }

    public void testAttributeWithMissing() {
        ((MergeInfrequentNominalValues)this.m_Filter).setAttributeIndices("5");
        ((MergeInfrequentNominalValues)this.m_Filter).setMinimumFrequency(100);
        Instances result = this.useFilter();
        MergeInfrequentNominalValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        MergeInfrequentNominalValuesTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        int mergedIndex = -1;
        for (int i = 0; i < result.numInstances(); ++i) {
            if (this.m_Instances.instance(i).isMissing(4)) {
                MergeInfrequentNominalValuesTest.assertTrue((String)"Missing in input should give missing in result", (boolean)result.instance(i).isMissing(4));
                continue;
            }
            if (this.m_Instances.instance(i).value(4) != 1.0 && this.m_Instances.instance(i).value(4) != 2.0) continue;
            if (mergedIndex == -1) {
                mergedIndex = (int)result.instance(i).value(4);
                continue;
            }
            MergeInfrequentNominalValuesTest.assertEquals((String)("Checking merged value for instance: " + (i + 1)), (int)mergedIndex, (int)((int)result.instance(i).value(4)));
        }
    }

    @Override
    public void testFilteredClassifier() {
        try {
            Instances data = this.getFilteredClassifierData();
            for (int i = 0; i < data.numAttributes(); ++i) {
                if (data.classIndex() == i || !data.attribute(i).isNominal()) continue;
                ((MergeInfrequentNominalValues)this.m_FilteredClassifier.getFilter()).setAttributeIndices("" + (i + 1));
                break;
            }
        }
        catch (Exception e) {
            MergeInfrequentNominalValuesTest.fail((String)("Problem setting up test for FilteredClassifier: " + e.toString()));
        }
        super.testFilteredClassifier();
    }

    public static Test suite() {
        return new TestSuite(MergeInfrequentNominalValuesTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)MergeInfrequentNominalValuesTest.suite());
    }
}

