/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.io.Reader;
import java.io.StringReader;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.classifiers.CostMatrix;
import weka.core.Instances;

public class CostMatrixTest
extends TestCase {
    protected static final String DATA = "@relation test\n@attribute one numeric\n@attribute two numeric\n@attribute three {c1,c2}\n@data\n-1, 5, c1\n6, 8, c2\n";

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected Instances getData() throws Exception {
        Instances insts = new Instances((Reader)new StringReader(DATA));
        insts.setClassIndex(insts.numAttributes() - 1);
        return insts;
    }

    protected CostMatrix get2ClassCostMatrixNoExpressions(double cost1, double cost2) {
        CostMatrix matrix = new CostMatrix(2);
        matrix.setCell(0, 1, (Object)cost1);
        matrix.setCell(1, 0, (Object)cost2);
        return matrix;
    }

    public void testIncorrectSize() throws Exception {
        CostMatrix matrix = new CostMatrix(3);
        Instances data = this.getData();
        try {
            matrix.applyCostMatrix(data, null);
            CostMatrixTest.fail((String)"Was expecting an exception as the cost matrix represents more classes than are present in the data");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void test2ClassCostMatrixNoExpressions() throws Exception {
        CostMatrix matrix = this.get2ClassCostMatrixNoExpressions(2.0, 6.0);
        Instances data = this.getData();
        Instances weighted = matrix.applyCostMatrix(data, null);
        CostMatrixTest.assertEquals((Object)0.5, (Object)weighted.instance(0).weight());
        CostMatrixTest.assertEquals((Object)1.5, (Object)weighted.instance(1).weight());
    }

    public void test2ClassCostMatrixOneSimpleExpression() throws Exception {
        CostMatrix matrix = this.get2ClassCostMatrixNoExpressions(2.0, 6.0);
        matrix.setCell(0, 1, (Object)"a2");
        Instances data = this.getData();
        Instances weighted = matrix.applyCostMatrix(data, null);
        CostMatrixTest.assertEquals((Object)5.0, (Object)weighted.instance(0).weight());
        CostMatrixTest.assertEquals((Object)6.0, (Object)weighted.instance(1).weight());
    }

    public void test2ClassCostMatrixOneExpression() throws Exception {
        CostMatrix matrix = this.get2ClassCostMatrixNoExpressions(2.0, 6.0);
        matrix.setCell(0, 1, (Object)"log(a2^2)*a1-1");
        Instances data = this.getData();
        Instances weighted = matrix.applyCostMatrix(data, null);
        CostMatrixTest.assertEquals((double)-4.218876, (double)weighted.instance(0).weight(), (double)1.0E-6);
        CostMatrixTest.assertEquals((Object)6.0, (Object)weighted.instance(1).weight());
    }

    public void test2ClassCostMatrixTwoExpressions() throws Exception {
        CostMatrix matrix = this.get2ClassCostMatrixNoExpressions(2.0, 6.0);
        matrix.setCell(0, 1, (Object)"log(a2^2)*a1-1");
        matrix.setCell(1, 0, (Object)"exp(a1*cos(a2))/sqrt(a1/2)");
        Instances data = this.getData();
        Instances weighted = matrix.applyCostMatrix(data, null);
        CostMatrixTest.assertEquals((double)-4.218876, (double)weighted.instance(0).weight(), (double)1.0E-6);
        CostMatrixTest.assertEquals((double)0.241157, (double)weighted.instance(1).weight(), (double)1.0E-6);
    }

    public static Test suite() {
        return new TestSuite(CostMatrixTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)CostMatrixTest.suite());
    }
}

