/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.classifiers.Classifier;
import weka.classifiers.evaluation.EvaluationUtils;
import weka.classifiers.evaluation.Prediction;
import weka.classifiers.misc.SerializedClassifier;
import weka.classifiers.trees.J48;
import weka.classifiers.trees.M5P;
import weka.core.CheckOptionHandler;
import weka.core.Instances;
import weka.core.SerializationHelper;
import weka.core.TestInstances;
import weka.test.Regression;

public class SerializedClassifierTest
extends TestCase {
    public static final String MODEL_FILENAME = System.getProperty("user.dir") + "/" + "temp.model";
    protected SerializedClassifier m_Classifier;
    protected CheckOptionHandler m_OptionTester;

    public SerializedClassifierTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.m_Classifier = null;
        this.m_OptionTester = new CheckOptionHandler();
        this.m_OptionTester.setSilent(true);
        File file = new File(MODEL_FILENAME);
        if (file.exists()) {
            file.delete();
        }
    }

    protected void tearDown() {
        this.m_Classifier = null;
        this.m_OptionTester = null;
        File file = new File(MODEL_FILENAME);
        if (file.exists()) {
            file.delete();
        }
    }

    protected double[] trainAndSerializeClassifier(Instances data) {
        double[] result;
        try {
            Object classifier = data.classAttribute().isNominal() ? new J48() : new M5P();
            classifier.buildClassifier(data);
            result = new double[data.numInstances()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = classifier.classifyInstance(data.instance(i));
            }
            SerializationHelper.write((String)MODEL_FILENAME, (Object)classifier);
        }
        catch (Exception e) {
            SerializedClassifierTest.fail((String)("Training base classifier failed: " + e));
            return null;
        }
        return result;
    }

    protected void performTest(boolean nomClass) {
        double[] originalResults;
        Instances data;
        try {
            TestInstances test = new TestInstances();
            if (nomClass) {
                test.setClassType(1);
                test.setNumNominal(5);
                test.setNumNominalValues(4);
                test.setNumNumeric(0);
            } else {
                test.setClassType(0);
                test.setNumNominal(0);
                test.setNumNumeric(5);
            }
            test.setNumDate(0);
            test.setNumString(0);
            test.setNumRelational(0);
            test.setNumInstances(100);
            data = test.generate();
        }
        catch (Exception e) {
            SerializedClassifierTest.fail((String)("Generating test data failed: " + e));
            return;
        }
        try {
            originalResults = this.trainAndSerializeClassifier(data);
        }
        catch (Exception e) {
            SerializedClassifierTest.fail((String)("Training base classifier failed: " + e));
            return;
        }
        try {
            this.m_Classifier = new SerializedClassifier();
            this.m_Classifier.setModelFile(new File(MODEL_FILENAME));
            this.m_Classifier.buildClassifier(data);
        }
        catch (Exception e) {
            SerializedClassifierTest.fail((String)("Loading/testing of classifier failed: " + e));
        }
        try {
            int i;
            double[] testResults = new double[data.numInstances()];
            for (i = 0; i < testResults.length; ++i) {
                testResults[i] = this.m_Classifier.classifyInstance(data.instance(i));
            }
            for (i = 0; i < originalResults.length; ++i) {
                if (originalResults[i] == testResults[i]) continue;
                throw new Exception("Result #" + (i + 1) + " differs!");
            }
        }
        catch (Exception e) {
            SerializedClassifierTest.fail((String)("Comparing results failed: " + e));
        }
    }

    public void testNominalClass() {
        this.performTest(true);
    }

    public void testNumericClass() {
        this.performTest(true);
    }

    protected String predictionsToString(ArrayList<Prediction> predictions) {
        StringBuffer sb = new StringBuffer();
        sb.append(predictions.size()).append(" predictions\n");
        for (int i = 0; i < predictions.size(); ++i) {
            sb.append(predictions.get(i)).append('\n');
        }
        return sb.toString();
    }

    public void testRegression() {
        Instances data;
        Regression reg = new Regression(((Object)((Object)this)).getClass());
        try {
            TestInstances testInst = new TestInstances();
            testInst.setClassType(1);
            testInst.setNumNominal(5);
            testInst.setNumNominalValues(4);
            testInst.setNumNumeric(0);
            testInst.setNumDate(0);
            testInst.setNumString(0);
            testInst.setNumRelational(0);
            testInst.setNumInstances(100);
            data = testInst.generate();
        }
        catch (Exception e) {
            SerializedClassifierTest.fail((String)("Failed generating data: " + e));
            return;
        }
        int tot = data.numInstances();
        int mid = tot / 2;
        Instances train = null;
        Instances test = null;
        try {
            train = new Instances(data, 0, mid);
            test = new Instances(data, mid, tot - mid);
            this.m_Classifier = new SerializedClassifier();
            this.m_Classifier.setModelFile(new File(MODEL_FILENAME));
        }
        catch (Exception e) {
            e.printStackTrace();
            SerializedClassifierTest.fail((String)("Problem setting up to use classifier: " + e));
        }
        EvaluationUtils evaluation = new EvaluationUtils();
        try {
            this.trainAndSerializeClassifier(train);
            ArrayList regressionResults = evaluation.getTrainTestPredictions((Classifier)this.m_Classifier, train, test);
            reg.println(this.predictionsToString(regressionResults));
        }
        catch (Exception e) {
            SerializedClassifierTest.fail((String)("Failed obtaining classifier predictions: " + e));
        }
        try {
            String diff = reg.diff();
            if (diff == null) {
                System.err.println("Warning: No reference available, creating.");
            } else if (!diff.equals("")) {
                SerializedClassifierTest.fail((String)("Regression test failed. Difference:\n" + diff));
            }
        }
        catch (IOException ex) {
            SerializedClassifierTest.fail((String)("Problem during regression testing.\n" + ex));
        }
    }

    public void testListOptions() {
        if (!this.m_OptionTester.checkListOptions()) {
            SerializedClassifierTest.fail((String)"Options cannot be listed via listOptions.");
        }
    }

    public void testSetOptions() {
        if (!this.m_OptionTester.checkSetOptions()) {
            SerializedClassifierTest.fail((String)"setOptions method failed.");
        }
    }

    public void testRemainingOptions() {
        if (!this.m_OptionTester.checkRemainingOptions()) {
            SerializedClassifierTest.fail((String)"There were 'left-over' options.");
        }
    }

    public void testCanonicalUserOptions() {
        if (!this.m_OptionTester.checkCanonicalUserOptions()) {
            SerializedClassifierTest.fail((String)"setOptions method failed");
        }
    }

    public void testResettingOptions() {
        if (!this.m_OptionTester.checkSetOptions()) {
            SerializedClassifierTest.fail((String)"Resetting of options failed");
        }
    }

    public static Test suite() {
        return new TestSuite(SerializedClassifierTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SerializedClassifierTest.suite());
    }
}

