/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.instance.RemoveWithValues;

public class RemoveWithValuesTest
extends AbstractFilterTest {
    public RemoveWithValuesTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        RemoveWithValues f = new RemoveWithValues();
        f.setAttributeIndex("3");
        f.setInvertSelection(true);
        return f;
    }

    public void testString() {
        Instances icopy = new Instances(this.m_Instances);
        try {
            ((RemoveWithValues)this.m_Filter).setAttributeIndex("1");
            this.m_Filter.setInputFormat(icopy);
            RemoveWithValuesTest.fail((String)"Should have thrown an exception selecting on a STRING attribute!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testNominal() {
        ((RemoveWithValues)this.m_Filter).setAttributeIndex("2");
        Instances result = this.useFilter();
        RemoveWithValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        RemoveWithValuesTest.assertEquals((String)"Default nominal selection matches all values", (int)this.m_Instances.numInstances(), (int)result.numInstances());
        try {
            ((RemoveWithValues)this.m_Filter).setNominalIndices("1-2");
        }
        catch (Exception ex) {
            RemoveWithValuesTest.fail((String)"Shouldn't ever get here unless Range chamges incompatibly");
        }
        result = this.useFilter();
        RemoveWithValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        RemoveWithValuesTest.assertTrue((this.m_Instances.numInstances() > result.numInstances() ? 1 : 0) != 0);
        try {
            ((RemoveWithValues)this.m_Filter).setNominalIndices("3-last");
        }
        catch (Exception ex) {
            RemoveWithValuesTest.fail((String)"Shouldn't ever get here unless Range chamges incompatibly");
        }
        Instances result2 = this.useFilter();
        RemoveWithValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result2.numAttributes());
        RemoveWithValuesTest.assertTrue((this.m_Instances.numInstances() > result2.numInstances() ? 1 : 0) != 0);
        RemoveWithValuesTest.assertEquals((int)this.m_Instances.numInstances(), (int)(result.numInstances() + result2.numInstances()));
        ((RemoveWithValues)this.m_Filter).setInvertSelection(false);
        result = this.useFilter();
        RemoveWithValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        RemoveWithValuesTest.assertEquals((int)this.m_Instances.numInstances(), (int)(result.numInstances() + result2.numInstances()));
    }

    public void testNumeric() {
        ((RemoveWithValues)this.m_Filter).setAttributeIndex("3");
        Instances result = this.useFilter();
        RemoveWithValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        RemoveWithValuesTest.assertEquals((String)"Default split point matches values less than 0", (int)0, (int)result.numInstances());
        ((RemoveWithValues)this.m_Filter).setSplitPoint(3.0);
        result = this.useFilter();
        RemoveWithValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        RemoveWithValuesTest.assertTrue((this.m_Instances.numInstances() > result.numInstances() ? 1 : 0) != 0);
        ((RemoveWithValues)this.m_Filter).setInvertSelection(false);
        Instances result2 = this.useFilter();
        RemoveWithValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result2.numAttributes());
        RemoveWithValuesTest.assertTrue((this.m_Instances.numInstances() > result2.numInstances() ? 1 : 0) != 0);
        RemoveWithValuesTest.assertEquals((int)this.m_Instances.numInstances(), (int)(result.numInstances() + result2.numInstances()));
    }

    public void testMatchMissingValues() {
        ((RemoveWithValues)this.m_Filter).setAttributeIndex("5");
        ((RemoveWithValues)this.m_Filter).setInvertSelection(false);
        ((RemoveWithValues)this.m_Filter).setMatchMissingValues(false);
        Instances result = this.useFilter();
        RemoveWithValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        RemoveWithValuesTest.assertTrue((result.numInstances() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < result.numInstances(); ++i) {
            RemoveWithValuesTest.assertTrue((String)"Should select only instances with missing values", (boolean)result.instance(i).isMissing(4));
        }
    }

    @Override
    public void testFilteredClassifier() {
    }

    public static Test suite() {
        return new TestSuite(RemoveWithValuesTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RemoveWithValuesTest.suite());
    }
}

