/*
 * Decompiled with CFR 0.152.
 */
package weka.core.packageManagement;

import java.awt.GraphicsEnvironment;
import java.beans.Beans;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.bounce.net.DefaultAuthenticator;
import weka.core.packageManagement.DefaultPackageManager;
import weka.core.packageManagement.Dependency;
import weka.core.packageManagement.Package;

public abstract class PackageManager {
    protected File m_packageHome;
    protected URL m_packageRepository;
    protected String m_baseSystemName;
    protected Object m_baseSystemVersion;
    protected transient Proxy m_httpProxy;
    protected transient String m_proxyUsername;
    protected transient String m_proxyPassword;
    protected transient boolean m_authenticatorSet = false;

    public static PackageManager create() {
        PackageManager pm = new DefaultPackageManager();
        pm.establishProxy();
        try {
            String managerName = System.getProperty("org.pentaho.packageManagement.manager");
            if (managerName != null && managerName.length() > 0) {
                Object manager = Beans.instantiate(pm.getClass().getClassLoader(), managerName);
                if (manager instanceof PackageManager) {
                    pm = (PackageManager)manager;
                }
            } else {
                File packageManagerPropsFile = new File(System.getProperty("user.home") + File.separator + "PackageManager.props");
                if (packageManagerPropsFile.exists()) {
                    Object manager;
                    Properties pmProps = new Properties();
                    pmProps.load(new FileInputStream(packageManagerPropsFile));
                    managerName = pmProps.getProperty("org.pentaho.packageManager.manager");
                    if (managerName != null && managerName.length() > 0 && (manager = Beans.instantiate(pm.getClass().getClassLoader(), managerName)) instanceof PackageManager) {
                        pm = (PackageManager)manager;
                    }
                }
            }
        }
        catch (Exception ex) {
            System.err.println("Problem instantiating package manager. Using DefaultPackageManager.");
        }
        return pm;
    }

    public void establishProxy() {
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (proxyHost != null && proxyHost.length() > 0) {
            int portNum = 80;
            if (proxyPort != null && proxyPort.length() > 0) {
                portNum = Integer.parseInt(proxyPort);
            }
            InetSocketAddress sa = new InetSocketAddress(proxyHost, portNum);
            this.setProxy(new Proxy(Proxy.Type.HTTP, sa));
        }
        String proxyUserName = System.getProperty("http.proxyUser");
        String proxyPassword = System.getProperty("http.proxyPassword");
        if (proxyUserName != null && proxyUserName.length() > 0 && proxyPassword != null && proxyPassword.length() > 0) {
            this.setProxyUsername(proxyUserName);
            this.setProxyPassword(proxyPassword);
        }
    }

    public synchronized boolean setProxyAuthentication(URL urlToConnectTo) {
        if (this.m_httpProxy == null) {
            ProxySelector ps = ProxySelector.getDefault();
            try {
                List<Proxy> proxyList = ps.select(urlToConnectTo.toURI());
                Proxy proxy = proxyList.get(0);
                this.setProxy(proxy);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        if (this.m_httpProxy != null) {
            if (this.m_proxyUsername != null && this.m_proxyPassword != null && !this.m_authenticatorSet) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(PackageManager.this.m_proxyUsername, PackageManager.this.m_proxyPassword.toCharArray());
                    }
                });
            } else if (!this.m_authenticatorSet && !GraphicsEnvironment.isHeadless()) {
                Authenticator.setDefault((Authenticator)new DefaultAuthenticator(null));
                this.m_authenticatorSet = true;
            }
            return true;
        }
        return this.m_httpProxy != null;
    }

    public void setPackageHome(File packageHome) {
        this.m_packageHome = packageHome;
    }

    public File getPackageHome() {
        return this.m_packageHome;
    }

    public void setBaseSystemName(String baseS) {
        this.m_baseSystemName = baseS;
    }

    public String getBaseSystemName() {
        return this.m_baseSystemName;
    }

    public void setBaseSystemVersion(Object systemV) {
        this.m_baseSystemVersion = systemV;
    }

    public Object getBaseSystemVersion() {
        return this.m_baseSystemVersion;
    }

    public void setPackageRepositoryURL(URL repositoryURL) {
        this.m_packageRepository = repositoryURL;
    }

    public URL getPackageRepositoryURL() {
        return this.m_packageRepository;
    }

    public void setProxy(Proxy proxyToUse) {
        this.m_httpProxy = proxyToUse;
    }

    public Proxy getProxy() {
        return this.m_httpProxy;
    }

    public void setProxyUsername(String proxyUsername) {
        this.m_proxyUsername = proxyUsername;
    }

    public void setProxyPassword(String proxyPassword) {
        this.m_proxyPassword = proxyPassword;
    }

    public abstract byte[] getRepositoryPackageMetaDataOnlyAsZip(PrintStream ... var1) throws Exception;

    public abstract Package getPackageArchiveInfo(String var1) throws Exception;

    public abstract Package getInstalledPackageInfo(String var1) throws Exception;

    public abstract Package getRepositoryPackageInfo(String var1) throws Exception;

    public abstract Package getRepositoryPackageInfo(String var1, Object var2) throws Exception;

    public abstract List<Object> getRepositoryPackageVersions(String var1) throws Exception;

    public abstract Package getURLPackageInfo(URL var1) throws Exception;

    public abstract String installPackageFromArchive(String var1, PrintStream ... var2) throws Exception;

    public abstract void installPackageFromRepository(String var1, Object var2, PrintStream ... var3) throws Exception;

    public abstract String installPackageFromURL(URL var1, PrintStream ... var2) throws Exception;

    public abstract void installPackages(List<Package> var1, PrintStream ... var2) throws Exception;

    public abstract void uninstallPackage(String var1, PrintStream ... var2) throws Exception;

    public abstract List<Package> getInstalledPackages() throws Exception;

    public abstract List<Package> getAllPackages(PrintStream ... var1) throws Exception;

    public abstract List<Package> getAvailablePackages() throws Exception;

    public abstract List<Dependency> getAllDependenciesForPackage(Package var1, Map<String, List<Dependency>> var2) throws Exception;
}

