/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class PluginManager {
    protected static Map<String, Map<String, String>> PLUGINS = new HashMap<String, Map<String, String>>();
    protected static Set<String> DISABLED = new HashSet<String>();
    protected static Map<String, Map<String, String>> RESOURCES = new HashMap<String, Map<String, String>>();

    public static synchronized void addToDisabledList(List<String> classnames) {
        for (String s : classnames) {
            PluginManager.addToDisabledList(s);
        }
    }

    public static synchronized void addToDisabledList(String classname) {
        DISABLED.add(classname);
    }

    public static synchronized void removeFromDisabledList(List<String> classnames) {
        for (String s : classnames) {
            PluginManager.removeFromDisabledList(s);
        }
    }

    public static synchronized void removeFromDisabledList(String classname) {
        DISABLED.remove(classname);
    }

    public static boolean isInDisabledList(String classname) {
        return DISABLED.contains(classname);
    }

    public static synchronized void addFromProperties(File propsFile) throws Exception {
        PluginManager.addFromProperties(propsFile, false);
    }

    public static synchronized void addFromProperties(File propsFile, boolean maintainInsertionOrder) throws Exception {
        BufferedInputStream bi = new BufferedInputStream(new FileInputStream(propsFile));
        PluginManager.addFromProperties(bi);
    }

    public static synchronized void addFromProperties(InputStream propsStream) throws Exception {
        PluginManager.addFromProperties(propsStream, false);
    }

    public static synchronized void addFromProperties(InputStream propsStream, boolean maintainInsertionOrder) throws Exception {
        Properties expProps = new Properties();
        expProps.load(propsStream);
        propsStream.close();
        propsStream = null;
        PluginManager.addFromProperties(expProps, maintainInsertionOrder);
    }

    public static synchronized void addFromProperties(Properties props) throws Exception {
        PluginManager.addFromProperties(props, false);
    }

    public static synchronized void addFromProperties(Properties props, boolean maintainInsertionOrder) throws Exception {
        Enumeration<?> keys = props.propertyNames();
        while (keys.hasMoreElements()) {
            String[] parts;
            String baseType = (String)keys.nextElement();
            String implementations = props.getProperty(baseType);
            if (baseType.equalsIgnoreCase("*resources*")) {
                PluginManager.addPluginResourcesFromProperty(implementations);
                continue;
            }
            if (implementations == null || implementations.length() <= 0) continue;
            for (String impl : parts = implementations.split(",")) {
                PluginManager.addPlugin(baseType, impl.trim(), impl.trim(), maintainInsertionOrder);
            }
        }
    }

    protected static synchronized void addPluginResourcesFromProperty(String resourceList) {
        String[] resources;
        for (String r : resources = resourceList.split(",")) {
            if (!(r = r.trim()).startsWith("[") || !r.endsWith("]")) {
                System.err.println("[PluginManager] Malformed resource in: " + resourceList);
                continue;
            }
            String[] rParts = (r = r.replace("[", "").replace("]", "")).split("\\|");
            if (rParts.length != 3) {
                System.err.println("[PluginManager] Was expecting 3 pipe separated parts in resource spec: " + r);
                continue;
            }
            String groupID = rParts[0].trim();
            String resourceDesc = rParts[1].trim();
            String resourcePath = rParts[2].trim();
            if (groupID.length() == 0 || resourceDesc.length() == 0 || resourcePath.length() == 0) {
                System.err.println("[PluginManager] Empty part in resource spec: " + r);
                continue;
            }
            PluginManager.addPluginResource(groupID, resourceDesc, resourcePath);
        }
    }

    public static synchronized void addPluginResource(String resourceGroupID, String resourceDescription, String resourcePath) {
        Map<String, String> groupMap = RESOURCES.get(resourceGroupID);
        if (groupMap == null) {
            groupMap = new LinkedHashMap<String, String>();
            RESOURCES.put(resourceGroupID, groupMap);
        }
        groupMap.put(resourceDescription, resourcePath);
    }

    public static InputStream getPluginResourceAsStream(String resourceGroupID, String resourceDescription) throws IOException {
        Map<String, String> groupMap = RESOURCES.get(resourceGroupID);
        if (groupMap == null) {
            throw new IOException("Unknown resource group ID: " + resourceGroupID);
        }
        String resourcePath = groupMap.get(resourceDescription);
        if (resourcePath == null) {
            throw new IOException("Unknown resource: " + resourceDescription);
        }
        return PluginManager.class.getClassLoader().getResourceAsStream(resourcePath);
    }

    public static int numResourcesForWithGroupID(String resourceGroupID) {
        Map<String, String> groupMap = RESOURCES.get(resourceGroupID);
        return groupMap == null ? 0 : groupMap.size();
    }

    public static Map<String, String> getResourcesWithGroupID(String resourceGroupID) {
        return RESOURCES.get(resourceGroupID);
    }

    public static Set<String> getPluginNamesOfType(String interfaceName) {
        if (PLUGINS.get(interfaceName) != null) {
            Set<String> match = PLUGINS.get(interfaceName).keySet();
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (String s : match) {
                String impl = PLUGINS.get(interfaceName).get(s);
                if (DISABLED.contains(impl)) continue;
                result.add(s);
            }
            return result;
        }
        return null;
    }

    public static void addPlugin(String interfaceName, String name, String concreteType) {
        PluginManager.addPlugin(interfaceName, name, concreteType, false);
    }

    public static void addPlugin(String interfaceName, String name, String concreteType, boolean maintainInsertionOrder) {
        if (PLUGINS.get(interfaceName) == null) {
            AbstractMap pluginsOfInterfaceType = maintainInsertionOrder ? new LinkedHashMap() : new TreeMap();
            pluginsOfInterfaceType.put(name, concreteType);
            PLUGINS.put(interfaceName, pluginsOfInterfaceType);
        } else {
            PLUGINS.get(interfaceName).put(name, concreteType);
        }
    }

    public static void removePlugins(String interfaceName, List<String> names) {
        for (String name : names) {
            PluginManager.removePlugin(interfaceName, name);
        }
    }

    public static void removePlugin(String interfaceName, String name) {
        if (PLUGINS.get(interfaceName) != null) {
            PLUGINS.get(interfaceName).remove(name);
        }
    }

    public static Object getPluginInstance(String interfaceType, String name) throws Exception {
        if (PLUGINS.get(interfaceType) == null || PLUGINS.get(interfaceType).size() == 0) {
            throw new Exception("No plugins of interface type: " + interfaceType + " available!!");
        }
        Map<String, String> pluginsOfInterfaceType = PLUGINS.get(interfaceType);
        if (pluginsOfInterfaceType.get(name) == null) {
            throw new Exception("Can't find named plugin '" + name + "' of type '" + interfaceType + "'!");
        }
        String concreteImpl = pluginsOfInterfaceType.get(name);
        Object plugin = null;
        if (!DISABLED.contains(concreteImpl)) {
            plugin = Class.forName(concreteImpl).newInstance();
        }
        return plugin;
    }
}

