/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;
import weka.core.Defaults;
import weka.core.Environment;
import weka.core.Settings;
import weka.gui.AbstractGUIApplication;
import weka.gui.GenericObjectEditor;
import weka.gui.LookAndFeel;
import weka.gui.Perspective;
import weka.gui.PerspectiveManager;
import weka.gui.beans.PluginManager;
import weka.gui.knowledgeflow.MainKFPerspective;
import weka.knowledgeflow.ExecutionEnvironment;
import weka.knowledgeflow.KFDefaults;

public class KnowledgeFlowApp
extends AbstractGUIApplication {
    private static final long serialVersionUID = -1460599392623083983L;
    protected Settings m_kfProperties;
    protected MainKFPerspective m_mainPerspective;

    public KnowledgeFlowApp() {
        this(true);
    }

    public KnowledgeFlowApp(boolean layoutComponent) {
        super(layoutComponent, "weka.gui.knowledgeflow", "weka.gui.SimpleCLIPanel");
        ((MainKFPerspective)this.m_perspectiveManager.getMainPerspective()).addUntitledTab();
        this.m_perspectiveManager.addSettingsMenuItemToProgramMenu(this.getApplicationSettings());
        if (this.m_perspectiveManager.userRequestedPerspectiveToolbarVisibleOnStartup(this.getApplicationSettings())) {
            this.showPerspectivesToolBar();
        }
    }

    @Override
    public String getApplicationName() {
        return "Knowledge Flow";
    }

    @Override
    public String getApplicationID() {
        return "knowledgeflow";
    }

    @Override
    public Perspective getMainPerspective() {
        if (this.m_mainPerspective == null) {
            this.m_mainPerspective = new MainKFPerspective();
        }
        return this.m_mainPerspective;
    }

    @Override
    public PerspectiveManager getPerspectiveManager() {
        return this.m_perspectiveManager;
    }

    @Override
    public Settings getApplicationSettings() {
        if (this.m_kfProperties == null) {
            this.m_kfProperties = new Settings("weka", "knowledgeflow");
            this.m_kfProperties.applyDefaults(new KnowledgeFlowGeneralDefaults());
        }
        return this.m_kfProperties;
    }

    @Override
    public void settingsChanged() {
        boolean showTipText = this.getApplicationSettings().getSetting("knowledgeflow", KFDefaults.SHOW_JTREE_TIP_TEXT_KEY, Boolean.valueOf(true), Environment.getSystemWide());
        GenericObjectEditor.setShowGlobalInfoToolTips(showTipText);
        this.m_mainPerspective.m_stepTree.setShowLeafTipText(showTipText);
    }

    public static void main(String[] args) {
        try {
            LookAndFeel.setLookAndFeel("knowledgeflow", "knowledgeflow.lookAndFeel");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        GenericObjectEditor.determineClasses();
        try {
            File toLoad;
            if (System.getProperty("os.name").contains("Mac")) {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
            }
            KnowledgeFlowApp app = new KnowledgeFlowApp();
            if (args.length == 1 && (toLoad = new File(args[0])).exists() && toLoad.isFile()) {
                ((MainKFPerspective)app.getMainPerspective()).loadLayout(toLoad, false);
            }
            JFrame jf = new JFrame("Weka " + app.getApplicationName());
            jf.getContentPane().setLayout(new BorderLayout());
            Image icon = Toolkit.getDefaultToolkit().getImage(KnowledgeFlowApp.class.getClassLoader().getResource("weka/gui/weka_icon_new_48.png"));
            jf.setIconImage(icon);
            jf.getContentPane().add((Component)app, "Center");
            jf.setDefaultCloseOperation(3);
            jf.pack();
            app.showMenuBar(jf);
            jf.setSize(1024, 768);
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static class KnowledgeFlowGeneralDefaults
    extends Defaults {
        private static final long serialVersionUID = 6957165806947500265L;
        public static final Settings.SettingKey LAF_KEY = new Settings.SettingKey("knowledgeflow.lookAndFeel", "Look and feel for UI", "Note: a restart is required for this setting ot come into effect");
        public static final String LAF = "";
        public static final Settings.SettingKey EXECUTION_ENV_KEY = new Settings.SettingKey("knowledgeflow.exec_env", "Execution environment", "Executor for flow processes");
        public static final String EXECUTION_ENV = "Default execution environment";

        public KnowledgeFlowGeneralDefaults() {
            super("knowledgeflow");
            List<String> lafs = LookAndFeel.getAvailableLookAndFeelClasses();
            lafs.add(0, "<use platform default>");
            LAF_KEY.setPickList(lafs);
            this.m_defaults.put(LAF_KEY, LAF);
            this.m_defaults.put(KFDefaults.SHOW_JTREE_TIP_TEXT_KEY, true);
            this.m_defaults.put(KFDefaults.LOGGING_LEVEL_KEY, KFDefaults.LOGGING_LEVEL);
            Set<String> execs = PluginManager.getPluginNamesOfType(ExecutionEnvironment.class.getCanonicalName());
            ArrayList<String> execList = new ArrayList<String>();
            execList.add(EXECUTION_ENV);
            if (execs != null) {
                for (String e : execs) {
                    if (e.equals(EXECUTION_ENV)) continue;
                    execList.add(e);
                }
            }
            EXECUTION_ENV_KEY.setPickList(execList);
            this.m_defaults.put(EXECUTION_ENV_KEY, EXECUTION_ENV);
        }
    }
}

