/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow;

import java.awt.BorderLayout;
import java.awt.Component;
import weka.core.Defaults;
import weka.core.Environment;
import weka.core.Instances;
import weka.core.Settings;
import weka.gui.AbstractPerspective;
import weka.gui.PerspectiveInfo;
import weka.gui.visualize.MatrixPanel;

@PerspectiveInfo(ID="weka.gui.knowledgeflow.scatterplotmatrix", title="Scatter plot matrix", toolTipText="Scatter plots", iconPath="weka/gui/knowledgeflow/icons/application_view_tile.png")
public class ScatterPlotMatrixPerspective
extends AbstractPerspective {
    private static final long serialVersionUID = 5661598509822826837L;
    protected MatrixPanel m_matrixPanel;
    protected Instances m_visualizeDataSet;

    public ScatterPlotMatrixPerspective() {
        this.setLayout(new BorderLayout());
        this.m_matrixPanel = new MatrixPanel();
        this.add((Component)this.m_matrixPanel, "Center");
    }

    @Override
    public Defaults getDefaultSettings() {
        return new ScatterDefaults();
    }

    @Override
    public boolean acceptsInstances() {
        return true;
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (this.m_isActive && this.m_visualizeDataSet != null) {
            int pointSize = this.m_mainApplication.getApplicationSettings().getSetting("weka.gui.knowledgeflow.scatterplotmatrix", ScatterDefaults.POINT_SIZE_KEY, Integer.valueOf(1), Environment.getSystemWide());
            int plotSize = this.m_mainApplication.getApplicationSettings().getSetting("weka.gui.knowledgeflow.scatterplotmatrix", ScatterDefaults.PLOT_SIZE_KEY, Integer.valueOf(100), Environment.getSystemWide());
            this.m_matrixPanel.setPointSize(pointSize);
            this.m_matrixPanel.setPlotSize(plotSize);
            this.m_matrixPanel.updatePanel();
        }
    }

    @Override
    public void setInstances(Instances instances) {
        this.m_visualizeDataSet = instances;
        this.m_matrixPanel.setInstances(this.m_visualizeDataSet);
    }

    @Override
    public boolean okToBeActive() {
        return this.m_visualizeDataSet != null;
    }

    public static class ScatterDefaults
    extends Defaults {
        public static final String ID = "weka.gui.knowledgeflow.scatterplotmatrix";
        public static final Settings.SettingKey POINT_SIZE_KEY = new Settings.SettingKey("weka.gui.knowledgeflow.scatterplotmatrix.pointSize", "Point size for scatter plots", "");
        public static final int POINT_SIZE = 1;
        public static final Settings.SettingKey PLOT_SIZE_KEY = new Settings.SettingKey("weka.gui.knowledgeflow.scatterplotmatrix.plotSize", "Size (in pixels) of the cells in the matrix", "");
        public static final int PLOT_SIZE = 100;
        public static final long serialVersionUID = -6890761195767034507L;

        public ScatterDefaults() {
            super(ID);
            this.m_defaults.put(POINT_SIZE_KEY, 1);
            this.m_defaults.put(PLOT_SIZE_KEY, 100);
        }
    }
}

