/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow.steps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.gui.EnvironmentField;
import weka.gui.JListHelper;
import weka.gui.beans.SubstringLabelerRules;
import weka.gui.knowledgeflow.StepEditorDialog;
import weka.knowledgeflow.steps.SubstringLabeler;

public class SubstringLabelerStepEditorDialog
extends StepEditorDialog {
    private static final long serialVersionUID = 2386951012941540643L;
    protected EnvironmentField m_matchAttNameField;
    protected EnvironmentField m_attListField;
    protected EnvironmentField m_matchField;
    protected EnvironmentField m_labelField;
    protected JCheckBox m_regexCheck = new JCheckBox();
    protected JCheckBox m_ignoreCaseCheck = new JCheckBox();
    protected JCheckBox m_nominalBinaryCheck = new JCheckBox();
    protected JCheckBox m_consumeNonMatchingCheck = new JCheckBox();
    protected JList<SubstringLabelerRules.SubstringLabelerMatchRule> m_list = new JList();
    protected DefaultListModel<SubstringLabelerRules.SubstringLabelerMatchRule> m_listModel;
    protected JButton m_newBut = new JButton("New");
    protected JButton m_deleteBut = new JButton("Delete");
    protected JButton m_upBut = new JButton("Move up");
    protected JButton m_downBut = new JButton("Move down");

    protected void initialize() {
        String[] parts;
        String mlString = ((SubstringLabeler)this.getStepToEdit()).getMatchDetails();
        this.m_listModel = new DefaultListModel();
        this.m_list.setModel(this.m_listModel);
        if (mlString != null && mlString.length() > 0 && (parts = mlString.split("@@match-rule@@")).length > 0) {
            this.m_upBut.setEnabled(true);
            this.m_downBut.setEnabled(true);
            for (String mPart : parts) {
                SubstringLabelerRules.SubstringLabelerMatchRule m = new SubstringLabelerRules.SubstringLabelerMatchRule(mPart);
                this.m_listModel.addElement(m);
            }
            this.m_list.repaint();
        }
    }

    @Override
    protected void layoutEditor() {
        this.initialize();
        JPanel mainHolder = new JPanel(new BorderLayout());
        JPanel controlHolder = new JPanel();
        controlHolder.setLayout(new BorderLayout());
        JPanel fieldHolder = new JPanel();
        JPanel attListP = new JPanel();
        attListP.setLayout(new BorderLayout());
        attListP.setBorder(BorderFactory.createTitledBorder("Apply to attributes"));
        this.m_attListField = new EnvironmentField(this.m_env);
        attListP.add((Component)this.m_attListField, "Center");
        attListP.setToolTipText("<html>Accepts a range of indexes (e.g. '1,2,6-10')<br> or a comma-separated list of named attributes</html>");
        JPanel matchP = new JPanel();
        matchP.setLayout(new BorderLayout());
        matchP.setBorder(BorderFactory.createTitledBorder("Match"));
        this.m_matchField = new EnvironmentField(this.m_env);
        matchP.add((Component)this.m_matchField, "Center");
        JPanel labelP = new JPanel();
        labelP.setLayout(new BorderLayout());
        labelP.setBorder(BorderFactory.createTitledBorder("Label"));
        this.m_labelField = new EnvironmentField(this.m_env);
        labelP.add((Component)this.m_labelField, "Center");
        fieldHolder.add(attListP);
        fieldHolder.add(matchP);
        fieldHolder.add(labelP);
        controlHolder.add((Component)fieldHolder, "North");
        JPanel checkHolder = new JPanel();
        checkHolder.setLayout(new GridLayout(0, 2));
        JLabel attNameLab = new JLabel("Name of label attribute", 4);
        checkHolder.add(attNameLab);
        this.m_matchAttNameField = new EnvironmentField(this.m_env);
        this.m_matchAttNameField.setText(((SubstringLabeler)this.getStepToEdit()).getMatchAttributeName());
        checkHolder.add(this.m_matchAttNameField);
        JLabel regexLab = new JLabel("Match using a regular expression", 4);
        regexLab.setToolTipText("Use a regular expression rather than literal match");
        checkHolder.add(regexLab);
        checkHolder.add(this.m_regexCheck);
        JLabel caseLab = new JLabel("Ignore case when matching", 4);
        checkHolder.add(caseLab);
        checkHolder.add(this.m_ignoreCaseCheck);
        JLabel nominalBinaryLab = new JLabel("Make binary label attribute nominal", 4);
        nominalBinaryLab.setToolTipText("<html>If the label attribute is binary (i.e. no <br>explicit labels have been declared) then<br>this makes the resulting attribute nominal<br>rather than numeric.</html>");
        checkHolder.add(nominalBinaryLab);
        checkHolder.add(this.m_nominalBinaryCheck);
        this.m_nominalBinaryCheck.setSelected(((SubstringLabeler)this.getStepToEdit()).getNominalBinary());
        JLabel consumeNonMatchLab = new JLabel("Consume non-matching instances", 4);
        consumeNonMatchLab.setToolTipText("<html>When explicit labels have been defined, consume <br>(rather than output with missing value) instances</html>");
        checkHolder.add(consumeNonMatchLab);
        checkHolder.add(this.m_consumeNonMatchingCheck);
        this.m_consumeNonMatchingCheck.setSelected(((SubstringLabeler)this.getStepToEdit()).getConsumeNonMatching());
        controlHolder.add((Component)checkHolder, "South");
        mainHolder.add((Component)controlHolder, "North");
        this.m_list.setVisibleRowCount(5);
        this.m_deleteBut.setEnabled(false);
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BorderLayout());
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new GridLayout(1, 0));
        butHolder.add(this.m_newBut);
        butHolder.add(this.m_deleteBut);
        butHolder.add(this.m_upBut);
        butHolder.add(this.m_downBut);
        this.m_upBut.setEnabled(false);
        this.m_downBut.setEnabled(false);
        listPanel.add((Component)butHolder, "North");
        JScrollPane js = new JScrollPane(this.m_list);
        js.setBorder(BorderFactory.createTitledBorder("Match-list list (rows applied in order)"));
        listPanel.add((Component)js, "Center");
        mainHolder.add((Component)listPanel, "Center");
        this.add((Component)mainHolder, "Center");
        this.m_attListField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                SubstringLabelerRules.SubstringLabelerMatchRule m = SubstringLabelerStepEditorDialog.this.m_list.getSelectedValue();
                if (m != null) {
                    m.setAttsToApplyTo(SubstringLabelerStepEditorDialog.this.m_attListField.getText());
                    SubstringLabelerStepEditorDialog.this.m_list.repaint();
                }
            }
        });
        this.m_matchField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                SubstringLabelerRules.SubstringLabelerMatchRule m = SubstringLabelerStepEditorDialog.this.m_list.getSelectedValue();
                if (m != null) {
                    m.setMatch(SubstringLabelerStepEditorDialog.this.m_matchField.getText());
                    SubstringLabelerStepEditorDialog.this.m_list.repaint();
                }
            }
        });
        this.m_labelField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                SubstringLabelerRules.SubstringLabelerMatchRule m = SubstringLabelerStepEditorDialog.this.m_list.getSelectedValue();
                if (m != null) {
                    m.setLabel(SubstringLabelerStepEditorDialog.this.m_labelField.getText());
                    SubstringLabelerStepEditorDialog.this.m_list.repaint();
                }
            }
        });
        this.m_list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SubstringLabelerRules.SubstringLabelerMatchRule entry;
                    if (!SubstringLabelerStepEditorDialog.this.m_deleteBut.isEnabled()) {
                        SubstringLabelerStepEditorDialog.this.m_deleteBut.setEnabled(true);
                    }
                    if ((entry = SubstringLabelerStepEditorDialog.this.m_list.getSelectedValue()) != null) {
                        SubstringLabelerRules.SubstringLabelerMatchRule m = entry;
                        SubstringLabelerStepEditorDialog.this.m_attListField.setText(m.getAttsToApplyTo());
                        SubstringLabelerStepEditorDialog.this.m_matchField.setText(m.getMatch());
                        SubstringLabelerStepEditorDialog.this.m_labelField.setText(m.getLabel());
                        SubstringLabelerStepEditorDialog.this.m_regexCheck.setSelected(m.getRegex());
                        SubstringLabelerStepEditorDialog.this.m_ignoreCaseCheck.setSelected(m.getIgnoreCase());
                    }
                }
            }
        });
        this.m_newBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubstringLabelerRules.SubstringLabelerMatchRule m = new SubstringLabelerRules.SubstringLabelerMatchRule();
                String atts = SubstringLabelerStepEditorDialog.this.m_attListField.getText() != null ? SubstringLabelerStepEditorDialog.this.m_attListField.getText() : "";
                m.setAttsToApplyTo(atts);
                String match = SubstringLabelerStepEditorDialog.this.m_matchField.getText() != null ? SubstringLabelerStepEditorDialog.this.m_matchField.getText() : "";
                m.setMatch(match);
                String label = SubstringLabelerStepEditorDialog.this.m_labelField.getText() != null ? SubstringLabelerStepEditorDialog.this.m_labelField.getText() : "";
                m.setLabel(label);
                m.setRegex(SubstringLabelerStepEditorDialog.this.m_regexCheck.isSelected());
                m.setIgnoreCase(SubstringLabelerStepEditorDialog.this.m_ignoreCaseCheck.isSelected());
                SubstringLabelerStepEditorDialog.this.m_listModel.addElement(m);
                if (SubstringLabelerStepEditorDialog.this.m_listModel.size() > 1) {
                    SubstringLabelerStepEditorDialog.this.m_upBut.setEnabled(true);
                    SubstringLabelerStepEditorDialog.this.m_downBut.setEnabled(true);
                }
                SubstringLabelerStepEditorDialog.this.m_list.setSelectedIndex(SubstringLabelerStepEditorDialog.this.m_listModel.size() - 1);
            }
        });
        this.m_deleteBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = SubstringLabelerStepEditorDialog.this.m_list.getSelectedIndex();
                if (selected >= 0) {
                    SubstringLabelerStepEditorDialog.this.m_listModel.removeElementAt(selected);
                    if (SubstringLabelerStepEditorDialog.this.m_listModel.size() <= 1) {
                        SubstringLabelerStepEditorDialog.this.m_upBut.setEnabled(false);
                        SubstringLabelerStepEditorDialog.this.m_downBut.setEnabled(false);
                    }
                }
            }
        });
        this.m_upBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JListHelper.moveUp(SubstringLabelerStepEditorDialog.this.m_list);
            }
        });
        this.m_downBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JListHelper.moveDown(SubstringLabelerStepEditorDialog.this.m_list);
            }
        });
        this.m_regexCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubstringLabelerRules.SubstringLabelerMatchRule m = SubstringLabelerStepEditorDialog.this.m_list.getSelectedValue();
                if (m != null) {
                    m.setRegex(SubstringLabelerStepEditorDialog.this.m_regexCheck.isSelected());
                    SubstringLabelerStepEditorDialog.this.m_list.repaint();
                }
            }
        });
        this.m_ignoreCaseCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubstringLabelerRules.SubstringLabelerMatchRule m = SubstringLabelerStepEditorDialog.this.m_list.getSelectedValue();
                if (m != null) {
                    m.setIgnoreCase(SubstringLabelerStepEditorDialog.this.m_ignoreCaseCheck.isSelected());
                    SubstringLabelerStepEditorDialog.this.m_list.repaint();
                }
            }
        });
    }

    @Override
    protected void okPressed() {
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < this.m_listModel.size(); ++i) {
            SubstringLabelerRules.SubstringLabelerMatchRule mr = this.m_listModel.elementAt(i);
            buff.append(mr.toStringInternal());
            if (i >= this.m_listModel.size() - 1) continue;
            buff.append("@@match-rule@@");
        }
        ((SubstringLabeler)this.getStepToEdit()).setMatchDetails(buff.toString());
    }
}

