/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow.steps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.gui.EnvironmentField;
import weka.gui.JListHelper;
import weka.gui.beans.SubstringReplacerRules;
import weka.gui.knowledgeflow.StepEditorDialog;
import weka.knowledgeflow.steps.SubstringReplacer;

public class SubstringReplacerStepEditorDialog
extends StepEditorDialog {
    private static final long serialVersionUID = 7804721324137987443L;
    protected EnvironmentField m_attListField;
    protected EnvironmentField m_matchField;
    protected EnvironmentField m_replaceField;
    protected JCheckBox m_regexCheck = new JCheckBox();
    protected JCheckBox m_ignoreCaseCheck = new JCheckBox();
    protected JList<SubstringReplacerRules.SubstringReplacerMatchRule> m_list = new JList();
    protected DefaultListModel<SubstringReplacerRules.SubstringReplacerMatchRule> m_listModel;
    protected JButton m_newBut = new JButton("New");
    protected JButton m_deleteBut = new JButton("Delete");
    protected JButton m_upBut = new JButton("Move up");
    protected JButton m_downBut = new JButton("Move down");

    protected void initialize() {
        String[] parts;
        String mrString = ((SubstringReplacer)this.getStepToEdit()).getMatchReplaceDetails();
        this.m_listModel = new DefaultListModel();
        this.m_list.setModel(this.m_listModel);
        if (mrString != null && mrString.length() > 0 && (parts = mrString.split("@@match-replace@@")).length > 0) {
            this.m_upBut.setEnabled(true);
            this.m_downBut.setEnabled(true);
            for (String mrPart : parts) {
                SubstringReplacerRules.SubstringReplacerMatchRule mr = new SubstringReplacerRules.SubstringReplacerMatchRule(mrPart);
                this.m_listModel.addElement(mr);
            }
            this.m_list.repaint();
        }
    }

    @Override
    protected void layoutEditor() {
        this.initialize();
        JPanel mainHolder = new JPanel(new BorderLayout());
        JPanel controlHolder = new JPanel();
        controlHolder.setLayout(new BorderLayout());
        JPanel fieldHolder = new JPanel();
        JPanel attListP = new JPanel();
        attListP.setLayout(new BorderLayout());
        attListP.setBorder(BorderFactory.createTitledBorder("Apply to attributes"));
        this.m_attListField = new EnvironmentField(this.m_env);
        attListP.add((Component)this.m_attListField, "Center");
        attListP.setToolTipText("<html>Accepts a range of indexes (e.g. '1,2,6-10')<br> or a comma-separated list of named attributes</html>");
        JPanel matchP = new JPanel();
        matchP.setLayout(new BorderLayout());
        matchP.setBorder(BorderFactory.createTitledBorder("Match"));
        this.m_matchField = new EnvironmentField(this.m_env);
        matchP.add((Component)this.m_matchField, "Center");
        JPanel replaceP = new JPanel();
        replaceP.setLayout(new BorderLayout());
        replaceP.setBorder(BorderFactory.createTitledBorder("Replace"));
        this.m_replaceField = new EnvironmentField(this.m_env);
        replaceP.add((Component)this.m_replaceField, "Center");
        fieldHolder.add(attListP);
        fieldHolder.add(matchP);
        fieldHolder.add(replaceP);
        controlHolder.add((Component)fieldHolder, "North");
        JPanel checkHolder = new JPanel();
        checkHolder.setLayout(new GridLayout(0, 2));
        JLabel regexLab = new JLabel("Match using a regular expression", 4);
        regexLab.setToolTipText("Use a regular expression rather than literal match");
        checkHolder.add(regexLab);
        checkHolder.add(this.m_regexCheck);
        JLabel caseLab = new JLabel("Ignore case when matching", 4);
        checkHolder.add(caseLab);
        checkHolder.add(this.m_ignoreCaseCheck);
        controlHolder.add((Component)checkHolder, "South");
        mainHolder.add((Component)controlHolder, "North");
        this.m_list.setVisibleRowCount(5);
        this.m_deleteBut.setEnabled(false);
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BorderLayout());
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new GridLayout(1, 0));
        butHolder.add(this.m_newBut);
        butHolder.add(this.m_deleteBut);
        butHolder.add(this.m_upBut);
        butHolder.add(this.m_downBut);
        this.m_upBut.setEnabled(false);
        this.m_downBut.setEnabled(false);
        listPanel.add((Component)butHolder, "North");
        JScrollPane js = new JScrollPane(this.m_list);
        js.setBorder(BorderFactory.createTitledBorder("Match-replace list (rows applied in order)"));
        listPanel.add((Component)js, "Center");
        mainHolder.add((Component)listPanel, "Center");
        this.add((Component)mainHolder, "Center");
        this.m_attListField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                SubstringReplacerRules.SubstringReplacerMatchRule mr = SubstringReplacerStepEditorDialog.this.m_list.getSelectedValue();
                if (mr != null) {
                    mr.setAttsToApplyTo(SubstringReplacerStepEditorDialog.this.m_attListField.getText());
                    SubstringReplacerStepEditorDialog.this.m_list.repaint();
                }
            }
        });
        this.m_matchField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                SubstringReplacerRules.SubstringReplacerMatchRule mr = SubstringReplacerStepEditorDialog.this.m_list.getSelectedValue();
                if (mr != null) {
                    mr.setMatch(SubstringReplacerStepEditorDialog.this.m_matchField.getText());
                    SubstringReplacerStepEditorDialog.this.m_list.repaint();
                }
            }
        });
        this.m_replaceField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                SubstringReplacerRules.SubstringReplacerMatchRule mr = SubstringReplacerStepEditorDialog.this.m_list.getSelectedValue();
                if (mr != null) {
                    mr.setReplace(SubstringReplacerStepEditorDialog.this.m_replaceField.getText());
                    SubstringReplacerStepEditorDialog.this.m_list.repaint();
                }
            }
        });
        this.m_list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SubstringReplacerRules.SubstringReplacerMatchRule entry;
                    if (!SubstringReplacerStepEditorDialog.this.m_deleteBut.isEnabled()) {
                        SubstringReplacerStepEditorDialog.this.m_deleteBut.setEnabled(true);
                    }
                    if ((entry = SubstringReplacerStepEditorDialog.this.m_list.getSelectedValue()) != null) {
                        SubstringReplacerRules.SubstringReplacerMatchRule mr = entry;
                        SubstringReplacerStepEditorDialog.this.m_attListField.setText(mr.getAttsToApplyTo());
                        SubstringReplacerStepEditorDialog.this.m_matchField.setText(mr.getMatch());
                        SubstringReplacerStepEditorDialog.this.m_replaceField.setText(mr.getReplace());
                        SubstringReplacerStepEditorDialog.this.m_regexCheck.setSelected(mr.getRegex());
                        SubstringReplacerStepEditorDialog.this.m_ignoreCaseCheck.setSelected(mr.getIgnoreCase());
                    }
                }
            }
        });
        this.m_newBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubstringReplacerRules.SubstringReplacerMatchRule mr = new SubstringReplacerRules.SubstringReplacerMatchRule();
                String atts = SubstringReplacerStepEditorDialog.this.m_attListField.getText() != null ? SubstringReplacerStepEditorDialog.this.m_attListField.getText() : "";
                mr.setAttsToApplyTo(atts);
                String match = SubstringReplacerStepEditorDialog.this.m_matchField.getText() != null ? SubstringReplacerStepEditorDialog.this.m_matchField.getText() : "";
                mr.setMatch(match);
                String replace = SubstringReplacerStepEditorDialog.this.m_replaceField.getText() != null ? SubstringReplacerStepEditorDialog.this.m_replaceField.getText() : "";
                mr.setReplace(replace);
                mr.setRegex(SubstringReplacerStepEditorDialog.this.m_regexCheck.isSelected());
                mr.setIgnoreCase(SubstringReplacerStepEditorDialog.this.m_ignoreCaseCheck.isSelected());
                SubstringReplacerStepEditorDialog.this.m_listModel.addElement(mr);
                if (SubstringReplacerStepEditorDialog.this.m_listModel.size() > 1) {
                    SubstringReplacerStepEditorDialog.this.m_upBut.setEnabled(true);
                    SubstringReplacerStepEditorDialog.this.m_downBut.setEnabled(true);
                }
                SubstringReplacerStepEditorDialog.this.m_list.setSelectedIndex(SubstringReplacerStepEditorDialog.this.m_listModel.size() - 1);
            }
        });
        this.m_deleteBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = SubstringReplacerStepEditorDialog.this.m_list.getSelectedIndex();
                if (selected >= 0) {
                    SubstringReplacerStepEditorDialog.this.m_listModel.removeElementAt(selected);
                    if (SubstringReplacerStepEditorDialog.this.m_listModel.size() <= 1) {
                        SubstringReplacerStepEditorDialog.this.m_upBut.setEnabled(false);
                        SubstringReplacerStepEditorDialog.this.m_downBut.setEnabled(false);
                    }
                }
            }
        });
        this.m_upBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JListHelper.moveUp(SubstringReplacerStepEditorDialog.this.m_list);
            }
        });
        this.m_downBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JListHelper.moveDown(SubstringReplacerStepEditorDialog.this.m_list);
            }
        });
        this.m_regexCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubstringReplacerRules.SubstringReplacerMatchRule mr = SubstringReplacerStepEditorDialog.this.m_list.getSelectedValue();
                if (mr != null) {
                    mr.setRegex(SubstringReplacerStepEditorDialog.this.m_regexCheck.isSelected());
                    SubstringReplacerStepEditorDialog.this.m_list.repaint();
                }
            }
        });
        this.m_ignoreCaseCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubstringReplacerRules.SubstringReplacerMatchRule mr = SubstringReplacerStepEditorDialog.this.m_list.getSelectedValue();
                if (mr != null) {
                    mr.setIgnoreCase(SubstringReplacerStepEditorDialog.this.m_ignoreCaseCheck.isSelected());
                    SubstringReplacerStepEditorDialog.this.m_list.repaint();
                }
            }
        });
    }

    @Override
    protected void okPressed() {
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < this.m_listModel.size(); ++i) {
            SubstringReplacerRules.SubstringReplacerMatchRule mr = this.m_listModel.elementAt(i);
            buff.append(mr.toStringInternal());
            if (i >= this.m_listModel.size() - 1) continue;
            buff.append("@@match-replace@@");
        }
        ((SubstringReplacer)this.getStepToEdit()).setMatchReplaceDetails(buff.toString());
    }
}

