/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import weka.core.Environment;
import weka.core.Settings;
import weka.core.WekaException;
import weka.gui.Logger;
import weka.gui.beans.PluginManager;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.ExecutionEnvironment;
import weka.knowledgeflow.ExecutionResult;
import weka.knowledgeflow.FlowExecutor;
import weka.knowledgeflow.LoggingLevel;
import weka.knowledgeflow.StepManagerImpl;
import weka.knowledgeflow.StepTask;

public class BaseExecutionEnvironment
implements ExecutionEnvironment {
    public static final String DESCRIPTION = "Default execution environment";
    protected FlowExecutor m_flowExecutor;
    protected boolean m_headless;
    protected transient Environment m_envVars = Environment.getSystemWide();
    protected transient Settings m_settings;
    protected transient ExecutorService m_executorService;
    protected transient Logger m_log;
    protected LoggingLevel m_loggingLevel = LoggingLevel.BASIC;

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public boolean isHeadless() {
        return this.m_headless;
    }

    @Override
    public void setHeadless(boolean headless) {
        this.m_headless = headless;
    }

    @Override
    public Environment getEnvironmentVariables() {
        return this.m_envVars;
    }

    @Override
    public void setEnvironmentVariables(Environment env) {
        this.m_envVars = env;
    }

    @Override
    public void setSettings(Settings settings) {
        this.m_settings = settings;
    }

    @Override
    public Settings getSettings() {
        if (this.m_settings == null) {
            this.m_settings = new Settings("weka", "knowledgeflow");
            try {
                this.m_settings.loadSettings();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.m_settings;
    }

    @Override
    public Logger getLog() {
        return this.m_log;
    }

    @Override
    public void setLog(Logger log) {
        this.m_log = log;
    }

    @Override
    public LoggingLevel getLoggingLevel() {
        return this.m_loggingLevel;
    }

    @Override
    public void setLoggingLevel(LoggingLevel level) {
        this.m_loggingLevel = level;
    }

    @Override
    public <T> Future<ExecutionResult<T>> submitTask(StepTask<T> stepTask) throws WekaException {
        return this.m_executorService.submit(stepTask);
    }

    @Override
    public void stopProcessing() {
        if (this.getFlowExecutor() != null) {
            this.getFlowExecutor().stopProcessing();
        }
        if (this.m_executorService != null) {
            this.m_executorService.shutdownNow();
            this.m_executorService = null;
        }
    }

    protected FlowExecutor getFlowExecutor() {
        return this.m_flowExecutor;
    }

    protected void setFlowExecutor(FlowExecutor executor) {
        this.m_flowExecutor = executor;
    }

    protected void startClientExecutionService(int numThreads) {
        if (this.m_executorService != null) {
            this.m_executorService.shutdownNow();
        }
        this.m_executorService = numThreads > 0 ? Executors.newFixedThreadPool(numThreads) : Executors.newCachedThreadPool();
    }

    protected void stopClientExecutionService() {
        if (this.m_executorService != null) {
            this.m_executorService.shutdown();
        }
    }

    protected void sendDataToStep(final StepManagerImpl step, final Data ... data) throws WekaException {
        if (data != null) {
            if (data.length == 1 && StepManagerImpl.connectionIsIncremental(data[0])) {
                step.processIncoming(data[0]);
            } else {
                this.m_executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (Data d : data) {
                            step.processIncoming(d);
                        }
                    }
                });
            }
        }
    }

    static {
        PluginManager.addPlugin(BaseExecutionEnvironment.class.getCanonicalName(), DESCRIPTION, BaseExecutionEnvironment.class.getCanonicalName());
    }
}

