/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow;

import java.io.Serializable;
import java.util.concurrent.Callable;
import weka.knowledgeflow.CallbackNotifierDelegate;
import weka.knowledgeflow.DefaultCallbackNotifierDelegate;
import weka.knowledgeflow.ExecutionResult;
import weka.knowledgeflow.LogHandler;
import weka.knowledgeflow.StepTaskCallback;
import weka.knowledgeflow.steps.Step;

public abstract class StepTask<T>
implements Callable<ExecutionResult<T>>,
Serializable {
    private static final long serialVersionUID = 2995081029283027784L;
    protected ExecutionResult<T> m_result = new ExecutionResult();
    protected transient StepTaskCallback<T> m_callback;
    protected LogHandler m_log;
    protected CallbackNotifierDelegate m_callbackNotifier = new DefaultCallbackNotifierDelegate();

    public StepTask(Step source) {
        this.m_log = new LogHandler(source);
    }

    public StepTask(Step source, StepTaskCallback<T> callback) {
        this(source);
        this.m_callback = callback;
    }

    protected final CallbackNotifierDelegate getCallbackNotifierDelegate() {
        return this.m_callbackNotifier;
    }

    protected final void setCallbackNotifierDelegate(CallbackNotifierDelegate delegate) {
        this.m_callbackNotifier = delegate;
    }

    protected final LogHandler getLogHandler() {
        return this.m_log;
    }

    protected final void setLogHandler(LogHandler log) {
        this.m_log = log;
    }

    protected final void notifyCallback() throws Exception {
        if (this.m_callback != null) {
            this.m_callbackNotifier.notifyCallback(this.m_callback, this, this.m_result);
        }
    }

    protected final ExecutionResult<T> getExecutionResult() {
        return this.m_result;
    }

    protected final void setExecutionResult(ExecutionResult<T> execResult) {
        this.m_result = execResult;
    }

    @Override
    public ExecutionResult<T> call() throws Exception {
        try {
            this.process();
        }
        catch (Exception ex) {
            this.getExecutionResult().setError(ex);
        }
        this.notifyCallback();
        return this.m_result;
    }

    public abstract void process() throws Exception;
}

