/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Map;
import weka.core.Defaults;
import weka.core.Instances;
import weka.core.WekaException;
import weka.gui.ProgrammaticProperty;
import weka.gui.knowledgeflow.StepInteractiveViewer;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.LoggingLevel;
import weka.knowledgeflow.StepManager;
import weka.knowledgeflow.steps.BaseStepExtender;
import weka.knowledgeflow.steps.KFStep;
import weka.knowledgeflow.steps.NotPersistable;
import weka.knowledgeflow.steps.Step;

public abstract class BaseStep
implements Step,
BaseStepExtender,
Serializable {
    private static final long serialVersionUID = -1595753549991953141L;
    protected boolean m_stopRequested;
    protected boolean m_busy;
    protected String m_stepName = "";
    protected transient StepManager m_stepManager;

    public BaseStep() {
        Annotation[] annotations;
        String clazzName = this.getClass().getCanonicalName();
        clazzName = clazzName.substring(clazzName.lastIndexOf(".") + 1);
        this.setName(clazzName);
        for (Annotation a : annotations = this.getClass().getAnnotations()) {
            String name;
            if (!(a instanceof KFStep) || (name = ((KFStep)a).name()).length() <= 0) continue;
            this.setName(name);
            break;
        }
    }

    public String globalInfo() {
        Annotation[] annotations;
        for (Annotation a : annotations = this.getClass().getAnnotations()) {
            if (!(a instanceof KFStep)) continue;
            return ((KFStep)a).toolTipText();
        }
        return null;
    }

    @Override
    @NotPersistable
    public StepManager getStepManager() {
        return this.m_stepManager;
    }

    @Override
    public void setStepManager(StepManager manager) {
        this.m_stepManager = manager;
    }

    @Override
    public void init() throws WekaException {
        this.m_stopRequested = false;
        this.m_busy = false;
        this.stepInit();
    }

    @Override
    public String getName() {
        return this.m_stepName;
    }

    @Override
    @ProgrammaticProperty
    public void setName(String name) {
        this.m_stepName = name;
    }

    @Override
    public void start() throws WekaException {
    }

    @Override
    public void stop() {
        this.getStepManager().statusMessage("INTERRUPTED");
        this.getStepManager().log("Interrupted", LoggingLevel.LOW);
        this.m_stopRequested = true;
        this.getStepManager().throughputUpdateEnd();
    }

    @Override
    @NotPersistable
    public boolean isBusy() {
        return this.m_busy;
    }

    @Override
    @ProgrammaticProperty
    public void setBusy(boolean busy) {
        this.m_busy = busy;
    }

    @Override
    public Instances outputStructureForConnectionType(String connectionName) throws WekaException {
        return null;
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
    }

    @Override
    public String getCustomEditorForStep() {
        return null;
    }

    @Override
    public Map<String, String> getInteractiveViewers() {
        return null;
    }

    @Override
    public Map<String, StepInteractiveViewer> getInteractiveViewersImpls() {
        return null;
    }

    @Override
    public Defaults getDefaultSettings() {
        return null;
    }

    @Override
    public boolean isStopRequested() {
        return this.m_stopRequested;
    }

    public String environmentSubstitute(String source) {
        return this.getStepManager().environmentSubstitute(source);
    }
}

