/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.bayes.NaiveBayes;
import weka.classifiers.evaluation.Evaluation;
import weka.core.Instances;
import weka.core.OptionMetadata;
import weka.core.WekaException;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;
import weka.knowledgeflow.steps.PairedDataHelper;

@KFStep(name="ExampleClassifier", category="Examples", toolTipText="A simple custom classifier processing example", iconPath="weka/gui/knowledgeflow/icons/DefaultClassifier.gif")
public class ExampleClassifier
extends BaseStep
implements PairedDataHelper.PairedProcessor<Classifier> {
    private static final long serialVersionUID = -1032628770114748181L;
    protected Classifier m_classifier = new NaiveBayes();
    protected transient PairedDataHelper<Classifier> m_trainTestHelper;

    @OptionMetadata(displayName="The classifier to use", description="The classifier to train")
    public void setClassifier(Classifier classifier) {
        this.m_classifier = classifier;
    }

    public Classifier getClassifier() {
        return this.m_classifier;
    }

    @Override
    public void stepInit() throws WekaException {
        this.m_trainTestHelper = new PairedDataHelper(this, this, "trainingSet", this.getStepManager().numIncomingConnectionsOfType("testSet") > 0 ? "testSet" : null);
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getStepManager().numIncomingConnectionsOfType("trainingSet") == 0) {
            result.add("trainingSet");
        }
        if (this.getStepManager().numIncomingConnectionsOfType("testSet") == 0 && this.getStepManager().numIncomingConnectionsOfType("trainingSet") > 0) {
            result.add("testSet");
        }
        return result;
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        return this.getStepManager().numIncomingConnectionsOfType("trainingSet") > 0 ? Arrays.asList("text") : new ArrayList<String>();
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        this.m_trainTestHelper.process(data);
    }

    @Override
    public Classifier processPrimary(Integer setNum, Integer maxSetNum, Data data, PairedDataHelper<Classifier> helper) throws WekaException {
        try {
            Classifier classifierToTrain = AbstractClassifier.makeCopy(this.m_classifier);
            Instances trainData = (Instances)data.getPrimaryPayload();
            Evaluation evaluation = new Evaluation(trainData);
            helper.addIndexedValueToNamedStore("initializedEvalObjects", setNum, evaluation);
            this.getStepManager().logBasic("Training classifier: " + this.m_classifier.getClass().getCanonicalName() + " on set " + setNum + " of " + maxSetNum);
            classifierToTrain.buildClassifier(trainData);
            Data textOut = new Data("text", classifierToTrain.toString());
            textOut.setPayloadElement("aux_textTitle", this.m_classifier.getClass().getCanonicalName());
            textOut.setPayloadElement("aux_set_num", setNum);
            textOut.setPayloadElement("aux_max_set_num", maxSetNum);
            this.getStepManager().outputData(textOut);
            return classifierToTrain;
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
    }

    @Override
    public void processSecondary(Integer setNum, Integer maxSetNum, Data data, PairedDataHelper<Classifier> helper) throws WekaException {
        Instances testData = (Instances)data.getPrimaryPayload();
        Classifier classifier = helper.getIndexedPrimaryResult(setNum);
        Evaluation eval = (Evaluation)helper.getIndexedValueFromNamedStore("initializedEvalObjects", setNum);
        try {
            this.getStepManager().logBasic("Evaluating classifier: " + this.m_classifier.getClass().getCanonicalName() + " on set " + setNum + " of " + maxSetNum);
            eval.evaluateModel(classifier, testData, new Object[0]);
            String results = eval.toSummaryString();
            Data textData = new Data("text", results);
            textData.setPayloadElement("aux_textTitle", this.m_classifier.getClass().getCanonicalName() + " - eval");
            textData.setPayloadElement("aux_set_num", setNum);
            textData.setPayloadElement("aux_max_set_num", maxSetNum);
            this.getStepManager().outputData(textData);
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
    }
}

