/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import weka.core.Defaults;
import weka.core.OptionMetadata;
import weka.core.Settings;
import weka.core.WekaException;
import weka.gui.FilePropertyMetadata;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="ImageSaver", category="DataSinks", toolTipText="Save static images to a file", iconPath="weka/gui/knowledgeflow/icons/SerializedModelSaver.gif")
public class ImageSaver
extends BaseStep {
    private static final long serialVersionUID = -8766164679635957891L;
    protected File m_file = new File("");
    protected String m_defaultFile = "";
    protected ImageFormat m_format = ImageFormat.DEFAULT;
    protected ImageFormat m_defaultFormat;

    @OptionMetadata(displayName="File to save to", description="The file to save textual results to", displayOrder=1)
    @FilePropertyMetadata(fileChooserDialogType=0, directoriesOnly=false)
    public void setFile(File f) {
        this.m_file = f;
    }

    public File getFile() {
        return this.m_file;
    }

    @OptionMetadata(displayName="Format to save image as", description="Format to save to", displayOrder=2)
    public void setFormat(ImageFormat format) {
        this.m_format = format;
    }

    public ImageFormat getFormat() {
        return this.m_format;
    }

    @Override
    public void stepInit() throws WekaException {
        this.m_defaultFile = this.getFile().toString();
        if (this.m_defaultFile == null || this.m_defaultFile.length() == 0) {
            File defaultF = this.getStepManager().getSettings().getSetting("weka.knowledgeflow.steps.imagesaver", ImageSaverDefaults.DEFAULT_FILE_KEY, ImageSaverDefaults.DEFAULT_FILE, this.getStepManager().getExecutionEnvironment().getEnvironmentVariables());
            this.m_defaultFile = defaultF.toString();
        }
        if (this.m_format == ImageFormat.DEFAULT) {
            this.m_defaultFormat = this.getStepManager().getSettings().getSetting("weka.knowledgeflow.steps.imagesaver", ImageSaverDefaults.DEFAULT_FORMAT_KEY, ImageSaverDefaults.DEFAULT_FORMAT, this.getStepManager().getExecutionEnvironment().getEnvironmentVariables());
            if (this.m_defaultFormat == ImageFormat.DEFAULT) {
                throw new WekaException("The default format to use must be something other than 'DEFAULT'");
            }
        }
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        return Arrays.asList("image");
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        return null;
    }

    @Override
    public synchronized void processIncoming(Data data) throws WekaException {
        this.getStepManager().processing();
        ImageFormat formatToUse = this.m_format == ImageFormat.DEFAULT ? this.m_defaultFormat : this.m_format;
        BufferedImage content = (BufferedImage)data.getPrimaryPayload();
        String fileName = this.getFile().toString();
        if (fileName == null || fileName.length() == 0) {
            fileName = this.m_defaultFile;
        }
        if (!new File(fileName = this.environmentSubstitute(fileName)).isDirectory()) {
            if (!fileName.toLowerCase().endsWith(formatToUse.toString().toLowerCase())) {
                fileName = fileName + "." + formatToUse.toString().toLowerCase();
            }
            File file = new File(fileName);
            this.getStepManager().logDetailed("Writing image to " + fileName);
            try {
                ImageIO.write((RenderedImage)content, formatToUse.toString().toLowerCase(), file);
            }
            catch (IOException ex) {
                throw new WekaException(ex);
            }
        } else {
            this.getStepManager().logWarning("Unable to write image because '" + fileName + "' is a directory!");
        }
        if (!this.isStopRequested()) {
            this.getStepManager().finished();
        } else {
            this.getStepManager().interrupted();
        }
    }

    @Override
    public Defaults getDefaultSettings() {
        return new ImageSaverDefaults();
    }

    public static final class ImageSaverDefaults
    extends Defaults {
        public static final String ID = "weka.knowledgeflow.steps.imagesaver";
        public static final Settings.SettingKey DEFAULT_FILE_KEY = new Settings.SettingKey("weka.knowledgeflow.steps.imagesaver.defaultFile", "Default file to save to", "Save to this file if the user has not explicitly set one in the step");
        public static final File DEFAULT_FILE = new File("${user.dir}/image");
        public static final Settings.SettingKey DEFAULT_FORMAT_KEY = new Settings.SettingKey("weka.knowledgeflow.steps.imagesaver.defaultFormat", "Default image format to write", "Default image format to write in the case that the user has explicitly set 'DEFAULT' in the step's options");
        public static final ImageFormat DEFAULT_FORMAT = ImageFormat.PNG;
        private static final long serialVersionUID = -2739579935119189195L;

        public ImageSaverDefaults() {
            super(ID);
            this.m_defaults.put(DEFAULT_FILE_KEY, DEFAULT_FILE);
            this.m_defaults.put(DEFAULT_FORMAT_KEY, DEFAULT_FORMAT);
        }
    }

    protected static enum ImageFormat {
        DEFAULT,
        PNG,
        GIF;

    }
}

