/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import weka.core.WekaException;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="ImageViewer", category="Visualization", toolTipText="View images", iconPath="weka/gui/knowledgeflow/icons/StripChart.gif")
public class ImageViewer
extends BaseStep {
    private static final long serialVersionUID = -4055716444227948343L;
    protected Map<String, BufferedImage> m_images = new LinkedHashMap<String, BufferedImage>();

    @Override
    public void stepInit() {
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        return Arrays.asList("image");
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        return this.getStepManager().numIncomingConnectionsOfType("image") > 0 ? Arrays.asList("image") : new ArrayList<String>();
    }

    @Override
    public synchronized void processIncoming(Data data) throws WekaException {
        this.getStepManager().processing();
        String imageTitle = (String)data.getPayloadElement("aux_textTitle");
        BufferedImage image = (BufferedImage)data.getPrimaryPayload();
        if (image == null) {
            throw new WekaException("Data does not seem to contain an image!");
        }
        String date = new SimpleDateFormat("HH:mm:ss.SSS - ").format(new Date());
        imageTitle = imageTitle != null ? date + imageTitle : date + "Untitled";
        this.m_images.put(imageTitle, image);
        this.getStepManager().logDetailed("Storing image: " + imageTitle);
        this.getStepManager().outputData(data);
        this.getStepManager().finished();
    }

    public Map<String, BufferedImage> getImages() {
        return this.m_images;
    }

    @Override
    public Map<String, String> getInteractiveViewers() {
        LinkedHashMap<String, String> views = new LinkedHashMap<String, String>();
        if (this.m_images.size() > 0) {
            views.put("Show images", "weka.gui.knowledgeflow.steps.ImageViewerInteractiveView");
        }
        return views;
    }
}

