/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SerializedObject;
import weka.core.WekaException;
import weka.core.converters.FileSourcedConverter;
import weka.gui.ProgrammaticProperty;
import weka.gui.beans.StreamThroughput;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.StepManagerImpl;
import weka.knowledgeflow.steps.KFStep;
import weka.knowledgeflow.steps.WekaAlgorithmWrapper;

@KFStep(name="Loader", category="DataSources", toolTipText="Weka loader wrapper", iconPath="")
public class Loader
extends WekaAlgorithmWrapper
implements Serializable {
    private static final long serialVersionUID = -788869066035779154L;
    protected String m_globalInfo;
    protected boolean m_instanceGeneration;
    protected boolean m_noOutputs;
    protected Data m_instanceData;
    protected StreamThroughput m_flowThroughput;

    @Override
    public Class getWrappedAlgorithmClass() {
        return weka.core.converters.Loader.class;
    }

    @Override
    public void setWrappedAlgorithm(Object algo) {
        super.setWrappedAlgorithm(algo);
        this.m_defaultIconPath = "weka/gui/knowledgeflow/icons/DefaultDataSource.gif";
    }

    public weka.core.converters.Loader getLoader() {
        return (weka.core.converters.Loader)this.getWrappedAlgorithm();
    }

    @ProgrammaticProperty
    public void setLoader(weka.core.converters.Loader loader) {
        this.setWrappedAlgorithm(loader);
    }

    @Override
    public void stepInit() throws WekaException {
        if (!(this.getWrappedAlgorithm() instanceof weka.core.converters.Loader)) {
            throw new WekaException("Incorrect type of algorithm");
        }
        int numDatasetOutputs = this.getStepManager().numOutgoingConnectionsOfType("dataSet");
        int numInstanceOutputs = this.getStepManager().numOutgoingConnectionsOfType("instance");
        boolean bl = this.m_noOutputs = numInstanceOutputs == 0 && numDatasetOutputs == 0;
        if (numDatasetOutputs > 0 && numInstanceOutputs > 0) {
            throw new WekaException("Can't have both instance and dataSet outgoing connections!");
        }
        if (this.getWrappedAlgorithm() instanceof EnvironmentHandler) {
            ((EnvironmentHandler)this.getWrappedAlgorithm()).setEnvironment(this.getStepManager().getExecutionEnvironment().getEnvironmentVariables());
        }
        this.m_instanceGeneration = numInstanceOutputs > 0;
        this.m_instanceData = new Data("instance");
    }

    @Override
    public void start() throws WekaException {
        if (this.m_noOutputs) {
            return;
        }
        this.getStepManager().processing();
        weka.core.converters.Loader theLoader = (weka.core.converters.Loader)this.getWrappedAlgorithm();
        String startMessage = theLoader instanceof FileSourcedConverter ? "Loading " + ((FileSourcedConverter)((Object)theLoader)).retrieveFile().getName() : "Loading...";
        this.getStepManager().logBasic(startMessage);
        this.getStepManager().statusMessage(startMessage);
        if (!this.m_instanceGeneration) {
            try {
                theLoader.reset();
                theLoader.setRetrieval(1);
                Instances dataset = theLoader.getDataSet();
                this.getStepManager().logBasic("Loaded " + dataset.relationName());
                Data data = new Data();
                data.setPayloadElement("dataSet", dataset);
                this.getStepManager().outputData("dataSet", data);
            }
            catch (Exception ex) {
                throw new WekaException(ex);
            }
            finally {
                this.getStepManager().finished();
            }
        }
        String stm = this.getName() + "$" + this.hashCode() + 99 + "| overall flow throughput -|";
        this.m_flowThroughput = new StreamThroughput(stm, "Starting flow...", ((StepManagerImpl)this.getStepManager()).getLog());
        Instance nextInstance = null;
        Instances structure = null;
        Instances structureCopy = null;
        Instances currentStructure = null;
        boolean stringAttsPresent = false;
        try {
            theLoader.reset();
            theLoader.setRetrieval(2);
            structure = theLoader.getStructure();
            if (structure.checkForStringAttributes()) {
                structureCopy = (Instances)new SerializedObject(structure).getObject();
                stringAttsPresent = true;
            }
            currentStructure = structure;
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
        if (this.isStopRequested()) {
            return;
        }
        try {
            nextInstance = theLoader.getNextInstance(structure);
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
        while (!this.isStopRequested() && nextInstance != null) {
            this.m_flowThroughput.updateStart();
            this.getStepManager().throughputUpdateStart();
            if (stringAttsPresent) {
                currentStructure = currentStructure == structure ? structureCopy : structure;
            }
            this.m_instanceData.setPayloadElement("instance", nextInstance);
            try {
                nextInstance = theLoader.getNextInstance(currentStructure);
            }
            catch (Exception ex) {
                this.getStepManager().throughputFinished(this.m_instanceData);
                throw new WekaException(ex);
            }
            this.getStepManager().throughputUpdateEnd();
            this.getStepManager().outputData("instance", this.m_instanceData);
            this.m_flowThroughput.updateEnd(((StepManagerImpl)this.getStepManager()).getLog());
        }
        if (this.isStopRequested()) {
            ((StepManagerImpl)this.getStepManager()).getLog().statusMessage(stm + "remove");
            return;
        }
        this.m_flowThroughput.finished(((StepManagerImpl)this.getStepManager()).getLog());
        this.m_instanceData.clearPayload();
        this.getStepManager().throughputFinished(this.m_instanceData);
    }

    @Override
    public Instances outputStructureForConnectionType(String connectionName) throws WekaException {
        if (this.isBusy()) {
            return null;
        }
        try {
            weka.core.converters.Loader theLoader = (weka.core.converters.Loader)this.getWrappedAlgorithm();
            theLoader.reset();
            if (theLoader instanceof EnvironmentHandler) {
                ((EnvironmentHandler)((Object)theLoader)).setEnvironment(Environment.getSystemWide());
            }
            return theLoader.getStructure();
        }
        catch (Exception ex) {
            this.getStepManager().logError(ex.getMessage(), ex);
            return null;
        }
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        return null;
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        ArrayList<String> outgoing = new ArrayList<String>();
        int numDatasetOutputs = this.getStepManager().numOutgoingConnectionsOfType("dataSet");
        int numInstanceOutputs = this.getStepManager().numOutgoingConnectionsOfType("instance");
        if (numDatasetOutputs == 0 && numInstanceOutputs == 0) {
            outgoing.add("dataSet");
            outgoing.add("instance");
        } else if (numDatasetOutputs > 0) {
            outgoing.add("dataSet");
        } else if (numInstanceOutputs > 0) {
            outgoing.add("instance");
        }
        return outgoing;
    }

    @Override
    public String getCustomEditorForStep() {
        return "weka.gui.knowledgeflow.steps.LoaderStepEditorDialog";
    }
}

