/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.core.WekaException;
import weka.core.converters.DatabaseConverter;
import weka.core.converters.DatabaseSaver;
import weka.gui.ProgrammaticProperty;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.ExecutionResult;
import weka.knowledgeflow.StepTask;
import weka.knowledgeflow.steps.KFStep;
import weka.knowledgeflow.steps.Step;
import weka.knowledgeflow.steps.WekaAlgorithmWrapper;

@KFStep(name="Saver", category="DataSinks", toolTipText="Weka saver wrapper", iconPath="")
public class Saver
extends WekaAlgorithmWrapper
implements Serializable {
    private static final long serialVersionUID = 6831606284211403465L;
    protected Instances m_structure;
    protected weka.core.converters.Saver m_saver;
    protected boolean m_isDBSaver;
    protected transient Future<ExecutionResult<Void>> m_future;
    private boolean m_relationNameForFilename = true;
    protected boolean m_isReset;

    @Override
    public Class getWrappedAlgorithmClass() {
        return weka.core.converters.Saver.class;
    }

    @Override
    public void setWrappedAlgorithm(Object algo) {
        super.setWrappedAlgorithm(algo);
        this.m_defaultIconPath = "weka/gui/knowledgeflow/icons/DefaultDataSink.gif";
    }

    public weka.core.converters.Saver getSaver() {
        return (weka.core.converters.Saver)this.getWrappedAlgorithm();
    }

    @ProgrammaticProperty
    public void setSaver(weka.core.converters.Saver saver) {
        this.setWrappedAlgorithm(saver);
    }

    public boolean getRelationNameForFilename() {
        return this.m_relationNameForFilename;
    }

    public void setRelationNameForFilename(boolean r) {
        this.m_relationNameForFilename = r;
    }

    @Override
    public void stepInit() throws WekaException {
        this.m_saver = null;
        if (!(this.getWrappedAlgorithm() instanceof weka.core.converters.Saver)) {
            throw new WekaException("Incorrect type of algorithm");
        }
        if (this.getWrappedAlgorithm() instanceof DatabaseConverter) {
            this.m_isDBSaver = true;
        }
        int numNonInstanceInputs = this.getStepManager().numIncomingConnectionsOfType("dataSet") + this.getStepManager().numIncomingConnectionsOfType("trainingSet") + this.getStepManager().numIncomingConnectionsOfType("testSet");
        int numInstanceInput = this.getStepManager().numIncomingConnectionsOfType("instance");
        if (numNonInstanceInputs > 0 && numInstanceInput > 0) {
            WekaException cause = new WekaException("Can't have both instance and batch-based incomming connections!");
            cause.fillInStackTrace();
            this.getStepManager().logError(cause.getMessage(), cause);
            throw new WekaException(cause);
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.m_future != null) {
            this.m_future.cancel(true);
        }
    }

    protected void saveBatch(Instances data, Integer setNum, Integer maxSetNum, String connectionName) throws WekaException {
        this.getStepManager().processing();
        try {
            String additional;
            this.m_saver = (weka.core.converters.Saver)new SerializedObject(this.getWrappedAlgorithm()).getObject();
            String fileName = this.sanitizeFilename(data.relationName());
            String string = additional = setNum != null && setNum + maxSetNum != 2 ? "_" + connectionName + "_" + setNum + "_of_" + maxSetNum : "";
            if (!this.m_isDBSaver) {
                this.m_saver.setDirAndPrefix(fileName, additional);
            } else {
                ((DatabaseSaver)this.m_saver).setTableName(fileName);
                ((DatabaseSaver)this.m_saver).setRelationForTableName(false);
                String setName = ((DatabaseSaver)this.m_saver).getTableName();
                setName = setName.replaceFirst("_" + connectionName + "_[0-9]+_of_[0-9]+", "");
                ((DatabaseSaver)this.m_saver).setTableName(setName + additional);
            }
            this.m_saver.setInstances(data);
            this.getStepManager().logBasic("Saving " + data.relationName() + additional);
            this.getStepManager().statusMessage("Saving " + data.relationName() + additional);
            BatchSaverTask b = new BatchSaverTask((Step)this, this.m_saver);
            this.m_future = this.getStepManager().getExecutionEnvironment().submitTask(b);
            ExecutionResult<Void> result = this.m_future.get();
            if (result != null && result.getError() != null) {
                result.getError().printStackTrace();
                throw result.getError();
            }
            if (!this.isStopRequested()) {
                this.getStepManager().statusMessage("Finished.");
                this.getStepManager().logBasic("Save successful");
            } else {
                this.getStepManager().interrupted();
            }
        }
        catch (Exception ex) {
            WekaException e = new WekaException(ex);
            throw e;
        }
        finally {
            this.getStepManager().finished();
        }
    }

    @Override
    public synchronized void processIncoming(Data data) throws WekaException {
        if (this.m_saver == null) {
            try {
                Instance forStructure;
                this.m_saver = (weka.core.converters.Saver)new SerializedObject(this.getWrappedAlgorithm()).getObject();
                if (this.m_saver instanceof EnvironmentHandler) {
                    ((EnvironmentHandler)((Object)this.m_saver)).setEnvironment(this.getStepManager().getExecutionEnvironment().getEnvironmentVariables());
                }
                if (data.getConnectionName().equals("dataSet") || data.getConnectionName().equals("trainingSet") || data.getConnectionName().equals("testSet")) {
                    this.m_saver.setRetrieval(1);
                    Instances theData = (Instances)data.getPayloadElement(data.getConnectionName());
                    Integer setNum = (Integer)data.getPayloadElement("aux_set_num");
                    Integer maxSetNum = (Integer)data.getPayloadElement("aux_max_set_num");
                    this.saveBatch(theData, setNum, maxSetNum, data.getConnectionName());
                    return;
                }
                if (data.getConnectionName().equals("instance") && (forStructure = (Instance)data.getPayloadElement("instance")) != null) {
                    this.m_saver.setRetrieval(2);
                    String fileName = this.sanitizeFilename(forStructure.dataset().relationName());
                    this.m_saver.setDirAndPrefix(fileName, "");
                    this.m_saver.setInstances(forStructure.dataset());
                    if (this.m_isDBSaver && ((DatabaseSaver)this.m_saver).getRelationForTableName()) {
                        ((DatabaseSaver)this.m_saver).setTableName(fileName);
                        ((DatabaseSaver)this.m_saver).setRelationForTableName(false);
                    }
                }
            }
            catch (Exception ex) {
                throw new WekaException(ex);
            }
        }
        Instance toSave = (Instance)data.getPayloadElement("instance");
        boolean streamEnd = this.getStepManager().isStreamFinished(data);
        try {
            if (streamEnd) {
                this.m_saver.writeIncremental(null);
                this.getStepManager().throughputFinished(new Data("instance"));
                return;
            }
            if (!this.isStopRequested()) {
                this.getStepManager().throughputUpdateStart();
                this.m_saver.writeIncremental(toSave);
            } else {
                this.m_saver.writeIncremental(null);
            }
            this.getStepManager().throughputUpdateEnd();
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        int numNonInstance;
        int numInstance = this.getStepManager().getIncomingConnectedStepsOfConnectionType("instance").size();
        if (numInstance + (numNonInstance = this.getStepManager().getIncomingConnectedStepsOfConnectionType("dataSet").size() + this.getStepManager().getIncomingConnectedStepsOfConnectionType("trainingSet").size() + this.getStepManager().getIncomingConnectedStepsOfConnectionType("testSet").size()) == 0) {
            return Arrays.asList("dataSet", "trainingSet", "testSet", "instance");
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        return new ArrayList<String>();
    }

    protected String sanitizeFilename(String filename) {
        filename = filename.replaceAll("\\\\", "_").replaceAll(":", "_").replaceAll("/", "_");
        filename = Utils.removeSubstring(filename, "weka.filters.supervised.instance.");
        filename = Utils.removeSubstring(filename, "weka.filters.supervised.attribute.");
        filename = Utils.removeSubstring(filename, "weka.filters.unsupervised.instance.");
        filename = Utils.removeSubstring(filename, "weka.filters.unsupervised.attribute.");
        filename = Utils.removeSubstring(filename, "weka.clusterers.");
        filename = Utils.removeSubstring(filename, "weka.associations.");
        filename = Utils.removeSubstring(filename, "weka.attributeSelection.");
        filename = Utils.removeSubstring(filename, "weka.estimators.");
        filename = Utils.removeSubstring(filename, "weka.datagenerators.");
        if (!this.m_isDBSaver && !this.m_relationNameForFilename) {
            filename = "";
            try {
                if (this.m_saver.filePrefix().equals("")) {
                    this.m_saver.setFilePrefix("no-name");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return filename;
    }

    @Override
    public String getCustomEditorForStep() {
        return "weka.gui.knowledgeflow.steps.SaverStepEditorDialog";
    }

    protected static class BatchSaverTask
    extends StepTask<Void>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected weka.core.converters.Saver m_saver;

        public BatchSaverTask(Step source, weka.core.converters.Saver saver) {
            super(source);
            this.m_saver = saver;
        }

        @Override
        public void process() throws Exception {
            try {
                this.m_saver.writeBatch();
            }
            catch (Exception ex) {
                this.m_result.setError(ex);
            }
        }
    }
}

