/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow.steps;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.core.Defaults;
import weka.core.Environment;
import weka.core.Instances;
import weka.core.Settings;
import weka.core.WekaException;
import weka.gui.ResultHistoryPanel;
import weka.gui.knowledgeflow.BaseInteractiveViewer;
import weka.gui.knowledgeflow.ScatterPlotMatrixPerspective;
import weka.gui.visualize.MatrixPanel;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.ScatterPlotMatrix;

public class ScatterPlotMatrixInteractiveView
extends BaseInteractiveViewer {
    private static final long serialVersionUID = 275603100387301133L;
    protected ResultHistoryPanel m_history;
    protected MatrixPanel m_matrixPanel = new MatrixPanel();
    protected JButton m_clearButton = new JButton("Clear results");
    protected JSplitPane m_splitPane;

    @Override
    public String getViewerName() {
        return "Scatter Plot Matrix";
    }

    @Override
    public void init() throws WekaException {
        this.addButton(this.m_clearButton);
        this.m_history = new ResultHistoryPanel(null);
        this.m_history.setBorder(BorderFactory.createTitledBorder("Result list"));
        this.m_history.setHandleRightClicks(false);
        this.m_history.getList().addMouseListener(new ResultHistoryPanel.RMouseAdapter(){
            private static final long serialVersionUID = -5174882230278923704L;

            @Override
            public void mouseClicked(MouseEvent e) {
                String name;
                Object insts;
                int index = ScatterPlotMatrixInteractiveView.this.m_history.getList().locationToIndex(e.getPoint());
                if (index != -1 && (insts = ScatterPlotMatrixInteractiveView.this.m_history.getNamedObject(name = ScatterPlotMatrixInteractiveView.this.m_history.getNameAtIndex(index))) instanceof Instances) {
                    try {
                        ScatterPlotMatrixInteractiveView.this.m_matrixPanel.setInstances((Instances)insts);
                        ScatterPlotMatrixInteractiveView.this.m_matrixPanel.repaint();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.m_history.getList().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ListSelectionModel lm = (ListSelectionModel)e.getSource();
                    for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                        String name;
                        Object insts;
                        if (!lm.isSelectedIndex(i)) continue;
                        if (i == -1 || (insts = ScatterPlotMatrixInteractiveView.this.m_history.getNamedObject(name = ScatterPlotMatrixInteractiveView.this.m_history.getNameAtIndex(i))) == null || !(insts instanceof Instances)) break;
                        try {
                            ScatterPlotMatrixInteractiveView.this.m_matrixPanel.setInstances((Instances)insts);
                            ScatterPlotMatrixInteractiveView.this.m_matrixPanel.repaint();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        break;
                    }
                }
            }
        });
        this.m_matrixPanel.setPreferredSize(new Dimension(800, 600));
        this.m_history.setMinimumSize(new Dimension(150, 600));
        this.m_splitPane = new JSplitPane(1, this.m_history, this.m_matrixPanel);
        this.add((Component)this.m_splitPane, "Center");
        boolean first = true;
        for (Data d : ((ScatterPlotMatrix)this.getStep()).getDatasets()) {
            String title = d.getPayloadElement("aux_textTitle").toString();
            this.m_history.addResult(title, new StringBuffer());
            Instances instances = (Instances)d.getPrimaryPayload();
            this.m_history.addObject(title, instances);
            if (!first) continue;
            this.m_matrixPanel.setInstances(instances);
            this.m_matrixPanel.repaint();
            first = false;
        }
        this.m_clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScatterPlotMatrixInteractiveView.this.m_history.clearResults();
                ((ScatterPlotMatrix)ScatterPlotMatrixInteractiveView.this.getStep()).getDatasets().clear();
                ScatterPlotMatrixInteractiveView.this.m_splitPane.remove(ScatterPlotMatrixInteractiveView.this.m_matrixPanel);
            }
        });
        this.applySettings(this.getSettings());
    }

    @Override
    public void applySettings(Settings settings) {
        int pointSize = settings.getSetting("weka.gui.knowledgeflow.scatterplotmatrix", ScatterPlotMatrixPerspective.ScatterDefaults.POINT_SIZE_KEY, Integer.valueOf(1), Environment.getSystemWide());
        int plotSize = settings.getSetting("weka.gui.knowledgeflow.scatterplotmatrix", ScatterPlotMatrixPerspective.ScatterDefaults.PLOT_SIZE_KEY, Integer.valueOf(100), Environment.getSystemWide());
        this.m_matrixPanel.setPointSize(pointSize);
        this.m_matrixPanel.setPlotSize(plotSize);
        this.m_matrixPanel.updatePanel();
    }

    @Override
    public Defaults getDefaultSettings() {
        return new ScatterPlotMatrixPerspective().getDefaultSettings();
    }
}

