/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionMetadata;
import weka.gui.ProgrammaticProperty;
import weka.gui.beans.OffscreenChartRenderer;
import weka.gui.beans.PluginManager;
import weka.gui.beans.WekaOffscreenChartRenderer;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.BaseSimpleDataVisualizer;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="AttributeSummarizer", category="Visualization", toolTipText="Visualize datasets in a scatter plot matrix", iconPath="weka/gui/knowledgeflow/icons/AttributeSummarizer.gif")
public class AttributeSummarizer
extends BaseSimpleDataVisualizer {
    private static final long serialVersionUID = 2313372820072708102L;
    protected String m_xAxis = "";
    protected transient OffscreenChartRenderer m_offscreenRenderer;
    protected String m_offscreenRendererName = "Weka Chart Renderer";
    protected String m_additionalOptions = "";
    protected String m_width = "500";
    protected String m_height = "400";

    @OptionMetadata(displayName="X-axis attribute", description="Attribute name or /first, /last or /<index>", displayOrder=1)
    public void setOffscreenXAxis(String xAxis) {
        this.m_xAxis = xAxis;
    }

    public String getOffscreenXAxis() {
        return this.m_xAxis;
    }

    @OptionMetadata(displayName="Chart width (pixels)", description="Width of the rendered chart", displayOrder=2)
    public void setOffscreenWidth(String width) {
        this.m_width = width;
    }

    public String getOffscreenWidth() {
        return this.m_width;
    }

    @OptionMetadata(displayName="Chart height (pixels)", description="Height of the rendered chart", displayOrder=3)
    public void setOffscreenHeight(String height) {
        this.m_height = height;
    }

    public String getOffscreenHeight() {
        return this.m_height;
    }

    @ProgrammaticProperty
    public void setOffscreenRendererName(String rendererName) {
        this.m_offscreenRendererName = rendererName;
        this.m_offscreenRenderer = null;
    }

    public String getOffscreenRendererName() {
        return this.m_offscreenRendererName;
    }

    @ProgrammaticProperty
    public void setOffscreenAdditionalOpts(String additional) {
        this.m_additionalOptions = additional;
    }

    public String getOffscreenAdditionalOpts() {
        return this.m_additionalOptions;
    }

    @Override
    public synchronized void processIncoming(Data data) {
        super.processIncoming(data, false);
        if (this.getStepManager().numOutgoingConnectionsOfType("image") > 0) {
            this.setupOffscreenRenderer();
            this.createOffscreenPlot(data);
        }
        this.getStepManager().finished();
    }

    protected void createOffscreenPlot(Data data) {
        String[] optionsParts;
        ArrayList<Instances> offscreenPlotData = new ArrayList<Instances>();
        Instances predictedI = (Instances)data.getPrimaryPayload();
        if (predictedI.classIndex() >= 0 && predictedI.classAttribute().isNominal()) {
            int i;
            Instances[] classes = new Instances[predictedI.numClasses()];
            for (i = 0; i < predictedI.numClasses(); ++i) {
                classes[i] = new Instances(predictedI, 0);
                classes[i].setRelationName(predictedI.classAttribute().value(i));
            }
            for (i = 0; i < predictedI.numInstances(); ++i) {
                Instance current = predictedI.instance(i);
                classes[(int)current.classValue()].add((Instance)current.copy());
            }
            for (Instances classe : classes) {
                offscreenPlotData.add(classe);
            }
        } else {
            offscreenPlotData.add(new Instances(predictedI));
        }
        ArrayList<String> options = new ArrayList<String>();
        String additional = this.m_additionalOptions;
        if (this.m_additionalOptions.length() > 0) {
            additional = this.environmentSubstitute(additional);
        }
        if (additional.contains("-color")) {
            if (additional.length() > 0) {
                additional = additional + ",";
            }
            additional = predictedI.classIndex() >= 0 ? additional + "-color=" + predictedI.classAttribute().name() : additional + "-color=/last";
        }
        for (String p : optionsParts = additional.split(",")) {
            options.add(p.trim());
        }
        String xAxis = this.m_xAxis;
        xAxis = this.environmentSubstitute(xAxis);
        String width = this.m_width;
        String height = this.m_height;
        int defWidth = 500;
        int defHeight = 400;
        width = this.environmentSubstitute(width);
        height = this.environmentSubstitute(height);
        defWidth = Integer.parseInt(width);
        defHeight = Integer.parseInt(height);
        try {
            this.getStepManager().logDetailed("Creating image");
            BufferedImage osi = this.m_offscreenRenderer.renderHistogram(defWidth, defHeight, offscreenPlotData, xAxis, options);
            Data imageData = new Data("image", osi);
            String relationName = predictedI.relationName();
            if (relationName.length() > 10) {
                relationName = relationName.substring(0, 10);
            }
            imageData.setPayloadElement("aux_textTitle", relationName + ":" + this.m_xAxis);
            this.getStepManager().outputData(imageData);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public Map<String, String> getInteractiveViewers() {
        LinkedHashMap<String, String> views = new LinkedHashMap<String, String>();
        if (this.m_data.size() > 0) {
            views.put("Show plots", "weka.gui.knowledgeflow.steps.AttributeSummarizerInteractiveView");
        }
        return views;
    }

    protected void setupOffscreenRenderer() {
        this.getStepManager().logDetailed("Initializing offscreen renderer: " + this.getOffscreenRendererName());
        if (this.m_offscreenRenderer == null) {
            if (this.m_offscreenRendererName == null || this.m_offscreenRendererName.length() == 0) {
                this.m_offscreenRenderer = new WekaOffscreenChartRenderer();
                return;
            }
            if (this.m_offscreenRendererName.equalsIgnoreCase("weka chart renderer")) {
                this.m_offscreenRenderer = new WekaOffscreenChartRenderer();
            } else {
                try {
                    Object r = PluginManager.getPluginInstance("weka.gui.beans.OffscreenChartRenderer", this.m_offscreenRendererName);
                    if (r != null && r instanceof OffscreenChartRenderer) {
                        this.m_offscreenRenderer = (OffscreenChartRenderer)r;
                    } else {
                        this.getStepManager().logWarning("Offscreen renderer '" + this.getOffscreenRendererName() + "' is not available, using default weka chart renderer " + "instead");
                        this.m_offscreenRenderer = new WekaOffscreenChartRenderer();
                    }
                }
                catch (Exception ex) {
                    this.getStepManager().logWarning("Offscreen renderer '" + this.getOffscreenRendererName() + "' is not available, using default weka chart renderer " + "instead");
                    this.m_offscreenRenderer = new WekaOffscreenChartRenderer();
                }
            }
        }
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        return this.getStepManager().numIncomingConnections() > 0 ? Arrays.asList("image") : new ArrayList<String>();
    }

    @Override
    public String getCustomEditorForStep() {
        return "weka.gui.knowledgeflow.steps.AttributeSummarizerStepEditorDialog";
    }
}

