/*
 * Decompiled with CFR 0.152.
 */
package weka.core.expressionlanguage;

import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.expressionlanguage.common.IfElseMacro;
import weka.core.expressionlanguage.common.JavaMacro;
import weka.core.expressionlanguage.common.MacroDeclarationsCompositor;
import weka.core.expressionlanguage.common.MathFunctions;
import weka.core.expressionlanguage.common.Primitives;
import weka.core.expressionlanguage.common.SimpleVariableDeclarations;
import weka.core.expressionlanguage.core.MacroDeclarations;
import weka.core.expressionlanguage.core.Node;
import weka.core.expressionlanguage.core.VariableDeclarations;
import weka.core.expressionlanguage.parser.Parser;

public class ExpressionLanguageTest
extends TestCase {
    public ExpressionLanguageTest(String name) {
        super(name);
    }

    private static Node compile(String expression, Object[] values) throws Exception {
        SimpleVariableDeclarations variables = new SimpleVariableDeclarations();
        for (int i = 0; i < values.length; ++i) {
            String name = "" + (char)(65 + i);
            if (values[i] instanceof Boolean) {
                variables.addBoolean(name);
                continue;
            }
            if (values[i] instanceof Double) {
                variables.addDouble(name);
                continue;
            }
            if (values[i] instanceof String) {
                variables.addString(name);
                continue;
            }
            throw new Exception("Unsupported variable type!");
        }
        Node node = Parser.parse((String)expression, (VariableDeclarations)variables, (MacroDeclarations)new MacroDeclarationsCompositor(new MacroDeclarations[]{new MathFunctions(), new IfElseMacro(), new JavaMacro()}));
        for (int i = 0; i < values.length; ++i) {
            String name = "" + (char)(65 + i);
            if (!variables.getInitializer().hasVariable(name)) continue;
            if (values[i] instanceof Boolean) {
                variables.getInitializer().setBoolean(name, ((Boolean)values[i]).booleanValue());
                continue;
            }
            if (values[i] instanceof Double) {
                variables.getInitializer().setDouble(name, ((Double)values[i]).doubleValue());
                continue;
            }
            if (values[i] instanceof String) {
                variables.getInitializer().setString(name, (String)values[i]);
                continue;
            }
            throw new Exception("Unsupported variable type!");
        }
        return node;
    }

    private static boolean evaluateBoolean(String expr, Object ... values) throws Exception {
        Node node = ExpressionLanguageTest.compile(expr, values);
        if (!(node instanceof Primitives.BooleanExpression)) {
            throw new Exception("Type error in expression!");
        }
        return ((Primitives.BooleanExpression)node).evaluate();
    }

    private static double evaluateDouble(String expr, Object ... values) throws Exception {
        Node node = ExpressionLanguageTest.compile(expr, values);
        if (!(node instanceof Primitives.DoubleExpression)) {
            throw new Exception("Type error in expression!");
        }
        return ((Primitives.DoubleExpression)node).evaluate();
    }

    private static String evaluateString(String expr, Object ... values) throws Exception {
        Node node = ExpressionLanguageTest.compile(expr, values);
        if (!(node instanceof Primitives.StringExpression)) {
            throw new Exception("Type error in expression!");
        }
        return ((Primitives.StringExpression)node).evaluate();
    }

    public void testParsing() throws Exception {
        ExpressionLanguageTest.evaluateDouble("0.0 + (-0.0 + 0.0)", new Object[0]);
        ExpressionLanguageTest.evaluateDouble("(4.0-2.0)", new Object[0]);
        ExpressionLanguageTest.assertEquals((String)"asdf", (String)ExpressionLanguageTest.evaluateString("'asdf'", new Object[0]));
        ExpressionLanguageTest.assertEquals((String)"asdf", (String)ExpressionLanguageTest.evaluateString("\"asdf\"", new Object[0]));
        ExpressionLanguageTest.assertEquals((String)"\b\f\n\r\t\\\"'", (String)ExpressionLanguageTest.evaluateString("'\\b\\f\\n\\r\\t\\\\\\\"\\''", new Object[0]));
        ExpressionLanguageTest.assertEquals((String)"\b\f\n\r\t\\\"'", (String)ExpressionLanguageTest.evaluateString("\"\\b\\f\\n\\r\\t\\\\\\\"\\'\"", new Object[0]));
        try {
            ExpressionLanguageTest.evaluateString("'\\a\\b'", new Object[0]);
            ExpressionLanguageTest.fail((String)"Didn't detect improper string escaping");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ExpressionLanguageTest.evaluateString("\"\\a\\b\"", new Object[0]);
            ExpressionLanguageTest.fail((String)"Didn't detect improper string escaping");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ExpressionLanguageTest.assertEquals((Object)4.0, (Object)ExpressionLanguageTest.evaluateDouble("8.0/(4.0/2.0)", new Object[0]));
        ExpressionLanguageTest.assertEquals((Object)6.0, (Object)ExpressionLanguageTest.evaluateDouble("8.0 - (4.0 - 2.0)", new Object[0]));
        ExpressionLanguageTest.evaluateDouble("((((((((((((1))))))))))))", new Object[0]);
        ExpressionLanguageTest.evaluateDouble("((((((((((((1)))))))))))) + ((((((((((((1))))))))))))", new Object[0]);
        ExpressionLanguageTest.evaluateDouble("((((((((((((1) + 1) + 1) + 1) + 1) + 1) + 1) + 1) + 1) + 1) + 1) + 1) + 1", new Object[0]);
        ExpressionLanguageTest.evaluateDouble("1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1", new Object[0]);
        ExpressionLanguageTest.evaluateDouble("1 - 1 - 1 - 1 - 1 - 1 - 1 - 1 - 1 - 1 - 1 - 1 - 1", new Object[0]);
        ExpressionLanguageTest.evaluateDouble("1 * 1 * 1 * 1 * 1 * 1 * 1 * 1 * 1 * 1 * 1 * 1 * 1", new Object[0]);
        ExpressionLanguageTest.evaluateDouble("1 / 1 / 1 / 1 / 1 / 1 / 1 / 1 / 1 / 1 / 1 / 1 / 1", new Object[0]);
        ExpressionLanguageTest.evaluateDouble("1 ^ 1 ^ 1 ^ 1 ^ 1 ^ 1 ^ 1 ^ 1 ^ 1 ^ 1 ^ 1 ^ 1 ^ 1", new Object[0]);
        ExpressionLanguageTest.evaluateDouble("--------1", new Object[0]);
        ExpressionLanguageTest.evaluateDouble("1--------1", new Object[0]);
        ExpressionLanguageTest.evaluateDouble("++++++++1", new Object[0]);
        ExpressionLanguageTest.evaluateDouble("1++++++++1", new Object[0]);
        ExpressionLanguageTest.evaluateDouble("-+-+-+-+1", new Object[0]);
        ExpressionLanguageTest.evaluateDouble("1-+-+-+-+1", new Object[0]);
        ExpressionLanguageTest.evaluateBoolean("not not not not not not true", new Object[0]);
        ExpressionLanguageTest.evaluateBoolean("! ! ! ! ! true", new Object[0]);
        ExpressionLanguageTest.evaluateBoolean("!!!!!true", new Object[0]);
        ExpressionLanguageTest.evaluateBoolean("not ! not ! not true", new Object[0]);
        ExpressionLanguageTest.evaluateBoolean("not!not!not true", new Object[0]);
        try {
            ExpressionLanguageTest.assertEquals((Object)1.0, (Object)ExpressionLanguageTest.evaluateDouble("1", new Object[0]));
        }
        catch (Exception e) {
            ExpressionLanguageTest.fail((String)"Parsing failure!");
        }
        try {
            ExpressionLanguageTest.assertEquals((Object)1.0, (Object)ExpressionLanguageTest.evaluateDouble("1.0", new Object[0]));
        }
        catch (Exception e) {
            ExpressionLanguageTest.fail((String)"Parsing failure!");
        }
        try {
            ExpressionLanguageTest.assertEquals((Object)1.0, (Object)ExpressionLanguageTest.evaluateDouble("1.0000000000000000000000000000000", new Object[0]));
        }
        catch (Exception e) {
            ExpressionLanguageTest.fail((String)"Parsing failure!");
        }
        try {
            ExpressionLanguageTest.assertEquals((Object)0.0, (Object)ExpressionLanguageTest.evaluateDouble("0", new Object[0]));
        }
        catch (Exception e) {
            ExpressionLanguageTest.fail((String)"Parsing failure!");
        }
        try {
            ExpressionLanguageTest.assertEquals((Object)0.0, (Object)ExpressionLanguageTest.evaluateDouble("0.0", new Object[0]));
        }
        catch (Exception e) {
            ExpressionLanguageTest.fail((String)"Parsing failure!");
        }
        try {
            ExpressionLanguageTest.assertEquals((Object)0.0, (Object)ExpressionLanguageTest.evaluateDouble("0.00000000000000000000000000000000", new Object[0]));
        }
        catch (Exception e) {
            ExpressionLanguageTest.fail((String)"Parsing failure!");
        }
        try {
            ExpressionLanguageTest.assertEquals((Object)-1.0, (Object)ExpressionLanguageTest.evaluateDouble("-1", new Object[0]));
        }
        catch (Exception e) {
            ExpressionLanguageTest.fail((String)"Parsing failure!");
        }
        try {
            ExpressionLanguageTest.assertEquals((Object)-1.0, (Object)ExpressionLanguageTest.evaluateDouble("-1.0", new Object[0]));
        }
        catch (Exception e) {
            ExpressionLanguageTest.fail((String)"Parsing failure!");
        }
        try {
            ExpressionLanguageTest.assertEquals((Object)-1.0, (Object)ExpressionLanguageTest.evaluateDouble("-1.00000000000000000000000000000000", new Object[0]));
        }
        catch (Exception e) {
            ExpressionLanguageTest.fail((String)"Parsing failure!");
        }
        try {
            ExpressionLanguageTest.evaluateDouble("1.0 & 5", new Object[0]);
            ExpressionLanguageTest.fail((String)"Failed to find syntax error!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ExpressionLanguageTest.evaluateDouble("1.000a0", new Object[0]);
            ExpressionLanguageTest.fail((String)"Failed to find syntax error!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testVariables() throws Exception {
        SimpleVariableDeclarations vars = new SimpleVariableDeclarations();
        vars.addBoolean("someBool");
        vars.addDouble("someDouble");
        vars.addString("someString");
        vars.addString("__weird_NAME_0123456789__");
        Primitives.DoubleExpression root = (Primitives.DoubleExpression)Parser.parse((String)"someDouble + ifelse(someBool, 0.0, ifelse(someString + __weird_NAME_0123456789__ regexp 'asdf', 1.0, 2.0))", (VariableDeclarations)vars, (MacroDeclarations)new MacroDeclarationsCompositor(new MacroDeclarations[]{new IfElseMacro(), new MathFunctions()}));
        double[] values = new double[]{0.0, 1.0, Double.NaN, Double.POSITIVE_INFINITY};
        vars.getInitializer().setBoolean("someBool", true);
        for (double value : values) {
            vars.getInitializer().setDouble("someDouble", value);
            ExpressionLanguageTest.assertEquals((Object)(value + 0.0), (Object)root.evaluate());
        }
        vars.getInitializer().setBoolean("someBool", false);
        for (double value : values) {
            vars.getInitializer().setDouble("someDouble", value);
            vars.getInitializer().setString("someString", "as");
            vars.getInitializer().setString("__weird_NAME_0123456789__", "df");
            ExpressionLanguageTest.assertEquals((Object)(value + 1.0), (Object)root.evaluate());
            vars.getInitializer().setString("someString", "clearly not matchin!");
            vars.getInitializer().setString("__weird_NAME_0123456789__", "and neither is this one");
            ExpressionLanguageTest.assertEquals((Object)(value + 2.0), (Object)root.evaluate());
        }
    }

    public void testPlusOperator() throws Exception {
        double[] safe_values;
        double[] values;
        for (double left : values = new double[]{0.0, 1.0, 2.0, 3.0, 100.0, 1000.0, 1.0E8, 1.0E-8, 0.1, -0.0, -1.0, -2.0, -3.0, -100.0, -1000.0, -1.0E8, -1.0E-8, -0.1}) {
            ExpressionLanguageTest.assertTrue((left == ExpressionLanguageTest.evaluateDouble(String.format("%.20f + 0.0", left), new Object[0]) ? 1 : 0) != 0);
            ExpressionLanguageTest.assertTrue((left == ExpressionLanguageTest.evaluateDouble(String.format("0.0 + %.20f", left), new Object[0]) ? 1 : 0) != 0);
            for (double right : values) {
                ExpressionLanguageTest.assertTrue((left + right == ExpressionLanguageTest.evaluateDouble(String.format("%.20f + %.20f", left, right), new Object[0]) ? 1 : 0) != 0);
                ExpressionLanguageTest.assertTrue((ExpressionLanguageTest.evaluateDouble(String.format("%.20f + %.20f", left, right), new Object[0]) == ExpressionLanguageTest.evaluateDouble(String.format("%.20f + %.20f", right, left), new Object[0]) ? 1 : 0) != 0);
            }
        }
        for (double first : safe_values = new double[]{0.0, 1.0, 2.0, -0.0, -1.0, -2.0}) {
            for (double second : safe_values) {
                for (double third : safe_values) {
                    ExpressionLanguageTest.assertTrue((ExpressionLanguageTest.evaluateDouble(String.format("%.20f + %.20f + %.20f", first, second, third), new Object[0]) == ExpressionLanguageTest.evaluateDouble(String.format("(%.20f + %.20f) + %.20f", first, second, third), new Object[0]) ? 1 : 0) != 0);
                    ExpressionLanguageTest.assertTrue((ExpressionLanguageTest.evaluateDouble(String.format("%.20f + %.20f + %.20f", first, second, third), new Object[0]) == ExpressionLanguageTest.evaluateDouble(String.format("%.20f + (%.20f + %.20f)", first, second, third), new Object[0]) ? 1 : 0) != 0);
                }
            }
        }
        ExpressionLanguageTest.assertTrue((boolean)Double.isNaN(ExpressionLanguageTest.evaluateDouble("sqrt(-1) + 1.0", new Object[0])));
        ExpressionLanguageTest.assertTrue((boolean)Double.isNaN(ExpressionLanguageTest.evaluateDouble("sqrt(-1) + sqrt(-1.0)", new Object[0])));
        ExpressionLanguageTest.assertTrue((boolean)Double.isInfinite(ExpressionLanguageTest.evaluateDouble(String.format("%.20f + %.20f", Double.MAX_VALUE, Double.MAX_VALUE), new Object[0])));
        ExpressionLanguageTest.assertTrue((boolean)Double.isNaN(ExpressionLanguageTest.evaluateDouble("1/0 + -1/0", new Object[0])));
        ExpressionLanguageTest.assertTrue((boolean)Double.isInfinite(ExpressionLanguageTest.evaluateDouble("1/0 + 1/0", new Object[0])));
    }

    public void testStringConcatenation() throws Exception {
        ExpressionLanguageTest.assertEquals((String)"asdf", (String)ExpressionLanguageTest.evaluateString("'asdf'", new Object[0]));
        ExpressionLanguageTest.assertEquals((String)"asdf", (String)ExpressionLanguageTest.evaluateString("\"asdf\"", new Object[0]));
        ExpressionLanguageTest.assertEquals((String)"asdf", (String)ExpressionLanguageTest.evaluateString("'as' + 'df'", new Object[0]));
        ExpressionLanguageTest.assertEquals((String)"asdf", (String)ExpressionLanguageTest.evaluateString("\"as\" + \"df\"", new Object[0]));
        ExpressionLanguageTest.assertEquals((String)"asdf", (String)ExpressionLanguageTest.evaluateString("'as' + \"df\"", new Object[0]));
        ExpressionLanguageTest.assertEquals((String)"asdf", (String)ExpressionLanguageTest.evaluateString("\"as\" + 'df'", new Object[0]));
        ExpressionLanguageTest.assertEquals((String)"Hello World from WEKA :)", (String)ExpressionLanguageTest.evaluateString("'Hello' + \" W\" + \"o\" + ('r' + (\"l\" + (('d'))) + \" from\")+' WEKA :)'", new Object[0]));
    }

    public void testMinusOperator() throws Exception {
        double[] safe_values;
        double[] values;
        for (double left : values = new double[]{0.0, 1.0, 2.0, 3.0, 100.0, 1000.0, 1.0E8, 1.0E-8, 0.1, -0.0, -1.0, -2.0, -3.0, -100.0, -1000.0, -1.0E8, -1.0E-8, -0.1}) {
            ExpressionLanguageTest.assertTrue((left == ExpressionLanguageTest.evaluateDouble(String.format("%.20f - 0.0", left), new Object[0]) ? 1 : 0) != 0);
            for (double right : values) {
                ExpressionLanguageTest.assertTrue((left - right == ExpressionLanguageTest.evaluateDouble(String.format("%.20f - %.20f", left, right), new Object[0]) ? 1 : 0) != 0);
            }
        }
        for (double first : safe_values = new double[]{0.0, 1.0, 2.0, -0.0, -1.0, -2.0}) {
            for (double second : safe_values) {
                for (double third : safe_values) {
                    ExpressionLanguageTest.assertTrue((ExpressionLanguageTest.evaluateDouble(String.format("%.20f - %.20f - %.20f", first, second, third), new Object[0]) == ExpressionLanguageTest.evaluateDouble(String.format("(%.20f - %.20f) - %.20f", first, second, third), new Object[0]) ? 1 : 0) != 0);
                }
            }
        }
        ExpressionLanguageTest.assertTrue((boolean)Double.isNaN(ExpressionLanguageTest.evaluateDouble("sqrt(-1) - 1.0", new Object[0])));
        ExpressionLanguageTest.assertTrue((boolean)Double.isNaN(ExpressionLanguageTest.evaluateDouble("sqrt(-1) - sqrt(-1.0)", new Object[0])));
        ExpressionLanguageTest.assertTrue((boolean)Double.isInfinite(ExpressionLanguageTest.evaluateDouble(String.format("%.20f - %.20f", -1.7976931348623157E308, Double.MAX_VALUE), new Object[0])));
        ExpressionLanguageTest.assertTrue((boolean)Double.isNaN(ExpressionLanguageTest.evaluateDouble("1/0 - 1/0", new Object[0])));
    }

    public void testTimesOperator() throws Exception {
        double[] safe_values;
        double[] values;
        for (double left : values = new double[]{0.0, 1.0, 2.0, 3.0, 100.0, 1000.0, 1.0E8, 1.0E-8, 0.1, -0.0, -1.0, -2.0, -3.0, -100.0, -1000.0, -1.0E8, -1.0E-8, -0.1}) {
            ExpressionLanguageTest.assertTrue((left == ExpressionLanguageTest.evaluateDouble(String.format("%.20f * 1.0", left), new Object[0]) ? 1 : 0) != 0);
            ExpressionLanguageTest.assertTrue((left == ExpressionLanguageTest.evaluateDouble(String.format("1.0 * %.20f", left), new Object[0]) ? 1 : 0) != 0);
            for (double right : values) {
                ExpressionLanguageTest.assertTrue((left * right == ExpressionLanguageTest.evaluateDouble(String.format("%.20f * %.20f", left, right), new Object[0]) ? 1 : 0) != 0);
                ExpressionLanguageTest.assertTrue((ExpressionLanguageTest.evaluateDouble(String.format("%.20f * %.20f", left, right), new Object[0]) == ExpressionLanguageTest.evaluateDouble(String.format("%.20f * %.20f", right, left), new Object[0]) ? 1 : 0) != 0);
            }
        }
        for (double first : safe_values = new double[]{0.0, 1.0, 2.0, -0.0, -1.0, -2.0}) {
            for (double second : safe_values) {
                for (double third : safe_values) {
                    ExpressionLanguageTest.assertTrue((ExpressionLanguageTest.evaluateDouble(String.format("%.20f * %.20f * %.20f", first, second, third), new Object[0]) == ExpressionLanguageTest.evaluateDouble(String.format("(%.20f * %.20f) * %.20f", first, second, third), new Object[0]) ? 1 : 0) != 0);
                    ExpressionLanguageTest.assertTrue((ExpressionLanguageTest.evaluateDouble(String.format("%.20f * %.20f * %.20f", first, second, third), new Object[0]) == ExpressionLanguageTest.evaluateDouble(String.format("%.20f * (%.20f * %.20f)", first, second, third), new Object[0]) ? 1 : 0) != 0);
                }
            }
        }
        ExpressionLanguageTest.assertTrue((boolean)Double.isNaN(ExpressionLanguageTest.evaluateDouble("sqrt(-1) * 1.0", new Object[0])));
        ExpressionLanguageTest.assertTrue((boolean)Double.isNaN(ExpressionLanguageTest.evaluateDouble("sqrt(-1) * sqrt(-1.0)", new Object[0])));
        ExpressionLanguageTest.assertTrue((boolean)Double.isInfinite(ExpressionLanguageTest.evaluateDouble(String.format("%.20f * %.20f", Double.MAX_VALUE, Double.MAX_VALUE), new Object[0])));
        ExpressionLanguageTest.assertTrue((boolean)Double.isInfinite(ExpressionLanguageTest.evaluateDouble("(1/0) * (-1/0)", new Object[0])));
        ExpressionLanguageTest.assertTrue((boolean)Double.isInfinite(ExpressionLanguageTest.evaluateDouble("(1/0) * (1/0)", new Object[0])));
    }

    public void testDivisionOperator() throws Exception {
        double[] safe_values;
        double[] values;
        for (double left : values = new double[]{0.0, 1.0, 2.0, 3.0, 100.0, 1000.0, 1.0E8, 1.0E-8, 0.1, -0.0, -1.0, -2.0, -3.0, -100.0, -1000.0, -1.0E8, -1.0E-8, -0.1}) {
            ExpressionLanguageTest.assertTrue((left == ExpressionLanguageTest.evaluateDouble(String.format("%.20f / 1.0", left), new Object[0]) ? 1 : 0) != 0);
            for (double right : values) {
                if (left == 0.0 && right == 0.0) continue;
                ExpressionLanguageTest.assertTrue((left / right == ExpressionLanguageTest.evaluateDouble(String.format("%.20f / %.20f", left, right), new Object[0]) ? 1 : 0) != 0);
            }
        }
        for (double first : safe_values = new double[]{0.0, 1.0, 2.0, -0.0, -1.0, -2.0}) {
            for (double second : safe_values) {
                for (double third : safe_values) {
                    if (first == 0.0 && (second == 0.0 || third == 0.0)) continue;
                    try {
                        ExpressionLanguageTest.assertTrue((ExpressionLanguageTest.evaluateDouble(String.format("%.20f / %.20f / %.20f", first, second, third), new Object[0]) == ExpressionLanguageTest.evaluateDouble(String.format("(%.20f / %.20f) / %.20f", first, second, third), new Object[0]) ? 1 : 0) != 0);
                    }
                    catch (AssertionFailedError e) {
                        System.out.println("failed");
                        ExpressionLanguageTest.assertTrue((ExpressionLanguageTest.evaluateDouble(String.format("%.20f / %.20f / %.20f", first, second, third), new Object[0]) == ExpressionLanguageTest.evaluateDouble(String.format("(%.20f / %.20f) / %.20f", first, second, third), new Object[0]) ? 1 : 0) != 0);
                    }
                }
            }
        }
        ExpressionLanguageTest.assertTrue((boolean)Double.isNaN(ExpressionLanguageTest.evaluateDouble("sqrt(-1) / 1.0", new Object[0])));
        ExpressionLanguageTest.assertTrue((boolean)Double.isNaN(ExpressionLanguageTest.evaluateDouble("sqrt(-1) / sqrt(-1.0)", new Object[0])));
        ExpressionLanguageTest.assertTrue((boolean)Double.isInfinite(ExpressionLanguageTest.evaluateDouble(String.format("%.20f + %.20f", Double.MAX_VALUE, Double.MAX_VALUE), new Object[0])));
        ExpressionLanguageTest.assertTrue((boolean)Double.isNaN(ExpressionLanguageTest.evaluateDouble("(1/0) / (1/0)", new Object[0])));
    }

    public void testPowOperator() throws Exception {
        double[] safe_values;
        double[] values;
        for (double left : values = new double[]{0.0, 1.0, 2.0, 3.0, 100.0, 1000.0, 1.0E8, 1.0E-8, 0.1, -0.0, -1.0, -2.0, -3.0, -100.0, -1000.0, -1.0E8, -1.0E-8, -0.1}) {
            ExpressionLanguageTest.assertTrue((left == ExpressionLanguageTest.evaluateDouble(String.format("%.20f ^ 1.0", left), new Object[0]) ? 1 : 0) != 0);
            ExpressionLanguageTest.assertTrue((1.0 == ExpressionLanguageTest.evaluateDouble(String.format("1.0 ^ %.20f", left), new Object[0]) ? 1 : 0) != 0);
            for (double right : values) {
                if (Double.isNaN(Math.pow(left, right))) continue;
                ExpressionLanguageTest.assertTrue((Math.pow(left, right) == ExpressionLanguageTest.evaluateDouble(String.format("(%.20f) ^ (%.20f)", left, right), new Object[0]) ? 1 : 0) != 0);
            }
        }
        for (double first : safe_values = new double[]{0.0, 1.0, 2.0, -0.0, -1.0, -2.0}) {
            for (double second : safe_values) {
                for (double third : safe_values) {
                    if (Double.isNaN(Math.pow(first, Math.pow(second, third)))) continue;
                    ExpressionLanguageTest.assertTrue((ExpressionLanguageTest.evaluateDouble(String.format("(%.20f) ^ (%.20f) ^ (%.20f)", first, second, third), new Object[0]) == ExpressionLanguageTest.evaluateDouble(String.format("(%.20f) ^ ((%.20f) ^ (%.20f))", first, second, third), new Object[0]) ? 1 : 0) != 0);
                }
            }
        }
        ExpressionLanguageTest.assertTrue((boolean)Double.isNaN(ExpressionLanguageTest.evaluateDouble("sqrt(-1) ^ 1.0", new Object[0])));
        ExpressionLanguageTest.assertTrue((boolean)Double.isNaN(ExpressionLanguageTest.evaluateDouble("1.0 ^ sqrt(-1)", new Object[0])));
        ExpressionLanguageTest.assertTrue((boolean)Double.isNaN(ExpressionLanguageTest.evaluateDouble("sqrt(-1) ^ sqrt(-1.0)", new Object[0])));
        ExpressionLanguageTest.assertTrue((boolean)Double.isInfinite(ExpressionLanguageTest.evaluateDouble(String.format("%.20f ^ 2", Double.MAX_VALUE), new Object[0])));
        ExpressionLanguageTest.assertTrue((boolean)Double.isNaN(ExpressionLanguageTest.evaluateDouble("1/0 ^ -1/0", new Object[0])));
        ExpressionLanguageTest.assertTrue((boolean)Double.isInfinite(ExpressionLanguageTest.evaluateDouble("1/0 + 1/0", new Object[0])));
    }

    public void testAndOperator() throws Exception {
        boolean[] values;
        for (boolean left : values = new boolean[]{true, false}) {
            for (boolean right : values) {
                ExpressionLanguageTest.assertEquals((left && right ? 1 : 0) != 0, (boolean)ExpressionLanguageTest.evaluateBoolean(left + " and " + right, new Object[0]));
                ExpressionLanguageTest.assertEquals((left && right ? 1 : 0) != 0, (boolean)ExpressionLanguageTest.evaluateBoolean(left + " & " + right, new Object[0]));
                ExpressionLanguageTest.assertEquals((boolean)ExpressionLanguageTest.evaluateBoolean(right + " and " + left, new Object[0]), (boolean)ExpressionLanguageTest.evaluateBoolean(left + " and " + right, new Object[0]));
                ExpressionLanguageTest.assertEquals((boolean)ExpressionLanguageTest.evaluateBoolean(right + " & " + left, new Object[0]), (boolean)ExpressionLanguageTest.evaluateBoolean(left + " & " + right, new Object[0]));
                for (boolean third : values) {
                    ExpressionLanguageTest.assertEquals((left && right && third ? 1 : 0) != 0, (boolean)ExpressionLanguageTest.evaluateBoolean("(" + left + " and " + right + ") and " + third, new Object[0]));
                    ExpressionLanguageTest.assertEquals((left && right && third ? 1 : 0) != 0, (boolean)ExpressionLanguageTest.evaluateBoolean("(" + left + " & " + right + ") & " + third, new Object[0]));
                    ExpressionLanguageTest.assertEquals((left && right && third ? 1 : 0) != 0, (boolean)ExpressionLanguageTest.evaluateBoolean(left + " and (" + right + " and " + third + ")", new Object[0]));
                    ExpressionLanguageTest.assertEquals((left && right && third ? 1 : 0) != 0, (boolean)ExpressionLanguageTest.evaluateBoolean(left + " & (" + right + " & " + third + ")", new Object[0]));
                    ExpressionLanguageTest.assertEquals((left && right && third ? 1 : 0) != 0, (boolean)ExpressionLanguageTest.evaluateBoolean(left + " & " + right + " and " + third, new Object[0]));
                }
            }
        }
    }

    public void testOrOperator() throws Exception {
        boolean[] values;
        for (boolean left : values = new boolean[]{true, false}) {
            for (boolean right : values) {
                ExpressionLanguageTest.assertEquals((left || right ? 1 : 0) != 0, (boolean)ExpressionLanguageTest.evaluateBoolean(left + " or " + right, new Object[0]));
                ExpressionLanguageTest.assertEquals((left || right ? 1 : 0) != 0, (boolean)ExpressionLanguageTest.evaluateBoolean(left + " | " + right, new Object[0]));
                ExpressionLanguageTest.assertEquals((boolean)ExpressionLanguageTest.evaluateBoolean(right + " or " + left, new Object[0]), (boolean)ExpressionLanguageTest.evaluateBoolean(left + " or " + right, new Object[0]));
                ExpressionLanguageTest.assertEquals((boolean)ExpressionLanguageTest.evaluateBoolean(right + " | " + left, new Object[0]), (boolean)ExpressionLanguageTest.evaluateBoolean(left + " | " + right, new Object[0]));
                for (boolean third : values) {
                    ExpressionLanguageTest.assertEquals((left || right || third ? 1 : 0) != 0, (boolean)ExpressionLanguageTest.evaluateBoolean("(" + left + " or " + right + ") or " + third, new Object[0]));
                    ExpressionLanguageTest.assertEquals((left || right || third ? 1 : 0) != 0, (boolean)ExpressionLanguageTest.evaluateBoolean("(" + left + " | " + right + ") | " + third, new Object[0]));
                    ExpressionLanguageTest.assertEquals((left || right || third ? 1 : 0) != 0, (boolean)ExpressionLanguageTest.evaluateBoolean(left + " or (" + right + " or " + third + ")", new Object[0]));
                    ExpressionLanguageTest.assertEquals((left || right || third ? 1 : 0) != 0, (boolean)ExpressionLanguageTest.evaluateBoolean(left + " | (" + right + " | " + third + ")", new Object[0]));
                    ExpressionLanguageTest.assertEquals((left || right || third ? 1 : 0) != 0, (boolean)ExpressionLanguageTest.evaluateBoolean(left + " or " + right + " | " + third, new Object[0]));
                }
            }
        }
    }

    public void testEqualsOperator() throws Exception {
        double[] values;
        for (double left : values = new double[]{0.0, 1.0, 2.0, 3.0, 100.0, 1000.0, 1.0E8, 1.0E-8, 0.1, -0.0, -1.0, -2.0, -3.0, -100.0, -1000.0, -1.0E8, -1.0E-8, -0.1}) {
            ExpressionLanguageTest.assertTrue((boolean)ExpressionLanguageTest.evaluateBoolean(String.format("%.20f = %.20f", left, left), new Object[0]));
            for (double right : values) {
                ExpressionLanguageTest.assertEquals((left == right ? 1 : 0) != 0, (boolean)ExpressionLanguageTest.evaluateBoolean(String.format("%.20f = %.20f", left, right), new Object[0]));
                ExpressionLanguageTest.assertEquals((boolean)ExpressionLanguageTest.evaluateBoolean(String.format("%.20f = %.20f", left, right), new Object[0]), (boolean)ExpressionLanguageTest.evaluateBoolean(String.format("%.20f = %.20f", right, left), new Object[0]));
            }
        }
        try {
            ExpressionLanguageTest.evaluateBoolean("1.0 == 1.0 == 1.0", new Object[0]);
            ExpressionLanguageTest.fail((String)"non-associativity!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ExpressionLanguageTest.assertTrue((boolean)ExpressionLanguageTest.evaluateBoolean("1/0 = 1/0", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("-1/0 = 1/0", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("sqrt(-1) = sqrt(-1)", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("0.0 = sqrt(-1)", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("1/0 = sqrt(-1)", new Object[0]));
    }

    public void testLtLeGtGeOperator() throws Exception {
        double[] values;
        for (double left : values = new double[]{0.0, 1.0, 2.0, 3.0, 100.0, 1000.0, 1.0E8, 1.0E-8, 0.1, -0.0, -1.0, -2.0, -3.0, -100.0, -1000.0, -1.0E8, -1.0E-8, -0.1}) {
            ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean(String.format("%.20f < %.20f", left, left), new Object[0]));
            ExpressionLanguageTest.assertTrue((boolean)ExpressionLanguageTest.evaluateBoolean(String.format("%.20f <= %.20f", left, left), new Object[0]));
            ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean(String.format("%.20f > %.20f", left, left), new Object[0]));
            ExpressionLanguageTest.assertTrue((boolean)ExpressionLanguageTest.evaluateBoolean(String.format("%.20f >= %.20f", left, left), new Object[0]));
            for (double right : values) {
                ExpressionLanguageTest.assertEquals((left < right ? 1 : 0) != 0, (boolean)ExpressionLanguageTest.evaluateBoolean(String.format("%.20f < %.20f", left, right), new Object[0]));
                ExpressionLanguageTest.assertEquals((left <= right ? 1 : 0) != 0, (boolean)ExpressionLanguageTest.evaluateBoolean(String.format("%.20f <= %.20f", left, right), new Object[0]));
                ExpressionLanguageTest.assertEquals((left > right ? 1 : 0) != 0, (boolean)ExpressionLanguageTest.evaluateBoolean(String.format("%.20f > %.20f", left, right), new Object[0]));
                ExpressionLanguageTest.assertEquals((left >= right ? 1 : 0) != 0, (boolean)ExpressionLanguageTest.evaluateBoolean(String.format("%.20f >= %.20f", left, right), new Object[0]));
            }
        }
        try {
            ExpressionLanguageTest.evaluateBoolean("1.0 < 1.0 < 1.0", new Object[0]);
            ExpressionLanguageTest.fail((String)"non-associativity!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ExpressionLanguageTest.evaluateBoolean("1.0 <= 1.0 <= 1.0", new Object[0]);
            ExpressionLanguageTest.fail((String)"non-associativity!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ExpressionLanguageTest.evaluateBoolean("1.0 > 1.0 > 1.0", new Object[0]);
            ExpressionLanguageTest.fail((String)"non-associativity!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ExpressionLanguageTest.evaluateBoolean("1.0 >= 1.0 >= 1.0", new Object[0]);
            ExpressionLanguageTest.fail((String)"non-associativity!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("1/0 < 1/0", new Object[0]));
        ExpressionLanguageTest.assertTrue((boolean)ExpressionLanguageTest.evaluateBoolean("1/0 <= 1/0", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("1/0 > 1/0", new Object[0]));
        ExpressionLanguageTest.assertTrue((boolean)ExpressionLanguageTest.evaluateBoolean("1/0 >= 1/0", new Object[0]));
        ExpressionLanguageTest.assertTrue((boolean)ExpressionLanguageTest.evaluateBoolean("-1/0 < 1/0", new Object[0]));
        ExpressionLanguageTest.assertTrue((boolean)ExpressionLanguageTest.evaluateBoolean("-1/0 <= 1/0", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("-1/0 > 1/0", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("-1/0 >= 1/0", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("sqrt(-1) < sqrt(-1)", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("sqrt(-1) <= sqrt(-1)", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("sqrt(-1) > sqrt(-1)", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("sqrt(-1) >= sqrt(-1)", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("0.0 < sqrt(-1)", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("0.0 <= sqrt(-1)", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("0.0 > sqrt(-1)", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("0.0 >= sqrt(-1)", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("1/0 < sqrt(-1)", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("1/0 <= sqrt(-1)", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("1/0 > sqrt(-1)", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("1/0 >= sqrt(-1)", new Object[0]));
    }

    public void testPrecedence() throws Exception {
        ExpressionLanguageTest.assertEquals((Object)32.0, (Object)ExpressionLanguageTest.evaluateDouble("8*2^2", new Object[0]));
        ExpressionLanguageTest.assertEquals((Object)2.0, (Object)ExpressionLanguageTest.evaluateDouble("8/2^2", new Object[0]));
        ExpressionLanguageTest.assertEquals((Object)-1.0, (Object)ExpressionLanguageTest.evaluateDouble("-1^2", new Object[0]));
        ExpressionLanguageTest.assertEquals((Object)10.0, (Object)ExpressionLanguageTest.evaluateDouble("2.0*3.0 + 4.0", new Object[0]));
        ExpressionLanguageTest.assertEquals((Object)2.0, (Object)ExpressionLanguageTest.evaluateDouble("2.0*3.0 - 4.0", new Object[0]));
        ExpressionLanguageTest.assertEquals((Object)-0.5, (Object)ExpressionLanguageTest.evaluateDouble("2.0/4.0 - 1.0", new Object[0]));
        ExpressionLanguageTest.assertEquals((Object)1.5, (Object)ExpressionLanguageTest.evaluateDouble("2.0/4.0 + 1.0", new Object[0]));
        ExpressionLanguageTest.assertEquals((Object)1.0, (Object)ExpressionLanguageTest.evaluateDouble("-1.0 + 2.0", new Object[0]));
        ExpressionLanguageTest.assertEquals((Object)-3.0, (Object)ExpressionLanguageTest.evaluateDouble("-1.0 - 2.0", new Object[0]));
        ExpressionLanguageTest.assertTrue((boolean)ExpressionLanguageTest.evaluateBoolean("1.0 + 2.0 >= 2.5", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("-2.0 - 2.0 > -2.5", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("2.0 * 2.0 <= 2.5", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("1.0 / 0.5 < 1.0", new Object[0]));
        ExpressionLanguageTest.assertTrue((boolean)ExpressionLanguageTest.evaluateBoolean("1.0 + 2.0 = 3.0", new Object[0]));
        ExpressionLanguageTest.assertTrue((boolean)ExpressionLanguageTest.evaluateBoolean("1.0 < 2.0 and true", new Object[0]));
        ExpressionLanguageTest.assertTrue((boolean)ExpressionLanguageTest.evaluateBoolean("1.0 <= 2.0 or false", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("1.0 > 2.0 and true", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("1.0 >= 2.0 or false", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("1.0 = 2.0 and true", new Object[0]));
        ExpressionLanguageTest.assertTrue((boolean)ExpressionLanguageTest.evaluateBoolean("1.0 < 2.0 & true", new Object[0]));
        ExpressionLanguageTest.assertTrue((boolean)ExpressionLanguageTest.evaluateBoolean("1.0 <= 2.0 | false", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("1.0 > 2.0 & true", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("1.0 >= 2.0 | false", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("1.0 = 2.0 & true", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("not true and false", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("not false and false", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("! true & false", new Object[0]));
        ExpressionLanguageTest.assertFalse((boolean)ExpressionLanguageTest.evaluateBoolean("! false & false", new Object[0]));
        ExpressionLanguageTest.assertTrue((boolean)ExpressionLanguageTest.evaluateBoolean("not true or true", new Object[0]));
        ExpressionLanguageTest.assertTrue((boolean)ExpressionLanguageTest.evaluateBoolean("not false or true", new Object[0]));
        ExpressionLanguageTest.assertTrue((boolean)ExpressionLanguageTest.evaluateBoolean("! true | true", new Object[0]));
        ExpressionLanguageTest.assertTrue((boolean)ExpressionLanguageTest.evaluateBoolean("! false | true", new Object[0]));
        ExpressionLanguageTest.assertTrue((boolean)ExpressionLanguageTest.evaluateBoolean("false and false or true", new Object[0]));
        ExpressionLanguageTest.assertTrue((boolean)ExpressionLanguageTest.evaluateBoolean("false and true or true", new Object[0]));
        ExpressionLanguageTest.assertTrue((boolean)ExpressionLanguageTest.evaluateBoolean("false & false | true", new Object[0]));
        ExpressionLanguageTest.assertTrue((boolean)ExpressionLanguageTest.evaluateBoolean("false & true | true", new Object[0]));
    }

    public void testCompositions() throws Exception {
        String[] booleanBinaryOperators;
        String[] binaryDoubleOperators = new String[]{"+", "-", "*", "/"};
        String[] comparisonOperators = new String[]{"=", "<", ">="};
        for (String booleanBinaryOperator : booleanBinaryOperators = new String[]{"&", "|", "and", "or"}) {
            for (String comparisonOperator : comparisonOperators) {
                for (String binaryDoubleOperator : binaryDoubleOperators) {
                    ExpressionLanguageTest.evaluateDouble(String.format("ifelse(exp(sin(A) %s B) %s C %s true, tan(A), rint(C) + 3.0) + java('java.lang.Math', 'double nextUp(double)', C^3)", binaryDoubleOperator, comparisonOperator, booleanBinaryOperator), 11.0, 43.0, 89.0);
                }
            }
        }
    }

    public void testMathFunctions() throws Exception {
        for (double v : new double[]{1.0, 2.0, 100.0, -1.0, -2.0, -100.0, 0.0}) {
            ExpressionLanguageTest.assertEquals((Object)Math.abs(v), (Object)ExpressionLanguageTest.evaluateDouble("abs(A)", v));
            ExpressionLanguageTest.assertEquals((Object)Math.log(v), (Object)ExpressionLanguageTest.evaluateDouble("log(A)", v));
            ExpressionLanguageTest.assertEquals((Object)Math.exp(v), (Object)ExpressionLanguageTest.evaluateDouble("exp(A)", v));
            ExpressionLanguageTest.assertEquals((Object)Math.sin(v), (Object)ExpressionLanguageTest.evaluateDouble("sin(A)", v));
            ExpressionLanguageTest.assertEquals((Object)Math.cos(v), (Object)ExpressionLanguageTest.evaluateDouble("cos(A)", v));
            ExpressionLanguageTest.assertEquals((Object)Math.tan(v), (Object)ExpressionLanguageTest.evaluateDouble("tan(A)", v));
            ExpressionLanguageTest.assertEquals((Object)Math.sqrt(v), (Object)ExpressionLanguageTest.evaluateDouble("sqrt(A)", v));
            ExpressionLanguageTest.assertEquals((Object)Math.floor(v), (Object)ExpressionLanguageTest.evaluateDouble("floor(A)", v));
            ExpressionLanguageTest.assertEquals((Object)Math.ceil(v), (Object)ExpressionLanguageTest.evaluateDouble("ceil(A)", v));
            ExpressionLanguageTest.assertEquals((Object)Math.rint(v), (Object)ExpressionLanguageTest.evaluateDouble("rint(A)", v));
            ExpressionLanguageTest.assertEquals((Object)Math.pow(v, v), (Object)ExpressionLanguageTest.evaluateDouble("pow(A, A)", v));
        }
    }

    public void testCallingJavaFunctions() throws Exception {
        double[] values;
        for (double value : values = new double[]{0.0, -1.0, 1.0, Double.NaN, Double.POSITIVE_INFINITY, 100.0}) {
            ExpressionLanguageTest.assertEquals((Object)Math.sqrt(value), (Object)ExpressionLanguageTest.evaluateDouble("java('java.lang.Math', 'double sqrt(double)', A)", value));
            ExpressionLanguageTest.assertEquals((String)String.valueOf(value), (String)ExpressionLanguageTest.evaluateString("java('java.lang.String', 'String valueOf(double)', A)", value));
            ExpressionLanguageTest.assertEquals((Object)ExpressionLanguageTest.badRandom(value, value * value, 1.0 / value), (Object)ExpressionLanguageTest.evaluateDouble("java('weka.core.expressionlanguage.ExpressionLanguageTest', 'double badRandom(double, double, double)', A, A^2, 1/A)", value));
        }
        ExpressionLanguageTest.assertEquals((boolean)Thread.interrupted(), (boolean)ExpressionLanguageTest.evaluateBoolean("java('java.lang.Thread', 'boolean interrupted()')", new Object[0]));
    }

    public static double badRandom(double seed1, double seed2, double seed3) {
        return new Double(Double.longBitsToDouble(Double.doubleToLongBits(seed1) ^ Double.doubleToLongBits(seed2) ^ Double.doubleToLongBits(seed3))).hashCode();
    }

    public static Test suite() {
        return new TestSuite(ExpressionLanguageTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ExpressionLanguageTest.suite());
    }
}

