/*
 * Decompiled with CFR 0.152.
 */
package weka.core.tokenizers;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.tokenizers.AbstractTokenizerTest;
import weka.core.tokenizers.CharacterNGramTokenizer;
import weka.core.tokenizers.Tokenizer;

public class CharacterNGramTokenizerTest
extends AbstractTokenizerTest {
    public CharacterNGramTokenizerTest(String name) {
        super(name);
    }

    @Override
    public Tokenizer getTokenizer() {
        return new CharacterNGramTokenizer();
    }

    public void testNumberOfGeneratedTokens() {
        String[] result;
        String s = "HOWEVER, the egg only got larger and larger, and more and more human";
        try {
            result = Tokenizer.tokenize((Tokenizer)this.m_Tokenizer, (String[])new String[]{"-min", "1", "-max", "1", s});
            CharacterNGramTokenizerTest.assertEquals((String)"number of tokens differ (1)", (int)68, (int)result.length);
        }
        catch (Exception e) {
            CharacterNGramTokenizerTest.fail((String)("Error tokenizing string '" + s + "'!"));
        }
        try {
            result = Tokenizer.tokenize((Tokenizer)this.m_Tokenizer, (String[])new String[]{"-min", "2", "-max", "2", s});
            CharacterNGramTokenizerTest.assertEquals((String)"number of tokens differ (2)", (int)67, (int)result.length);
        }
        catch (Exception e) {
            CharacterNGramTokenizerTest.fail((String)("Error tokenizing string '" + s + "'!"));
        }
        try {
            result = Tokenizer.tokenize((Tokenizer)this.m_Tokenizer, (String[])new String[]{"-min", "1", "-max", "3", s});
            CharacterNGramTokenizerTest.assertEquals((String)"number of tokens differ (3)", (int)201, (int)result.length);
        }
        catch (Exception e) {
            CharacterNGramTokenizerTest.fail((String)("Error tokenizing string '" + s + "'!"));
        }
        try {
            s = "ca";
            result = Tokenizer.tokenize((Tokenizer)this.m_Tokenizer, (String[])new String[]{"-min", "1", "-max", "3", s});
            CharacterNGramTokenizerTest.assertEquals((String)"number of tokens differ (4)", (int)3, (int)result.length);
        }
        catch (Exception e) {
            CharacterNGramTokenizerTest.fail((String)("Error tokenizing string '" + s + "'!"));
        }
    }

    public static Test suite() {
        return new TestSuite(CharacterNGramTokenizerTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)CharacterNGramTokenizerTest.suite());
    }
}

