/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.functions.Logistic;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.classifiers.functions.supportVector.SMOset;
import weka.classifiers.meta.MultiClassClassifier;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;
import weka.filters.unsupervised.attribute.Standardize;

public class SMO
extends AbstractClassifier
implements WeightedInstancesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -6585883636378691736L;
    public static final int FILTER_NORMALIZE = 0;
    public static final int FILTER_STANDARDIZE = 1;
    public static final int FILTER_NONE = 2;
    public static final Tag[] TAGS_FILTER = new Tag[]{new Tag(0, "Normalize training data"), new Tag(1, "Standardize training data"), new Tag(2, "No normalization/standardization")};
    protected BinarySMO[][] m_classifiers = null;
    protected double m_C = 1.0;
    protected double m_eps = 1.0E-12;
    protected double m_tol = 0.001;
    protected int m_filterType = 0;
    protected NominalToBinary m_NominalToBinary;
    protected Filter m_Filter = null;
    protected ReplaceMissingValues m_Missing;
    protected int m_classIndex = -1;
    protected Attribute m_classAttribute;
    protected boolean m_KernelIsLinear = false;
    protected boolean m_checksTurnedOff;
    protected static double m_Del = 4.94E-321;
    protected boolean m_fitCalibratorModels = false;
    protected Classifier m_calibrator = new Logistic();
    protected int m_numFolds = -1;
    protected int m_randomSeed = 1;
    protected Kernel m_kernel = new PolyKernel();

    public String globalInfo() {
        return "Implements John Platt's sequential minimal optimization algorithm for training a support vector classifier.\n\nThis implementation globally replaces all missing values and transforms nominal attributes into binary ones. It also normalizes all attributes by default. (In that case the coefficients in the output are based on the normalized data, not the original data --- this is important for interpreting the classifier.)\n\nMulti-class problems are solved using pairwise classification (aka 1-vs-1).\n\nTo obtain proper probability estimates, use the option that fits calibration models to the outputs of the support vector machine. In the multi-class case, the predicted probabilities are coupled using Hastie and Tibshirani's pairwise coupling method.\n\nNote: for improved speed normalization should be turned off when operating on SparseInstances.\n\nFor more information on the SMO algorithm, see\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INCOLLECTION);
        result.setValue(TechnicalInformation.Field.AUTHOR, "J. Platt");
        result.setValue(TechnicalInformation.Field.YEAR, "1998");
        result.setValue(TechnicalInformation.Field.TITLE, "Fast Training of Support Vector Machines using Sequential Minimal Optimization");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Advances in Kernel Methods - Support Vector Learning");
        result.setValue(TechnicalInformation.Field.EDITOR, "B. Schoelkopf and C. Burges and A. Smola");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "MIT Press");
        result.setValue(TechnicalInformation.Field.URL, "http://research.microsoft.com/~jplatt/smo.html");
        result.setValue(TechnicalInformation.Field.PDF, "http://research.microsoft.com/~jplatt/smo-book.pdf");
        result.setValue(TechnicalInformation.Field.PS, "http://research.microsoft.com/~jplatt/smo-book.ps.gz");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.ARTICLE);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "S.S. Keerthi and S.K. Shevade and C. Bhattacharyya and K.R.K. Murthy");
        additional.setValue(TechnicalInformation.Field.YEAR, "2001");
        additional.setValue(TechnicalInformation.Field.TITLE, "Improvements to Platt's SMO Algorithm for SVM Classifier Design");
        additional.setValue(TechnicalInformation.Field.JOURNAL, "Neural Computation");
        additional.setValue(TechnicalInformation.Field.VOLUME, "13");
        additional.setValue(TechnicalInformation.Field.NUMBER, "3");
        additional.setValue(TechnicalInformation.Field.PAGES, "637-649");
        additional.setValue(TechnicalInformation.Field.PS, "http://guppy.mpe.nus.edu.sg/~mpessk/svm/smo_mod_nc.ps.gz");
        additional = result.add(TechnicalInformation.Type.INPROCEEDINGS);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Trevor Hastie and Robert Tibshirani");
        additional.setValue(TechnicalInformation.Field.YEAR, "1998");
        additional.setValue(TechnicalInformation.Field.TITLE, "Classification by Pairwise Coupling");
        additional.setValue(TechnicalInformation.Field.BOOKTITLE, "Advances in Neural Information Processing Systems");
        additional.setValue(TechnicalInformation.Field.VOLUME, "10");
        additional.setValue(TechnicalInformation.Field.PUBLISHER, "MIT Press");
        additional.setValue(TechnicalInformation.Field.EDITOR, "Michael I. Jordan and Michael J. Kearns and Sara A. Solla");
        additional.setValue(TechnicalInformation.Field.PS, "http://www-stat.stanford.edu/~hastie/Papers/2class.ps");
        return result;
    }

    public void turnChecksOff() {
        this.m_checksTurnedOff = true;
    }

    public void turnChecksOn() {
        this.m_checksTurnedOff = false;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = this.getKernel().getCapabilities();
        result.setOwner(this);
        result.enableAllAttributeDependencies();
        if (result.handles(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        }
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.disableAllClasses();
        result.disableAllClassDependencies();
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void buildClassifier(Instances insts) throws Exception {
        int i;
        if (!this.m_checksTurnedOff) {
            this.getCapabilities().testWithFail(insts);
            insts = new Instances(insts);
            insts.deleteWithMissingClass();
            Instances data = new Instances(insts, insts.numInstances());
            for (i = 0; i < insts.numInstances(); ++i) {
                if (!(insts.instance(i).weight() > 0.0)) continue;
                data.add(insts.instance(i));
            }
            if (data.numInstances() == 0) {
                throw new Exception("No training instances left after removing instances with weight 0!");
            }
            insts = data;
        }
        if (!this.m_checksTurnedOff) {
            this.m_Missing = new ReplaceMissingValues();
            this.m_Missing.setInputFormat(insts);
            insts = Filter.useFilter(insts, this.m_Missing);
        } else {
            this.m_Missing = null;
        }
        if (this.getCapabilities().handles(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            boolean onlyNumeric = true;
            if (!this.m_checksTurnedOff) {
                for (i = 0; i < insts.numAttributes(); ++i) {
                    if (i == insts.classIndex() || insts.attribute(i).isNumeric()) continue;
                    onlyNumeric = false;
                    break;
                }
            }
            if (!onlyNumeric) {
                this.m_NominalToBinary = new NominalToBinary();
                this.m_NominalToBinary.setInputFormat(insts);
                insts = Filter.useFilter(insts, this.m_NominalToBinary);
            } else {
                this.m_NominalToBinary = null;
            }
        } else {
            this.m_NominalToBinary = null;
        }
        if (this.m_filterType == 1) {
            this.m_Filter = new Standardize();
            this.m_Filter.setInputFormat(insts);
            insts = Filter.useFilter(insts, this.m_Filter);
        } else if (this.m_filterType == 0) {
            this.m_Filter = new Normalize();
            this.m_Filter.setInputFormat(insts);
            insts = Filter.useFilter(insts, this.m_Filter);
        } else {
            this.m_Filter = null;
        }
        this.m_classIndex = insts.classIndex();
        this.m_classAttribute = insts.classAttribute();
        this.m_KernelIsLinear = this.m_kernel instanceof PolyKernel && ((PolyKernel)this.m_kernel).getExponent() == 1.0;
        Instances[] subsets = new Instances[insts.numClasses()];
        for (i = 0; i < insts.numClasses(); ++i) {
            subsets[i] = new Instances(insts, insts.numInstances());
        }
        for (int j = 0; j < insts.numInstances(); ++j) {
            Instance inst = insts.instance(j);
            subsets[(int)inst.classValue()].add(inst);
        }
        for (i = 0; i < insts.numClasses(); ++i) {
            subsets[i].compactify();
        }
        Random rand = new Random(this.m_randomSeed);
        this.m_classifiers = new BinarySMO[insts.numClasses()][insts.numClasses()];
        for (int i2 = 0; i2 < insts.numClasses(); ++i2) {
            for (int j = i2 + 1; j < insts.numClasses(); ++j) {
                int k;
                this.m_classifiers[i2][j] = new BinarySMO();
                this.m_classifiers[i2][j].setKernel(Kernel.makeCopy(this.getKernel()));
                Instances data = new Instances(insts, insts.numInstances());
                for (k = 0; k < subsets[i2].numInstances(); ++k) {
                    data.add(subsets[i2].instance(k));
                }
                for (k = 0; k < subsets[j].numInstances(); ++k) {
                    data.add(subsets[j].instance(k));
                }
                data.compactify();
                data.randomize(rand);
                this.m_classifiers[i2][j].buildClassifier(data, i2, j, this.m_fitCalibratorModels, this.m_numFolds, this.m_randomSeed);
            }
        }
    }

    @Override
    public double[] distributionForInstance(Instance inst) throws Exception {
        if (!this.m_checksTurnedOff) {
            this.m_Missing.input(inst);
            this.m_Missing.batchFinished();
            inst = this.m_Missing.output();
        }
        if (this.m_NominalToBinary != null) {
            this.m_NominalToBinary.input(inst);
            this.m_NominalToBinary.batchFinished();
            inst = this.m_NominalToBinary.output();
        }
        if (this.m_Filter != null) {
            this.m_Filter.input(inst);
            this.m_Filter.batchFinished();
            inst = this.m_Filter.output();
        }
        if (!this.m_fitCalibratorModels) {
            double[] result = new double[inst.numClasses()];
            for (int i = 0; i < inst.numClasses(); ++i) {
                for (int j = i + 1; j < inst.numClasses(); ++j) {
                    if (this.m_classifiers[i][j].m_alpha == null && this.m_classifiers[i][j].m_sparseWeights == null) continue;
                    double output = this.m_classifiers[i][j].SVMOutput(-1, inst);
                    if (output > 0.0) {
                        int n = j;
                        result[n] = result[n] + 1.0;
                        continue;
                    }
                    int n = i;
                    result[n] = result[n] + 1.0;
                }
            }
            Utils.normalize(result);
            return result;
        }
        if (inst.numClasses() == 2) {
            double[] newInst = new double[]{this.m_classifiers[0][1].SVMOutput(-1, inst), Utils.missingValue()};
            DenseInstance d = new DenseInstance(1.0, newInst);
            d.setDataset(this.m_classifiers[0][1].m_calibrationDataHeader);
            return this.m_classifiers[0][1].m_calibrator.distributionForInstance(d);
        }
        double[][] r = new double[inst.numClasses()][inst.numClasses()];
        double[][] n = new double[inst.numClasses()][inst.numClasses()];
        for (int i = 0; i < inst.numClasses(); ++i) {
            for (int j = i + 1; j < inst.numClasses(); ++j) {
                if (this.m_classifiers[i][j].m_alpha == null && this.m_classifiers[i][j].m_sparseWeights == null) continue;
                double[] newInst = new double[]{this.m_classifiers[i][j].SVMOutput(-1, inst), Utils.missingValue()};
                DenseInstance d = new DenseInstance(1.0, newInst);
                d.setDataset(this.m_classifiers[i][j].m_calibrationDataHeader);
                r[i][j] = this.m_classifiers[i][j].m_calibrator.distributionForInstance(d)[0];
                n[i][j] = this.m_classifiers[i][j].m_sumOfWeights;
            }
        }
        return MultiClassClassifier.pairwiseCoupling(n, r);
    }

    public int[] obtainVotes(Instance inst) throws Exception {
        if (!this.m_checksTurnedOff) {
            this.m_Missing.input(inst);
            this.m_Missing.batchFinished();
            inst = this.m_Missing.output();
        }
        if (this.m_NominalToBinary != null) {
            this.m_NominalToBinary.input(inst);
            this.m_NominalToBinary.batchFinished();
            inst = this.m_NominalToBinary.output();
        }
        if (this.m_Filter != null) {
            this.m_Filter.input(inst);
            this.m_Filter.batchFinished();
            inst = this.m_Filter.output();
        }
        int[] votes = new int[inst.numClasses()];
        for (int i = 0; i < inst.numClasses(); ++i) {
            for (int j = i + 1; j < inst.numClasses(); ++j) {
                double output = this.m_classifiers[i][j].SVMOutput(-1, inst);
                if (output > 0.0) {
                    int n = j;
                    votes[n] = votes[n] + 1;
                    continue;
                }
                int n = i;
                votes[n] = votes[n] + 1;
            }
        }
        return votes;
    }

    public double[][][] sparseWeights() {
        int numValues = this.m_classAttribute.numValues();
        double[][][] sparseWeights = new double[numValues][numValues][];
        for (int i = 0; i < numValues; ++i) {
            for (int j = i + 1; j < numValues; ++j) {
                sparseWeights[i][j] = this.m_classifiers[i][j].m_sparseWeights;
            }
        }
        return sparseWeights;
    }

    public int[][][] sparseIndices() {
        int numValues = this.m_classAttribute.numValues();
        int[][][] sparseIndices = new int[numValues][numValues][];
        for (int i = 0; i < numValues; ++i) {
            for (int j = i + 1; j < numValues; ++j) {
                sparseIndices[i][j] = this.m_classifiers[i][j].m_sparseIndices;
            }
        }
        return sparseIndices;
    }

    public double[][] bias() {
        int numValues = this.m_classAttribute.numValues();
        double[][] bias = new double[numValues][numValues];
        for (int i = 0; i < numValues; ++i) {
            for (int j = i + 1; j < numValues; ++j) {
                bias[i][j] = this.m_classifiers[i][j].m_b;
            }
        }
        return bias;
    }

    public int numClassAttributeValues() {
        return this.m_classAttribute.numValues();
    }

    public String[] classAttributeNames() {
        int numValues = this.m_classAttribute.numValues();
        String[] classAttributeNames = new String[numValues];
        for (int i = 0; i < numValues; ++i) {
            classAttributeNames[i] = this.m_classAttribute.value(i);
        }
        return classAttributeNames;
    }

    public String[][][] attributeNames() {
        int numValues = this.m_classAttribute.numValues();
        String[][][] attributeNames = new String[numValues][numValues][];
        for (int i = 0; i < numValues; ++i) {
            for (int j = i + 1; j < numValues; ++j) {
                int numAttributes = this.m_classifiers[i][j].m_sparseIndices.length;
                String[] attrNames = new String[numAttributes];
                for (int k = 0; k < numAttributes; ++k) {
                    attrNames[k] = this.m_classifiers[i][j].m_data.attribute(this.m_classifiers[i][j].m_sparseIndices[k]).name();
                }
                attributeNames[i][j] = attrNames;
            }
        }
        return attributeNames;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tTurns off all checks - use with caution!\n\tTurning them off assumes that data is purely numeric, doesn't\n\tcontain any missing values, and has a nominal class. Turning them\n\toff also means that no header information will be stored if the\n\tmachine is linear. Finally, it also assumes that no instance has\n\ta weight equal to 0.\n\t(default: checks on)", "no-checks", 0, "-no-checks"));
        result.addElement(new Option("\tThe complexity constant C. (default 1)", "C", 1, "-C <double>"));
        result.addElement(new Option("\tWhether to 0=normalize/1=standardize/2=neither. (default 0=normalize)", "N", 1, "-N"));
        result.addElement(new Option("\tThe tolerance parameter. (default 1.0e-3)", "L", 1, "-L <double>"));
        result.addElement(new Option("\tThe epsilon for round-off error. (default 1.0e-12)", "P", 1, "-P <double>"));
        result.addElement(new Option("\tFit calibration models to SVM outputs. ", "M", 0, "-M"));
        result.addElement(new Option("\tThe number of folds for the internal\n\tcross-validation. (default -1, use training data)", "V", 1, "-V <double>"));
        result.addElement(new Option("\tThe random number seed. (default 1)", "W", 1, "-W <double>"));
        result.addElement(new Option("\tThe Kernel to use.\n\t(default: weka.classifiers.functions.supportVector.PolyKernel)", "K", 1, "-K <classname and parameters>"));
        result.addElement(new Option("\tFull name of calibration model, followed by options.\n\t(default: \"weka.classifiers.functions.Logistic\")", "calibrator", 0, "-calibrator <scheme specification>"));
        result.addAll(Collections.list(super.listOptions()));
        result.addElement(new Option("", "", 0, "\nOptions specific to kernel " + this.getKernel().getClass().getName() + ":"));
        result.addAll(Collections.list(this.getKernel().listOptions()));
        if (this.getCalibrator() instanceof OptionHandler) {
            result.addElement(new Option("", "", 0, "\nOptions specific to calibrator " + this.getCalibrator().getClass().getName() + ":"));
            result.addAll(Collections.list(((OptionHandler)((Object)this.getCalibrator())).listOptions()));
        }
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String classifierName;
        String classifierString;
        String[] classifierSpec;
        this.setChecksTurnedOff(Utils.getFlag("no-checks", options));
        String tmpStr = Utils.getOption('C', options);
        if (tmpStr.length() != 0) {
            this.setC(Double.parseDouble(tmpStr));
        } else {
            this.setC(1.0);
        }
        tmpStr = Utils.getOption('L', options);
        if (tmpStr.length() != 0) {
            this.setToleranceParameter(Double.parseDouble(tmpStr));
        } else {
            this.setToleranceParameter(0.001);
        }
        tmpStr = Utils.getOption('P', options);
        if (tmpStr.length() != 0) {
            this.setEpsilon(Double.parseDouble(tmpStr));
        } else {
            this.setEpsilon(1.0E-12);
        }
        tmpStr = Utils.getOption('N', options);
        if (tmpStr.length() != 0) {
            this.setFilterType(new SelectedTag(Integer.parseInt(tmpStr), TAGS_FILTER));
        } else {
            this.setFilterType(new SelectedTag(0, TAGS_FILTER));
        }
        this.setBuildCalibrationModels(Utils.getFlag('M', options));
        tmpStr = Utils.getOption('V', options);
        if (tmpStr.length() != 0) {
            this.setNumFolds(Integer.parseInt(tmpStr));
        } else {
            this.setNumFolds(-1);
        }
        tmpStr = Utils.getOption('W', options);
        if (tmpStr.length() != 0) {
            this.setRandomSeed(Integer.parseInt(tmpStr));
        } else {
            this.setRandomSeed(1);
        }
        tmpStr = Utils.getOption('K', options);
        String[] tmpOptions = Utils.splitOptions(tmpStr);
        if (tmpOptions.length != 0) {
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            this.setKernel(Kernel.forName(tmpStr, tmpOptions));
        }
        if ((classifierSpec = Utils.splitOptions(classifierString = Utils.getOption("calibrator", options))).length == 0) {
            classifierName = "weka.classifiers.functions.Logistic";
        } else {
            classifierName = classifierSpec[0];
            classifierSpec[0] = "";
        }
        this.setCalibrator(AbstractClassifier.forName(classifierName, classifierSpec));
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getChecksTurnedOff()) {
            result.add("-no-checks");
        }
        result.add("-C");
        result.add("" + this.getC());
        result.add("-L");
        result.add("" + this.getToleranceParameter());
        result.add("-P");
        result.add("" + this.getEpsilon());
        result.add("-N");
        result.add("" + this.m_filterType);
        if (this.getBuildCalibrationModels()) {
            result.add("-M");
        }
        result.add("-V");
        result.add("" + this.getNumFolds());
        result.add("-W");
        result.add("" + this.getRandomSeed());
        result.add("-K");
        result.add("" + this.getKernel().getClass().getName() + " " + Utils.joinOptions(this.getKernel().getOptions()));
        result.add("-calibrator");
        result.add(this.getCalibrator().getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)this.getCalibrator())).getOptions()));
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public void setChecksTurnedOff(boolean value) {
        if (value) {
            this.turnChecksOff();
        } else {
            this.turnChecksOn();
        }
    }

    public boolean getChecksTurnedOff() {
        return this.m_checksTurnedOff;
    }

    public String checksTurnedOffTipText() {
        return "Turns time-consuming checks off - use with caution.";
    }

    public String kernelTipText() {
        return "The kernel to use.";
    }

    public void setKernel(Kernel value) {
        this.m_kernel = value;
    }

    public Kernel getKernel() {
        return this.m_kernel;
    }

    public String calibratorTipText() {
        return "The calibration method to use.";
    }

    public void setCalibrator(Classifier value) {
        this.m_calibrator = value;
    }

    public Classifier getCalibrator() {
        return this.m_calibrator;
    }

    public String cTipText() {
        return "The complexity parameter C.";
    }

    public double getC() {
        return this.m_C;
    }

    public void setC(double v) {
        this.m_C = v;
    }

    public String toleranceParameterTipText() {
        return "The tolerance parameter (shouldn't be changed).";
    }

    public double getToleranceParameter() {
        return this.m_tol;
    }

    public void setToleranceParameter(double v) {
        this.m_tol = v;
    }

    public String epsilonTipText() {
        return "The epsilon for round-off error (shouldn't be changed).";
    }

    public double getEpsilon() {
        return this.m_eps;
    }

    public void setEpsilon(double v) {
        this.m_eps = v;
    }

    public String filterTypeTipText() {
        return "Determines how/if the data will be transformed.";
    }

    public SelectedTag getFilterType() {
        return new SelectedTag(this.m_filterType, TAGS_FILTER);
    }

    public void setFilterType(SelectedTag newType) {
        if (newType.getTags() == TAGS_FILTER) {
            this.m_filterType = newType.getSelectedTag().getID();
        }
    }

    public String buildCalibrationModelsTipText() {
        return "Whether to fit calibration models to the SVM's outputs (for proper probability estimates).";
    }

    public boolean getBuildCalibrationModels() {
        return this.m_fitCalibratorModels;
    }

    public void setBuildCalibrationModels(boolean newbuildCalibrationModels) {
        this.m_fitCalibratorModels = newbuildCalibrationModels;
    }

    public String numFoldsTipText() {
        return "The number of folds for cross-validation used to generate training data for calibration models (-1 means use training data).";
    }

    public int getNumFolds() {
        return this.m_numFolds;
    }

    public void setNumFolds(int newnumFolds) {
        this.m_numFolds = newnumFolds;
    }

    public String randomSeedTipText() {
        return "Random number seed for the cross-validation.";
    }

    public int getRandomSeed() {
        return this.m_randomSeed;
    }

    public void setRandomSeed(int newrandomSeed) {
        this.m_randomSeed = newrandomSeed;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.m_classAttribute == null) {
            return "SMO: No model built yet.";
        }
        try {
            text.append("SMO\n\n");
            text.append("Kernel used:\n  " + this.m_kernel.toString() + "\n\n");
            for (int i = 0; i < this.m_classAttribute.numValues(); ++i) {
                for (int j = i + 1; j < this.m_classAttribute.numValues(); ++j) {
                    text.append("Classifier for classes: " + this.m_classAttribute.value(i) + ", " + this.m_classAttribute.value(j) + "\n\n");
                    text.append(this.m_classifiers[i][j]);
                    if (this.m_fitCalibratorModels) {
                        text.append("\n\n");
                        if (this.m_classifiers[i][j].m_calibrator == null) {
                            text.append("No calibration model has been fit.\n");
                        } else {
                            text.append("Calibration model fit to the output:\n");
                            text.append(this.m_classifiers[i][j].m_calibrator);
                        }
                    }
                    text.append("\n\n");
                }
            }
        }
        catch (Exception e) {
            return "Can't print SMO classifier.";
        }
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 12341 $");
    }

    public static void main(String[] argv) {
        SMO.runClassifier(new SMO(), argv);
    }

    public class BinarySMO
    implements Serializable {
        static final long serialVersionUID = -8246163625699362456L;
        protected double[] m_alpha;
        protected double m_b;
        protected double m_bLow;
        protected double m_bUp;
        protected int m_iLow;
        protected int m_iUp;
        protected Instances m_data;
        protected double[] m_weights;
        protected double[] m_sparseWeights;
        protected int[] m_sparseIndices;
        protected Kernel m_kernel;
        protected double[] m_class;
        protected double[] m_errors;
        protected SMOset m_I0;
        protected SMOset m_I1;
        protected SMOset m_I2;
        protected SMOset m_I3;
        protected SMOset m_I4;
        protected SMOset m_supportVectors;
        protected Classifier m_calibrator = null;
        protected Instances m_calibrationDataHeader = null;
        protected double m_sumOfWeights = 0.0;

        protected void fitCalibrator(Instances insts, int cl1, int cl2, int numFolds, Random random) throws Exception {
            ArrayList<Attribute> atts = new ArrayList<Attribute>(2);
            atts.add(new Attribute("pred"));
            ArrayList<String> attVals = new ArrayList<String>(2);
            attVals.add(insts.classAttribute().value(cl1));
            attVals.add(insts.classAttribute().value(cl2));
            atts.add(new Attribute("class", attVals));
            Instances data = new Instances("data", atts, insts.numInstances());
            data.setClassIndex(1);
            this.m_calibrationDataHeader = data;
            if (numFolds <= 0) {
                for (int j = 0; j < insts.numInstances(); ++j) {
                    Instance inst = insts.instance(j);
                    double[] vals = new double[2];
                    vals[0] = this.SVMOutput(-1, inst);
                    if (inst.classValue() == (double)cl2) {
                        vals[1] = 1.0;
                    }
                    data.add(new DenseInstance(inst.weight(), vals));
                }
            } else {
                if (numFolds > insts.numInstances()) {
                    numFolds = insts.numInstances();
                }
                insts = new Instances(insts);
                insts.randomize(random);
                insts.stratify(numFolds);
                for (int i = 0; i < numFolds; ++i) {
                    Instances train = insts.trainCV(numFolds, i, random);
                    BinarySMO smo = new BinarySMO();
                    smo.setKernel(Kernel.makeCopy(SMO.this.m_kernel));
                    smo.buildClassifier(train, cl1, cl2, false, -1, -1);
                    Instances test = insts.testCV(numFolds, i);
                    for (int j = 0; j < test.numInstances(); ++j) {
                        double[] vals = new double[2];
                        vals[0] = smo.SVMOutput(-1, test.instance(j));
                        if (test.instance(j).classValue() == (double)cl2) {
                            vals[1] = 1.0;
                        }
                        data.add(new DenseInstance(test.instance(j).weight(), vals));
                    }
                }
            }
            this.m_calibrator = AbstractClassifier.makeCopy(SMO.this.getCalibrator());
            this.m_calibrator.buildClassifier(data);
        }

        public void setKernel(Kernel value) {
            this.m_kernel = value;
        }

        public Kernel getKernel() {
            return this.m_kernel;
        }

        protected void buildClassifier(Instances insts, int cl1, int cl2, boolean fitCalibrator, int numFolds, int randomSeed) throws Exception {
            int i;
            this.m_bUp = -1.0;
            this.m_bLow = 1.0;
            this.m_b = 0.0;
            this.m_alpha = null;
            this.m_data = null;
            this.m_weights = null;
            this.m_errors = null;
            this.m_calibrator = null;
            this.m_I0 = null;
            this.m_I1 = null;
            this.m_I2 = null;
            this.m_I3 = null;
            this.m_I4 = null;
            this.m_sparseWeights = null;
            this.m_sparseIndices = null;
            this.m_sumOfWeights = insts.sumOfWeights();
            this.m_class = new double[insts.numInstances()];
            this.m_iUp = -1;
            this.m_iLow = -1;
            for (i = 0; i < this.m_class.length; ++i) {
                if ((int)insts.instance(i).classValue() == cl1) {
                    this.m_class[i] = -1.0;
                    this.m_iLow = i;
                    continue;
                }
                if ((int)insts.instance(i).classValue() == cl2) {
                    this.m_class[i] = 1.0;
                    this.m_iUp = i;
                    continue;
                }
                throw new Exception("This should never happen!");
            }
            if (this.m_iUp == -1 || this.m_iLow == -1) {
                if (this.m_iUp != -1) {
                    this.m_b = -1.0;
                } else if (this.m_iLow != -1) {
                    this.m_b = 1.0;
                } else {
                    this.m_class = null;
                    return;
                }
                if (SMO.this.m_KernelIsLinear) {
                    this.m_sparseWeights = new double[0];
                    this.m_sparseIndices = new int[0];
                    this.m_class = null;
                } else {
                    this.m_supportVectors = new SMOset(0);
                    this.m_alpha = new double[0];
                    this.m_class = new double[0];
                }
                if (fitCalibrator) {
                    this.fitCalibrator(insts, cl1, cl2, numFolds, new Random(randomSeed));
                }
                return;
            }
            this.m_data = insts;
            this.m_weights = (double[])(SMO.this.m_KernelIsLinear ? new double[this.m_data.numAttributes()] : null);
            this.m_alpha = new double[this.m_data.numInstances()];
            this.m_supportVectors = new SMOset(this.m_data.numInstances());
            this.m_I0 = new SMOset(this.m_data.numInstances());
            this.m_I1 = new SMOset(this.m_data.numInstances());
            this.m_I2 = new SMOset(this.m_data.numInstances());
            this.m_I3 = new SMOset(this.m_data.numInstances());
            this.m_I4 = new SMOset(this.m_data.numInstances());
            this.m_sparseWeights = null;
            this.m_sparseIndices = null;
            this.m_kernel.buildKernel(this.m_data);
            this.m_errors = new double[this.m_data.numInstances()];
            this.m_errors[this.m_iLow] = 1.0;
            this.m_errors[this.m_iUp] = -1.0;
            for (i = 0; i < this.m_class.length; ++i) {
                if (this.m_class[i] == 1.0) {
                    this.m_I1.insert(i);
                    continue;
                }
                this.m_I4.insert(i);
            }
            int numChanged = 0;
            boolean examineAll = true;
            while (numChanged > 0 || examineAll) {
                int i2;
                numChanged = 0;
                if (examineAll) {
                    for (i2 = 0; i2 < this.m_alpha.length; ++i2) {
                        if (!this.examineExample(i2)) continue;
                        ++numChanged;
                    }
                } else {
                    for (i2 = 0; i2 < this.m_alpha.length; ++i2) {
                        if (!(this.m_alpha[i2] > 0.0) || !(this.m_alpha[i2] < SMO.this.m_C * this.m_data.instance(i2).weight())) continue;
                        if (this.examineExample(i2)) {
                            ++numChanged;
                        }
                        if (!(this.m_bUp > this.m_bLow - 2.0 * SMO.this.m_tol)) continue;
                        numChanged = 0;
                        break;
                    }
                }
                if (examineAll) {
                    examineAll = false;
                    continue;
                }
                if (numChanged != 0) continue;
                examineAll = true;
            }
            this.m_b = (this.m_bLow + this.m_bUp) / 2.0;
            this.m_kernel.clean();
            this.m_errors = null;
            this.m_I4 = null;
            this.m_I3 = null;
            this.m_I2 = null;
            this.m_I1 = null;
            this.m_I0 = null;
            if (SMO.this.m_KernelIsLinear) {
                this.m_supportVectors = null;
                this.m_class = null;
                this.m_data = !SMO.this.m_checksTurnedOff ? new Instances(this.m_data, 0) : null;
                double[] sparseWeights = new double[this.m_weights.length];
                int[] sparseIndices = new int[this.m_weights.length];
                int counter = 0;
                for (int i3 = 0; i3 < this.m_weights.length; ++i3) {
                    if (this.m_weights[i3] == 0.0) continue;
                    sparseWeights[counter] = this.m_weights[i3];
                    sparseIndices[counter] = i3;
                    ++counter;
                }
                this.m_sparseWeights = new double[counter];
                this.m_sparseIndices = new int[counter];
                System.arraycopy(sparseWeights, 0, this.m_sparseWeights, 0, counter);
                System.arraycopy(sparseIndices, 0, this.m_sparseIndices, 0, counter);
                this.m_weights = null;
                this.m_alpha = null;
            }
            if (fitCalibrator) {
                this.fitCalibrator(insts, cl1, cl2, numFolds, new Random(randomSeed));
            }
        }

        public double SVMOutput(int index, Instance inst) throws Exception {
            double result = 0.0;
            if (SMO.this.m_KernelIsLinear) {
                if (this.m_sparseWeights == null) {
                    int n1 = inst.numValues();
                    for (int p = 0; p < n1; ++p) {
                        if (inst.index(p) == SMO.this.m_classIndex) continue;
                        result += this.m_weights[inst.index(p)] * inst.valueSparse(p);
                    }
                } else {
                    int n1 = inst.numValues();
                    int n2 = this.m_sparseWeights.length;
                    int p1 = 0;
                    int p2 = 0;
                    while (p1 < n1 && p2 < n2) {
                        int ind2;
                        int ind1 = inst.index(p1);
                        if (ind1 == (ind2 = this.m_sparseIndices[p2])) {
                            if (ind1 != SMO.this.m_classIndex) {
                                result += inst.valueSparse(p1) * this.m_sparseWeights[p2];
                            }
                            ++p1;
                            ++p2;
                            continue;
                        }
                        if (ind1 > ind2) {
                            ++p2;
                            continue;
                        }
                        ++p1;
                    }
                }
            } else {
                int i = this.m_supportVectors.getNext(-1);
                while (i != -1) {
                    result += this.m_class[i] * this.m_alpha[i] * this.m_kernel.eval(index, i, inst);
                    i = this.m_supportVectors.getNext(i);
                }
            }
            return result -= this.m_b;
        }

        public String toString() {
            StringBuffer text = new StringBuffer();
            int printed = 0;
            if (this.m_alpha == null && this.m_sparseWeights == null) {
                return "BinarySMO: No model built yet.\n";
            }
            try {
                int i;
                text.append("BinarySMO\n\n");
                if (SMO.this.m_KernelIsLinear) {
                    text.append("Machine linear: showing attribute weights, ");
                    text.append("not support vectors.\n\n");
                    for (i = 0; i < this.m_sparseWeights.length; ++i) {
                        if (this.m_sparseIndices[i] == SMO.this.m_classIndex) continue;
                        if (printed > 0) {
                            text.append(" + ");
                        } else {
                            text.append("   ");
                        }
                        text.append(Utils.doubleToString(this.m_sparseWeights[i], 12, 4) + " * ");
                        if (SMO.this.m_filterType == 1) {
                            text.append("(standardized) ");
                        } else if (SMO.this.m_filterType == 0) {
                            text.append("(normalized) ");
                        }
                        if (!SMO.this.m_checksTurnedOff) {
                            text.append(this.m_data.attribute(this.m_sparseIndices[i]).name() + "\n");
                        } else {
                            text.append("attribute with index " + this.m_sparseIndices[i] + "\n");
                        }
                        ++printed;
                    }
                } else {
                    for (i = 0; i < this.m_alpha.length; ++i) {
                        if (!this.m_supportVectors.contains(i)) continue;
                        double val = this.m_alpha[i];
                        if (this.m_class[i] == 1.0) {
                            if (printed > 0) {
                                text.append(" + ");
                            }
                        } else {
                            text.append(" - ");
                        }
                        text.append(Utils.doubleToString(val, 12, 4) + " * <");
                        for (int j = 0; j < this.m_data.numAttributes(); ++j) {
                            if (j != this.m_data.classIndex()) {
                                text.append(this.m_data.instance(i).toString(j));
                            }
                            if (j == this.m_data.numAttributes() - 1) continue;
                            text.append(" ");
                        }
                        text.append("> * X]\n");
                        ++printed;
                    }
                }
                if (this.m_b > 0.0) {
                    text.append(" - " + Utils.doubleToString(this.m_b, 12, 4));
                } else {
                    text.append(" + " + Utils.doubleToString(-this.m_b, 12, 4));
                }
                if (!SMO.this.m_KernelIsLinear) {
                    text.append("\n\nNumber of support vectors: " + this.m_supportVectors.numElements());
                }
                int numEval = 0;
                int numCacheHits = -1;
                if (this.m_kernel != null) {
                    numEval = this.m_kernel.numEvals();
                    numCacheHits = this.m_kernel.numCacheHits();
                }
                text.append("\n\nNumber of kernel evaluations: " + numEval);
                if (numCacheHits >= 0 && numEval > 0) {
                    double hitRatio = 1.0 - (double)numEval * 1.0 / (double)(numCacheHits + numEval);
                    text.append(" (" + Utils.doubleToString(hitRatio * 100.0, 7, 3).trim() + "% cached)");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return "Can't print BinarySMO classifier.";
            }
            return text.toString();
        }

        protected boolean examineExample(int i2) throws Exception {
            double F2;
            int i1 = -1;
            double y2 = this.m_class[i2];
            if (this.m_I0.contains(i2)) {
                F2 = this.m_errors[i2];
            } else {
                this.m_errors[i2] = F2 = this.SVMOutput(i2, this.m_data.instance(i2)) + this.m_b - y2;
                if ((this.m_I1.contains(i2) || this.m_I2.contains(i2)) && F2 < this.m_bUp) {
                    this.m_bUp = F2;
                    this.m_iUp = i2;
                } else if ((this.m_I3.contains(i2) || this.m_I4.contains(i2)) && F2 > this.m_bLow) {
                    this.m_bLow = F2;
                    this.m_iLow = i2;
                }
            }
            boolean optimal = true;
            if ((this.m_I0.contains(i2) || this.m_I1.contains(i2) || this.m_I2.contains(i2)) && this.m_bLow - F2 > 2.0 * SMO.this.m_tol) {
                optimal = false;
                i1 = this.m_iLow;
            }
            if ((this.m_I0.contains(i2) || this.m_I3.contains(i2) || this.m_I4.contains(i2)) && F2 - this.m_bUp > 2.0 * SMO.this.m_tol) {
                optimal = false;
                i1 = this.m_iUp;
            }
            if (optimal) {
                return false;
            }
            if (this.m_I0.contains(i2)) {
                i1 = this.m_bLow - F2 > F2 - this.m_bUp ? this.m_iLow : this.m_iUp;
            }
            if (i1 == -1) {
                throw new Exception("This should never happen!");
            }
            return this.takeStep(i1, i2, F2);
        }

        protected boolean takeStep(int i1, int i2, double F2) throws Exception {
            double a2;
            double k22;
            double H;
            double L;
            double C1 = SMO.this.m_C * this.m_data.instance(i1).weight();
            double C2 = SMO.this.m_C * this.m_data.instance(i2).weight();
            if (i1 == i2) {
                return false;
            }
            double alph1 = this.m_alpha[i1];
            double alph2 = this.m_alpha[i2];
            double y1 = this.m_class[i1];
            double y2 = this.m_class[i2];
            double F1 = this.m_errors[i1];
            double s = y1 * y2;
            if (y1 != y2) {
                L = Math.max(0.0, alph2 - alph1);
                H = Math.min(C2, C1 + alph2 - alph1);
            } else {
                L = Math.max(0.0, alph1 + alph2 - C1);
                H = Math.min(C2, alph1 + alph2);
            }
            if (L >= H) {
                return false;
            }
            double k11 = this.m_kernel.eval(i1, i1, this.m_data.instance(i1));
            double k12 = this.m_kernel.eval(i1, i2, this.m_data.instance(i1));
            double eta = 2.0 * k12 - k11 - (k22 = this.m_kernel.eval(i2, i2, this.m_data.instance(i2)));
            if (eta < 0.0) {
                a2 = alph2 - y2 * (F1 - F2) / eta;
                if (a2 < L) {
                    a2 = L;
                } else if (a2 > H) {
                    a2 = H;
                }
            } else {
                double Hobj;
                double f2;
                double v2;
                double gamma = alph1 + s * alph2;
                double f1 = this.SVMOutput(i1, this.m_data.instance(i1));
                double v1 = f1 + this.m_b - y1 * alph1 * k11 - y2 * alph2 * k12;
                double Lobj = gamma - s * L + L - 0.5 * k11 * (gamma - s * L) * (gamma - s * L) - 0.5 * k22 * L * L - s * k12 * (gamma - s * L) * L - y1 * (gamma - s * L) * v1 - y2 * L * (v2 = (f2 = this.SVMOutput(i2, this.m_data.instance(i2))) + this.m_b - y1 * alph1 * k12 - y2 * alph2 * k22);
                a2 = Lobj > (Hobj = gamma - s * H + H - 0.5 * k11 * (gamma - s * H) * (gamma - s * H) - 0.5 * k22 * H * H - s * k12 * (gamma - s * H) * H - y1 * (gamma - s * H) * v1 - y2 * H * v2) + SMO.this.m_eps ? L : (Lobj < Hobj - SMO.this.m_eps ? H : alph2);
            }
            if (Math.abs(a2 - alph2) < SMO.this.m_eps * (a2 + alph2 + SMO.this.m_eps)) {
                return false;
            }
            if (a2 > C2 - m_Del * C2) {
                a2 = C2;
            } else if (a2 <= m_Del * C2) {
                a2 = 0.0;
            }
            double a1 = alph1 + s * (alph2 - a2);
            if (a1 > C1 - m_Del * C1) {
                a1 = C1;
            } else if (a1 <= m_Del * C1) {
                a1 = 0.0;
            }
            if (a1 > 0.0) {
                this.m_supportVectors.insert(i1);
            } else {
                this.m_supportVectors.delete(i1);
            }
            if (a1 > 0.0 && a1 < C1) {
                this.m_I0.insert(i1);
            } else {
                this.m_I0.delete(i1);
            }
            if (y1 == 1.0 && a1 == 0.0) {
                this.m_I1.insert(i1);
            } else {
                this.m_I1.delete(i1);
            }
            if (y1 == -1.0 && a1 == C1) {
                this.m_I2.insert(i1);
            } else {
                this.m_I2.delete(i1);
            }
            if (y1 == 1.0 && a1 == C1) {
                this.m_I3.insert(i1);
            } else {
                this.m_I3.delete(i1);
            }
            if (y1 == -1.0 && a1 == 0.0) {
                this.m_I4.insert(i1);
            } else {
                this.m_I4.delete(i1);
            }
            if (a2 > 0.0) {
                this.m_supportVectors.insert(i2);
            } else {
                this.m_supportVectors.delete(i2);
            }
            if (a2 > 0.0 && a2 < C2) {
                this.m_I0.insert(i2);
            } else {
                this.m_I0.delete(i2);
            }
            if (y2 == 1.0 && a2 == 0.0) {
                this.m_I1.insert(i2);
            } else {
                this.m_I1.delete(i2);
            }
            if (y2 == -1.0 && a2 == C2) {
                this.m_I2.insert(i2);
            } else {
                this.m_I2.delete(i2);
            }
            if (y2 == 1.0 && a2 == C2) {
                this.m_I3.insert(i2);
            } else {
                this.m_I3.delete(i2);
            }
            if (y2 == -1.0 && a2 == 0.0) {
                this.m_I4.insert(i2);
            } else {
                this.m_I4.delete(i2);
            }
            if (SMO.this.m_KernelIsLinear) {
                Instance inst1 = this.m_data.instance(i1);
                for (int p1 = 0; p1 < inst1.numValues(); ++p1) {
                    if (inst1.index(p1) == this.m_data.classIndex()) continue;
                    int n = inst1.index(p1);
                    this.m_weights[n] = this.m_weights[n] + y1 * (a1 - alph1) * inst1.valueSparse(p1);
                }
                Instance inst2 = this.m_data.instance(i2);
                for (int p2 = 0; p2 < inst2.numValues(); ++p2) {
                    if (inst2.index(p2) == this.m_data.classIndex()) continue;
                    int n = inst2.index(p2);
                    this.m_weights[n] = this.m_weights[n] + y2 * (a2 - alph2) * inst2.valueSparse(p2);
                }
            }
            int j = this.m_I0.getNext(-1);
            while (j != -1) {
                if (j != i1 && j != i2) {
                    int n = j;
                    this.m_errors[n] = this.m_errors[n] + (y1 * (a1 - alph1) * this.m_kernel.eval(i1, j, this.m_data.instance(i1)) + y2 * (a2 - alph2) * this.m_kernel.eval(i2, j, this.m_data.instance(i2)));
                }
                j = this.m_I0.getNext(j);
            }
            int n = i1;
            this.m_errors[n] = this.m_errors[n] + (y1 * (a1 - alph1) * k11 + y2 * (a2 - alph2) * k12);
            int n2 = i2;
            this.m_errors[n2] = this.m_errors[n2] + (y1 * (a1 - alph1) * k12 + y2 * (a2 - alph2) * k22);
            this.m_alpha[i1] = a1;
            this.m_alpha[i2] = a2;
            this.m_bLow = -1.7976931348623157E308;
            this.m_bUp = Double.MAX_VALUE;
            this.m_iLow = -1;
            this.m_iUp = -1;
            j = this.m_I0.getNext(-1);
            while (j != -1) {
                if (this.m_errors[j] < this.m_bUp) {
                    this.m_bUp = this.m_errors[j];
                    this.m_iUp = j;
                }
                if (this.m_errors[j] > this.m_bLow) {
                    this.m_bLow = this.m_errors[j];
                    this.m_iLow = j;
                }
                j = this.m_I0.getNext(j);
            }
            if (!this.m_I0.contains(i1)) {
                if (this.m_I3.contains(i1) || this.m_I4.contains(i1)) {
                    if (this.m_errors[i1] > this.m_bLow) {
                        this.m_bLow = this.m_errors[i1];
                        this.m_iLow = i1;
                    }
                } else if (this.m_errors[i1] < this.m_bUp) {
                    this.m_bUp = this.m_errors[i1];
                    this.m_iUp = i1;
                }
            }
            if (!this.m_I0.contains(i2)) {
                if (this.m_I3.contains(i2) || this.m_I4.contains(i2)) {
                    if (this.m_errors[i2] > this.m_bLow) {
                        this.m_bLow = this.m_errors[i2];
                        this.m_iLow = i2;
                    }
                } else if (this.m_errors[i2] < this.m_bUp) {
                    this.m_bUp = this.m_errors[i2];
                    this.m_iUp = i2;
                }
            }
            if (this.m_iLow == -1 || this.m_iUp == -1) {
                throw new Exception("This should never happen!");
            }
            return true;
        }

        protected void checkClassifier() throws Exception {
            int i;
            double sum = 0.0;
            for (i = 0; i < this.m_alpha.length; ++i) {
                if (!(this.m_alpha[i] > 0.0)) continue;
                sum += this.m_class[i] * this.m_alpha[i];
            }
            System.err.println("Sum of y(i) * alpha(i): " + sum);
            for (i = 0; i < this.m_alpha.length; ++i) {
                double output = this.SVMOutput(i, this.m_data.instance(i));
                if (Utils.eq(this.m_alpha[i], 0.0) && Utils.sm(this.m_class[i] * output, 1.0)) {
                    System.err.println("KKT condition 1 violated: " + this.m_class[i] * output);
                }
                if (Utils.gr(this.m_alpha[i], 0.0) && Utils.sm(this.m_alpha[i], SMO.this.m_C * this.m_data.instance(i).weight()) && !Utils.eq(this.m_class[i] * output, 1.0)) {
                    System.err.println("KKT condition 2 violated: " + this.m_class[i] * output);
                }
                if (!Utils.eq(this.m_alpha[i], SMO.this.m_C * this.m_data.instance(i).weight()) || !Utils.gr(this.m_class[i] * output, 1.0)) continue;
                System.err.println("KKT condition 3 violated: " + this.m_class[i] * output);
            }
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 12341 $");
        }
    }
}

