/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import weka.core.Settings;
import weka.gui.GUIApplication;
import weka.gui.PerspectiveManager;
import weka.knowledgeflow.LogHandler;

public abstract class AbstractGUIApplication
extends JPanel
implements GUIApplication {
    private static final long serialVersionUID = -2116770422043462730L;
    protected PerspectiveManager m_perspectiveManager;
    protected Settings m_applicationSettings;

    public AbstractGUIApplication() {
        this(true, new String[0]);
    }

    public AbstractGUIApplication(boolean layoutComponent, String[] allowedPerspectiveClassPrefixes, String[] disallowedPerspectiveClassPrefixes) {
        this.m_perspectiveManager = new PerspectiveManager((GUIApplication)this, allowedPerspectiveClassPrefixes, disallowedPerspectiveClassPrefixes);
        this.m_perspectiveManager.setMainApplicationForAllPerspectives();
        if (layoutComponent) {
            this.setLayout(new BorderLayout());
            this.add((Component)this.m_perspectiveManager, "Center");
            if (this.m_perspectiveManager.perspectiveToolBarIsVisible()) {
                this.add((Component)this.m_perspectiveManager.getPerspectiveToolBar(), "North");
            }
        }
    }

    public AbstractGUIApplication(boolean layoutComponent, String ... allowedPerspectiveClassPrefixes) {
        this(layoutComponent, allowedPerspectiveClassPrefixes, new String[0]);
    }

    @Override
    public PerspectiveManager getPerspectiveManager() {
        return this.m_perspectiveManager;
    }

    @Override
    public Settings getApplicationSettings() {
        if (this.m_applicationSettings == null) {
            this.m_applicationSettings = new Settings("weka", this.getApplicationID());
            this.m_applicationSettings.applyDefaults(this.getApplicationDefaults());
        }
        return this.m_applicationSettings;
    }

    @Override
    public boolean isPerspectivesToolBarVisible() {
        return this.m_perspectiveManager.perspectiveToolBarIsVisible();
    }

    @Override
    public void hidePerspectivesToolBar() {
        if (this.isPerspectivesToolBarVisible()) {
            this.m_perspectiveManager.setPerspectiveToolBarIsVisible(false);
            this.remove(this.m_perspectiveManager.getPerspectiveToolBar());
        }
    }

    @Override
    public void showPerspectivesToolBar() {
        if (!this.isPerspectivesToolBarVisible()) {
            this.m_perspectiveManager.setPerspectiveToolBarIsVisible(true);
            this.add((Component)this.m_perspectiveManager.getPerspectiveToolBar(), "North");
        }
    }

    @Override
    public void settingsChanged() {
    }

    @Override
    public void showMenuBar(JFrame topLevelAncestor) {
        this.m_perspectiveManager.showMenuBar(topLevelAncestor);
    }

    @Override
    public void showErrorDialog(Exception cause) {
        String stackTrace = LogHandler.stackTraceToString(cause);
        Object[] options = null;
        options = stackTrace != null && stackTrace.length() > 0 ? new Object[]{"OK", "Show error"} : new Object[]{"OK"};
        int result = JOptionPane.showOptionDialog(this, "An error has occurred: " + cause.getMessage(), this.getApplicationName(), 0, 0, null, options, options[0]);
        if (result == 1) {
            JTextArea jt = new JTextArea(stackTrace, 10, 40);
            JOptionPane.showMessageDialog(this, new JScrollPane(jt), this.getApplicationName(), 0);
        }
    }

    @Override
    public void showInfoDialog(Object information, String title, boolean isWarning) {
        JOptionPane.showMessageDialog(this, information, title, isWarning ? 2 : 1);
    }

    @Override
    public void revalidate() {
        if (this.getTopLevelAncestor() != null) {
            this.getTopLevelAncestor().revalidate();
            this.getTopLevelAncestor().repaint();
        } else {
            super.revalidate();
        }
        this.repaint();
    }
}

