/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JFrame;
import weka.core.Capabilities;
import weka.core.Defaults;
import weka.core.Environment;
import weka.core.Memory;
import weka.core.Settings;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ConverterUtils;
import weka.gui.AbstractGUIApplication;
import weka.gui.GenericObjectEditor;
import weka.gui.LookAndFeel;
import weka.gui.Perspective;
import weka.gui.WorkbenchDefaults;
import weka.gui.explorer.Explorer;
import weka.gui.explorer.PreprocessPanel;
import weka.gui.knowledgeflow.AttributeSummaryPerspective;
import weka.gui.knowledgeflow.SQLViewerPerspective;
import weka.gui.knowledgeflow.ScatterPlotMatrixPerspective;

public class WorkbenchApp
extends AbstractGUIApplication {
    private static final long serialVersionUID = -2357486011273897728L;
    protected static Memory m_Memory = new Memory(true);
    protected static WorkbenchApp m_workbench;
    protected PreprocessPanel m_mainPerspective;
    protected Settings m_workbenchSettings;

    public WorkbenchApp() {
        super(true, new String[0], new String[]{AttributeSummaryPerspective.class.getCanonicalName(), ScatterPlotMatrixPerspective.class.getCanonicalName(), SQLViewerPerspective.class.getCanonicalName()});
        this.m_perspectiveManager.addSettingsMenuItemToProgramMenu(this.getApplicationSettings());
        this.showPerspectivesToolBar();
        List<Perspective> perspectives = this.m_perspectiveManager.getLoadedPerspectives();
        for (Perspective p : perspectives) {
            this.m_perspectiveManager.setEnablePerspectiveTab(p.getPerspectiveID(), p.okToBeActive());
        }
    }

    @Override
    public String getApplicationName() {
        return "Workbench";
    }

    @Override
    public String getApplicationID() {
        return "workbench";
    }

    @Override
    public Perspective getMainPerspective() {
        if (this.m_mainPerspective == null) {
            this.m_mainPerspective = new PreprocessPanel();
        }
        return this.m_mainPerspective;
    }

    @Override
    public void settingsChanged() {
        GenericObjectEditor.setShowGlobalInfoToolTips(this.getApplicationSettings().getSetting("workbench", WorkbenchDefaults.SHOW_JTREE_TIP_TEXT_KEY, Boolean.valueOf(true), Environment.getSystemWide()));
    }

    public void notifyCapabilitiesFilterListeners(Capabilities filter) {
        for (Perspective p : this.getPerspectiveManager().getVisiblePerspectives()) {
            if (!(p instanceof Explorer.CapabilitiesFilterChangeListener)) continue;
            ((Explorer.CapabilitiesFilterChangeListener)((Object)p)).capabilitiesFilterChanged(new Explorer.CapabilitiesFilterChangeEvent(this, filter));
        }
    }

    @Override
    public Defaults getApplicationDefaults() {
        return new WorkbenchDefaults();
    }

    public static void main(String[] args) {
        try {
            LookAndFeel.setLookAndFeel("workbench", "workbench.lookAndFeel");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        GenericObjectEditor.determineClasses();
        try {
            if (System.getProperty("os.name").contains("Mac")) {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
            }
            m_workbench = new WorkbenchApp();
            final JFrame jf = new JFrame("Weka " + m_workbench.getApplicationName());
            jf.getContentPane().setLayout(new BorderLayout());
            Image icon = Toolkit.getDefaultToolkit().getImage(WorkbenchApp.class.getClassLoader().getResource("weka/gui/weka_icon_new_48.png"));
            jf.setIconImage(icon);
            jf.getContentPane().add((Component)m_workbench, "Center");
            jf.setDefaultCloseOperation(3);
            jf.pack();
            m_workbench.showMenuBar(jf);
            jf.setSize(1024, 768);
            jf.setVisible(true);
            if (args.length == 1) {
                System.err.println("Loading instances from " + args[0]);
                AbstractFileLoader loader = ConverterUtils.getLoaderForFile(args[0]);
                loader.setFile(new File(args[0]));
                m_workbench.getPerspectiveManager().getMainPerspective().setInstances(loader.getDataSet());
            }
            Thread memMonitor = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        if (!m_Memory.isOutOfMemory()) {
                            continue;
                        }
                        jf.dispose();
                        m_workbench = null;
                        System.gc();
                        System.err.println("\ndisplayed message:");
                        m_Memory.showOutOfMemory();
                        System.err.println("\nexiting");
                        System.exit(-1);
                    }
                }
            };
            memMonitor.setPriority(10);
            memMonitor.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

