/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow.steps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.core.WekaException;
import weka.gui.ResultHistoryPanel;
import weka.gui.knowledgeflow.BaseInteractiveViewer;
import weka.knowledgeflow.steps.ImageViewer;

public class ImageViewerInteractiveView
extends BaseInteractiveViewer {
    private static final long serialVersionUID = -6652203133445653870L;
    protected JButton m_clearButton = new JButton("Clear results");
    protected ResultHistoryPanel m_history;
    protected ImageDisplayer m_plotter;

    @Override
    public String getViewerName() {
        return "Image Viewer";
    }

    @Override
    public void init() throws WekaException {
        this.addButton(this.m_clearButton);
        this.m_plotter = new ImageDisplayer();
        this.m_plotter.setMinimumSize(new Dimension(810, 610));
        this.m_plotter.setPreferredSize(new Dimension(810, 610));
        this.m_history = new ResultHistoryPanel(null);
        this.m_history.setBorder(BorderFactory.createTitledBorder("Image list"));
        this.m_history.setHandleRightClicks(false);
        this.m_history.getList().addMouseListener(new ResultHistoryPanel.RMouseAdapter(){
            private static final long serialVersionUID = -4984130887963944249L;

            @Override
            public void mouseClicked(MouseEvent e) {
                String name;
                Object pic;
                int index = ImageViewerInteractiveView.this.m_history.getList().locationToIndex(e.getPoint());
                if (index != -1 && (pic = ImageViewerInteractiveView.this.m_history.getNamedObject(name = ImageViewerInteractiveView.this.m_history.getNameAtIndex(index))) instanceof BufferedImage) {
                    ImageViewerInteractiveView.this.m_plotter.setImage((BufferedImage)pic);
                    ImageViewerInteractiveView.this.m_plotter.repaint();
                }
            }
        });
        this.m_history.getList().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ListSelectionModel lm = (ListSelectionModel)e.getSource();
                    for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                        String name;
                        Object pic;
                        if (!lm.isSelectedIndex(i)) continue;
                        if (i == -1 || (pic = ImageViewerInteractiveView.this.m_history.getNamedObject(name = ImageViewerInteractiveView.this.m_history.getNameAtIndex(i))) == null || !(pic instanceof BufferedImage)) break;
                        ImageViewerInteractiveView.this.m_plotter.setImage((BufferedImage)pic);
                        ImageViewerInteractiveView.this.m_plotter.repaint();
                        break;
                    }
                }
            }
        });
        MainPanel mainPanel = new MainPanel(this.m_history, this.m_plotter);
        this.add((Component)mainPanel, "Center");
        boolean first = true;
        for (Map.Entry<String, BufferedImage> e : ((ImageViewer)this.getStep()).getImages().entrySet()) {
            this.m_history.addResult(e.getKey(), new StringBuffer());
            this.m_history.addObject(e.getKey(), e.getValue());
            if (!first) continue;
            this.m_plotter.setImage(e.getValue());
            this.m_plotter.repaint();
            first = false;
        }
        this.m_clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageViewerInteractiveView.this.m_history.clearResults();
                ((ImageViewer)ImageViewerInteractiveView.this.getStep()).getImages().clear();
                ImageViewerInteractiveView.this.m_plotter.setImage(null);
                ImageViewerInteractiveView.this.m_plotter.repaint();
            }
        });
    }

    protected static class ImageDisplayer
    extends JPanel {
        private static final long serialVersionUID = 4161957589912537357L;
        private BufferedImage m_image;
        private int m_imageZoom = 100;

        protected ImageDisplayer() {
        }

        public void setImage(BufferedImage image) {
            this.m_image = image;
        }

        public void setZoom(int zoom) {
            this.m_imageZoom = zoom;
        }

        public int getZoom() {
            return this.m_imageZoom;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.m_image != null) {
                double lz = (double)this.m_imageZoom / 100.0;
                ((Graphics2D)g).scale(lz, lz);
                int plotWidth = this.m_image.getWidth();
                int plotHeight = this.m_image.getHeight();
                int ourWidth = this.getWidth();
                int ourHeight = this.getHeight();
                int x = 0;
                int y = 0;
                if (plotWidth < ourWidth) {
                    x = (ourWidth - plotWidth) / 2;
                }
                if (plotHeight < ourHeight) {
                    y = (ourHeight - plotHeight) / 2;
                }
                g.drawImage(this.m_image, x, y, this);
                this.setPreferredSize(new Dimension(plotWidth, plotHeight));
                this.revalidate();
            }
        }
    }

    protected static class MainPanel
    extends JPanel {
        private static final long serialVersionUID = 5648976848887609072L;

        private static Image loadImage(String path) {
            Image pic = null;
            URL imageURL = ImageViewer.class.getClassLoader().getResource(path);
            if (imageURL != null) {
                pic = Toolkit.getDefaultToolkit().getImage(imageURL);
            }
            return pic;
        }

        public MainPanel(ResultHistoryPanel p, final ImageDisplayer id) {
            this.setLayout(new BorderLayout());
            JPanel topP = new JPanel();
            topP.setLayout(new BorderLayout());
            JPanel holder = new JPanel();
            holder.setLayout(new BorderLayout());
            holder.setBorder(BorderFactory.createTitledBorder("Image"));
            JToolBar tools = new JToolBar();
            tools.setOrientation(0);
            JButton zoomInB = new JButton(new ImageIcon(MainPanel.loadImage("weka/gui/knowledgeflow/icons/zoom_in.png")));
            zoomInB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int z = id.getZoom();
                    if ((z += 25) >= 200) {
                        z = 200;
                    }
                    id.setZoom(z);
                    id.repaint();
                }
            });
            JButton zoomOutB = new JButton(new ImageIcon(MainPanel.loadImage("weka/gui/knowledgeflow/icons/zoom_out.png")));
            zoomOutB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int z = id.getZoom();
                    if ((z -= 25) <= 50) {
                        z = 50;
                    }
                    id.setZoom(z);
                    id.repaint();
                }
            });
            tools.add(zoomInB);
            tools.add(zoomOutB);
            holder.add((Component)tools, "North");
            JScrollPane js = new JScrollPane(id);
            holder.add((Component)js, "Center");
            JSplitPane p2 = new JSplitPane(1, p, holder);
            topP.add((Component)p2, "Center");
            this.add((Component)topP, "Center");
        }
    }
}

