/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import weka.clusterers.AbstractClusterer;
import weka.core.Drawable;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.OptionMetadata;
import weka.core.Utils;
import weka.core.WekaException;
import weka.gui.FilePropertyMetadata;
import weka.gui.ProgrammaticProperty;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.KFStep;
import weka.knowledgeflow.steps.PairedDataHelper;
import weka.knowledgeflow.steps.WekaAlgorithmWrapper;

@KFStep(name="Clusterer", category="Clusterers", toolTipText="Weka clusterer wrapper", iconPath="", resourceIntensive=true)
public class Clusterer
extends WekaAlgorithmWrapper
implements PairedDataHelper.PairedProcessor<weka.clusterers.Clusterer> {
    private static final long serialVersionUID = 3275754421525338036L;
    protected weka.clusterers.Clusterer m_clustererTemplate;
    protected weka.clusterers.Clusterer m_trainedClusterer;
    protected Instances m_trainedClustererHeader;
    protected transient PairedDataHelper<weka.clusterers.Clusterer> m_trainTestHelper;
    protected File m_loadModelFileName = new File("");
    protected boolean m_isReset;
    protected Data m_incrementalData;
    protected boolean m_streaming;

    public weka.clusterers.Clusterer getClusterer() {
        return (weka.clusterers.Clusterer)this.getWrappedAlgorithm();
    }

    @ProgrammaticProperty
    public void setClusterer(weka.clusterers.Clusterer clusterer) {
        this.setWrappedAlgorithm(clusterer);
    }

    public File getLoadClustererFileName() {
        return this.m_loadModelFileName;
    }

    @OptionMetadata(displayName="Clusterer model to load", description="Optional path to a clusterer to load at execution time (only applies when using testSet connections)")
    @FilePropertyMetadata(fileChooserDialogType=0, directoriesOnly=false)
    public void setLoadClustererFileName(File filename) {
        this.m_loadModelFileName = filename;
    }

    @Override
    public Class getWrappedAlgorithmClass() {
        return weka.clusterers.Clusterer.class;
    }

    @Override
    public void setWrappedAlgorithm(Object algo) {
        super.setWrappedAlgorithm(algo);
        this.m_defaultIconPath = "weka/gui/knowledgeflow/icons/DefaultClusterer.gif";
    }

    @Override
    public void stepInit() throws WekaException {
        if (!(this.getWrappedAlgorithm() instanceof weka.clusterers.Clusterer)) {
            throw new WekaException("Incorrect type of algorithm");
        }
        try {
            this.m_clustererTemplate = AbstractClusterer.makeCopy((weka.clusterers.Clusterer)this.getWrappedAlgorithm());
            if (this.m_clustererTemplate instanceof EnvironmentHandler) {
                ((EnvironmentHandler)((Object)this.m_clustererTemplate)).setEnvironment(this.getStepManager().getExecutionEnvironment().getEnvironmentVariables());
            }
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
        if (this.getStepManager().numIncomingConnectionsOfType("trainingSet") > 0) {
            this.m_trainTestHelper = new PairedDataHelper(this, this, "trainingSet", this.getStepManager().numIncomingConnectionsOfType("testSet") > 0 ? "testSet" : null);
        }
        this.m_isReset = true;
        this.m_streaming = false;
        this.m_incrementalData = new Data("incrementalClusterer");
        if (this.getLoadClustererFileName() != null && this.getLoadClustererFileName().toString().length() > 0 && this.getStepManager().numIncomingConnectionsOfType("trainingSet") == 0) {
            String resolvedFileName = this.getStepManager().environmentSubstitute(this.getLoadClustererFileName().toString());
            try {
                this.loadModel(resolvedFileName);
            }
            catch (Exception ex) {
                throw new WekaException(ex);
            }
        }
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        try {
            if (this.m_isReset) {
                this.m_isReset = false;
                this.getStepManager().processing();
                Instances incomingStructure = null;
                incomingStructure = data.getConnectionName().equals("instance") ? ((Instance)data.getPayloadElement("instance")).dataset() : (Instances)data.getPayloadElement(data.getConnectionName());
                if (data.getConnectionName().equals("instance")) {
                    this.m_streaming = true;
                    if (this.m_trainedClusterer == null) {
                        this.m_trainedClusterer = AbstractClusterer.makeCopy(this.m_clustererTemplate);
                        if (this.m_trainedClusterer instanceof EnvironmentHandler) {
                            ((EnvironmentHandler)((Object)this.m_trainedClusterer)).setEnvironment(this.getStepManager().getExecutionEnvironment().getEnvironmentVariables());
                        }
                    }
                } else if (data.getConnectionName().equals("trainingSet")) {
                    this.m_trainedClustererHeader = incomingStructure;
                }
                if (this.m_trainedClustererHeader != null && !incomingStructure.equalHeaders(this.m_trainedClustererHeader)) {
                    throw new WekaException("Structure of incoming data does not match that of the trained clusterer");
                }
            }
            if (!this.m_streaming) {
                if (this.m_trainTestHelper != null) {
                    this.m_trainTestHelper.process(data);
                } else {
                    this.processOnlyTestSet(data);
                }
            }
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
    }

    protected void processOnlyTestSet(Data data) throws WekaException {
        try {
            weka.clusterers.Clusterer tempToTest = AbstractClusterer.makeCopy(this.m_trainedClusterer);
            Data batchClusterer = new Data("batchClusterer", tempToTest);
            batchClusterer.setPayloadElement("aux_testsSet", data.getPayloadElement("aux_testsSet"));
            batchClusterer.setPayloadElement("aux_set_num", data.getPayloadElement("aux_set_num", 1));
            batchClusterer.setPayloadElement("aux_max_set_num", data.getPayloadElement("aux_max_set_num", 1));
            this.getStepManager().outputData(batchClusterer);
            if (this.isStopRequested()) {
                this.getStepManager().interrupted();
            } else {
                this.getStepManager().finished();
            }
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        ArrayList<String> result = new ArrayList<String>();
        int numTraining = this.getStepManager().numIncomingConnectionsOfType("trainingSet");
        int numTesting = this.getStepManager().numIncomingConnectionsOfType("testSet");
        int numInstance = this.getStepManager().numIncomingConnectionsOfType("instance");
        if (numTraining == 0) {
            result.add("trainingSet");
        }
        if (numTesting == 0) {
            result.add("testSet");
        }
        if (numTraining == 0 && numTesting == 0) {
            result.add("instance");
        }
        return result;
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        int numTraining = this.getStepManager().numIncomingConnectionsOfType("trainingSet");
        int numTesting = this.getStepManager().numIncomingConnectionsOfType("testSet");
        ArrayList<String> result = new ArrayList<String>();
        if (numTraining > 0 || numTesting > 0) {
            result.add("batchClusterer");
        }
        result.add("text");
        if (this.getClusterer() instanceof Drawable && numTraining > 0) {
            result.add("graph");
        }
        result.add("info");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadModel(String filePath) throws Exception {
        ObjectInputStream is = null;
        try {
            is = new ObjectInputStream(new BufferedInputStream(new FileInputStream(new File(filePath))));
            this.m_trainedClusterer = (weka.clusterers.Clusterer)is.readObject();
            try {
                this.m_trainedClustererHeader = (Instances)is.readObject();
            }
            catch (Exception ex) {
                this.getStepManager().logWarning("Model file '" + filePath + "' does not seem to contain an Instances header");
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    protected void outputGraphData(weka.clusterers.Clusterer clusterer, int setNum) throws WekaException {
        if (clusterer instanceof Drawable) {
            if (this.getStepManager().numOutgoingConnectionsOfType("graph") == 0) {
                return;
            }
            try {
                String graphString = ((Drawable)((Object)clusterer)).graph();
                int graphType = ((Drawable)((Object)clusterer)).graphType();
                String grphTitle = clusterer.getClass().getCanonicalName();
                grphTitle = grphTitle.substring(grphTitle.lastIndexOf(46) + 1, grphTitle.length());
                grphTitle = "Set " + setNum + " (" + this.m_trainedClustererHeader.relationName() + ") " + grphTitle;
                Data graphData = new Data("graph");
                graphData.setPayloadElement("graph", graphString);
                graphData.setPayloadElement("graph_title", grphTitle);
                graphData.setPayloadElement("graph_type", graphType);
                this.getStepManager().outputData(graphData);
            }
            catch (Exception ex) {
                throw new WekaException(ex);
            }
        }
    }

    protected void outputTextData(weka.clusterers.Clusterer clusterer, int setNum) throws WekaException {
        if (this.getStepManager().numOutgoingConnectionsOfType("text") == 0) {
            return;
        }
        Data textData = new Data("text");
        String modelString = clusterer.toString();
        String titleString = clusterer.getClass().getName();
        titleString = titleString.substring(titleString.lastIndexOf(46) + 1, titleString.length());
        modelString = "=== Clusterer model ===\n\nScheme:   " + titleString + "\n" + "Relation: " + this.m_trainedClustererHeader.relationName() + "\n\n" + modelString;
        titleString = "Model: " + titleString;
        textData.setPayloadElement("text", modelString);
        textData.setPayloadElement("aux_textTitle", titleString);
        if (setNum != -1) {
            textData.setPayloadElement("aux_set_num", setNum);
        }
        this.getStepManager().outputData(textData);
    }

    @Override
    public weka.clusterers.Clusterer processPrimary(Integer setNum, Integer maxSetNum, Data data, PairedDataHelper<weka.clusterers.Clusterer> helper) throws WekaException {
        Instances trainingData = (Instances)data.getPrimaryPayload();
        try {
            weka.clusterers.Clusterer clusterer = AbstractClusterer.makeCopy(this.m_clustererTemplate);
            String clustererDesc = clusterer.getClass().getCanonicalName();
            clustererDesc = clustererDesc.substring(clustererDesc.lastIndexOf(46) + 1);
            if (clusterer instanceof OptionHandler) {
                String optsString = Utils.joinOptions(((OptionHandler)((Object)clusterer)).getOptions());
                clustererDesc = clustererDesc + " " + optsString;
            }
            if (clusterer instanceof EnvironmentHandler) {
                ((EnvironmentHandler)((Object)clusterer)).setEnvironment(this.getStepManager().getExecutionEnvironment().getEnvironmentVariables());
            }
            helper.addIndexedValueToNamedStore("trainingSplits", setNum, trainingData);
            if (!this.isStopRequested()) {
                this.getStepManager().logBasic("Building " + clustererDesc + " on " + trainingData.relationName() + " for fold/set " + setNum + " out of " + maxSetNum);
                if (maxSetNum == 1) {
                    this.m_trainedClusterer = clusterer;
                }
                clusterer.buildClusterer(trainingData);
                this.getStepManager().logDetailed("Finished building " + clustererDesc + "on " + trainingData.relationName() + " for fold/set " + setNum + " out of " + maxSetNum);
                this.outputTextData(clusterer, setNum);
                this.outputGraphData(clusterer, setNum);
            }
            return clusterer;
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
    }

    @Override
    public void processSecondary(Integer setNum, Integer maxSetNum, Data data, PairedDataHelper<weka.clusterers.Clusterer> helper) throws WekaException {
        weka.clusterers.Clusterer clusterer = helper.getIndexedPrimaryResult(setNum);
        Instances testSplit = (Instances)data.getPrimaryPayload();
        Instances trainingSplit = (Instances)helper.getIndexedValueFromNamedStore("trainingSplits", setNum);
        this.getStepManager().logBasic("Dispatching model for set " + setNum + " out of " + maxSetNum + " to output");
        Data batchClusterer = new Data("batchClusterer", clusterer);
        batchClusterer.setPayloadElement("aux_trainingSet", trainingSplit);
        batchClusterer.setPayloadElement("aux_testsSet", testSplit);
        batchClusterer.setPayloadElement("aux_set_num", setNum);
        batchClusterer.setPayloadElement("aux_max_set_num", maxSetNum);
        batchClusterer.setPayloadElement("aux_label", this.getName());
        this.getStepManager().outputData(batchClusterer);
    }
}

