/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.WekaException;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="InstanceStreamToBatchMaker", category="Flow", toolTipText="Converts an incoming instance stream into a batch dataset", iconPath="weka/gui/knowledgeflow/icons/InstanceStreamToBatchMaker.gif")
public class InstanceStreamToBatchMaker
extends BaseStep {
    private static final long serialVersionUID = 5461324282251111320L;
    protected boolean m_isReset;
    protected Instances m_structure;
    protected List<Instance> m_batch;

    @Override
    public void stepInit() throws WekaException {
        this.m_batch = new ArrayList<Instance>();
        this.m_isReset = true;
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        if (this.getStepManager().numIncomingConnections() == 0) {
            return Arrays.asList("instance");
        }
        return null;
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        if (this.getStepManager().numIncomingConnections() > 0) {
            return Arrays.asList("dataSet", "trainingSet", "testSet");
        }
        return null;
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        if (this.m_isReset) {
            this.m_isReset = false;
            if (data.getPrimaryPayload() == null) {
                throw new WekaException("We didn't receive any instances!");
            }
            this.getStepManager().logDetailed("Collecting instances...");
            Instance temp = (Instance)data.getPrimaryPayload();
            this.m_structure = new Instances(temp.dataset(), 0);
        }
        if (this.isStopRequested()) {
            this.getStepManager().interrupted();
            return;
        }
        if (!this.getStepManager().isStreamFinished(data)) {
            this.getStepManager().throughputUpdateStart();
            Instance inst = (Instance)data.getPrimaryPayload();
            this.m_batch.add(inst);
            this.getStepManager().throughputUpdateEnd();
        } else {
            Instances toOutput = new Instances(this.m_structure, this.m_batch.size());
            for (Instance i : this.m_batch) {
                toOutput.add(i);
            }
            toOutput.compactify();
            this.m_batch.clear();
            this.getStepManager().logBasic("Emitting a batch of " + toOutput.numInstances() + " instances.");
            ArrayList<String> outCons = new ArrayList<String>(this.getStepManager().getOutgoingConnections().keySet());
            Data out = new Data((String)outCons.get(0), toOutput);
            out.setPayloadElement("aux_set_num", 1);
            out.setPayloadElement("aux_max_set_num", 1);
            if (!this.isStopRequested()) {
                this.getStepManager().outputData(out);
                this.getStepManager().finished();
            } else {
                this.getStepManager().interrupted();
            }
        }
    }

    @Override
    public Instances outputStructureForConnectionType(String connectionName) throws WekaException {
        if (this.getStepManager().numIncomingConnections() > 0) {
            return this.getStepManager().getIncomingStructureForConnectionType("instance");
        }
        return null;
    }
}

