/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import weka.core.WekaException;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.Step;

public class PairedDataHelper<P>
implements Serializable {
    private static final long serialVersionUID = -7813465607881227514L;
    protected Map<String, Map<Integer, Object>> m_namedIndexedStore = new HashMap<String, Map<Integer, Object>>();
    protected Map<Integer, P> m_primaryResultMap = new HashMap<Integer, P>();
    protected Map<Integer, Data> m_secondaryDataMap = new HashMap<Integer, Data>();
    protected String m_primaryConType;
    protected String m_secondaryConType;
    protected transient PairedProcessor m_processor;
    protected transient Step m_ownerStep;
    protected transient AtomicInteger m_setCount;

    public PairedDataHelper(Step owner, PairedProcessor processor, String primaryConType, String secondaryConType) {
        this.m_primaryConType = primaryConType;
        this.m_secondaryConType = secondaryConType;
        this.m_ownerStep = owner;
        this.m_processor = processor;
    }

    public void process(Data data) throws WekaException {
        if (this.m_ownerStep.getStepManager().isStopRequested()) {
            this.m_ownerStep.getStepManager().interrupted();
            return;
        }
        String connType = data.getConnectionName();
        if (connType.equals(this.m_primaryConType)) {
            this.processPrimary(data);
        } else if (this.m_secondaryConType != null && connType.equals(this.m_secondaryConType)) {
            this.processSecondary(data);
        } else {
            throw new WekaException("Illegal connection/data type: " + connType);
        }
        if (!this.m_ownerStep.getStepManager().isStopRequested() && this.m_setCount != null && this.m_setCount.get() == 0) {
            this.m_ownerStep.getStepManager().finished();
            this.m_primaryResultMap.clear();
            this.m_secondaryDataMap.clear();
            this.m_namedIndexedStore.clear();
        }
    }

    private void processPrimary(Data data) throws WekaException {
        Data waitingSecondary;
        Object result;
        Integer setNum = data.getPayloadElement("aux_set_num", 1);
        Integer maxSetNum = data.getPayloadElement("aux_max_set_num", 1);
        if (this.m_setCount == null) {
            this.m_setCount = new AtomicInteger(maxSetNum);
        }
        if (setNum == 1) {
            this.m_ownerStep.getStepManager().processing();
            this.m_ownerStep.getStepManager().statusMessage("Processing set/fold " + setNum + " out of " + maxSetNum);
        }
        if (!this.m_ownerStep.getStepManager().isStopRequested() && (result = this.m_processor.processPrimary(setNum, maxSetNum, data, this)) != null) {
            this.m_primaryResultMap.put(setNum, result);
        }
        if ((waitingSecondary = this.m_secondaryDataMap.get(setNum)) != null) {
            this.processSecondary(waitingSecondary);
        } else if (this.m_secondaryConType == null) {
            this.m_setCount.decrementAndGet();
        }
    }

    private synchronized void processSecondary(Data data) throws WekaException {
        Integer setNum = data.getPayloadElement("aux_set_num", 1);
        Integer maxSetNum = data.getPayloadElement("aux_max_set_num", 1);
        P primaryData = this.m_primaryResultMap.get(setNum);
        if (primaryData == null) {
            this.m_secondaryDataMap.put(setNum, data);
            return;
        }
        if (!this.m_ownerStep.getStepManager().isStopRequested()) {
            this.m_processor.processSecondary(setNum, maxSetNum, data, this);
        }
        this.m_setCount.decrementAndGet();
    }

    public P getIndexedPrimaryResult(int index) {
        return this.m_primaryResultMap.get(index);
    }

    public void reset() {
        if (this.m_setCount != null && this.m_setCount.get() > 0 && !this.m_ownerStep.getStepManager().isStopRequested()) {
            return;
        }
        this.m_setCount = null;
    }

    public boolean isFinished() {
        return this.m_setCount.get() == 0;
    }

    public void createNamedIndexedStore(String name) {
        this.m_namedIndexedStore.put(name, new HashMap());
    }

    public <T> T getIndexedValueFromNamedStore(String storeName, Integer index) {
        Map<Integer, Object> store = this.m_namedIndexedStore.get(storeName);
        if (store != null) {
            return (T)store.get(index);
        }
        return null;
    }

    public void addIndexedValueToNamedStore(String storeName, Integer index, Object value) {
        Map<Integer, Object> store = this.m_namedIndexedStore.get(storeName);
        if (store == null) {
            this.createNamedIndexedStore(storeName);
            store = this.m_namedIndexedStore.get(storeName);
        }
        store.put(index, value);
    }

    public static interface PairedProcessor<P> {
        public P processPrimary(Integer var1, Integer var2, Data var3, PairedDataHelper<P> var4) throws WekaException;

        public void processSecondary(Integer var1, Integer var2, Data var3, PairedDataHelper<P> var4) throws WekaException;
    }
}

