/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.instance;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.AttributeStats;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.supervised.instance.SpreadSubsample;

public class SpreadSubsampleTest
extends AbstractFilterTest {
    private static double TOLERANCE = 0.001;

    public SpreadSubsampleTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        SpreadSubsample f = new SpreadSubsample();
        f.setDistributionSpread(0.0);
        return f;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances.setClassIndex(1);
    }

    public void testDistributionSpread() throws Exception {
        this.testDistributionSpread_X(1.0);
        this.testDistributionSpread_X(2.0);
        this.testDistributionSpread_X(3.0);
    }

    public void testAdjustWeights() {
        ((SpreadSubsample)this.m_Filter).setAdjustWeights(true);
        Instances result = this.useFilter();
        SpreadSubsampleTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        double origWeight = 0.0;
        for (int i = 0; i < this.m_Instances.numInstances(); ++i) {
            origWeight += this.m_Instances.instance(i).weight();
        }
        double outWeight = 0.0;
        for (int i = 0; i < result.numInstances(); ++i) {
            outWeight += result.instance(i).weight();
        }
        SpreadSubsampleTest.assertEquals((double)origWeight, (double)outWeight, (double)TOLERANCE);
    }

    private void testDistributionSpread_X(double factor) throws Exception {
        AttributeStats origs = this.m_Instances.attributeStats(1);
        SpreadSubsampleTest.assertNotNull((Object)origs.nominalCounts);
        ((SpreadSubsample)this.m_Filter).setDistributionSpread(factor);
        Instances result = this.useFilter();
        SpreadSubsampleTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        AttributeStats outs = result.attributeStats(1);
        SpreadSubsampleTest.assertNotNull((Object)outs.nominalCounts);
        SpreadSubsampleTest.assertEquals((int)origs.nominalCounts.length, (int)outs.nominalCounts.length);
        int min = outs.nominalCounts[0];
        int max = outs.nominalCounts[0];
        for (int i = 1; i < outs.nominalCounts.length; ++i) {
            if (outs.nominalCounts[i] < min) {
                min = outs.nominalCounts[i];
            }
            if (outs.nominalCounts[i] <= max) continue;
            max = outs.nominalCounts[i];
        }
        SpreadSubsampleTest.assertTrue(((double)max / factor <= (double)min ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(SpreadSubsampleTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SpreadSubsampleTest.suite());
    }
}

