/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.AdditionalMeasureProducer;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.CSVResultListener;
import weka.experiment.CrossValidationResultProducer;
import weka.experiment.DatabaseResultListener;
import weka.experiment.DatabaseUtils;
import weka.experiment.ResultListener;
import weka.experiment.ResultProducer;

public class DatabaseResultProducer
extends DatabaseResultListener
implements ResultProducer,
OptionHandler,
AdditionalMeasureProducer {
    static final long serialVersionUID = -5620660780203158666L;
    protected Instances m_Instances;
    protected ResultListener m_ResultListener = new CSVResultListener();
    protected String[] m_AdditionalMeasures = null;

    @Override
    public String globalInfo() {
        return "Examines a database and extracts out the results produced by the specified ResultProducer and submits them to the specified ResultListener. If a result needs to be generated, the ResultProducer is used to obtain the result.";
    }

    public DatabaseResultProducer() throws Exception {
        this.m_ResultProducer = new CrossValidationResultProducer();
    }

    @Override
    public void doRunKeys(int run) throws Exception {
        if (this.m_ResultProducer == null) {
            throw new Exception("No ResultProducer set");
        }
        if (this.m_ResultListener == null) {
            throw new Exception("No ResultListener set");
        }
        if (this.m_Instances == null) {
            throw new Exception("No Instances set");
        }
        this.m_ResultProducer.setResultListener(this);
        this.m_ResultProducer.setInstances(this.m_Instances);
        this.m_ResultProducer.doRunKeys(run);
    }

    @Override
    public void doRun(int run) throws Exception {
        if (this.m_ResultProducer == null) {
            throw new Exception("No ResultProducer set");
        }
        if (this.m_ResultListener == null) {
            throw new Exception("No ResultListener set");
        }
        if (this.m_Instances == null) {
            throw new Exception("No Instances set");
        }
        this.m_ResultProducer.setResultListener(this);
        this.m_ResultProducer.setInstances(this.m_Instances);
        this.m_ResultProducer.doRun(run);
    }

    @Override
    public void preProcess(ResultProducer rp) throws Exception {
        super.preProcess(rp);
        if (this.m_ResultListener == null) {
            throw new Exception("No ResultListener set");
        }
        this.m_ResultListener.preProcess(this);
    }

    @Override
    public void postProcess(ResultProducer rp) throws Exception {
        super.postProcess(rp);
        this.m_ResultListener.postProcess(this);
    }

    @Override
    public void preProcess() throws Exception {
        if (this.m_ResultProducer == null) {
            throw new Exception("No ResultProducer set");
        }
        this.m_ResultProducer.setResultListener(this);
        this.m_ResultProducer.preProcess();
    }

    @Override
    public void postProcess() throws Exception {
        this.m_ResultProducer.postProcess();
    }

    @Override
    public void acceptResult(ResultProducer rp, Object[] key, Object[] result) throws Exception {
        if (this.m_ResultProducer != rp) {
            throw new Error("Unrecognized ResultProducer sending results!!");
        }
        boolean isRequiredByListener = this.m_ResultListener.isResultRequired(this, key);
        boolean isRequiredByDatabase = super.isResultRequired(rp, key);
        if (isRequiredByDatabase && result != null) {
            super.acceptResult(rp, key, result);
        }
        if (isRequiredByListener) {
            this.m_ResultListener.acceptResult(this, key, result);
        }
    }

    @Override
    public boolean isResultRequired(ResultProducer rp, Object[] key) throws Exception {
        if (this.m_ResultProducer != rp) {
            throw new Error("Unrecognized ResultProducer sending results!!");
        }
        boolean isRequiredByListener = this.m_ResultListener.isResultRequired(this, key);
        boolean isRequiredByDatabase = super.isResultRequired(rp, key);
        if (!isRequiredByDatabase && isRequiredByListener) {
            Object[] result = this.getResultFromTable(this.m_ResultsTableName, rp, key);
            System.err.println("Got result from database: " + DatabaseUtils.arrayToString(result));
            this.m_ResultListener.acceptResult(this, key, result);
            return false;
        }
        return isRequiredByListener || isRequiredByDatabase;
    }

    @Override
    public String[] getKeyNames() throws Exception {
        return this.m_ResultProducer.getKeyNames();
    }

    @Override
    public Object[] getKeyTypes() throws Exception {
        return this.m_ResultProducer.getKeyTypes();
    }

    @Override
    public String[] getResultNames() throws Exception {
        return this.m_ResultProducer.getResultNames();
    }

    @Override
    public Object[] getResultTypes() throws Exception {
        return this.m_ResultProducer.getResultTypes();
    }

    @Override
    public String getCompatibilityState() {
        String result = "";
        if (this.m_ResultProducer == null) {
            result = result + "<null ResultProducer>";
        } else {
            result = result + "-W " + this.m_ResultProducer.getClass().getName();
            result = result + " -- " + this.m_ResultProducer.getCompatibilityState();
        }
        return result.trim();
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\tThe name of the database field to cache over.\n\teg: \"Fold\" (default none)", "F", 1, "-F <field name>"));
        newVector.addElement(new Option("\tThe full class name of a ResultProducer.\n\teg: weka.experiment.CrossValidationResultProducer", "W", 1, "-W <class name>"));
        if (this.m_ResultProducer != null && this.m_ResultProducer instanceof OptionHandler) {
            newVector.addElement(new Option("", "", 0, "\nOptions specific to result producer " + this.m_ResultProducer.getClass().getName() + ":"));
            newVector.addAll(Collections.list(((OptionHandler)((Object)this.m_ResultProducer)).listOptions()));
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setCacheKeyName(Utils.getOption('F', options));
        String rpName = Utils.getOption('W', options);
        if (rpName.length() == 0) {
            throw new Exception("A ResultProducer must be specified with the -W option.");
        }
        this.setResultProducer((ResultProducer)Utils.forName(ResultProducer.class, rpName, null));
        if (this.getResultProducer() instanceof OptionHandler) {
            ((OptionHandler)((Object)this.getResultProducer())).setOptions(Utils.partitionOptions(options));
        }
    }

    @Override
    public String[] getOptions() {
        String[] seOptions = new String[]{};
        if (this.m_ResultProducer != null && this.m_ResultProducer instanceof OptionHandler) {
            seOptions = ((OptionHandler)((Object)this.m_ResultProducer)).getOptions();
        }
        String[] options = new String[seOptions.length + 8];
        int current = 0;
        if (!this.getCacheKeyName().equals("")) {
            options[current++] = "-F";
            options[current++] = this.getCacheKeyName();
        }
        if (this.getResultProducer() != null) {
            options[current++] = "-W";
            options[current++] = this.getResultProducer().getClass().getName();
        }
        options[current++] = "--";
        System.arraycopy(seOptions, 0, options, current, seOptions.length);
        current += seOptions.length;
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public void setAdditionalMeasures(String[] additionalMeasures) {
        this.m_AdditionalMeasures = additionalMeasures;
        if (this.m_ResultProducer != null) {
            System.err.println("DatabaseResultProducer: setting additional measures for ResultProducer");
            this.m_ResultProducer.setAdditionalMeasures(this.m_AdditionalMeasures);
        }
    }

    @Override
    public Enumeration<String> enumerateMeasures() {
        Vector<String> newVector = new Vector<String>();
        if (this.m_ResultProducer instanceof AdditionalMeasureProducer) {
            Enumeration<String> en = ((AdditionalMeasureProducer)((Object)this.m_ResultProducer)).enumerateMeasures();
            while (en.hasMoreElements()) {
                String mname = en.nextElement();
                newVector.addElement(mname);
            }
        }
        return newVector.elements();
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (this.m_ResultProducer instanceof AdditionalMeasureProducer) {
            return ((AdditionalMeasureProducer)((Object)this.m_ResultProducer)).getMeasure(additionalMeasureName);
        }
        throw new IllegalArgumentException("DatabaseResultProducer: Can't return value for : " + additionalMeasureName + ". " + this.m_ResultProducer.getClass().getName() + " " + "is not an AdditionalMeasureProducer");
    }

    @Override
    public void setInstances(Instances instances) {
        this.m_Instances = instances;
    }

    @Override
    public void setResultListener(ResultListener listener) {
        this.m_ResultListener = listener;
    }

    public String resultProducerTipText() {
        return "Set the result producer to use. If some results are not found in the source database then this result producer is used to generate them.";
    }

    public ResultProducer getResultProducer() {
        return this.m_ResultProducer;
    }

    public void setResultProducer(ResultProducer newResultProducer) {
        this.m_ResultProducer = newResultProducer;
    }

    public String toString() {
        String result = "DatabaseResultProducer: ";
        result = result + this.getCompatibilityState();
        result = this.m_Instances == null ? result + ": <null Instances>" : result + ": " + Utils.backQuoteChars(this.m_Instances.relationName());
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 11247 $");
    }
}

