/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.CheckOptionHandler;
import weka.core.DictionaryBuilder;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;

public class DictionaryBuilderTest
extends TestCase {
    protected static final String DATA1 = "@relation test1\n@attribute text1 string\n@data\n'the quick brown fox jumped over the lazy turnip.'\n'the slow sherman tank drove over the animated vw beetle'\n";
    protected static final String DATA2 = "@relation test2\n@attribute text1 string\n@attribute class {one,two}\n@data\n'the quick brown fox jumped over the lazy turnip.',one\n'the slow sherman tank drove over the animated vw beetle',two\n";
    protected static final String DATA3 = "@relation test3\n@attribute first numeric\n@attribute second numeric\n@attribute text1 string\n@data\n1,2,'the quick brown fox jumped over the lazy turnip.'\n3,4,'the slow sherman tank drove over the animated vw beetle'\n";
    protected static final String DATA4 = "@relation test1\n@attribute text1 string\n@data\n'the quick brown fox jumped over the lazy armchair.'\n'the slow sherman tank drove over the animated unicycle'\n";

    protected Instances getData1() throws Exception {
        Instances data1 = new Instances((Reader)new StringReader(DATA1));
        return data1;
    }

    protected Instances getData2() throws Exception {
        Instances data2 = new Instances((Reader)new StringReader(DATA2));
        data2.setClassIndex(1);
        return data2;
    }

    protected Instances getData3() throws Exception {
        Instances data3 = new Instances((Reader)new StringReader(DATA3));
        return data3;
    }

    protected Instances getData4() throws Exception {
        Instances data4 = new Instances((Reader)new StringReader(DATA4));
        return data4;
    }

    public DictionaryBuilderTest(String name) {
        super(name);
    }

    public void testInit() throws Exception {
        Instances data1 = this.getData1();
        Instances structure = new Instances(data1, 0);
        DictionaryBuilder builder = new DictionaryBuilder();
        builder.setMinTermFreq(2);
        builder.setup(structure);
        DictionaryBuilderTest.assertEquals((int)1, (int)builder.getDictionaries(false).length);
    }

    public void testTypicalNoClass() throws Exception {
        Instances data1 = this.getData1();
        Instances structure = new Instances(data1, 0);
        DictionaryBuilder builder = new DictionaryBuilder();
        builder.setMinTermFreq(2);
        builder.setup(structure);
        for (int i = 0; i < data1.numInstances(); ++i) {
            builder.processInstance(data1.instance(i));
        }
        DictionaryBuilderTest.assertEquals((int)15, (int)builder.getDictionaries(false)[0].size());
        DictionaryBuilderTest.assertTrue((builder.getDictionaries(false)[0].get("the") != null ? 1 : 0) != 0);
        DictionaryBuilderTest.assertEquals((int)4, (int)((int[])builder.getDictionaries(false)[0].get("the"))[0]);
        DictionaryBuilderTest.assertEquals((int)2, (int)((int[])builder.getDictionaries(false)[0].get("the"))[1]);
    }

    public void testFinalizeDictionaryNoClass() throws Exception {
        Instances data1 = this.getData1();
        Instances structure = new Instances(data1, 0);
        DictionaryBuilder builder = new DictionaryBuilder();
        builder.setMinTermFreq(2);
        builder.setup(structure);
        for (int i = 0; i < data1.numInstances(); ++i) {
            builder.processInstance(data1.instance(i));
        }
        DictionaryBuilderTest.assertEquals((int)15, (int)builder.getDictionaries(false)[0].size());
        Map consolidated = builder.finalizeDictionary();
        DictionaryBuilderTest.assertEquals((int)2, (int)consolidated.size());
    }

    public void testPruneMinFreq() throws Exception {
        Instances data1 = this.getData1();
        Instances structure = new Instances(data1, 0);
        DictionaryBuilder builder = new DictionaryBuilder();
        builder.setMinTermFreq(1);
        builder.setup(structure);
        for (int i = 0; i < data1.numInstances(); ++i) {
            builder.processInstance(data1.instance(i));
        }
        DictionaryBuilderTest.assertEquals((int)15, (int)builder.getDictionaries(false)[0].size());
        Map consolidated = builder.finalizeDictionary();
        DictionaryBuilderTest.assertEquals((int)15, (int)consolidated.size());
    }

    public void testGetVectorizedStructureNoClass() throws Exception {
        Instances data1 = this.getData1();
        Instances structure = new Instances(data1, 0);
        DictionaryBuilder builder = new DictionaryBuilder();
        builder.setMinTermFreq(2);
        builder.setup(structure);
        for (int i = 0; i < data1.numInstances(); ++i) {
            builder.processInstance(data1.instance(i));
        }
        builder.finalizeDictionary();
        Instances format = builder.getVectorizedFormat();
        DictionaryBuilderTest.assertTrue((format != null ? 1 : 0) != 0);
        DictionaryBuilderTest.assertEquals((int)2, (int)format.numAttributes());
    }

    public void testVectorizeInstanceWordPresenceNoClass() throws Exception {
        Instances data1 = this.getData1();
        Instances structure = new Instances(data1, 0);
        DictionaryBuilder builder = new DictionaryBuilder();
        builder.setMinTermFreq(2);
        builder.setup(structure);
        for (int i = 0; i < data1.numInstances(); ++i) {
            builder.processInstance(data1.instance(i));
        }
        builder.finalizeDictionary();
        Instance vectorized = builder.vectorizeInstance(data1.instance(0));
        DictionaryBuilderTest.assertEquals((int)2, (int)vectorized.numAttributes());
        DictionaryBuilderTest.assertEquals((int)1, (int)((int)vectorized.value(0)));
        DictionaryBuilderTest.assertEquals((int)1, (int)((int)vectorized.value(1)));
    }

    public void testVectorizeInstanceWordCountsNoClass() throws Exception {
        Instances data1 = this.getData1();
        Instances structure = new Instances(data1, 0);
        DictionaryBuilder builder = new DictionaryBuilder();
        builder.setMinTermFreq(2);
        builder.setOutputWordCounts(true);
        builder.setup(structure);
        for (int i = 0; i < data1.numInstances(); ++i) {
            builder.processInstance(data1.instance(i));
        }
        builder.finalizeDictionary();
        Instance vectorized = builder.vectorizeInstance(data1.instance(0));
        DictionaryBuilderTest.assertEquals((int)2, (int)vectorized.numAttributes());
        DictionaryBuilderTest.assertEquals((int)2, (int)((int)vectorized.value(0)));
        DictionaryBuilderTest.assertEquals((int)1, (int)((int)vectorized.value(1)));
    }

    public void testTypicalNoClassExtraAtts() throws Exception {
        Instances data1 = this.getData3();
        Instances structure = new Instances(data1, 0);
        DictionaryBuilder builder = new DictionaryBuilder();
        builder.setMinTermFreq(2);
        builder.setup(structure);
        for (int i = 0; i < data1.numInstances(); ++i) {
            builder.processInstance(data1.instance(i));
        }
        DictionaryBuilderTest.assertEquals((int)15, (int)builder.getDictionaries(false)[0].size());
        DictionaryBuilderTest.assertTrue((builder.getDictionaries(false)[0].get("the") != null ? 1 : 0) != 0);
        DictionaryBuilderTest.assertEquals((int)4, (int)((int[])builder.getDictionaries(false)[0].get("the"))[0]);
        DictionaryBuilderTest.assertEquals((int)2, (int)((int[])builder.getDictionaries(false)[0].get("the"))[1]);
    }

    public void testFinalizeDictionaryNoClassExtraAtts() throws Exception {
        Instances data1 = this.getData3();
        Instances structure = new Instances(data1, 0);
        DictionaryBuilder builder = new DictionaryBuilder();
        builder.setMinTermFreq(2);
        builder.setup(structure);
        for (int i = 0; i < data1.numInstances(); ++i) {
            builder.processInstance(data1.instance(i));
        }
        DictionaryBuilderTest.assertEquals((int)15, (int)builder.getDictionaries(false)[0].size());
        Map consolidated = builder.finalizeDictionary();
        DictionaryBuilderTest.assertEquals((int)2, (int)consolidated.size());
    }

    public void testGetVectorizedStructureNoClassExtraAtts() throws Exception {
        Instances data1 = this.getData3();
        Instances structure = new Instances(data1, 0);
        DictionaryBuilder builder = new DictionaryBuilder();
        builder.setMinTermFreq(2);
        builder.setup(structure);
        for (int i = 0; i < data1.numInstances(); ++i) {
            builder.processInstance(data1.instance(i));
        }
        builder.finalizeDictionary();
        Instances format = builder.getVectorizedFormat();
        DictionaryBuilderTest.assertTrue((format != null ? 1 : 0) != 0);
        DictionaryBuilderTest.assertEquals((int)4, (int)format.numAttributes());
    }

    public void testTypicalClassAttPresent() throws Exception {
        Instances data2 = this.getData2();
        Instances structure = new Instances(data2, 0);
        DictionaryBuilder builder = new DictionaryBuilder();
        builder.setMinTermFreq(2);
        builder.setup(structure);
        for (int i = 0; i < data2.numInstances(); ++i) {
            builder.processInstance(data2.instance(i));
        }
        DictionaryBuilderTest.assertEquals((int)2, (int)builder.getDictionaries(false).length);
        DictionaryBuilderTest.assertEquals((int)8, (int)builder.getDictionaries(false)[0].size());
        DictionaryBuilderTest.assertEquals((int)9, (int)builder.getDictionaries(false)[1].size());
        DictionaryBuilderTest.assertTrue((builder.getDictionaries(false)[0].get("the") != null ? 1 : 0) != 0);
        DictionaryBuilderTest.assertEquals((int)2, (int)((int[])builder.getDictionaries(false)[0].get("the"))[0]);
        DictionaryBuilderTest.assertEquals((int)1, (int)((int[])builder.getDictionaries(false)[0].get("the"))[1]);
    }

    public void testAggregateDictionaries() throws Exception {
        Instances data1 = this.getData1();
        Instances data4 = this.getData4();
        Instances structure = new Instances(data1, 0);
        DictionaryBuilder builder = new DictionaryBuilder();
        builder.setMinTermFreq(1);
        builder.setup(structure);
        for (int i = 0; i < data1.numInstances(); ++i) {
            builder.processInstance(data1.instance(i));
        }
        Instances structure2 = new Instances(data4, 0);
        DictionaryBuilder builder2 = new DictionaryBuilder();
        builder2.setMinTermFreq(1);
        builder2.setup(structure2);
        for (int i = 0; i < data4.numInstances(); ++i) {
            builder2.processInstance(data4.instance(i));
        }
        builder = builder.aggregate(builder2);
        builder.finalizeAggregation();
        Map consolidated = builder.finalizeDictionary();
        DictionaryBuilderTest.assertEquals((int)17, (int)consolidated.size());
    }

    public void testSaveLoadDictionaryPlainTextNoNormalize() throws Exception {
        Instances data1 = this.getData1();
        Instances structure = new Instances(data1, 0);
        DictionaryBuilder builder = new DictionaryBuilder();
        builder.setMinTermFreq(2);
        builder.setup(structure);
        for (int i = 0; i < data1.numInstances(); ++i) {
            builder.processInstance(data1.instance(i));
        }
        builder.finalizeDictionary();
        StringWriter sw = new StringWriter();
        builder.saveDictionary((Writer)sw);
        StringReader sr = new StringReader(sw.toString());
        DictionaryBuilder builder2 = new DictionaryBuilder();
        builder2.setup(structure);
        builder2.loadDictionary((Reader)sr);
        Map consolidated = builder2.finalizeDictionary();
        DictionaryBuilderTest.assertEquals((int)2, (int)consolidated.size());
    }

    public void testSaveLoadDictionaryPlainTextNormalize() throws Exception {
        Instances data1 = this.getData1();
        Instances structure = new Instances(data1, 0);
        DictionaryBuilder builder = new DictionaryBuilder();
        builder.setMinTermFreq(2);
        builder.setNormalize(true);
        builder.setup(structure);
        for (int i = 0; i < data1.numInstances(); ++i) {
            builder.processInstance(data1.instance(i));
        }
        builder.finalizeDictionary();
        StringWriter sw = new StringWriter();
        builder.saveDictionary((Writer)sw);
        String dictText = sw.toString();
        DictionaryBuilderTest.assertTrue((boolean)dictText.contains("@@@3.39036"));
        StringReader sr = new StringReader(dictText);
        DictionaryBuilder builder2 = new DictionaryBuilder();
        builder2.setup(structure);
        builder2.loadDictionary((Reader)sr);
        Map consolidated = builder2.finalizeDictionary();
        DictionaryBuilderTest.assertEquals((int)2, (int)consolidated.size());
    }

    public void testListOptions() {
        CheckOptionHandler optionHandler = new CheckOptionHandler();
        DictionaryBuilder builder = new DictionaryBuilder();
        optionHandler.setOptionHandler((OptionHandler)builder);
        if (!optionHandler.checkListOptions()) {
            DictionaryBuilderTest.fail((String)"Options cannot be listed via listOptions");
        }
    }

    public void testSetOptions() {
        CheckOptionHandler optionHandler = new CheckOptionHandler();
        DictionaryBuilder builder = new DictionaryBuilder();
        optionHandler.setOptionHandler((OptionHandler)builder);
        if (!optionHandler.checkSetOptions()) {
            DictionaryBuilderTest.fail((String)"setOptions method failed");
        }
    }

    public void testCanonicalUserOptions() {
        CheckOptionHandler optionHandler = new CheckOptionHandler();
        DictionaryBuilder builder = new DictionaryBuilder();
        optionHandler.setOptionHandler((OptionHandler)builder);
        if (!optionHandler.checkCanonicalUserOptions()) {
            DictionaryBuilderTest.fail((String)"setOptions method failed");
        }
    }

    public void testResettingOptions() {
        CheckOptionHandler optionHandler = new CheckOptionHandler();
        DictionaryBuilder builder = new DictionaryBuilder();
        optionHandler.setOptionHandler((OptionHandler)builder);
        if (!optionHandler.checkResettingOptions()) {
            DictionaryBuilderTest.fail((String)"Resetting of options failed");
        }
    }

    public void testRemainingOptions() {
        CheckOptionHandler optionHandler = new CheckOptionHandler();
        DictionaryBuilder builder = new DictionaryBuilder();
        optionHandler.setOptionHandler((OptionHandler)builder);
        if (!optionHandler.checkRemainingOptions()) {
            DictionaryBuilderTest.fail((String)"There were leftover options");
        }
    }

    public static Test suite() {
        return new TestSuite(DictionaryBuilderTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DictionaryBuilderTest.suite());
    }
}

