/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Trie;

public class TrieTest
extends TestCase {
    protected String[] m_Data;
    protected Trie m_Trie;

    public TrieTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_Data = new String[]{"this is a test", "this is another test", "and something else"};
        this.m_Trie = this.buildTrie(this.m_Data);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public Trie buildTrie(String data) {
        return this.buildTrie(new String[]{data});
    }

    public Trie buildTrie(String[] data) {
        Trie result = new Trie();
        for (int i = 0; i < data.length; ++i) {
            result.add(data[i]);
        }
        return result;
    }

    public void testCorrectBuild() {
        Iterator iter = this.m_Trie.iterator();
        HashSet<String> set = new HashSet<String>();
        while (iter.hasNext()) {
            set.add((String)iter.next());
        }
        TrieTest.assertEquals((String)"size() does not reflect number of added strings", (int)this.m_Data.length, (int)this.m_Trie.size());
        TrieTest.assertEquals((String)"Iterator returns different number of strings", (int)this.m_Data.length, (int)set.size());
        for (int i = 0; i < this.m_Data.length; ++i) {
            if (set.contains(this.m_Data[i])) continue;
            TrieTest.fail((String)("Cannot find string '" + this.m_Data[i] + "'"));
        }
    }

    public void testDifferentBuildOrder() {
        String[] newData = new String[this.m_Data.length];
        for (int i = 0; i < this.m_Data.length; ++i) {
            newData[i] = this.m_Data[this.m_Data.length - i - 1];
        }
        Trie t2 = this.buildTrie(this.m_Data);
        if (!this.m_Trie.equals((Object)t2)) {
            TrieTest.fail((String)"Tries differ");
        }
    }

    public void testClone() {
        Trie clone = (Trie)this.m_Trie.clone();
        if (!this.m_Trie.equals((Object)clone)) {
            TrieTest.fail((String)"Tries differ");
        }
    }

    public void testRemoveAllPartial() {
        Trie remove = this.buildTrie(this.m_Data[0]);
        Trie clone = (Trie)this.m_Trie.clone();
        this.m_Trie.removeAll((Collection)remove);
        TrieTest.assertEquals((String)"Removing of 1 string", (int)clone.size(), (int)(this.m_Trie.size() + 1));
    }

    public void testRemoveAllFull() {
        Trie remove = this.buildTrie(this.m_Data);
        Trie clone = (Trie)this.m_Trie.clone();
        this.m_Trie.removeAll((Collection)remove);
        TrieTest.assertEquals((String)"Removing all strings", (int)clone.size(), (int)(this.m_Trie.size() + this.m_Data.length));
    }

    public void testRetainAllPartial() {
        Trie retain = this.buildTrie(this.m_Data[0]);
        this.m_Trie.retainAll((Collection)retain);
        TrieTest.assertEquals((String)"Retaining of 1 string", (int)1, (int)this.m_Trie.size());
    }

    public void testRetainAllFull() {
        Trie retain = this.buildTrie(this.m_Data);
        Trie clone = (Trie)this.m_Trie.clone();
        this.m_Trie.retainAll((Collection)retain);
        TrieTest.assertEquals((String)"Retaining all strings", (int)clone.size(), (int)this.m_Trie.size());
    }

    public void testCommonPrefix() {
        String returned = this.m_Trie.getCommonPrefix();
        TrieTest.assertEquals((String)"Common prefixes differ", (int)0, (int)returned.length());
        String expected = "this is a";
        Trie t = this.buildTrie(new String[]{this.m_Data[0], this.m_Data[1]});
        returned = t.getCommonPrefix();
        TrieTest.assertEquals((String)"Common prefixes differ", (int)expected.length(), (int)returned.length());
    }

    public void testFindPrefixes() {
        Vector prefixes = this.m_Trie.getWithPrefix("this");
        TrieTest.assertEquals((String)"Different number of prefixes returned", (int)2, (int)prefixes.size());
        prefixes = this.m_Trie.getWithPrefix("blah");
        TrieTest.assertEquals((String)"Different number of prefixes returned", (int)0, (int)prefixes.size());
    }

    public static Test suite() {
        return new TestSuite(TrieTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TrieTest.suite());
    }
}

