/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.AddExpression;

public class AddExpressionTest
extends AbstractFilterTest {
    private static double EXPR_DELTA = 0.001;

    public AddExpressionTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        return new AddExpression();
    }

    public Filter getFilter(String expr) {
        AddExpression af = new AddExpression();
        af.setExpression(expr);
        return af;
    }

    public void testAdd() {
        this.m_Filter = this.getFilter("a3+a6");
        Instances result = this.useFilter();
        for (int i = 0; i < result.numInstances(); ++i) {
            Instance inst = result.instance(i);
            AddExpressionTest.assertEquals((String)("Instance " + (i + 1)), (double)(inst.value(2) + inst.value(5)), (double)inst.value(inst.numAttributes() - 1), (double)EXPR_DELTA);
        }
    }

    public void testSubtract() {
        this.m_Filter = this.getFilter("a3-a6");
        Instances result = this.useFilter();
        for (int i = 0; i < result.numInstances(); ++i) {
            Instance inst = result.instance(i);
            AddExpressionTest.assertEquals((String)("Instance " + (i + 1)), (double)(inst.value(2) - inst.value(5)), (double)inst.value(inst.numAttributes() - 1), (double)EXPR_DELTA);
        }
    }

    public void testMultiply() {
        this.m_Filter = this.getFilter("a3*a6");
        Instances result = this.useFilter();
        for (int i = 0; i < result.numInstances(); ++i) {
            Instance inst = result.instance(i);
            AddExpressionTest.assertEquals((String)("Instance " + (i + 1)), (double)(inst.value(2) * inst.value(5)), (double)inst.value(inst.numAttributes() - 1), (double)EXPR_DELTA);
        }
    }

    public void testDivide() {
        this.m_Filter = this.getFilter("a3/a6");
        Instances result = this.useFilter();
        for (int i = 0; i < result.numInstances(); ++i) {
            Instance inst = result.instance(i);
            AddExpressionTest.assertEquals((String)("Instance " + (i + 1)), (double)(inst.value(2) / inst.value(5)), (double)inst.value(inst.numAttributes() - 1), (double)EXPR_DELTA);
        }
    }

    public void testExponent() {
        this.m_Filter = this.getFilter("a3^a6");
        Instances result = this.useFilter();
        for (int i = 0; i < result.numInstances(); ++i) {
            Instance inst = result.instance(i);
            AddExpressionTest.assertEquals((String)("Instance " + (i + 1)), (double)Math.pow(inst.value(2), inst.value(5)), (double)inst.value(inst.numAttributes() - 1), (double)EXPR_DELTA);
        }
    }

    public void testLog() {
        this.m_Filter = this.getFilter("log(a6/5)");
        Instances result = this.useFilter();
        for (int i = 0; i < result.numInstances(); ++i) {
            Instance inst = result.instance(i);
            if (inst.value(5) == 0.0) continue;
            AddExpressionTest.assertEquals((String)("Instance " + (i + 1)), (double)Math.log(inst.value(5) / 5.0), (double)inst.value(inst.numAttributes() - 1), (double)EXPR_DELTA);
        }
    }

    public void testCos() {
        this.m_Filter = this.getFilter("cos(a6/5)");
        Instances result = this.useFilter();
        for (int i = 0; i < result.numInstances(); ++i) {
            Instance inst = result.instance(i);
            AddExpressionTest.assertEquals((String)("Instance " + (i + 1)), (double)Math.cos(inst.value(5) / 5.0), (double)inst.value(inst.numAttributes() - 1), (double)EXPR_DELTA);
        }
    }

    public void testSin() {
        this.m_Filter = this.getFilter("sin(a6/5)");
        Instances result = this.useFilter();
        for (int i = 0; i < result.numInstances(); ++i) {
            Instance inst = result.instance(i);
            AddExpressionTest.assertEquals((String)("Instance " + (i + 1)), (double)Math.sin(inst.value(5) / 5.0), (double)inst.value(inst.numAttributes() - 1), (double)EXPR_DELTA);
        }
    }

    public void testTan() {
        this.m_Filter = this.getFilter("tan(a6/5)");
        Instances result = this.useFilter();
        for (int i = 0; i < result.numInstances(); ++i) {
            Instance inst = result.instance(i);
            AddExpressionTest.assertEquals((String)("Instance " + (i + 1) + ": " + inst + "\n"), (double)Math.tan(inst.value(5) / 5.0), (double)inst.value(inst.numAttributes() - 1), (double)EXPR_DELTA);
        }
    }

    public void testAbs() {
        this.m_Filter = this.getFilter("abs(a6-a3)");
        Instances result = this.useFilter();
        for (int i = 0; i < result.numInstances(); ++i) {
            Instance inst = result.instance(i);
            AddExpressionTest.assertEquals((String)("Instance " + (i + 1)), (double)Math.abs(inst.value(5) - inst.value(2)), (double)inst.value(inst.numAttributes() - 1), (double)EXPR_DELTA);
        }
    }

    public void testExp() {
        this.m_Filter = this.getFilter("exp(a6-a3)");
        Instances result = this.useFilter();
        for (int i = 0; i < result.numInstances(); ++i) {
            Instance inst = result.instance(i);
            AddExpressionTest.assertEquals((String)("Instance " + (i + 1)), (double)Math.exp(inst.value(5) - inst.value(2)), (double)inst.value(inst.numAttributes() - 1), (double)EXPR_DELTA);
        }
    }

    public void testSqrt() {
        this.m_Filter = this.getFilter("sqrt(a6+a3/5)");
        Instances result = this.useFilter();
        for (int i = 0; i < result.numInstances(); ++i) {
            Instance inst = result.instance(i);
            AddExpressionTest.assertEquals((String)("Instance " + (i + 1)), (double)Math.sqrt(inst.value(5) + inst.value(2) / 5.0), (double)inst.value(inst.numAttributes() - 1), (double)EXPR_DELTA);
        }
    }

    public void testFloor() {
        this.m_Filter = this.getFilter("floor(a6+a3/5)");
        Instances result = this.useFilter();
        for (int i = 0; i < result.numInstances(); ++i) {
            Instance inst = result.instance(i);
            AddExpressionTest.assertEquals((String)("Instance " + (i + 1)), (double)Math.floor(inst.value(5) + inst.value(2) / 5.0), (double)inst.value(inst.numAttributes() - 1), (double)EXPR_DELTA);
        }
    }

    public void testCeil() {
        this.m_Filter = this.getFilter("ceil(a6*a3/5)");
        Instances result = this.useFilter();
        for (int i = 0; i < result.numInstances(); ++i) {
            Instance inst = result.instance(i);
            AddExpressionTest.assertEquals((String)("Instance " + (i + 1)), (double)Math.ceil(inst.value(5) * inst.value(2) / 5.0), (double)inst.value(inst.numAttributes() - 1), (double)EXPR_DELTA);
        }
    }

    public void testRint() {
        this.m_Filter = this.getFilter("rint(a6*a3/5)");
        Instances result = this.useFilter();
        for (int i = 0; i < result.numInstances(); ++i) {
            Instance inst = result.instance(i);
            AddExpressionTest.assertEquals((String)("Instance " + (i + 1)), (double)Math.rint(inst.value(5) * inst.value(2) / 5.0), (double)inst.value(inst.numAttributes() - 1), (double)EXPR_DELTA);
        }
    }

    public void testBracketing() {
        this.m_Filter = this.getFilter("(a3+a6)*((a6-a3)/5)");
        Instances result = this.useFilter();
        for (int i = 0; i < result.numInstances(); ++i) {
            Instance inst = result.instance(i);
            if (inst.isMissing(2) || inst.isMissing(5)) {
                AddExpressionTest.assertTrue((String)("Instance " + (i + 1) + " should have been ?"), (boolean)inst.isMissing(inst.numAttributes() - 1));
                continue;
            }
            AddExpressionTest.assertEquals((String)("Instance " + (i + 1)), (double)((inst.value(2) + inst.value(5)) * ((inst.value(5) - inst.value(2)) / 5.0)), (double)inst.value(inst.numAttributes() - 1), (double)EXPR_DELTA);
        }
    }

    public void testBODMAS() {
        this.m_Filter = this.getFilter("a3+a3*a6-a3/5+a3*a6+a6");
        Instances result = this.useFilter();
        for (int i = 0; i < result.numInstances(); ++i) {
            Instance inst = result.instance(i);
            if (inst.isMissing(2) || inst.isMissing(5)) {
                AddExpressionTest.assertTrue((String)("Instance " + (i + 1) + " should have been ?"), (boolean)inst.isMissing(inst.numAttributes() - 1));
                continue;
            }
            AddExpressionTest.assertEquals((String)("Instance " + (i + 1)), (double)(inst.value(2) + inst.value(2) * inst.value(5) - inst.value(2) / 5.0 + inst.value(2) * inst.value(5) + inst.value(5)), (double)inst.value(inst.numAttributes() - 1), (double)EXPR_DELTA);
        }
    }

    public void testAddNamed() {
        this.m_Filter = this.getFilter("a3+a6");
        String name = "BongoBongo";
        ((AddExpression)this.m_Filter).setName(name);
        Instances result = this.useFilter();
        AddExpressionTest.assertEquals((String)name, (String)result.attribute(result.numAttributes() - 1).name());
        name = "BongoBongoSecond";
        ((AddExpression)this.m_Filter).setName(name);
        result = this.useFilter();
        AddExpressionTest.assertEquals((String)name, (String)result.attribute(result.numAttributes() - 1).name());
    }

    public static Test suite() {
        return new TestSuite(AddExpressionTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)AddExpressionTest.suite());
    }
}

