/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Option;
import weka.core.Utils;
import weka.datagenerators.DataGenerator;

public abstract class ClusterGenerator
extends DataGenerator {
    private static final long serialVersionUID = 6131722618472046365L;
    protected int m_NumAttributes;
    protected boolean m_ClassFlag = false;

    public ClusterGenerator() {
        this.setNumAttributes(this.defaultNumAttributes());
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = this.enumToVector(super.listOptions());
        result.addElement(new Option("\tThe number of attributes (default " + this.defaultNumAttributes() + ").", "a", 1, "-a <num>"));
        result.addElement(new Option("\tClass Flag, if set, the cluster is listed in extra attribute.", "c", 0, "-c"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption('a', options);
        if (tmpStr.length() != 0) {
            this.setNumAttributes(Integer.parseInt(tmpStr));
        } else {
            this.setNumAttributes(this.defaultNumAttributes());
        }
        this.setClassFlag(Utils.getFlag('c', options));
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        Collections.addAll(result, super.getOptions());
        result.add("-a");
        result.add("" + this.getNumAttributes());
        if (this.getClassFlag()) {
            result.add("-c");
        }
        return result.toArray(new String[result.size()]);
    }

    protected int defaultNumAttributes() {
        return 10;
    }

    public void setNumAttributes(int numAttributes) {
        this.m_NumAttributes = numAttributes;
    }

    public int getNumAttributes() {
        return this.m_NumAttributes;
    }

    public String numAttributesTipText() {
        return "The number of attributes the generated data will contain.";
    }

    public void setClassFlag(boolean classFlag) {
        this.m_ClassFlag = classFlag;
    }

    public boolean getClassFlag() {
        return this.m_ClassFlag;
    }

    public String classFlagTipText() {
        return "If set to TRUE, lists the cluster as an extra attribute.";
    }
}

