/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow.steps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import weka.core.Environment;
import weka.core.Instances;
import weka.core.WekaException;
import weka.gui.FileEnvironmentField;
import weka.gui.knowledgeflow.StepEditorDialog;
import weka.knowledgeflow.StepManager;
import weka.knowledgeflow.steps.ExecuteProcess;

public class ExecuteProcessStepEditorDialog
extends StepEditorDialog {
    private static final long serialVersionUID = -7740004961609720209L;
    protected StaticProcessPanel m_staticPanel;
    protected DynamicProcessPanel m_dynamicPanel;
    protected JCheckBox m_useDynamicCheck = new JCheckBox("Execute dynamic commands");
    protected JCheckBox m_raiseExceptonOnCommandFailure = new JCheckBox("Raise an exception for command failure");

    @Override
    protected void layoutEditor() {
        ExecuteProcess executeProcess = (ExecuteProcess)this.getStepToEdit();
        boolean hasIncomingInstances = executeProcess.getStepManager().numIncomingConnectionsOfType("instance") > 0 || executeProcess.getStepManager().numIncomingConnectionsOfType("environment") > 0;
        Environment env = Environment.getSystemWide();
        JPanel holderP = new JPanel(new BorderLayout());
        JPanel checkP = new JPanel(new BorderLayout());
        holderP.add((Component)checkP, "North");
        if (hasIncomingInstances) {
            checkP.add((Component)this.m_useDynamicCheck, "North");
            this.m_useDynamicCheck.setSelected(executeProcess.getUseDynamic());
        } else {
            this.m_useDynamicCheck = null;
        }
        checkP.add((Component)this.m_raiseExceptonOnCommandFailure, "South");
        this.m_raiseExceptonOnCommandFailure.setSelected(executeProcess.getRaiseExceptionOnCommandFailure());
        this.m_staticPanel = new StaticProcessPanel(executeProcess, env);
        if (hasIncomingInstances) {
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.add("Static", this.m_staticPanel);
            this.m_dynamicPanel = new DynamicProcessPanel(executeProcess);
            tabbedPane.add("Dynamic", this.m_dynamicPanel);
            holderP.add((Component)tabbedPane, "Center");
        } else {
            holderP.add((Component)this.m_staticPanel, "Center");
        }
        this.add((Component)holderP, "Center");
    }

    @Override
    protected void okPressed() {
        ExecuteProcess executeProcess = (ExecuteProcess)this.getStepToEdit();
        if (this.m_useDynamicCheck != null && this.m_useDynamicCheck.isSelected()) {
            this.m_dynamicPanel.applyToStep(executeProcess);
        }
        executeProcess.setRaiseExceptionOnCommandFailure(this.m_raiseExceptonOnCommandFailure.isSelected());
        this.m_staticPanel.applyToStep(executeProcess);
    }

    protected class StaticProcessPanel
    extends JPanel {
        private static final long serialVersionUID = -4215730214067279661L;
        protected JTextField m_cmdText = new JTextField(10);
        protected JTextField m_argsText = new JTextField(10);
        protected FileEnvironmentField m_workingDirField;

        public StaticProcessPanel(ExecuteProcess executeProcess, Environment env) {
            String workingDir;
            String args;
            this.m_workingDirField = new FileEnvironmentField("", env, 0, true);
            this.setLayout(new GridLayout(0, 2));
            this.add(new JLabel("Command", 4));
            this.add(this.m_cmdText);
            this.add(new JLabel("Arguments", 4));
            this.add(this.m_argsText);
            this.add(new JLabel("Working directory", 4));
            this.add(this.m_workingDirField);
            String cmd = executeProcess.getStaticCmd();
            if (cmd != null && cmd.length() > 0) {
                this.m_cmdText.setText(cmd);
            }
            if ((args = executeProcess.getStaticArgs()) != null && args.length() > 0) {
                this.m_argsText.setText(args);
            }
            if ((workingDir = executeProcess.getStaticWorkingDir()) != null && workingDir.length() > 0) {
                this.m_workingDirField.setCurrentDirectory(workingDir);
            }
            this.m_workingDirField.setEnvironment(env);
        }

        public void applyToStep(ExecuteProcess executeProcess) {
            executeProcess.setStaticCmd(this.m_cmdText.getText());
            executeProcess.setStaticArgs(this.m_argsText.getText());
            executeProcess.setStaticWorkingDir(this.m_workingDirField.getText());
        }
    }

    protected class DynamicProcessPanel
    extends JPanel {
        private static final long serialVersionUID = 6440523583792476595L;
        protected JComboBox<String> m_cmdField = new JComboBox();
        protected JComboBox<String> m_argsField = new JComboBox();
        protected JComboBox<String> m_workingDirField = new JComboBox();

        public DynamicProcessPanel(ExecuteProcess executeProcess) {
            this.m_cmdField.setEditable(true);
            this.m_argsField.setEditable(true);
            this.m_workingDirField.setEditable(true);
            Map<String, List<StepManager>> incomingConnTypes = executeProcess.getStepManager().getIncomingConnections();
            String incomingConnType = incomingConnTypes.keySet().iterator().next();
            try {
                String currentWorkingDirField;
                String currentArgsField;
                String currentCmdField;
                Instances incomingStructure = executeProcess.outputStructureForConnectionType(incomingConnType);
                if (incomingStructure != null) {
                    this.m_argsField.addItem("");
                    this.m_workingDirField.addItem("");
                    for (int i = 0; i < incomingStructure.numAttributes(); ++i) {
                        if (!incomingStructure.attribute(i).isString() && !incomingStructure.attribute(i).isNominal()) continue;
                        this.m_cmdField.addItem(incomingStructure.attribute(i).name());
                        this.m_argsField.addItem(incomingStructure.attribute(i).name());
                        this.m_workingDirField.addItem(incomingStructure.attribute(i).name());
                    }
                }
                if ((currentCmdField = executeProcess.getDynamicCmdField()) != null && currentCmdField.length() > 0) {
                    this.m_cmdField.setSelectedItem(currentCmdField);
                }
                if ((currentArgsField = executeProcess.getDynamicArgsField()) != null && currentArgsField.length() > 0) {
                    this.m_argsField.setSelectedItem(currentArgsField);
                }
                if ((currentWorkingDirField = executeProcess.getDynamicWorkingDirField()) != null && currentWorkingDirField.length() > 0) {
                    this.m_workingDirField.setSelectedItem(currentWorkingDirField);
                }
            }
            catch (WekaException ex) {
                ExecuteProcessStepEditorDialog.this.showErrorDialog(ex);
            }
            this.setLayout(new GridLayout(0, 2));
            this.add(new JLabel("Command attribute", 4));
            this.add(this.m_cmdField);
            this.add(new JLabel("Arguments attribute", 4));
            this.add(this.m_argsField);
            this.add(new JLabel("Working dir attribute", 4));
            this.add(this.m_workingDirField);
        }

        public void applyToStep(ExecuteProcess executeProcess) {
            executeProcess.setDynamicCmdField(this.m_cmdField.getSelectedItem().toString());
            executeProcess.setDynamicArgsField(this.m_argsField.getSelectedItem().toString());
            executeProcess.setDynamicWorkingDirField(this.m_workingDirField.getSelectedItem().toString());
            executeProcess.setUseDynamic(ExecuteProcessStepEditorDialog.this.m_useDynamicCheck.isSelected());
        }
    }
}

